(ns symmetry.lib.dev.nrepl-server
  (:require [symmetry.lib.log :as log]
            [symmetry.lib.core :refer [and-let]]
            [clojure.string :as string]
            [clojure.tools.nrepl.server]
            [cider.nrepl]))

(defn- args-map [args]
  (into {}
        (for [[k v] (partition 2 args)]
          {(keyword (.substring k 1)) v})))

(defn -main [& args]
  (let [opts (args-map args)
        app-name (or (:app-name opts)
                     (when-let [m (:main opts)]
                       (last (string/split m #"\."))))]
    (log/init! app-name)
    (println "starting nREPL server...")
    (let [m (clojure.tools.nrepl.server/start-server
             :handler cider.nrepl/cider-nrepl-handler)
          p (:port m)]
      (spit ".nrepl-port" (str p))
      (println (str "nrepl server running on port " p "."))
      (and-let [main (:main opts)
                m    (symbol main)]
        (println (format "Loading %s" main))
        (require m)
        (let [f (get (ns-publics m) '-main)]
          (println (format "Running (%s/-main)" main))
          (f)
          (println "Ready"))))))
