(ns symmetry.lib.math)

(defn average [& numbers]
  (let [s (flatten numbers)]
    (/ (apply + s)
       (count s))))

(defmacro ineq? [& args]
  `(and ~@(map (fn [[x op y]] (list op x y))
               (partition 3 2 args))))
