(ns sv.ha.failover.heartbeat.example
  (:require [sv.ha.failover.heartbeat.core :as c]))

(defonce node1 (atom nil))

(defonce node2 (atom nil))

(defonce state (atom nil))

(defn state-fn
  ;; TODO: replace with a real CAS operation
  ([]
   @state)
  ([f]
   (reset! state f)
   true))

(def heartbeat-interval 1000)

(defn exception-handler [exception]
  (println "error:" exception))

(comment
  (do
    (reset! node1 nil)
    (reset! node2 nil)
    (reset! state nil))
  
  (do
    (reset! node1 (c/new-local-value))
    (c/do-process heartbeat-interval node1 state-fn))

  (c/start heartbeat-interval node1 state-fn exception-handler)
  (c/start heartbeat-interval node2 state-fn exception-handler)

  (c/stop node1)
  (c/stop node2)

  (do
    (require '[clojure.pprint :as p])
    (p/pprint [@node1
               @node2
               @state]))
  )
