(ns sv.ha.failover.heartbeat.gcloud.datastore.example
  (:require [sv.gcloud.client :as c]
            [sv.ha.failover.heartbeat.gcloud.datastore :as d]
            [sv.gcloud.datastore.client :as dc]
            [sv.ha.failover.heartbeat.core :as h]))

(def client
  (dc/create-client
   c/create-client
   {:projectId "*your-project-id*"}))

(def state-fn
  (d/create-state-fn
   client
   {:ds/kind "test.ha.failover"
    :ds/name "ha.failover.value"}))

(comment
  (state-fn)
  (state-fn {})
  (state-fn))

(defonce node1 (atom nil))

(defonce node2 (atom nil))

(def heartbeat-interval 1000)
(def check-interval 4000)

(defn exception-handler [exception]
  (println "error:" exception))

(comment
  (h/start heartbeat-interval check-interval node1 state-fn exception-handler)
  (h/start heartbeat-interval check-interval node2 state-fn exception-handler)

  (h/stop node1)
  (h/stop node2)

  (do
    (require '[clojure.pprint :as p])
    (p/pprint [@node1
               @node2
               (state-fn)]))
  )
