(ns sv.gcloud.datastore.spike
  (:require [sv.gcloud.client :as c]
            [sv.gcloud.datastore.client :refer :all]))

(def client
  (create-client
   c/create-client
   {:projectId "vire-1315"}))

(defn s2 []
  (lookup-entity
   client
   {:ds/kind "order-placement-counter"
    :ds/name "{:order 123, :placement 456, :shard 6}"}))

(defn s3 []
  (swap-entity
   client
   {:ds/kind "order-placement-counter"
    :ds/name "{:order 123, :placement 456, :shard 6}"}
   (fn [entity]
     (update entity :count #(inc (or % 0))))))

(defn s4 []
  (transact-entity
   client
   {:ds/kind "order-placement-counter"
    :ds/name "{:order 123, :placement 456, :shard 6}"}
   (fn [entity]
     (update entity :count #(inc (or % 0))))))

(defn inc-count [client entity-key]
  (transact-entity
   client
   entity-key
   (fn [entity]
     (update entity :count #(inc (or % 0))))))

(defn s5 []
  (inc-count
   client
   {:ds/kind "order-placement-counter"
    :ds/name "{:order 123, :placement 456, :shard 6}"}))

(require '[clj-time.core :as t]
         '[clj-time.coerce :as tc])

(defn build-name-key [params]
  [(:eid params)
   (:shard params)
   (:time-point params)])

(defn build-key [params]
  {:ds/kind (:kind params)
   :ds/name (pr-str (build-name-key params))})

;; kind = advertiser.offer.view.count

[17592186048582 2016 11 23]

(defn day-time-point [timestamp]
  (let [timestamp (tc/to-date-time timestamp)]
    [(t/year timestamp)
     (t/month timestamp)
     (t/day timestamp)]))

(defn s6 []
  (build-key   
   {:kind "advertiser.offer.view.day.count"
    :eid 17592186048582
    :shard (rand-int 20)
    :time-point (day-time-point (t/now))}))

(defn advertiser-offer-view-day-count-key [advertiser-offer-eid timestamp]
  {:kind "advertiser.offer.view.day.count"
   :eid advertiser-offer-eid
   :shard (rand-int 20)
   :time-point (day-time-point timestamp)})

(defn inc-advertiser-offer-view-day-count
  [client advertiser-offer-eid timestamp]
  (inc-count
   client
   (build-key
    (advertiser-offer-view-day-count-key
     advertiser-offer-eid
     timestamp))))

;; (time (inc-advertiser-offer-view-day-count client 1 (t/now)))

;; The Vire platform allows advertisers to create an advertiser
;; offer. The advertiser offer contains a ref to the asset (3D model
;; of the product) and a CPM price. Advertisers have an overall
;; balance for their Vire account. The balance is the amount of money
;; (in US dollars) of the advertiser, which is left to spend on the
;; Vire platform.

;; To avoid a negative balance the Vire platform needs to count the
;; number of views per advertiser offer. If the balance is zero
;; (almost zero; plus some safety margin), then the Vire platform
;; should stop serving all offers / campaigns of the corresponding
;; advertiser. Later the advertiser should receive the option to
;; define a daily budget for each advertiser offer, to receive more
;; control about where his money is spend on the Vire platform.

;; The reporting already enforces that the CPM price of an advertiser
;; offer can only be changed once a day (UTC-based). Therefore the
;; logic that enforces the balance limit in realtime, should adhere to
;; the same pattern.

;; Since the CPM price could be changed everyday, the number of views
;; per advertiser offer also has to be counted per day.

