// Compiled by ClojureScript 1.10.312 {}
goog.provide('otplike.csi.core');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('goog.string.format');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.match');
goog.require('cognitect.transit');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
otplike.csi.core.Pid = (function (id,__meta,__extmap,__hash){
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
otplike.csi.core.Pid.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4190__auto__,k__4191__auto__){
var self__ = this;
var this__4190__auto____$1 = this;
return this__4190__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4191__auto__,null);
});

otplike.csi.core.Pid.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4192__auto__,k3686,else__4193__auto__){
var self__ = this;
var this__4192__auto____$1 = this;
var G__3690 = k3686;
var G__3690__$1 = (((G__3690 instanceof cljs.core.Keyword))?G__3690.fqn:null);
switch (G__3690__$1) {
case "id":
return self__.id;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k3686,else__4193__auto__);

}
});

otplike.csi.core.Pid.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4204__auto__,writer__4205__auto__,opts__4206__auto__){
var self__ = this;
var this__4204__auto____$1 = this;
var pr_pair__4207__auto__ = ((function (this__4204__auto____$1){
return (function (keyval__4208__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4205__auto__,cljs.core.pr_writer,""," ","",opts__4206__auto__,keyval__4208__auto__);
});})(this__4204__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__4205__auto__,pr_pair__4207__auto__,"#otplike.csi.core.Pid{",", ","}",opts__4206__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null))], null),self__.__extmap));
});

otplike.csi.core.Pid.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__3685){
var self__ = this;
var G__3685__$1 = this;
return (new cljs.core.RecordIter((0),G__3685__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

otplike.csi.core.Pid.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4188__auto__){
var self__ = this;
var this__4188__auto____$1 = this;
return self__.__meta;
});

otplike.csi.core.Pid.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4185__auto__){
var self__ = this;
var this__4185__auto____$1 = this;
return (new otplike.csi.core.Pid(self__.id,self__.__meta,self__.__extmap,self__.__hash));
});

otplike.csi.core.Pid.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4194__auto__){
var self__ = this;
var this__4194__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

otplike.csi.core.Pid.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4186__auto__){
var self__ = this;
var this__4186__auto____$1 = this;
var h__4048__auto__ = self__.__hash;
if(!((h__4048__auto__ == null))){
return h__4048__auto__;
} else {
var h__4048__auto____$1 = ((function (h__4048__auto__,this__4186__auto____$1){
return (function (coll__4187__auto__){
return (-99848531 ^ cljs.core.hash_unordered_coll.call(null,coll__4187__auto__));
});})(h__4048__auto__,this__4186__auto____$1))
.call(null,this__4186__auto____$1);
self__.__hash = h__4048__auto____$1;

return h__4048__auto____$1;
}
});

otplike.csi.core.Pid.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this3687,other3688){
var self__ = this;
var this3687__$1 = this;
return ((!((other3688 == null))) && ((this3687__$1.constructor === other3688.constructor)) && (cljs.core._EQ_.call(null,this3687__$1.id,other3688.id)) && (cljs.core._EQ_.call(null,this3687__$1.__extmap,other3688.__extmap)));
});

otplike.csi.core.Pid.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4199__auto__,k__4200__auto__){
var self__ = this;
var this__4199__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id","id",-1388402092),null], null), null),k__4200__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4199__auto____$1),self__.__meta),k__4200__auto__);
} else {
return (new otplike.csi.core.Pid(self__.id,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4200__auto__)),null));
}
});

otplike.csi.core.Pid.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4197__auto__,k__4198__auto__,G__3685){
var self__ = this;
var this__4197__auto____$1 = this;
var pred__3691 = cljs.core.keyword_identical_QMARK_;
var expr__3692 = k__4198__auto__;
if(cljs.core.truth_(pred__3691.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__3692))){
return (new otplike.csi.core.Pid(G__3685,self__.__meta,self__.__extmap,null));
} else {
return (new otplike.csi.core.Pid(self__.id,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4198__auto__,G__3685),null));
}
});

otplike.csi.core.Pid.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4202__auto__){
var self__ = this;
var this__4202__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null))], null),self__.__extmap));
});

otplike.csi.core.Pid.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4189__auto__,G__3685){
var self__ = this;
var this__4189__auto____$1 = this;
return (new otplike.csi.core.Pid(self__.id,G__3685,self__.__extmap,self__.__hash));
});

otplike.csi.core.Pid.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4195__auto__,entry__4196__auto__){
var self__ = this;
var this__4195__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4196__auto__)){
return this__4195__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4196__auto__,(0)),cljs.core._nth.call(null,entry__4196__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4195__auto____$1,entry__4196__auto__);
}
});

otplike.csi.core.Pid.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null)], null);
});

otplike.csi.core.Pid.cljs$lang$type = true;

otplike.csi.core.Pid.cljs$lang$ctorPrSeq = (function (this__4226__auto__){
return (new cljs.core.List(null,"otplike.csi.core/Pid",null,(1),null));
});

otplike.csi.core.Pid.cljs$lang$ctorPrWriter = (function (this__4226__auto__,writer__4227__auto__){
return cljs.core._write.call(null,writer__4227__auto__,"otplike.csi.core/Pid");
});

/**
 * Positional factory function for otplike.csi.core/Pid.
 */
otplike.csi.core.__GT_Pid = (function otplike$csi$core$__GT_Pid(id){
return (new otplike.csi.core.Pid(id,null,null,null));
});

/**
 * Factory function for otplike.csi.core/Pid, taking a map of keywords to field values.
 */
otplike.csi.core.map__GT_Pid = (function otplike$csi$core$map__GT_Pid(G__3689){
return (new otplike.csi.core.Pid(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__3689),null,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,G__3689,new cljs.core.Keyword(null,"id","id",-1388402092))),null));
});

otplike.csi.core.pid__GT_str = (function otplike$csi$core$pid__GT_str(pid){
return goog.string.format("<%d>",new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(pid));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
otplike.csi.core.TRef = (function (id,__meta,__extmap,__hash){
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
otplike.csi.core.TRef.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4190__auto__,k__4191__auto__){
var self__ = this;
var this__4190__auto____$1 = this;
return this__4190__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4191__auto__,null);
});

otplike.csi.core.TRef.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4192__auto__,k3696,else__4193__auto__){
var self__ = this;
var this__4192__auto____$1 = this;
var G__3700 = k3696;
var G__3700__$1 = (((G__3700 instanceof cljs.core.Keyword))?G__3700.fqn:null);
switch (G__3700__$1) {
case "id":
return self__.id;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k3696,else__4193__auto__);

}
});

otplike.csi.core.TRef.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4204__auto__,writer__4205__auto__,opts__4206__auto__){
var self__ = this;
var this__4204__auto____$1 = this;
var pr_pair__4207__auto__ = ((function (this__4204__auto____$1){
return (function (keyval__4208__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4205__auto__,cljs.core.pr_writer,""," ","",opts__4206__auto__,keyval__4208__auto__);
});})(this__4204__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__4205__auto__,pr_pair__4207__auto__,"#otplike.csi.core.TRef{",", ","}",opts__4206__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null))], null),self__.__extmap));
});

otplike.csi.core.TRef.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__3695){
var self__ = this;
var G__3695__$1 = this;
return (new cljs.core.RecordIter((0),G__3695__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

otplike.csi.core.TRef.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4188__auto__){
var self__ = this;
var this__4188__auto____$1 = this;
return self__.__meta;
});

otplike.csi.core.TRef.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4185__auto__){
var self__ = this;
var this__4185__auto____$1 = this;
return (new otplike.csi.core.TRef(self__.id,self__.__meta,self__.__extmap,self__.__hash));
});

otplike.csi.core.TRef.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4194__auto__){
var self__ = this;
var this__4194__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

otplike.csi.core.TRef.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4186__auto__){
var self__ = this;
var this__4186__auto____$1 = this;
var h__4048__auto__ = self__.__hash;
if(!((h__4048__auto__ == null))){
return h__4048__auto__;
} else {
var h__4048__auto____$1 = ((function (h__4048__auto__,this__4186__auto____$1){
return (function (coll__4187__auto__){
return (804092170 ^ cljs.core.hash_unordered_coll.call(null,coll__4187__auto__));
});})(h__4048__auto__,this__4186__auto____$1))
.call(null,this__4186__auto____$1);
self__.__hash = h__4048__auto____$1;

return h__4048__auto____$1;
}
});

otplike.csi.core.TRef.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this3697,other3698){
var self__ = this;
var this3697__$1 = this;
return ((!((other3698 == null))) && ((this3697__$1.constructor === other3698.constructor)) && (cljs.core._EQ_.call(null,this3697__$1.id,other3698.id)) && (cljs.core._EQ_.call(null,this3697__$1.__extmap,other3698.__extmap)));
});

otplike.csi.core.TRef.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4199__auto__,k__4200__auto__){
var self__ = this;
var this__4199__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id","id",-1388402092),null], null), null),k__4200__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4199__auto____$1),self__.__meta),k__4200__auto__);
} else {
return (new otplike.csi.core.TRef(self__.id,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4200__auto__)),null));
}
});

otplike.csi.core.TRef.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4197__auto__,k__4198__auto__,G__3695){
var self__ = this;
var this__4197__auto____$1 = this;
var pred__3701 = cljs.core.keyword_identical_QMARK_;
var expr__3702 = k__4198__auto__;
if(cljs.core.truth_(pred__3701.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__3702))){
return (new otplike.csi.core.TRef(G__3695,self__.__meta,self__.__extmap,null));
} else {
return (new otplike.csi.core.TRef(self__.id,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4198__auto__,G__3695),null));
}
});

otplike.csi.core.TRef.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4202__auto__){
var self__ = this;
var this__4202__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null))], null),self__.__extmap));
});

otplike.csi.core.TRef.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4189__auto__,G__3695){
var self__ = this;
var this__4189__auto____$1 = this;
return (new otplike.csi.core.TRef(self__.id,G__3695,self__.__extmap,self__.__hash));
});

otplike.csi.core.TRef.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4195__auto__,entry__4196__auto__){
var self__ = this;
var this__4195__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4196__auto__)){
return this__4195__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4196__auto__,(0)),cljs.core._nth.call(null,entry__4196__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4195__auto____$1,entry__4196__auto__);
}
});

otplike.csi.core.TRef.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null)], null);
});

otplike.csi.core.TRef.cljs$lang$type = true;

otplike.csi.core.TRef.cljs$lang$ctorPrSeq = (function (this__4226__auto__){
return (new cljs.core.List(null,"otplike.csi.core/TRef",null,(1),null));
});

otplike.csi.core.TRef.cljs$lang$ctorPrWriter = (function (this__4226__auto__,writer__4227__auto__){
return cljs.core._write.call(null,writer__4227__auto__,"otplike.csi.core/TRef");
});

/**
 * Positional factory function for otplike.csi.core/TRef.
 */
otplike.csi.core.__GT_TRef = (function otplike$csi$core$__GT_TRef(id){
return (new otplike.csi.core.TRef(id,null,null,null));
});

/**
 * Factory function for otplike.csi.core/TRef, taking a map of keywords to field values.
 */
otplike.csi.core.map__GT_TRef = (function otplike$csi$core$map__GT_TRef(G__3699){
return (new otplike.csi.core.TRef(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__3699),null,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,G__3699,new cljs.core.Keyword(null,"id","id",-1388402092))),null));
});


/**
 * @interface
 */
otplike.csi.core.IErlangMBox = function(){};

otplike.csi.core.close_BANG_ = (function otplike$csi$core$close_BANG_(_){
if(((!((_ == null))) && (!((_.otplike$csi$core$IErlangMBox$close_BANG_$arity$1 == null))))){
return _.otplike$csi$core$IErlangMBox$close_BANG_$arity$1(_);
} else {
var x__4229__auto__ = (((_ == null))?null:_);
var m__4230__auto__ = (otplike.csi.core.close_BANG_[goog.typeOf(x__4229__auto__)]);
if(!((m__4230__auto__ == null))){
return m__4230__auto__.call(null,_);
} else {
var m__4230__auto____$1 = (otplike.csi.core.close_BANG_["_"]);
if(!((m__4230__auto____$1 == null))){
return m__4230__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"IErlangMBox.close!",_);
}
}
}
});

otplike.csi.core.reset_context_BANG_ = (function otplike$csi$core$reset_context_BANG_(_,ctx){
if(((!((_ == null))) && (!((_.otplike$csi$core$IErlangMBox$reset_context_BANG_$arity$2 == null))))){
return _.otplike$csi$core$IErlangMBox$reset_context_BANG_$arity$2(_,ctx);
} else {
var x__4229__auto__ = (((_ == null))?null:_);
var m__4230__auto__ = (otplike.csi.core.reset_context_BANG_[goog.typeOf(x__4229__auto__)]);
if(!((m__4230__auto__ == null))){
return m__4230__auto__.call(null,_,ctx);
} else {
var m__4230__auto____$1 = (otplike.csi.core.reset_context_BANG_["_"]);
if(!((m__4230__auto____$1 == null))){
return m__4230__auto____$1.call(null,_,ctx);
} else {
throw cljs.core.missing_protocol.call(null,"IErlangMBox.reset-context!",_);
}
}
}
});

otplike.csi.core.update_context_BANG_ = (function otplike$csi$core$update_context_BANG_(_,f){
if(((!((_ == null))) && (!((_.otplike$csi$core$IErlangMBox$update_context_BANG_$arity$2 == null))))){
return _.otplike$csi$core$IErlangMBox$update_context_BANG_$arity$2(_,f);
} else {
var x__4229__auto__ = (((_ == null))?null:_);
var m__4230__auto__ = (otplike.csi.core.update_context_BANG_[goog.typeOf(x__4229__auto__)]);
if(!((m__4230__auto__ == null))){
return m__4230__auto__.call(null,_,f);
} else {
var m__4230__auto____$1 = (otplike.csi.core.update_context_BANG_["_"]);
if(!((m__4230__auto____$1 == null))){
return m__4230__auto____$1.call(null,_,f);
} else {
throw cljs.core.missing_protocol.call(null,"IErlangMBox.update-context!",_);
}
}
}
});

otplike.csi.core.cast_BANG_ = (function otplike$csi$core$cast_BANG_(_,func,args){
if(((!((_ == null))) && (!((_.otplike$csi$core$IErlangMBox$cast_BANG_$arity$3 == null))))){
return _.otplike$csi$core$IErlangMBox$cast_BANG_$arity$3(_,func,args);
} else {
var x__4229__auto__ = (((_ == null))?null:_);
var m__4230__auto__ = (otplike.csi.core.cast_BANG_[goog.typeOf(x__4229__auto__)]);
if(!((m__4230__auto__ == null))){
return m__4230__auto__.call(null,_,func,args);
} else {
var m__4230__auto____$1 = (otplike.csi.core.cast_BANG_["_"]);
if(!((m__4230__auto____$1 == null))){
return m__4230__auto____$1.call(null,_,func,args);
} else {
throw cljs.core.missing_protocol.call(null,"IErlangMBox.cast!",_);
}
}
}
});

otplike.csi.core.call_BANG_ = (function otplike$csi$core$call_BANG_(var_args){
var G__3706 = arguments.length;
switch (G__3706) {
case 3:
return otplike.csi.core.call_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return otplike.csi.core.call_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

otplike.csi.core.call_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (_,func,params){
if(((!((_ == null))) && (!((_.otplike$csi$core$IErlangMBox$call_BANG_$arity$3 == null))))){
return _.otplike$csi$core$IErlangMBox$call_BANG_$arity$3(_,func,params);
} else {
var x__4229__auto__ = (((_ == null))?null:_);
var m__4230__auto__ = (otplike.csi.core.call_BANG_[goog.typeOf(x__4229__auto__)]);
if(!((m__4230__auto__ == null))){
return m__4230__auto__.call(null,_,func,params);
} else {
var m__4230__auto____$1 = (otplike.csi.core.call_BANG_["_"]);
if(!((m__4230__auto____$1 == null))){
return m__4230__auto____$1.call(null,_,func,params);
} else {
throw cljs.core.missing_protocol.call(null,"IErlangMBox.call!",_);
}
}
}
});

otplike.csi.core.call_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (_,func,params,timeout){
if(((!((_ == null))) && (!((_.otplike$csi$core$IErlangMBox$call_BANG_$arity$4 == null))))){
return _.otplike$csi$core$IErlangMBox$call_BANG_$arity$4(_,func,params,timeout);
} else {
var x__4229__auto__ = (((_ == null))?null:_);
var m__4230__auto__ = (otplike.csi.core.call_BANG_[goog.typeOf(x__4229__auto__)]);
if(!((m__4230__auto__ == null))){
return m__4230__auto__.call(null,_,func,params,timeout);
} else {
var m__4230__auto____$1 = (otplike.csi.core.call_BANG_["_"]);
if(!((m__4230__auto____$1 == null))){
return m__4230__auto____$1.call(null,_,func,params,timeout);
} else {
throw cljs.core.missing_protocol.call(null,"IErlangMBox.call!",_);
}
}
}
});

otplike.csi.core.call_BANG_.cljs$lang$maxFixedArity = 4;


otplike.csi.core.self = (function otplike$csi$core$self(_){
if(((!((_ == null))) && (!((_.otplike$csi$core$IErlangMBox$self$arity$1 == null))))){
return _.otplike$csi$core$IErlangMBox$self$arity$1(_);
} else {
var x__4229__auto__ = (((_ == null))?null:_);
var m__4230__auto__ = (otplike.csi.core.self[goog.typeOf(x__4229__auto__)]);
if(!((m__4230__auto__ == null))){
return m__4230__auto__.call(null,_);
} else {
var m__4230__auto____$1 = (otplike.csi.core.self["_"]);
if(!((m__4230__auto____$1 == null))){
return m__4230__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"IErlangMBox.self",_);
}
}
}
});

otplike.csi.core.exit_reason = (function otplike$csi$core$exit_reason(_){
if(((!((_ == null))) && (!((_.otplike$csi$core$IErlangMBox$exit_reason$arity$1 == null))))){
return _.otplike$csi$core$IErlangMBox$exit_reason$arity$1(_);
} else {
var x__4229__auto__ = (((_ == null))?null:_);
var m__4230__auto__ = (otplike.csi.core.exit_reason[goog.typeOf(x__4229__auto__)]);
if(!((m__4230__auto__ == null))){
return m__4230__auto__.call(null,_);
} else {
var m__4230__auto____$1 = (otplike.csi.core.exit_reason["_"]);
if(!((m__4230__auto____$1 == null))){
return m__4230__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"IErlangMBox.exit-reason",_);
}
}
}
});

otplike.csi.core.transit_reader = cognitect.transit.reader.call(null,new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"handlers","handlers",79528781),new cljs.core.PersistentArrayMap(null, 2, ["pid",(function (p__3708){
var map__3709 = p__3708;
var map__3709__$1 = ((((!((map__3709 == null)))?(((((map__3709.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3709.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3709):map__3709);
var id = cljs.core.get.call(null,map__3709__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
return otplike.csi.core.__GT_Pid.call(null,id);
}),"otp-ref",(function (p__3711){
var map__3712 = p__3711;
var map__3712__$1 = ((((!((map__3712 == null)))?(((((map__3712.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3712.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3712):map__3712);
var id = cljs.core.get.call(null,map__3712__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
return otplike.csi.core.__GT_TRef.call(null,id);
})], null)], null));
otplike.csi.core.transit_writer = cognitect.transit.writer.call(null,new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"handlers","handlers",79528781),cljs.core.PersistentArrayMap.createAsIfByAssoc([otplike.csi.core.Pid,cognitect.transit.write_handler.call(null,cljs.core.constantly.call(null,"pid"),(function (p__3714){
var map__3715 = p__3714;
var map__3715__$1 = ((((!((map__3715 == null)))?(((((map__3715.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3715.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3715):map__3715);
var id = cljs.core.get.call(null,map__3715__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id","id",-1388402092),id], null);
})),otplike.csi.core.TRef,cognitect.transit.write_handler.call(null,cljs.core.constantly.call(null,"otp-ref"),(function (p__3717){
var map__3718 = p__3717;
var map__3718__$1 = ((((!((map__3718 == null)))?(((((map__3718.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3718.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3718):map__3718);
var id = cljs.core.get.call(null,map__3718__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id","id",-1388402092),id], null);
}))])], null));
otplike.csi.core.make_ws = (function otplike$csi$core$make_ws(url){
var result = cljs.core.async.chan.call(null);
var in$ = cljs.core.async.chan.call(null);
var out = cljs.core.async.chan.call(null);
var ws = (new WebSocket(url));
ws.addEventListener("open",((function (result,in$,out,ws){
return (function (event){
console.debug("websocket :: on open",event);

var c__2327__auto___3751 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2327__auto___3751,result,in$,out,ws){
return (function (){
var f__2328__auto__ = (function (){var switch__2306__auto__ = ((function (c__2327__auto___3751,result,in$,out,ws){
return (function (state_3734){
var state_val_3735 = (state_3734[(1)]);
if((state_val_3735 === (1))){
var state_3734__$1 = state_3734;
var statearr_3736_3752 = state_3734__$1;
(statearr_3736_3752[(2)] = null);

(statearr_3736_3752[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3735 === (2))){
var state_3734__$1 = state_3734;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3734__$1,(4),in$);
} else {
if((state_val_3735 === (3))){
var inst_3732 = (state_3734[(2)]);
var state_3734__$1 = state_3734;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3734__$1,inst_3732);
} else {
if((state_val_3735 === (4))){
var inst_3722 = (state_3734[(7)]);
var inst_3722__$1 = (state_3734[(2)]);
var state_3734__$1 = (function (){var statearr_3737 = state_3734;
(statearr_3737[(7)] = inst_3722__$1);

return statearr_3737;
})();
if(cljs.core.truth_(inst_3722__$1)){
var statearr_3738_3753 = state_3734__$1;
(statearr_3738_3753[(1)] = (5));

} else {
var statearr_3739_3754 = state_3734__$1;
(statearr_3739_3754[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3735 === (5))){
var inst_3722 = (state_3734[(7)]);
var inst_3724 = console.debug("ws-channel :: 'in' message, sending to WebSocket",inst_3722);
var inst_3725 = cognitect.transit.write.call(null,otplike.csi.core.transit_writer,inst_3722);
var inst_3726 = ws.send(inst_3725);
var state_3734__$1 = (function (){var statearr_3740 = state_3734;
(statearr_3740[(8)] = inst_3724);

(statearr_3740[(9)] = inst_3726);

return statearr_3740;
})();
var statearr_3741_3755 = state_3734__$1;
(statearr_3741_3755[(2)] = null);

(statearr_3741_3755[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3735 === (6))){
var state_3734__$1 = state_3734;
var statearr_3742_3756 = state_3734__$1;
(statearr_3742_3756[(2)] = null);

(statearr_3742_3756[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3735 === (7))){
var inst_3730 = (state_3734[(2)]);
var state_3734__$1 = state_3734;
var statearr_3743_3757 = state_3734__$1;
(statearr_3743_3757[(2)] = inst_3730);

(statearr_3743_3757[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__2327__auto___3751,result,in$,out,ws))
;
return ((function (switch__2306__auto__,c__2327__auto___3751,result,in$,out,ws){
return (function() {
var otplike$csi$core$make_ws_$_state_machine__2307__auto__ = null;
var otplike$csi$core$make_ws_$_state_machine__2307__auto____0 = (function (){
var statearr_3744 = [null,null,null,null,null,null,null,null,null,null];
(statearr_3744[(0)] = otplike$csi$core$make_ws_$_state_machine__2307__auto__);

(statearr_3744[(1)] = (1));

return statearr_3744;
});
var otplike$csi$core$make_ws_$_state_machine__2307__auto____1 = (function (state_3734){
while(true){
var ret_value__2308__auto__ = (function (){try{while(true){
var result__2309__auto__ = switch__2306__auto__.call(null,state_3734);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2309__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2309__auto__;
}
break;
}
}catch (e3745){if((e3745 instanceof Object)){
var ex__2310__auto__ = e3745;
var statearr_3746_3758 = state_3734;
(statearr_3746_3758[(5)] = ex__2310__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_3734);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e3745;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2308__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3759 = state_3734;
state_3734 = G__3759;
continue;
} else {
return ret_value__2308__auto__;
}
break;
}
});
otplike$csi$core$make_ws_$_state_machine__2307__auto__ = function(state_3734){
switch(arguments.length){
case 0:
return otplike$csi$core$make_ws_$_state_machine__2307__auto____0.call(this);
case 1:
return otplike$csi$core$make_ws_$_state_machine__2307__auto____1.call(this,state_3734);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
otplike$csi$core$make_ws_$_state_machine__2307__auto__.cljs$core$IFn$_invoke$arity$0 = otplike$csi$core$make_ws_$_state_machine__2307__auto____0;
otplike$csi$core$make_ws_$_state_machine__2307__auto__.cljs$core$IFn$_invoke$arity$1 = otplike$csi$core$make_ws_$_state_machine__2307__auto____1;
return otplike$csi$core$make_ws_$_state_machine__2307__auto__;
})()
;})(switch__2306__auto__,c__2327__auto___3751,result,in$,out,ws))
})();
var state__2329__auto__ = (function (){var statearr_3747 = f__2328__auto__.call(null);
(statearr_3747[(6)] = c__2327__auto___3751);

return statearr_3747;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2329__auto__);
});})(c__2327__auto___3751,result,in$,out,ws))
);


return cljs.core.async.put_BANG_.call(null,result,(function (){
if((typeof otplike !== 'undefined') && (typeof otplike.csi !== 'undefined') && (typeof otplike.csi.core !== 'undefined') && (typeof otplike.csi.core.t_otplike$csi$core3748 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
otplike.csi.core.t_otplike$csi$core3748 = (function (url,result,in$,out,ws,event,meta3749){
this.url = url;
this.result = result;
this.in$ = in$;
this.out = out;
this.ws = ws;
this.event = event;
this.meta3749 = meta3749;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
otplike.csi.core.t_otplike$csi$core3748.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (result,in$,out,ws){
return (function (_3750,meta3749__$1){
var self__ = this;
var _3750__$1 = this;
return (new otplike.csi.core.t_otplike$csi$core3748(self__.url,self__.result,self__.in$,self__.out,self__.ws,self__.event,meta3749__$1));
});})(result,in$,out,ws))
;

otplike.csi.core.t_otplike$csi$core3748.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (result,in$,out,ws){
return (function (_3750){
var self__ = this;
var _3750__$1 = this;
return self__.meta3749;
});})(result,in$,out,ws))
;

otplike.csi.core.t_otplike$csi$core3748.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

otplike.csi.core.t_otplike$csi$core3748.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = ((function (result,in$,out,ws){
return (function (_){
var self__ = this;
var ___$1 = this;
console.debug("ws-channel :: close requested, closing WebSocket");

return self__.ws.close();
});})(result,in$,out,ws))
;

otplike.csi.core.t_otplike$csi$core3748.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = ((function (result,in$,out,ws){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core._EQ_.call(null,self__.ws.readyState,(3));
});})(result,in$,out,ws))
;

otplike.csi.core.t_otplike$csi$core3748.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

otplike.csi.core.t_otplike$csi$core3748.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = ((function (result,in$,out,ws){
return (function (_,handler){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.out,handler);
});})(result,in$,out,ws))
;

otplike.csi.core.t_otplike$csi$core3748.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

otplike.csi.core.t_otplike$csi$core3748.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = ((function (result,in$,out,ws){
return (function (_,val,handler){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.in$,val,handler);
});})(result,in$,out,ws))
;

otplike.csi.core.t_otplike$csi$core3748.getBasis = ((function (result,in$,out,ws){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"url","url",1916828573,null),new cljs.core.Symbol(null,"result","result",-1239343558,null),new cljs.core.Symbol(null,"in","in",109346662,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"ws","ws",1727372970,null),new cljs.core.Symbol(null,"event","event",1941966969,null),new cljs.core.Symbol(null,"meta3749","meta3749",1438980570,null)], null);
});})(result,in$,out,ws))
;

otplike.csi.core.t_otplike$csi$core3748.cljs$lang$type = true;

otplike.csi.core.t_otplike$csi$core3748.cljs$lang$ctorStr = "otplike.csi.core/t_otplike$csi$core3748";

otplike.csi.core.t_otplike$csi$core3748.cljs$lang$ctorPrWriter = ((function (result,in$,out,ws){
return (function (this__4179__auto__,writer__4180__auto__,opt__4181__auto__){
return cljs.core._write.call(null,writer__4180__auto__,"otplike.csi.core/t_otplike$csi$core3748");
});})(result,in$,out,ws))
;

/**
 * Positional factory function for otplike.csi.core/t_otplike$csi$core3748.
 */
otplike.csi.core.__GT_t_otplike$csi$core3748 = ((function (result,in$,out,ws){
return (function otplike$csi$core$make_ws_$___GT_t_otplike$csi$core3748(url__$1,result__$1,in$__$1,out__$1,ws__$1,event__$1,meta3749){
return (new otplike.csi.core.t_otplike$csi$core3748(url__$1,result__$1,in$__$1,out__$1,ws__$1,event__$1,meta3749));
});})(result,in$,out,ws))
;

}

return (new otplike.csi.core.t_otplike$csi$core3748(url,result,in$,out,ws,event,cljs.core.PersistentArrayMap.EMPTY));
})()
);
});})(result,in$,out,ws))
);

ws.addEventListener("close",((function (result,in$,out,ws){
return (function (event){
console.debug("websocket :: on close",event);

cljs.core.async.close_BANG_.call(null,in$);

cljs.core.async.close_BANG_.call(null,out);

return cljs.core.async.put_BANG_.call(null,result,out);
});})(result,in$,out,ws))
);

ws.addEventListener("message",((function (result,in$,out,ws){
return (function (event){
console.debug("websocket :: on message",event);

var msg = cognitect.transit.read.call(null,otplike.csi.core.transit_reader,event.data);
return cljs.core.async.put_BANG_.call(null,out,msg);
});})(result,in$,out,ws))
);

return result;
});
otplike.csi.core.make_mbox = (function otplike$csi$core$make_mbox(pid,ws){
var out = cljs.core.async.chan.call(null);
var exit_reason = cljs.core.atom.call(null,null);
var counter = cljs.core.atom.call(null,(0));
var returns = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var context = cljs.core.atom.call(null,null);
var terminate_BANG_ = ((function (out,exit_reason,counter,returns,context){
return (function (reason){
if(cljs.core.truth_(cljs.core.deref.call(null,exit_reason))){
} else {
cljs.core.reset_BANG_.call(null,exit_reason,reason);
}

cljs.core.async.close_BANG_.call(null,out);

var seq__3760 = cljs.core.seq.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,returns)));
var chunk__3761 = null;
var count__3762 = (0);
var i__3763 = (0);
while(true){
if((i__3763 < count__3762)){
var return$ = cljs.core._nth.call(null,chunk__3761,i__3763);
cljs.core.async.close_BANG_.call(null,return$);


var G__4298 = seq__3760;
var G__4299 = chunk__3761;
var G__4300 = count__3762;
var G__4301 = (i__3763 + (1));
seq__3760 = G__4298;
chunk__3761 = G__4299;
count__3762 = G__4300;
i__3763 = G__4301;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__3760);
if(temp__4657__auto__){
var seq__3760__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__3760__$1)){
var c__4337__auto__ = cljs.core.chunk_first.call(null,seq__3760__$1);
var G__4302 = cljs.core.chunk_rest.call(null,seq__3760__$1);
var G__4303 = c__4337__auto__;
var G__4304 = cljs.core.count.call(null,c__4337__auto__);
var G__4305 = (0);
seq__3760 = G__4302;
chunk__3761 = G__4303;
count__3762 = G__4304;
i__3763 = G__4305;
continue;
} else {
var return$ = cljs.core.first.call(null,seq__3760__$1);
cljs.core.async.close_BANG_.call(null,return$);


var G__4306 = cljs.core.next.call(null,seq__3760__$1);
var G__4307 = null;
var G__4308 = (0);
var G__4309 = (0);
seq__3760 = G__4306;
chunk__3761 = G__4307;
count__3762 = G__4308;
i__3763 = G__4309;
continue;
}
} else {
return null;
}
}
break;
}
});})(out,exit_reason,counter,returns,context))
;
var c__2327__auto___4310 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2327__auto___4310,out,exit_reason,counter,returns,context,terminate_BANG_){
return (function (){
var f__2328__auto__ = (function (){var switch__2306__auto__ = ((function (c__2327__auto___4310,out,exit_reason,counter,returns,context,terminate_BANG_){
return (function (state_3940){
var state_val_3941 = (state_3940[(1)]);
if((state_val_3941 === (65))){
var inst_3776 = (state_3940[(7)]);
var inst_3919 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_3776)].join('');
var inst_3920 = (new Error(inst_3919));
var inst_3921 = (function(){throw inst_3920})();
var state_3940__$1 = state_3940;
var statearr_3942_4311 = state_3940__$1;
(statearr_3942_4311[(2)] = inst_3921);

(statearr_3942_4311[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (62))){
var inst_3776 = (state_3940[(7)]);
var inst_3909 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_3776)].join('');
var inst_3910 = (new Error(inst_3909));
var inst_3911 = (function(){throw inst_3910})();
var state_3940__$1 = state_3940;
var statearr_3943_4312 = state_3940__$1;
(statearr_3943_4312[(2)] = inst_3911);

(statearr_3943_4312[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (7))){
var inst_3936 = (state_3940[(2)]);
var state_3940__$1 = state_3940;
var statearr_3944_4313 = state_3940__$1;
(statearr_3944_4313[(2)] = inst_3936);

(statearr_3944_4313[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (59))){
var state_3940__$1 = state_3940;
var statearr_3945_4314 = state_3940__$1;
(statearr_3945_4314[(2)] = null);

(statearr_3945_4314[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (20))){
var inst_3776 = (state_3940[(7)]);
var inst_3801 = cljs.core.nth.call(null,inst_3776,(1));
var inst_3802 = ["mbox :: ping, payload=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_3801)].join('');
var inst_3803 = console.debug(inst_3802);
var inst_3804 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_3805 = [new cljs.core.Keyword("otplike.csi.core","pong","otplike.csi.core/pong",-907004734),inst_3801];
var inst_3806 = (new cljs.core.PersistentVector(null,2,(5),inst_3804,inst_3805,null));
var inst_3807 = cljs.core.async.put_BANG_.call(null,ws,inst_3806);
var state_3940__$1 = (function (){var statearr_3946 = state_3940;
(statearr_3946[(8)] = inst_3807);

(statearr_3946[(9)] = inst_3803);

return statearr_3946;
})();
var statearr_3947_4315 = state_3940__$1;
(statearr_3947_4315[(2)] = null);

(statearr_3947_4315[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (58))){
var inst_3897 = (state_3940[(10)]);
var inst_3891 = (state_3940[(11)]);
var inst_3892 = (state_3940[(12)]);
var inst_3899 = cljs.core.swap_BANG_.call(null,returns,cljs.core.dissoc,inst_3892);
var state_3940__$1 = (function (){var statearr_3948 = state_3940;
(statearr_3948[(13)] = inst_3899);

return statearr_3948;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3940__$1,(61),inst_3897,inst_3891);
} else {
if((state_val_3941 === (60))){
var inst_3905 = (state_3940[(2)]);
var state_3940__$1 = (function (){var statearr_3949 = state_3940;
(statearr_3949[(14)] = inst_3905);

return statearr_3949;
})();
var statearr_3950_4316 = state_3940__$1;
(statearr_3950_4316[(2)] = null);

(statearr_3950_4316[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (27))){
var state_3940__$1 = state_3940;
var statearr_3951_4317 = state_3940__$1;
(statearr_3951_4317[(1)] = (30));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (1))){
var state_3940__$1 = state_3940;
var statearr_3953_4318 = state_3940__$1;
(statearr_3953_4318[(2)] = null);

(statearr_3953_4318[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (24))){
var state_3940__$1 = state_3940;
var statearr_3954_4319 = state_3940__$1;
(statearr_3954_4319[(2)] = null);

(statearr_3954_4319[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (55))){
var inst_3897 = (state_3940[(10)]);
var inst_3891 = (state_3940[(11)]);
var inst_3892 = (state_3940[(12)]);
var inst_3776 = (state_3940[(7)]);
var inst_3891__$1 = cljs.core.nth.call(null,inst_3776,(1));
var inst_3892__$1 = cljs.core.nth.call(null,inst_3776,(2));
var inst_3893 = cljs.core.pr_str.call(null,inst_3891__$1);
var inst_3894 = ["mbox :: return, correlation=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_3892__$1),", value=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_3893)].join('');
var inst_3895 = console.debug(inst_3894);
var inst_3896 = cljs.core.deref.call(null,returns);
var inst_3897__$1 = cljs.core.get.call(null,inst_3896,inst_3892__$1);
var state_3940__$1 = (function (){var statearr_3955 = state_3940;
(statearr_3955[(10)] = inst_3897__$1);

(statearr_3955[(11)] = inst_3891__$1);

(statearr_3955[(15)] = inst_3895);

(statearr_3955[(12)] = inst_3892__$1);

return statearr_3955;
})();
if(cljs.core.truth_(inst_3897__$1)){
var statearr_3956_4320 = state_3940__$1;
(statearr_3956_4320[(1)] = (58));

} else {
var statearr_3957_4321 = state_3940__$1;
(statearr_3957_4321[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (39))){
var inst_3831 = (state_3940[(16)]);
var inst_3836 = (state_3940[(17)]);
var inst_3830 = (state_3940[(18)]);
var inst_3838 = cljs.core.swap_BANG_.call(null,returns,cljs.core.dissoc,inst_3831);
var state_3940__$1 = (function (){var statearr_3958 = state_3940;
(statearr_3958[(19)] = inst_3838);

return statearr_3958;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3940__$1,(42),inst_3836,inst_3830);
} else {
if((state_val_3941 === (46))){
var inst_3776 = (state_3940[(7)]);
var inst_3858 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_3776)].join('');
var inst_3859 = (new Error(inst_3858));
var inst_3860 = (function(){throw inst_3859})();
var state_3940__$1 = state_3940;
var statearr_3959_4322 = state_3940__$1;
(statearr_3959_4322[(2)] = inst_3860);

(statearr_3959_4322[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (4))){
var inst_3776 = (state_3940[(7)]);
var inst_3776__$1 = (state_3940[(2)]);
var inst_3777 = (inst_3776__$1 === null);
var state_3940__$1 = (function (){var statearr_3960 = state_3940;
(statearr_3960[(7)] = inst_3776__$1);

return statearr_3960;
})();
if(cljs.core.truth_(inst_3777)){
var statearr_3961_4323 = state_3940__$1;
(statearr_3961_4323[(1)] = (5));

} else {
var statearr_3962_4324 = state_3940__$1;
(statearr_3962_4324[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (54))){
var inst_3926 = (state_3940[(2)]);
var state_3940__$1 = state_3940;
var statearr_3963_4325 = state_3940__$1;
(statearr_3963_4325[(2)] = inst_3926);

(statearr_3963_4325[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (15))){
var state_3940__$1 = state_3940;
var statearr_3964_4326 = state_3940__$1;
(statearr_3964_4326[(1)] = (17));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (48))){
var inst_3863 = (state_3940[(2)]);
var state_3940__$1 = state_3940;
var statearr_3966_4327 = state_3940__$1;
(statearr_3966_4327[(2)] = inst_3863);

(statearr_3966_4327[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (50))){
var state_3940__$1 = state_3940;
var statearr_3967_4328 = state_3940__$1;
(statearr_3967_4328[(2)] = null);

(statearr_3967_4328[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (21))){
var state_3940__$1 = state_3940;
var statearr_3968_4329 = state_3940__$1;
(statearr_3968_4329[(1)] = (23));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (31))){
var state_3940__$1 = state_3940;
var statearr_3970_4330 = state_3940__$1;
(statearr_3970_4330[(2)] = null);

(statearr_3970_4330[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (32))){
var inst_3868 = (state_3940[(2)]);
var state_3940__$1 = state_3940;
var statearr_3971_4331 = state_3940__$1;
(statearr_3971_4331[(2)] = inst_3868);

(statearr_3971_4331[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (40))){
var state_3940__$1 = state_3940;
var statearr_3972_4332 = state_3940__$1;
(statearr_3972_4332[(2)] = null);

(statearr_3972_4332[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (56))){
var state_3940__$1 = state_3940;
var statearr_3973_4333 = state_3940__$1;
(statearr_3973_4333[(1)] = (62));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (33))){
var inst_3776 = (state_3940[(7)]);
var inst_3827 = cljs.core.nth.call(null,inst_3776,(0));
var inst_3828 = cljs.core.keyword_identical_QMARK_.call(null,inst_3827,new cljs.core.Keyword("otplike.csi.core","return","otplike.csi.core/return",-1827025081));
var state_3940__$1 = state_3940;
if(inst_3828){
var statearr_3975_4334 = state_3940__$1;
(statearr_3975_4334[(1)] = (36));

} else {
var statearr_3976_4335 = state_3940__$1;
(statearr_3976_4335[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (13))){
var inst_3931 = (state_3940[(2)]);
var state_3940__$1 = state_3940;
var statearr_3977_4336 = state_3940__$1;
(statearr_3977_4336[(2)] = inst_3931);

(statearr_3977_4336[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (22))){
var inst_3875 = (state_3940[(2)]);
var state_3940__$1 = state_3940;
var statearr_3978_4337 = state_3940__$1;
(statearr_3978_4337[(2)] = inst_3875);

(statearr_3978_4337[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (36))){
var inst_3831 = (state_3940[(16)]);
var inst_3836 = (state_3940[(17)]);
var inst_3830 = (state_3940[(18)]);
var inst_3776 = (state_3940[(7)]);
var inst_3830__$1 = cljs.core.nth.call(null,inst_3776,(1));
var inst_3831__$1 = cljs.core.nth.call(null,inst_3776,(2));
var inst_3832 = cljs.core.pr_str.call(null,inst_3830__$1);
var inst_3833 = ["mbox :: return, correlation=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_3831__$1),", value=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_3832)].join('');
var inst_3834 = console.debug(inst_3833);
var inst_3835 = cljs.core.deref.call(null,returns);
var inst_3836__$1 = cljs.core.get.call(null,inst_3835,inst_3831__$1);
var state_3940__$1 = (function (){var statearr_3979 = state_3940;
(statearr_3979[(16)] = inst_3831__$1);

(statearr_3979[(17)] = inst_3836__$1);

(statearr_3979[(20)] = inst_3834);

(statearr_3979[(18)] = inst_3830__$1);

return statearr_3979;
})();
if(cljs.core.truth_(inst_3836__$1)){
var statearr_3980_4338 = state_3940__$1;
(statearr_3980_4338[(1)] = (39));

} else {
var statearr_3981_4339 = state_3940__$1;
(statearr_3981_4339[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (41))){
var inst_3844 = (state_3940[(2)]);
var state_3940__$1 = (function (){var statearr_3982 = state_3940;
(statearr_3982[(21)] = inst_3844);

return statearr_3982;
})();
var statearr_3983_4340 = state_3940__$1;
(statearr_3983_4340[(2)] = null);

(statearr_3983_4340[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (43))){
var inst_3776 = (state_3940[(7)]);
var inst_3848 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_3776)].join('');
var inst_3849 = (new Error(inst_3848));
var inst_3850 = (function(){throw inst_3849})();
var state_3940__$1 = state_3940;
var statearr_3984_4341 = state_3940__$1;
(statearr_3984_4341[(2)] = inst_3850);

(statearr_3984_4341[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (61))){
var inst_3897 = (state_3940[(10)]);
var inst_3901 = (state_3940[(2)]);
var inst_3902 = cljs.core.async.close_BANG_.call(null,inst_3897);
var state_3940__$1 = (function (){var statearr_3985 = state_3940;
(statearr_3985[(22)] = inst_3901);

return statearr_3985;
})();
var statearr_3986_4342 = state_3940__$1;
(statearr_3986_4342[(2)] = inst_3902);

(statearr_3986_4342[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (29))){
var inst_3818 = (state_3940[(2)]);
var state_3940__$1 = (function (){var statearr_3987 = state_3940;
(statearr_3987[(23)] = inst_3818);

return statearr_3987;
})();
var statearr_3988_4343 = state_3940__$1;
(statearr_3988_4343[(2)] = null);

(statearr_3988_4343[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (44))){
var state_3940__$1 = state_3940;
var statearr_3989_4344 = state_3940__$1;
(statearr_3989_4344[(2)] = null);

(statearr_3989_4344[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (6))){
var state_3940__$1 = state_3940;
var statearr_3990_4345 = state_3940__$1;
(statearr_3990_4345[(1)] = (8));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (28))){
var inst_3870 = (state_3940[(2)]);
var state_3940__$1 = state_3940;
var statearr_3992_4346 = state_3940__$1;
(statearr_3992_4346[(2)] = inst_3870);

(statearr_3992_4346[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (64))){
var inst_3914 = (state_3940[(2)]);
var state_3940__$1 = state_3940;
var statearr_3993_4347 = state_3940__$1;
(statearr_3993_4347[(2)] = inst_3914);

(statearr_3993_4347[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (51))){
var inst_3929 = (state_3940[(2)]);
var state_3940__$1 = state_3940;
var statearr_3994_4348 = state_3940__$1;
(statearr_3994_4348[(2)] = inst_3929);

(statearr_3994_4348[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (25))){
var inst_3873 = (state_3940[(2)]);
var state_3940__$1 = state_3940;
var statearr_3995_4349 = state_3940__$1;
(statearr_3995_4349[(2)] = inst_3873);

(statearr_3995_4349[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (34))){
var state_3940__$1 = state_3940;
var statearr_3996_4350 = state_3940__$1;
(statearr_3996_4350[(1)] = (46));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (17))){
var inst_3776 = (state_3940[(7)]);
var inst_3798 = cljs.core.nth.call(null,inst_3776,(0));
var inst_3799 = cljs.core.keyword_identical_QMARK_.call(null,inst_3798,new cljs.core.Keyword("otplike.csi.core","ping","otplike.csi.core/ping",-1875108480));
var state_3940__$1 = state_3940;
if(inst_3799){
var statearr_3998_4351 = state_3940__$1;
(statearr_3998_4351[(1)] = (20));

} else {
var statearr_3999_4352 = state_3940__$1;
(statearr_3999_4352[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (3))){
var inst_3938 = (state_3940[(2)]);
var state_3940__$1 = state_3940;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3940__$1,inst_3938);
} else {
if((state_val_3941 === (12))){
var state_3940__$1 = state_3940;
var statearr_4000_4353 = state_3940__$1;
(statearr_4000_4353[(1)] = (49));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (2))){
var state_3940__$1 = state_3940;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3940__$1,(4),ws);
} else {
if((state_val_3941 === (66))){
var state_3940__$1 = state_3940;
var statearr_4002_4354 = state_3940__$1;
(statearr_4002_4354[(2)] = null);

(statearr_4002_4354[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (23))){
var inst_3776 = (state_3940[(7)]);
var inst_3811 = cljs.core.nth.call(null,inst_3776,(0));
var inst_3812 = cljs.core.keyword_identical_QMARK_.call(null,inst_3811,new cljs.core.Keyword("otplike.csi.core","message","otplike.csi.core/message",-337368482));
var state_3940__$1 = state_3940;
if(inst_3812){
var statearr_4003_4355 = state_3940__$1;
(statearr_4003_4355[(1)] = (26));

} else {
var statearr_4004_4356 = state_3940__$1;
(statearr_4004_4356[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (47))){
var state_3940__$1 = state_3940;
var statearr_4005_4357 = state_3940__$1;
(statearr_4005_4357[(2)] = null);

(statearr_4005_4357[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (35))){
var inst_3865 = (state_3940[(2)]);
var state_3940__$1 = state_3940;
var statearr_4006_4358 = state_3940__$1;
(statearr_4006_4358[(2)] = inst_3865);

(statearr_4006_4358[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (19))){
var inst_3878 = (state_3940[(2)]);
var state_3940__$1 = state_3940;
var statearr_4007_4359 = state_3940__$1;
(statearr_4007_4359[(2)] = inst_3878);

(statearr_4007_4359[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (57))){
var inst_3916 = (state_3940[(2)]);
var state_3940__$1 = state_3940;
var statearr_4008_4360 = state_3940__$1;
(statearr_4008_4360[(2)] = inst_3916);

(statearr_4008_4360[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (11))){
var inst_3776 = (state_3940[(7)]);
var inst_3789 = cljs.core.nth.call(null,inst_3776,(0));
var inst_3790 = cljs.core.keyword_identical_QMARK_.call(null,inst_3789,new cljs.core.Keyword("otplike.csi.core","exit","otplike.csi.core/exit",420540614));
var state_3940__$1 = state_3940;
if(inst_3790){
var statearr_4009_4361 = state_3940__$1;
(statearr_4009_4361[(1)] = (14));

} else {
var statearr_4010_4362 = state_3940__$1;
(statearr_4010_4362[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (9))){
var state_3940__$1 = state_3940;
var statearr_4011_4363 = state_3940__$1;
(statearr_4011_4363[(2)] = null);

(statearr_4011_4363[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (5))){
var inst_3779 = ["mbox :: disconnect"].join('');
var inst_3780 = console.debug(inst_3779);
var inst_3781 = terminate_BANG_.call(null,new cljs.core.Keyword(null,"disconnected","disconnected",-1908014586));
var state_3940__$1 = (function (){var statearr_4012 = state_3940;
(statearr_4012[(24)] = inst_3780);

return statearr_4012;
})();
var statearr_4013_4364 = state_3940__$1;
(statearr_4013_4364[(2)] = inst_3781);

(statearr_4013_4364[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (14))){
var inst_3776 = (state_3940[(7)]);
var inst_3792 = cljs.core.nth.call(null,inst_3776,(1));
var inst_3793 = ["mbox :: exit, reason=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_3792)].join('');
var inst_3794 = console.debug(inst_3793);
var inst_3795 = terminate_BANG_.call(null,inst_3792);
var state_3940__$1 = (function (){var statearr_4014 = state_3940;
(statearr_4014[(25)] = inst_3794);

return statearr_4014;
})();
var statearr_4015_4365 = state_3940__$1;
(statearr_4015_4365[(2)] = inst_3795);

(statearr_4015_4365[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (45))){
var inst_3853 = (state_3940[(2)]);
var state_3940__$1 = state_3940;
var statearr_4016_4366 = state_3940__$1;
(statearr_4016_4366[(2)] = inst_3853);

(statearr_4016_4366[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (53))){
var state_3940__$1 = state_3940;
var statearr_4017_4367 = state_3940__$1;
(statearr_4017_4367[(1)] = (65));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (26))){
var inst_3776 = (state_3940[(7)]);
var inst_3814 = cljs.core.nth.call(null,inst_3776,(1));
var inst_3815 = ["mbox :: message, payload=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_3814)].join('');
var inst_3816 = console.debug(inst_3815);
var state_3940__$1 = (function (){var statearr_4019 = state_3940;
(statearr_4019[(26)] = inst_3816);

return statearr_4019;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3940__$1,(29),out,inst_3814);
} else {
if((state_val_3941 === (16))){
var inst_3880 = (state_3940[(2)]);
var state_3940__$1 = state_3940;
var statearr_4020_4368 = state_3940__$1;
(statearr_4020_4368[(2)] = inst_3880);

(statearr_4020_4368[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (38))){
var inst_3855 = (state_3940[(2)]);
var state_3940__$1 = state_3940;
var statearr_4021_4369 = state_3940__$1;
(statearr_4021_4369[(2)] = inst_3855);

(statearr_4021_4369[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (30))){
var inst_3776 = (state_3940[(7)]);
var inst_3822 = cljs.core.vector_QMARK_.call(null,inst_3776);
var inst_3823 = cljs.core.count.call(null,inst_3776);
var inst_3824 = (inst_3823 === 3);
var inst_3825 = ((inst_3822) && (inst_3824));
var state_3940__$1 = state_3940;
if(cljs.core.truth_(inst_3825)){
var statearr_4022_4370 = state_3940__$1;
(statearr_4022_4370[(1)] = (33));

} else {
var statearr_4023_4371 = state_3940__$1;
(statearr_4023_4371[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (10))){
var inst_3934 = (state_3940[(2)]);
var state_3940__$1 = state_3940;
var statearr_4024_4372 = state_3940__$1;
(statearr_4024_4372[(2)] = inst_3934);

(statearr_4024_4372[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (18))){
var state_3940__$1 = state_3940;
var statearr_4025_4373 = state_3940__$1;
(statearr_4025_4373[(2)] = null);

(statearr_4025_4373[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (52))){
var inst_3776 = (state_3940[(7)]);
var inst_3888 = cljs.core.nth.call(null,inst_3776,(0));
var inst_3889 = cljs.core.keyword_identical_QMARK_.call(null,inst_3888,new cljs.core.Keyword("otplike.csi.core","return","otplike.csi.core/return",-1827025081));
var state_3940__$1 = state_3940;
if(inst_3889){
var statearr_4026_4374 = state_3940__$1;
(statearr_4026_4374[(1)] = (55));

} else {
var statearr_4027_4375 = state_3940__$1;
(statearr_4027_4375[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (67))){
var inst_3924 = (state_3940[(2)]);
var state_3940__$1 = state_3940;
var statearr_4028_4376 = state_3940__$1;
(statearr_4028_4376[(2)] = inst_3924);

(statearr_4028_4376[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (42))){
var inst_3836 = (state_3940[(17)]);
var inst_3840 = (state_3940[(2)]);
var inst_3841 = cljs.core.async.close_BANG_.call(null,inst_3836);
var state_3940__$1 = (function (){var statearr_4029 = state_3940;
(statearr_4029[(27)] = inst_3840);

return statearr_4029;
})();
var statearr_4030_4377 = state_3940__$1;
(statearr_4030_4377[(2)] = inst_3841);

(statearr_4030_4377[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (37))){
var state_3940__$1 = state_3940;
var statearr_4031_4378 = state_3940__$1;
(statearr_4031_4378[(1)] = (43));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (63))){
var state_3940__$1 = state_3940;
var statearr_4033_4379 = state_3940__$1;
(statearr_4033_4379[(2)] = null);

(statearr_4033_4379[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (8))){
var inst_3776 = (state_3940[(7)]);
var inst_3784 = cljs.core.vector_QMARK_.call(null,inst_3776);
var inst_3785 = cljs.core.count.call(null,inst_3776);
var inst_3786 = (inst_3785 === 2);
var inst_3787 = ((inst_3784) && (inst_3786));
var state_3940__$1 = state_3940;
if(cljs.core.truth_(inst_3787)){
var statearr_4034_4380 = state_3940__$1;
(statearr_4034_4380[(1)] = (11));

} else {
var statearr_4035_4381 = state_3940__$1;
(statearr_4035_4381[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3941 === (49))){
var inst_3776 = (state_3940[(7)]);
var inst_3883 = cljs.core.vector_QMARK_.call(null,inst_3776);
var inst_3884 = cljs.core.count.call(null,inst_3776);
var inst_3885 = (inst_3884 === 3);
var inst_3886 = ((inst_3883) && (inst_3885));
var state_3940__$1 = state_3940;
if(cljs.core.truth_(inst_3886)){
var statearr_4036_4382 = state_3940__$1;
(statearr_4036_4382[(1)] = (52));

} else {
var statearr_4037_4383 = state_3940__$1;
(statearr_4037_4383[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__2327__auto___4310,out,exit_reason,counter,returns,context,terminate_BANG_))
;
return ((function (switch__2306__auto__,c__2327__auto___4310,out,exit_reason,counter,returns,context,terminate_BANG_){
return (function() {
var otplike$csi$core$make_mbox_$_state_machine__2307__auto__ = null;
var otplike$csi$core$make_mbox_$_state_machine__2307__auto____0 = (function (){
var statearr_4038 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_4038[(0)] = otplike$csi$core$make_mbox_$_state_machine__2307__auto__);

(statearr_4038[(1)] = (1));

return statearr_4038;
});
var otplike$csi$core$make_mbox_$_state_machine__2307__auto____1 = (function (state_3940){
while(true){
var ret_value__2308__auto__ = (function (){try{while(true){
var result__2309__auto__ = switch__2306__auto__.call(null,state_3940);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2309__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2309__auto__;
}
break;
}
}catch (e4039){if((e4039 instanceof Object)){
var ex__2310__auto__ = e4039;
var statearr_4040_4384 = state_3940;
(statearr_4040_4384[(5)] = ex__2310__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_3940);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e4039;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2308__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4385 = state_3940;
state_3940 = G__4385;
continue;
} else {
return ret_value__2308__auto__;
}
break;
}
});
otplike$csi$core$make_mbox_$_state_machine__2307__auto__ = function(state_3940){
switch(arguments.length){
case 0:
return otplike$csi$core$make_mbox_$_state_machine__2307__auto____0.call(this);
case 1:
return otplike$csi$core$make_mbox_$_state_machine__2307__auto____1.call(this,state_3940);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
otplike$csi$core$make_mbox_$_state_machine__2307__auto__.cljs$core$IFn$_invoke$arity$0 = otplike$csi$core$make_mbox_$_state_machine__2307__auto____0;
otplike$csi$core$make_mbox_$_state_machine__2307__auto__.cljs$core$IFn$_invoke$arity$1 = otplike$csi$core$make_mbox_$_state_machine__2307__auto____1;
return otplike$csi$core$make_mbox_$_state_machine__2307__auto__;
})()
;})(switch__2306__auto__,c__2327__auto___4310,out,exit_reason,counter,returns,context,terminate_BANG_))
})();
var state__2329__auto__ = (function (){var statearr_4041 = f__2328__auto__.call(null);
(statearr_4041[(6)] = c__2327__auto___4310);

return statearr_4041;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2329__auto__);
});})(c__2327__auto___4310,out,exit_reason,counter,returns,context,terminate_BANG_))
);


if((typeof otplike !== 'undefined') && (typeof otplike.csi !== 'undefined') && (typeof otplike.csi.core !== 'undefined') && (typeof otplike.csi.core.t_otplike$csi$core4042 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {otplike.csi.core.IErlangMBox}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
otplike.csi.core.t_otplike$csi$core4042 = (function (pid,ws,out,exit_reason,counter,returns,context,terminate_BANG_,meta4043){
this.pid = pid;
this.ws = ws;
this.out = out;
this.exit_reason = exit_reason;
this.counter = counter;
this.returns = returns;
this.context = context;
this.terminate_BANG_ = terminate_BANG_;
this.meta4043 = meta4043;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
otplike.csi.core.t_otplike$csi$core4042.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (out,exit_reason,counter,returns,context,terminate_BANG_){
return (function (_4044,meta4043__$1){
var self__ = this;
var _4044__$1 = this;
return (new otplike.csi.core.t_otplike$csi$core4042(self__.pid,self__.ws,self__.out,self__.exit_reason,self__.counter,self__.returns,self__.context,self__.terminate_BANG_,meta4043__$1));
});})(out,exit_reason,counter,returns,context,terminate_BANG_))
;

otplike.csi.core.t_otplike$csi$core4042.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (out,exit_reason,counter,returns,context,terminate_BANG_){
return (function (_4044){
var self__ = this;
var _4044__$1 = this;
return self__.meta4043;
});})(out,exit_reason,counter,returns,context,terminate_BANG_))
;

otplike.csi.core.t_otplike$csi$core4042.prototype.otplike$csi$core$IErlangMBox$ = cljs.core.PROTOCOL_SENTINEL;

otplike.csi.core.t_otplike$csi$core4042.prototype.otplike$csi$core$IErlangMBox$close_BANG_$arity$1 = ((function (out,exit_reason,counter,returns,context,terminate_BANG_){
return (function (_){
var self__ = this;
var ___$1 = this;
console.debug("mbox :: close requested, closing ws-channel");

cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ws);

return null;
});})(out,exit_reason,counter,returns,context,terminate_BANG_))
;

otplike.csi.core.t_otplike$csi$core4042.prototype.otplike$csi$core$IErlangMBox$reset_context_BANG_$arity$2 = ((function (out,exit_reason,counter,returns,context,terminate_BANG_){
return (function (_,ctx){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.context,ctx);
});})(out,exit_reason,counter,returns,context,terminate_BANG_))
;

otplike.csi.core.t_otplike$csi$core4042.prototype.otplike$csi$core$IErlangMBox$update_context_BANG_$arity$2 = ((function (out,exit_reason,counter,returns,context,terminate_BANG_){
return (function (_,f){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.context,f);
});})(out,exit_reason,counter,returns,context,terminate_BANG_))
;

otplike.csi.core.t_otplike$csi$core4042.prototype.otplike$csi$core$IErlangMBox$cast_BANG_$arity$3 = ((function (out,exit_reason,counter,returns,context,terminate_BANG_){
return (function (_,func,args){
var self__ = this;
var ___$1 = this;
cljs.core.async.put_BANG_.call(null,self__.ws,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("otplike.csi.core","cast","otplike.csi.core/cast",-1694441655),func,args], null),cljs.core.deref.call(null,self__.context)], null));

return null;
});})(out,exit_reason,counter,returns,context,terminate_BANG_))
;

otplike.csi.core.t_otplike$csi$core4042.prototype.otplike$csi$core$IErlangMBox$call_BANG_$arity$3 = ((function (out,exit_reason,counter,returns,context,terminate_BANG_){
return (function (this$,func,args){
var self__ = this;
var this$__$1 = this;
return otplike.csi.core.call_BANG_.call(null,this$__$1,func,args,(5000));
});})(out,exit_reason,counter,returns,context,terminate_BANG_))
;

otplike.csi.core.t_otplike$csi$core4042.prototype.otplike$csi$core$IErlangMBox$call_BANG_$arity$4 = ((function (out,exit_reason,counter,returns,context,terminate_BANG_){
return (function (this$,func,args,timeout){
var self__ = this;
var this$__$1 = this;
var correlation = cljs.core.swap_BANG_.call(null,self__.counter,cljs.core.inc);
var result_chan = cljs.core.async.chan.call(null);
var return_chan = cljs.core.async.chan.call(null);
var timeout_chan = cljs.core.async.timeout.call(null,timeout);
cljs.core.swap_BANG_.call(null,self__.returns,cljs.core.assoc,correlation,result_chan);

console.debug(["mbox :: call! correlation=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(correlation),", args",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,args))].join(''));

var c__2327__auto___4386 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2327__auto___4386,correlation,result_chan,return_chan,timeout_chan,this$__$1,out,exit_reason,counter,returns,context,terminate_BANG_){
return (function (){
var f__2328__auto__ = (function (){var switch__2306__auto__ = ((function (c__2327__auto___4386,correlation,result_chan,return_chan,timeout_chan,this$__$1,out,exit_reason,counter,returns,context,terminate_BANG_){
return (function (state_4205){
var state_val_4206 = (state_4205[(1)]);
if((state_val_4206 === (65))){
var inst_4199 = (state_4205[(2)]);
var state_4205__$1 = state_4205;
var statearr_4207_4387 = state_4205__$1;
(statearr_4207_4387[(2)] = inst_4199);

(statearr_4207_4387[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (62))){
var inst_4189 = (state_4205[(2)]);
var state_4205__$1 = state_4205;
var statearr_4208_4388 = state_4205__$1;
(statearr_4208_4388[(2)] = inst_4189);

(statearr_4208_4388[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (7))){
var inst_4063 = (state_4205[(2)]);
var state_4205__$1 = state_4205;
var statearr_4209_4389 = state_4205__$1;
(statearr_4209_4389[(2)] = inst_4063);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4205__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (59))){
var inst_4179 = (state_4205[(2)]);
var state_4205__$1 = state_4205;
var statearr_4210_4390 = state_4205__$1;
(statearr_4210_4390[(2)] = inst_4179);

(statearr_4210_4390[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (20))){
var inst_4075 = (state_4205[(7)]);
var inst_4080 = (function(){throw inst_4075})();
var state_4205__$1 = state_4205;
var statearr_4211_4391 = state_4205__$1;
(statearr_4211_4391[(2)] = inst_4080);

(statearr_4211_4391[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (58))){
var state_4205__$1 = state_4205;
var statearr_4212_4392 = state_4205__$1;
(statearr_4212_4392[(2)] = null);

(statearr_4212_4392[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (60))){
var inst_4186 = (function(){throw cljs.core.match.backtrack})();
var state_4205__$1 = state_4205;
var statearr_4213_4393 = state_4205__$1;
(statearr_4213_4393[(2)] = inst_4186);

(statearr_4213_4393[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (27))){
var inst_4089 = (state_4205[(8)]);
var inst_4089__$1 = (state_4205[(2)]);
var inst_4090 = (inst_4089__$1 === cljs.core.match.backtrack);
var state_4205__$1 = (function (){var statearr_4214 = state_4205;
(statearr_4214[(8)] = inst_4089__$1);

return statearr_4214;
})();
if(cljs.core.truth_(inst_4090)){
var statearr_4215_4394 = state_4205__$1;
(statearr_4215_4394[(1)] = (28));

} else {
var statearr_4216_4395 = state_4205__$1;
(statearr_4216_4395[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (1))){
var inst_4049 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_4050 = [result_chan,timeout_chan];
var inst_4051 = (new cljs.core.PersistentVector(null,2,(5),inst_4049,inst_4050,null));
var state_4205__$1 = state_4205;
return cljs.core.async.ioc_alts_BANG_.call(null,state_4205__$1,(2),inst_4051);
} else {
if((state_val_4206 === (24))){
var state_4205__$1 = state_4205;
var statearr_4217_4396 = state_4205__$1;
(statearr_4217_4396[(1)] = (38));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (55))){
var state_4205__$1 = state_4205;
var statearr_4219_4397 = state_4205__$1;
(statearr_4219_4397[(1)] = (57));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (39))){
var state_4205__$1 = state_4205;
var statearr_4221_4398 = state_4205__$1;
(statearr_4221_4398[(2)] = null);

(statearr_4221_4398[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (46))){
var inst_4143 = (state_4205[(9)]);
var inst_4143__$1 = (state_4205[(2)]);
var inst_4144 = (inst_4143__$1 === cljs.core.match.backtrack);
var state_4205__$1 = (function (){var statearr_4222 = state_4205;
(statearr_4222[(9)] = inst_4143__$1);

return statearr_4222;
})();
if(cljs.core.truth_(inst_4144)){
var statearr_4223_4399 = state_4205__$1;
(statearr_4223_4399[(1)] = (47));

} else {
var statearr_4224_4400 = state_4205__$1;
(statearr_4224_4400[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (4))){
var inst_4054 = (state_4205[(10)]);
var inst_4054__$1 = (state_4205[(2)]);
var inst_4055 = (inst_4054__$1 === cljs.core.match.backtrack);
var state_4205__$1 = (function (){var statearr_4225 = state_4205;
(statearr_4225[(10)] = inst_4054__$1);

return statearr_4225;
})();
if(cljs.core.truth_(inst_4055)){
var statearr_4226_4401 = state_4205__$1;
(statearr_4226_4401[(1)] = (5));

} else {
var statearr_4227_4402 = state_4205__$1;
(statearr_4227_4402[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (54))){
var inst_4164 = ["mbox :: call! correlation=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(correlation)," - disconnected"].join('');
var inst_4165 = console.debug(inst_4164);
var inst_4166 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_4167 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_4168 = [func,args];
var inst_4169 = (new cljs.core.PersistentVector(null,2,(5),inst_4167,inst_4168,null));
var inst_4170 = [new cljs.core.Keyword(null,"disconnected","disconnected",-1908014586),inst_4169];
var inst_4171 = (new cljs.core.PersistentVector(null,2,(5),inst_4166,inst_4170,null));
var inst_4172 = self__.terminate_BANG_.call(null,inst_4171);
var inst_4173 = otplike.csi.core.close_BANG_.call(null,this$__$1);
var state_4205__$1 = (function (){var statearr_4228 = state_4205;
(statearr_4228[(11)] = inst_4172);

(statearr_4228[(12)] = inst_4165);

return statearr_4228;
})();
var statearr_4229_4403 = state_4205__$1;
(statearr_4229_4403[(2)] = inst_4173);

(statearr_4229_4403[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (15))){
var inst_4072 = (state_4205[(13)]);
var inst_4134 = (function(){throw inst_4072})();
var state_4205__$1 = state_4205;
var statearr_4230_4404 = state_4205__$1;
(statearr_4230_4404[(2)] = inst_4134);

(statearr_4230_4404[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (48))){
var inst_4143 = (state_4205[(9)]);
var inst_4155 = (function(){throw inst_4143})();
var state_4205__$1 = state_4205;
var statearr_4231_4405 = state_4205__$1;
(statearr_4231_4405[(2)] = inst_4155);

(statearr_4231_4405[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (50))){
var state_4205__$1 = state_4205;
var statearr_4232_4406 = state_4205__$1;
(statearr_4232_4406[(2)] = null);

(statearr_4232_4406[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (21))){
var inst_4082 = (state_4205[(2)]);
var state_4205__$1 = state_4205;
var statearr_4233_4407 = state_4205__$1;
(statearr_4233_4407[(2)] = inst_4082);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4205__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (31))){
var inst_4053 = (state_4205[(14)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_4205,(27),Error,null,(26));
var inst_4100 = cljs.core.nth.call(null,inst_4053,(0));
var inst_4101 = (inst_4100 === null);
var state_4205__$1 = state_4205;
if(cljs.core.truth_(inst_4101)){
var statearr_4234_4408 = state_4205__$1;
(statearr_4234_4408[(1)] = (32));

} else {
var statearr_4235_4409 = state_4205__$1;
(statearr_4235_4409[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (32))){
var inst_4103 = ["mbox :: call! correlation=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(correlation)," - timeout"].join('');
var inst_4104 = console.debug(inst_4103);
var inst_4105 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_4106 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_4107 = [func,args];
var inst_4108 = (new cljs.core.PersistentVector(null,2,(5),inst_4106,inst_4107,null));
var inst_4109 = [new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_4108,timeout];
var inst_4110 = (new cljs.core.PersistentVector(null,3,(5),inst_4105,inst_4109,null));
var inst_4111 = self__.terminate_BANG_.call(null,inst_4110);
var inst_4112 = otplike.csi.core.close_BANG_.call(null,this$__$1);
var state_4205__$1 = (function (){var statearr_4236 = state_4205;
(statearr_4236[(15)] = inst_4111);

(statearr_4236[(16)] = inst_4104);

return statearr_4236;
})();
var statearr_4237_4410 = state_4205__$1;
(statearr_4237_4410[(2)] = inst_4112);

(statearr_4237_4410[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (40))){
var inst_4128 = (state_4205[(2)]);
var state_4205__$1 = state_4205;
var statearr_4238_4411 = state_4205__$1;
(statearr_4238_4411[(2)] = inst_4128);

(statearr_4238_4411[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (56))){
var inst_4181 = (state_4205[(2)]);
var state_4205__$1 = state_4205;
var statearr_4239_4412 = state_4205__$1;
(statearr_4239_4412[(2)] = inst_4181);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4205__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (33))){
var state_4205__$1 = state_4205;
var statearr_4240_4413 = state_4205__$1;
(statearr_4240_4413[(1)] = (35));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (13))){
var inst_4072 = (state_4205[(13)]);
var inst_4072__$1 = (state_4205[(2)]);
var inst_4073 = (inst_4072__$1 === cljs.core.match.backtrack);
var state_4205__$1 = (function (){var statearr_4242 = state_4205;
(statearr_4242[(13)] = inst_4072__$1);

return statearr_4242;
})();
if(cljs.core.truth_(inst_4073)){
var statearr_4243_4414 = state_4205__$1;
(statearr_4243_4414[(1)] = (14));

} else {
var statearr_4244_4415 = state_4205__$1;
(statearr_4244_4415[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (22))){
var inst_4053 = (state_4205[(14)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_4205,(18),Error,null,(17));
var inst_4086 = cljs.core.nth.call(null,inst_4053,(1));
var inst_4087 = cljs.core._EQ_.call(null,inst_4086,timeout_chan);
var state_4205__$1 = state_4205;
if(inst_4087){
var statearr_4245_4416 = state_4205__$1;
(statearr_4245_4416[(1)] = (23));

} else {
var statearr_4246_4417 = state_4205__$1;
(statearr_4246_4417[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (36))){
var state_4205__$1 = state_4205;
var statearr_4247_4418 = state_4205__$1;
(statearr_4247_4418[(2)] = null);

(statearr_4247_4418[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (41))){
var inst_4053 = (state_4205[(14)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_4205,(13),Error,null,(12));
var inst_4140 = cljs.core.nth.call(null,inst_4053,(1));
var inst_4141 = cljs.core._EQ_.call(null,inst_4140,result_chan);
var state_4205__$1 = state_4205;
if(inst_4141){
var statearr_4248_4419 = state_4205__$1;
(statearr_4248_4419[(1)] = (42));

} else {
var statearr_4249_4420 = state_4205__$1;
(statearr_4249_4420[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (43))){
var state_4205__$1 = state_4205;
var statearr_4250_4421 = state_4205__$1;
(statearr_4250_4421[(1)] = (60));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (61))){
var state_4205__$1 = state_4205;
var statearr_4252_4422 = state_4205__$1;
(statearr_4252_4422[(2)] = null);

(statearr_4252_4422[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (29))){
var inst_4089 = (state_4205[(8)]);
var inst_4094 = (function(){throw inst_4089})();
var state_4205__$1 = state_4205;
var statearr_4253_4423 = state_4205__$1;
(statearr_4253_4423[(2)] = inst_4094);

(statearr_4253_4423[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (44))){
var inst_4191 = (state_4205[(2)]);
var state_4205__$1 = state_4205;
var statearr_4254_4424 = state_4205__$1;
(statearr_4254_4424[(2)] = inst_4191);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4205__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (6))){
var inst_4054 = (state_4205[(10)]);
var inst_4061 = (function(){throw inst_4054})();
var state_4205__$1 = state_4205;
var statearr_4255_4425 = state_4205__$1;
(statearr_4255_4425[(2)] = inst_4061);

(statearr_4255_4425[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (28))){
var inst_4092 = (function(){throw cljs.core.match.backtrack})();
var state_4205__$1 = state_4205;
var statearr_4256_4426 = state_4205__$1;
(statearr_4256_4426[(2)] = inst_4092);

(statearr_4256_4426[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (64))){
var state_4205__$1 = state_4205;
var statearr_4257_4427 = state_4205__$1;
(statearr_4257_4427[(2)] = null);

(statearr_4257_4427[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (51))){
var inst_4150 = ["mbox :: call! correlation=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(correlation)," - no receiver for the result, dropping"].join('');
var inst_4151 = console.warn(inst_4150);
var state_4205__$1 = state_4205;
var statearr_4258_4428 = state_4205__$1;
(statearr_4258_4428[(2)] = inst_4151);

(statearr_4258_4428[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (25))){
var inst_4130 = (state_4205[(2)]);
var state_4205__$1 = state_4205;
var statearr_4259_4429 = state_4205__$1;
(statearr_4259_4429[(2)] = inst_4130);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4205__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (34))){
var inst_4120 = (state_4205[(2)]);
var state_4205__$1 = state_4205;
var statearr_4260_4430 = state_4205__$1;
(statearr_4260_4430[(2)] = inst_4120);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4205__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (17))){
var inst_4132 = (state_4205[(2)]);
var state_4205__$1 = state_4205;
var statearr_4261_4431 = state_4205__$1;
(statearr_4261_4431[(2)] = inst_4132);

(statearr_4261_4431[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (3))){
var inst_4203 = (state_4205[(2)]);
var state_4205__$1 = state_4205;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4205__$1,inst_4203);
} else {
if((state_val_4206 === (12))){
var inst_4193 = (state_4205[(2)]);
var state_4205__$1 = state_4205;
var statearr_4262_4432 = state_4205__$1;
(statearr_4262_4432[(2)] = inst_4193);

(statearr_4262_4432[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (2))){
var inst_4053 = (state_4205[(2)]);
var state_4205__$1 = (function (){var statearr_4263 = state_4205;
(statearr_4263[(14)] = inst_4053);

return statearr_4263;
})();
var statearr_4264_4433 = state_4205__$1;
(statearr_4264_4433[(2)] = null);

(statearr_4264_4433[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (23))){
var state_4205__$1 = state_4205;
var statearr_4265_4434 = state_4205__$1;
(statearr_4265_4434[(2)] = null);

(statearr_4265_4434[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (47))){
var inst_4053 = (state_4205[(14)]);
var inst_4146 = cljs.core.nth.call(null,inst_4053,(0));
var inst_4147 = cljs.core.async.offer_BANG_.call(null,return_chan,inst_4146);
var state_4205__$1 = state_4205;
if(cljs.core.truth_(inst_4147)){
var statearr_4266_4435 = state_4205__$1;
(statearr_4266_4435[(1)] = (50));

} else {
var statearr_4267_4436 = state_4205__$1;
(statearr_4267_4436[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (35))){
var inst_4115 = (function(){throw cljs.core.match.backtrack})();
var state_4205__$1 = state_4205;
var statearr_4268_4437 = state_4205__$1;
(statearr_4268_4437[(2)] = inst_4115);

(statearr_4268_4437[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (19))){
var inst_4078 = (function(){throw cljs.core.match.backtrack})();
var state_4205__$1 = state_4205;
var statearr_4269_4438 = state_4205__$1;
(statearr_4269_4438[(2)] = inst_4078);

(statearr_4269_4438[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (57))){
var inst_4176 = (function(){throw cljs.core.match.backtrack})();
var state_4205__$1 = state_4205;
var statearr_4270_4439 = state_4205__$1;
(statearr_4270_4439[(2)] = inst_4176);

(statearr_4270_4439[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (11))){
var inst_4201 = (state_4205[(2)]);
var state_4205__$1 = state_4205;
var statearr_4271_4440 = state_4205__$1;
(statearr_4271_4440[(2)] = inst_4201);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4205__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (9))){
var state_4205__$1 = state_4205;
var statearr_4272_4441 = state_4205__$1;
(statearr_4272_4441[(2)] = null);

(statearr_4272_4441[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (5))){
var inst_4053 = (state_4205[(14)]);
var inst_4057 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_4053)].join('');
var inst_4058 = (new Error(inst_4057));
var inst_4059 = (function(){throw inst_4058})();
var state_4205__$1 = state_4205;
var statearr_4273_4442 = state_4205__$1;
(statearr_4273_4442[(2)] = inst_4059);

(statearr_4273_4442[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (14))){
var state_4205__$1 = state_4205;
var statearr_4274_4443 = state_4205__$1;
(statearr_4274_4443[(2)] = null);

(statearr_4274_4443[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (45))){
var inst_4183 = (state_4205[(2)]);
var state_4205__$1 = state_4205;
var statearr_4275_4444 = state_4205__$1;
(statearr_4275_4444[(2)] = inst_4183);

(statearr_4275_4444[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (53))){
var inst_4053 = (state_4205[(14)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_4205,(46),Error,null,(45));
var inst_4161 = cljs.core.nth.call(null,inst_4053,(0));
var inst_4162 = (inst_4161 === null);
var state_4205__$1 = state_4205;
if(cljs.core.truth_(inst_4162)){
var statearr_4276_4445 = state_4205__$1;
(statearr_4276_4445[(1)] = (54));

} else {
var statearr_4277_4446 = state_4205__$1;
(statearr_4277_4446[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (26))){
var inst_4122 = (state_4205[(2)]);
var state_4205__$1 = state_4205;
var statearr_4278_4447 = state_4205__$1;
(statearr_4278_4447[(2)] = inst_4122);

(statearr_4278_4447[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (16))){
var inst_4136 = (state_4205[(2)]);
var state_4205__$1 = state_4205;
var statearr_4279_4448 = state_4205__$1;
(statearr_4279_4448[(2)] = inst_4136);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4205__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (38))){
var inst_4125 = (function(){throw cljs.core.match.backtrack})();
var state_4205__$1 = state_4205;
var statearr_4280_4449 = state_4205__$1;
(statearr_4280_4449[(2)] = inst_4125);

(statearr_4280_4449[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (30))){
var inst_4096 = (state_4205[(2)]);
var state_4205__$1 = state_4205;
var statearr_4281_4450 = state_4205__$1;
(statearr_4281_4450[(2)] = inst_4096);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4205__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (10))){
var state_4205__$1 = state_4205;
var statearr_4282_4451 = state_4205__$1;
(statearr_4282_4451[(1)] = (63));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (18))){
var inst_4075 = (state_4205[(7)]);
var inst_4075__$1 = (state_4205[(2)]);
var inst_4076 = (inst_4075__$1 === cljs.core.match.backtrack);
var state_4205__$1 = (function (){var statearr_4284 = state_4205;
(statearr_4284[(7)] = inst_4075__$1);

return statearr_4284;
})();
if(cljs.core.truth_(inst_4076)){
var statearr_4285_4452 = state_4205__$1;
(statearr_4285_4452[(1)] = (19));

} else {
var statearr_4286_4453 = state_4205__$1;
(statearr_4286_4453[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (52))){
var inst_4153 = (state_4205[(2)]);
var state_4205__$1 = state_4205;
var statearr_4287_4454 = state_4205__$1;
(statearr_4287_4454[(2)] = inst_4153);

(statearr_4287_4454[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (42))){
var state_4205__$1 = state_4205;
var statearr_4288_4455 = state_4205__$1;
(statearr_4288_4455[(2)] = null);

(statearr_4288_4455[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (37))){
var inst_4118 = (state_4205[(2)]);
var state_4205__$1 = state_4205;
var statearr_4289_4456 = state_4205__$1;
(statearr_4289_4456[(2)] = inst_4118);

(statearr_4289_4456[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (63))){
var inst_4196 = (function(){throw cljs.core.match.backtrack})();
var state_4205__$1 = state_4205;
var statearr_4290_4457 = state_4205__$1;
(statearr_4290_4457[(2)] = inst_4196);

(statearr_4290_4457[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (8))){
var inst_4053 = (state_4205[(14)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_4205,(4),Error,null,(3));
var inst_4067 = cljs.core.vector_QMARK_.call(null,inst_4053);
var inst_4068 = cljs.core.count.call(null,inst_4053);
var inst_4069 = (inst_4068 === 2);
var inst_4070 = ((inst_4067) && (inst_4069));
var state_4205__$1 = state_4205;
if(cljs.core.truth_(inst_4070)){
var statearr_4291_4458 = state_4205__$1;
(statearr_4291_4458[(1)] = (9));

} else {
var statearr_4292_4459 = state_4205__$1;
(statearr_4292_4459[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4206 === (49))){
var inst_4157 = (state_4205[(2)]);
var state_4205__$1 = state_4205;
var statearr_4293_4460 = state_4205__$1;
(statearr_4293_4460[(2)] = inst_4157);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4205__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__2327__auto___4386,correlation,result_chan,return_chan,timeout_chan,this$__$1,out,exit_reason,counter,returns,context,terminate_BANG_))
;
return ((function (switch__2306__auto__,c__2327__auto___4386,correlation,result_chan,return_chan,timeout_chan,this$__$1,out,exit_reason,counter,returns,context,terminate_BANG_){
return (function() {
var otplike$csi$core$make_mbox_$_state_machine__2307__auto__ = null;
var otplike$csi$core$make_mbox_$_state_machine__2307__auto____0 = (function (){
var statearr_4294 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_4294[(0)] = otplike$csi$core$make_mbox_$_state_machine__2307__auto__);

(statearr_4294[(1)] = (1));

return statearr_4294;
});
var otplike$csi$core$make_mbox_$_state_machine__2307__auto____1 = (function (state_4205){
while(true){
var ret_value__2308__auto__ = (function (){try{while(true){
var result__2309__auto__ = switch__2306__auto__.call(null,state_4205);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2309__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2309__auto__;
}
break;
}
}catch (e4295){if((e4295 instanceof Object)){
var ex__2310__auto__ = e4295;
var statearr_4296_4461 = state_4205;
(statearr_4296_4461[(5)] = ex__2310__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4205);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e4295;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2308__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4462 = state_4205;
state_4205 = G__4462;
continue;
} else {
return ret_value__2308__auto__;
}
break;
}
});
otplike$csi$core$make_mbox_$_state_machine__2307__auto__ = function(state_4205){
switch(arguments.length){
case 0:
return otplike$csi$core$make_mbox_$_state_machine__2307__auto____0.call(this);
case 1:
return otplike$csi$core$make_mbox_$_state_machine__2307__auto____1.call(this,state_4205);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
otplike$csi$core$make_mbox_$_state_machine__2307__auto__.cljs$core$IFn$_invoke$arity$0 = otplike$csi$core$make_mbox_$_state_machine__2307__auto____0;
otplike$csi$core$make_mbox_$_state_machine__2307__auto__.cljs$core$IFn$_invoke$arity$1 = otplike$csi$core$make_mbox_$_state_machine__2307__auto____1;
return otplike$csi$core$make_mbox_$_state_machine__2307__auto__;
})()
;})(switch__2306__auto__,c__2327__auto___4386,correlation,result_chan,return_chan,timeout_chan,this$__$1,out,exit_reason,counter,returns,context,terminate_BANG_))
})();
var state__2329__auto__ = (function (){var statearr_4297 = f__2328__auto__.call(null);
(statearr_4297[(6)] = c__2327__auto___4386);

return statearr_4297;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2329__auto__);
});})(c__2327__auto___4386,correlation,result_chan,return_chan,timeout_chan,this$__$1,out,exit_reason,counter,returns,context,terminate_BANG_))
);


cljs.core.async.put_BANG_.call(null,self__.ws,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("otplike.csi.core","call","otplike.csi.core/call",-452421594),func,args,correlation], null),cljs.core.deref.call(null,self__.context)], null));

return return_chan;
});})(out,exit_reason,counter,returns,context,terminate_BANG_))
;

otplike.csi.core.t_otplike$csi$core4042.prototype.otplike$csi$core$IErlangMBox$self$arity$1 = ((function (out,exit_reason,counter,returns,context,terminate_BANG_){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.pid;
});})(out,exit_reason,counter,returns,context,terminate_BANG_))
;

otplike.csi.core.t_otplike$csi$core4042.prototype.otplike$csi$core$IErlangMBox$exit_reason$arity$1 = ((function (out,exit_reason,counter,returns,context,terminate_BANG_){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.exit_reason);
});})(out,exit_reason,counter,returns,context,terminate_BANG_))
;

otplike.csi.core.t_otplike$csi$core4042.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

otplike.csi.core.t_otplike$csi$core4042.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = ((function (out,exit_reason,counter,returns,context,terminate_BANG_){
return (function (_,handler){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.out,handler);
});})(out,exit_reason,counter,returns,context,terminate_BANG_))
;

otplike.csi.core.t_otplike$csi$core4042.getBasis = ((function (out,exit_reason,counter,returns,context,terminate_BANG_){
return (function (){
return new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"pid","pid",-1636048071,null),new cljs.core.Symbol(null,"ws","ws",1727372970,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"exit-reason","exit-reason",-1766999710,null),new cljs.core.Symbol(null,"counter","counter",-1850427592,null),new cljs.core.Symbol(null,"returns","returns",1025078949,null),new cljs.core.Symbol(null,"context","context",810340414,null),new cljs.core.Symbol(null,"terminate!","terminate!",1667550856,null),new cljs.core.Symbol(null,"meta4043","meta4043",-1471659689,null)], null);
});})(out,exit_reason,counter,returns,context,terminate_BANG_))
;

otplike.csi.core.t_otplike$csi$core4042.cljs$lang$type = true;

otplike.csi.core.t_otplike$csi$core4042.cljs$lang$ctorStr = "otplike.csi.core/t_otplike$csi$core4042";

otplike.csi.core.t_otplike$csi$core4042.cljs$lang$ctorPrWriter = ((function (out,exit_reason,counter,returns,context,terminate_BANG_){
return (function (this__4179__auto__,writer__4180__auto__,opt__4181__auto__){
return cljs.core._write.call(null,writer__4180__auto__,"otplike.csi.core/t_otplike$csi$core4042");
});})(out,exit_reason,counter,returns,context,terminate_BANG_))
;

/**
 * Positional factory function for otplike.csi.core/t_otplike$csi$core4042.
 */
otplike.csi.core.__GT_t_otplike$csi$core4042 = ((function (out,exit_reason,counter,returns,context,terminate_BANG_){
return (function otplike$csi$core$make_mbox_$___GT_t_otplike$csi$core4042(pid__$1,ws__$1,out__$1,exit_reason__$1,counter__$1,returns__$1,context__$1,terminate_BANG___$1,meta4043){
return (new otplike.csi.core.t_otplike$csi$core4042(pid__$1,ws__$1,out__$1,exit_reason__$1,counter__$1,returns__$1,context__$1,terminate_BANG___$1,meta4043));
});})(out,exit_reason,counter,returns,context,terminate_BANG_))
;

}

return (new otplike.csi.core.t_otplike$csi$core4042(pid,ws,out,exit_reason,counter,returns,context,terminate_BANG_,cljs.core.PersistentArrayMap.EMPTY));
});
otplike.csi.core.mbox = (function otplike$csi$core$mbox(url){
console.debug("handshake :: create mbox with url=",url);

var c__2327__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2327__auto__){
return (function (){
var f__2328__auto__ = (function (){var switch__2306__auto__ = ((function (c__2327__auto__){
return (function (state_4549){
var state_val_4550 = (state_4549[(1)]);
if((state_val_4550 === (7))){
var inst_4472 = (state_4549[(7)]);
var inst_4500 = (function(){throw inst_4472})();
var state_4549__$1 = state_4549;
var statearr_4551_4608 = state_4549__$1;
(statearr_4551_4608[(2)] = inst_4500);

(statearr_4551_4608[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4550 === (20))){
var inst_4494 = (state_4549[(2)]);
var state_4549__$1 = state_4549;
var statearr_4552_4609 = state_4549__$1;
(statearr_4552_4609[(2)] = inst_4494);

(statearr_4552_4609[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4550 === (27))){
var inst_4514 = (function(){throw cljs.core.match.backtrack})();
var state_4549__$1 = state_4549;
var statearr_4553_4610 = state_4549__$1;
(statearr_4553_4610[(2)] = inst_4514);

(statearr_4553_4610[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4550 === (1))){
var inst_4463 = otplike.csi.core.make_ws.call(null,url);
var state_4549__$1 = state_4549;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_4549__$1,(2),inst_4463);
} else {
if((state_val_4550 === (24))){
var inst_4545 = (state_4549[(2)]);
var state_4549__$1 = state_4549;
var statearr_4554_4611 = state_4549__$1;
(statearr_4554_4611[(2)] = inst_4545);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4549__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4550 === (39))){
var inst_4543 = (state_4549[(2)]);
var state_4549__$1 = state_4549;
var statearr_4555_4612 = state_4549__$1;
(statearr_4555_4612[(2)] = inst_4543);

(statearr_4555_4612[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4550 === (4))){
var inst_4547 = (state_4549[(2)]);
var state_4549__$1 = state_4549;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4549__$1,inst_4547);
} else {
if((state_val_4550 === (15))){
var inst_4488 = console.warn("handshake :: unexpected connection close");
var state_4549__$1 = (function (){var statearr_4556 = state_4549;
(statearr_4556[(8)] = inst_4488);

return statearr_4556;
})();
var statearr_4557_4613 = state_4549__$1;
(statearr_4557_4613[(2)] = null);

(statearr_4557_4613[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4550 === (21))){
var inst_4471 = (state_4549[(9)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_4549,(5),Error,null,(4));
var inst_4506 = cljs.core.vector_QMARK_.call(null,inst_4471);
var inst_4507 = cljs.core.count.call(null,inst_4471);
var inst_4508 = (inst_4507 === 2);
var inst_4509 = ((inst_4506) && (inst_4508));
var state_4549__$1 = state_4549;
if(cljs.core.truth_(inst_4509)){
var statearr_4558_4614 = state_4549__$1;
(statearr_4558_4614[(1)] = (22));

} else {
var statearr_4559_4615 = state_4549__$1;
(statearr_4559_4615[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4550 === (31))){
var inst_4465 = (state_4549[(10)]);
var inst_4471 = (state_4549[(9)]);
var inst_4525 = cljs.core.nth.call(null,inst_4471,(1));
var inst_4526 = console.debug("handshake :: counterparty self",inst_4525);
var inst_4527 = otplike.csi.core.make_mbox.call(null,inst_4525,inst_4465);
var state_4549__$1 = (function (){var statearr_4560 = state_4549;
(statearr_4560[(11)] = inst_4526);

return statearr_4560;
})();
var statearr_4561_4616 = state_4549__$1;
(statearr_4561_4616[(2)] = inst_4527);

(statearr_4561_4616[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4550 === (32))){
var state_4549__$1 = state_4549;
var statearr_4562_4617 = state_4549__$1;
(statearr_4562_4617[(1)] = (34));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4550 === (33))){
var inst_4535 = (state_4549[(2)]);
var state_4549__$1 = state_4549;
var statearr_4564_4618 = state_4549__$1;
(statearr_4564_4618[(2)] = inst_4535);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4549__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4550 === (13))){
var inst_4482 = (state_4549[(2)]);
var state_4549__$1 = state_4549;
var statearr_4565_4619 = state_4549__$1;
(statearr_4565_4619[(2)] = inst_4482);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4549__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4550 === (22))){
var state_4549__$1 = state_4549;
var statearr_4566_4620 = state_4549__$1;
(statearr_4566_4620[(2)] = null);

(statearr_4566_4620[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4550 === (36))){
var inst_4533 = (state_4549[(2)]);
var state_4549__$1 = state_4549;
var statearr_4567_4621 = state_4549__$1;
(statearr_4567_4621[(2)] = inst_4533);

(statearr_4567_4621[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4550 === (29))){
var inst_4518 = (state_4549[(2)]);
var state_4549__$1 = state_4549;
var statearr_4568_4622 = state_4549__$1;
(statearr_4568_4622[(2)] = inst_4518);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4549__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4550 === (6))){
var state_4549__$1 = state_4549;
var statearr_4569_4623 = state_4549__$1;
(statearr_4569_4623[(2)] = null);

(statearr_4569_4623[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4550 === (28))){
var inst_4511 = (state_4549[(12)]);
var inst_4516 = (function(){throw inst_4511})();
var state_4549__$1 = state_4549;
var statearr_4570_4624 = state_4549__$1;
(statearr_4570_4624[(2)] = inst_4516);

(statearr_4570_4624[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4550 === (25))){
var inst_4537 = (state_4549[(2)]);
var state_4549__$1 = state_4549;
var statearr_4571_4625 = state_4549__$1;
(statearr_4571_4625[(2)] = inst_4537);

(statearr_4571_4625[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4550 === (34))){
var inst_4530 = (function(){throw cljs.core.match.backtrack})();
var state_4549__$1 = state_4549;
var statearr_4572_4626 = state_4549__$1;
(statearr_4572_4626[(2)] = inst_4530);

(statearr_4572_4626[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4550 === (17))){
var inst_4496 = (state_4549[(2)]);
var state_4549__$1 = state_4549;
var statearr_4573_4627 = state_4549__$1;
(statearr_4573_4627[(2)] = inst_4496);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4549__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4550 === (3))){
var inst_4471 = (state_4549[(2)]);
var state_4549__$1 = (function (){var statearr_4574 = state_4549;
(statearr_4574[(9)] = inst_4471);

return statearr_4574;
})();
var statearr_4575_4628 = state_4549__$1;
(statearr_4575_4628[(2)] = null);

(statearr_4575_4628[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4550 === (12))){
var inst_4475 = (state_4549[(13)]);
var inst_4480 = (function(){throw inst_4475})();
var state_4549__$1 = state_4549;
var statearr_4576_4629 = state_4549__$1;
(statearr_4576_4629[(2)] = inst_4480);

(statearr_4576_4629[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4550 === (2))){
var inst_4465 = (state_4549[(10)]);
var inst_4465__$1 = (state_4549[(2)]);
var state_4549__$1 = (function (){var statearr_4577 = state_4549;
(statearr_4577[(10)] = inst_4465__$1);

return statearr_4577;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_4549__$1,(3),inst_4465__$1);
} else {
if((state_val_4550 === (23))){
var state_4549__$1 = state_4549;
var statearr_4578_4630 = state_4549__$1;
(statearr_4578_4630[(1)] = (37));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4550 === (35))){
var state_4549__$1 = state_4549;
var statearr_4580_4631 = state_4549__$1;
(statearr_4580_4631[(2)] = null);

(statearr_4580_4631[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4550 === (19))){
var state_4549__$1 = state_4549;
var statearr_4581_4632 = state_4549__$1;
(statearr_4581_4632[(2)] = null);

(statearr_4581_4632[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4550 === (11))){
var inst_4471 = (state_4549[(9)]);
var inst_4478 = console.warn("handshake :: unexpected message",inst_4471);
var state_4549__$1 = (function (){var statearr_4582 = state_4549;
(statearr_4582[(14)] = inst_4478);

return statearr_4582;
})();
var statearr_4583_4633 = state_4549__$1;
(statearr_4583_4633[(2)] = null);

(statearr_4583_4633[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4550 === (9))){
var inst_4498 = (state_4549[(2)]);
var state_4549__$1 = state_4549;
var statearr_4584_4634 = state_4549__$1;
(statearr_4584_4634[(2)] = inst_4498);

(statearr_4584_4634[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4550 === (5))){
var inst_4472 = (state_4549[(7)]);
var inst_4472__$1 = (state_4549[(2)]);
var inst_4473 = (inst_4472__$1 === cljs.core.match.backtrack);
var state_4549__$1 = (function (){var statearr_4585 = state_4549;
(statearr_4585[(7)] = inst_4472__$1);

return statearr_4585;
})();
if(cljs.core.truth_(inst_4473)){
var statearr_4586_4635 = state_4549__$1;
(statearr_4586_4635[(1)] = (6));

} else {
var statearr_4587_4636 = state_4549__$1;
(statearr_4587_4636[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4550 === (14))){
var inst_4471 = (state_4549[(9)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_4549,(10),Error,null,(9));
var inst_4486 = (inst_4471 === null);
var state_4549__$1 = state_4549;
if(cljs.core.truth_(inst_4486)){
var statearr_4588_4637 = state_4549__$1;
(statearr_4588_4637[(1)] = (15));

} else {
var statearr_4589_4638 = state_4549__$1;
(statearr_4589_4638[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4550 === (26))){
var inst_4511 = (state_4549[(12)]);
var inst_4511__$1 = (state_4549[(2)]);
var inst_4512 = (inst_4511__$1 === cljs.core.match.backtrack);
var state_4549__$1 = (function (){var statearr_4590 = state_4549;
(statearr_4590[(12)] = inst_4511__$1);

return statearr_4590;
})();
if(cljs.core.truth_(inst_4512)){
var statearr_4591_4639 = state_4549__$1;
(statearr_4591_4639[(1)] = (27));

} else {
var statearr_4592_4640 = state_4549__$1;
(statearr_4592_4640[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4550 === (16))){
var state_4549__$1 = state_4549;
var statearr_4593_4641 = state_4549__$1;
(statearr_4593_4641[(1)] = (18));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4550 === (38))){
var state_4549__$1 = state_4549;
var statearr_4595_4642 = state_4549__$1;
(statearr_4595_4642[(2)] = null);

(statearr_4595_4642[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4550 === (30))){
var inst_4471 = (state_4549[(9)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_4549,(26),Error,null,(25));
var inst_4522 = cljs.core.nth.call(null,inst_4471,(0));
var inst_4523 = cljs.core.keyword_identical_QMARK_.call(null,inst_4522,new cljs.core.Keyword("otplike.csi.core","self","otplike.csi.core/self",-1612922051));
var state_4549__$1 = state_4549;
if(inst_4523){
var statearr_4596_4643 = state_4549__$1;
(statearr_4596_4643[(1)] = (31));

} else {
var statearr_4597_4644 = state_4549__$1;
(statearr_4597_4644[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4550 === (10))){
var inst_4475 = (state_4549[(13)]);
var inst_4475__$1 = (state_4549[(2)]);
var inst_4476 = (inst_4475__$1 === cljs.core.match.backtrack);
var state_4549__$1 = (function (){var statearr_4598 = state_4549;
(statearr_4598[(13)] = inst_4475__$1);

return statearr_4598;
})();
if(cljs.core.truth_(inst_4476)){
var statearr_4599_4645 = state_4549__$1;
(statearr_4599_4645[(1)] = (11));

} else {
var statearr_4600_4646 = state_4549__$1;
(statearr_4600_4646[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4550 === (18))){
var inst_4491 = (function(){throw cljs.core.match.backtrack})();
var state_4549__$1 = state_4549;
var statearr_4601_4647 = state_4549__$1;
(statearr_4601_4647[(2)] = inst_4491);

(statearr_4601_4647[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4550 === (37))){
var inst_4540 = (function(){throw cljs.core.match.backtrack})();
var state_4549__$1 = state_4549;
var statearr_4602_4648 = state_4549__$1;
(statearr_4602_4648[(2)] = inst_4540);

(statearr_4602_4648[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4550 === (8))){
var inst_4502 = (state_4549[(2)]);
var state_4549__$1 = state_4549;
var statearr_4603_4649 = state_4549__$1;
(statearr_4603_4649[(2)] = inst_4502);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4549__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__2327__auto__))
;
return ((function (switch__2306__auto__,c__2327__auto__){
return (function() {
var otplike$csi$core$mbox_$_state_machine__2307__auto__ = null;
var otplike$csi$core$mbox_$_state_machine__2307__auto____0 = (function (){
var statearr_4604 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_4604[(0)] = otplike$csi$core$mbox_$_state_machine__2307__auto__);

(statearr_4604[(1)] = (1));

return statearr_4604;
});
var otplike$csi$core$mbox_$_state_machine__2307__auto____1 = (function (state_4549){
while(true){
var ret_value__2308__auto__ = (function (){try{while(true){
var result__2309__auto__ = switch__2306__auto__.call(null,state_4549);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2309__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2309__auto__;
}
break;
}
}catch (e4605){if((e4605 instanceof Object)){
var ex__2310__auto__ = e4605;
var statearr_4606_4650 = state_4549;
(statearr_4606_4650[(5)] = ex__2310__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4549);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e4605;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2308__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4651 = state_4549;
state_4549 = G__4651;
continue;
} else {
return ret_value__2308__auto__;
}
break;
}
});
otplike$csi$core$mbox_$_state_machine__2307__auto__ = function(state_4549){
switch(arguments.length){
case 0:
return otplike$csi$core$mbox_$_state_machine__2307__auto____0.call(this);
case 1:
return otplike$csi$core$mbox_$_state_machine__2307__auto____1.call(this,state_4549);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
otplike$csi$core$mbox_$_state_machine__2307__auto__.cljs$core$IFn$_invoke$arity$0 = otplike$csi$core$mbox_$_state_machine__2307__auto____0;
otplike$csi$core$mbox_$_state_machine__2307__auto__.cljs$core$IFn$_invoke$arity$1 = otplike$csi$core$mbox_$_state_machine__2307__auto____1;
return otplike$csi$core$mbox_$_state_machine__2307__auto__;
})()
;})(switch__2306__auto__,c__2327__auto__))
})();
var state__2329__auto__ = (function (){var statearr_4607 = f__2328__auto__.call(null);
(statearr_4607[(6)] = c__2327__auto__);

return statearr_4607;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2329__auto__);
});})(c__2327__auto__))
);

return c__2327__auto__;
});

//# sourceMappingURL=core.js.map?rel=1544213749997
