(ns superstructor.boot-git
  (:require
    [boot.core :as boot]
    [boot.pod :as pod]))

(defn- make-pod
  []
  (let [pod-env
        (-> (boot/get-env)
            (dissoc :boot-class-path :fake-class-path)
            (update :dependencies
                    (fn [dependencies]
                      (conj (filter
                             #(not (= (first %) 'org.clojure/clojure))
                             dependencies)
                            '[org.clojure/clojure "1.9.0"]
                            '[org.eclipse.jgit/org.eclipse.jgit "4.10.0.201712302008-r"]i
                            '[clj-jgit "0.8.10" :exclusions [org.eclipse.jgit/org.eclipse.jgit]]))))]
    (pod/make-pod pod-env)))

(boot/deftask checkout
  [n branch-name NAME  str "Branch name to checkout."
   s start-point START str ""]
  (let [git-pod (make-pod)]
    (boot/with-pass-thru fs
      (pod/with-call-in git-pod
        (superstructor.boot-git.pod/checkout ~branch-name ~start-point))
      identity)))

