/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import kafka.utils.SystemTime$;
import kafka.utils.Throttler$;
import kafka.utils.Time;
import kafka.utils.Time$;
import org.apache.log4j.Logger;
import scala.ScalaObject;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015q!B\u0001\u0003\u0011\u000b9\u0011!\u0003+ie>$H\u000f\\3s\u0015\t\u0019A!A\u0003vi&d7OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"\u0001C\u0005\u000e\u0003\t1\u0001B\u0003\u0002\u0005\u0002\u0003E)a\u0003\u0002\n)\"\u0014x\u000e\u001e;mKJ\u001c2!\u0003\u0007\u0015!\ti!#D\u0001\u000f\u0015\ty\u0001#\u0001\u0003mC:<'\"A\t\u0002\t)\fg/Y\u0005\u0003'9\u0011aa\u00142kK\u000e$\bCA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"aC*dC2\fwJ\u00196fGRDQaG\u0005\u0005\u0002q\ta\u0001P5oSRtD#A\u0004\t\u000fyI!\u0019!C\u0001?\u00051An\\4hKJ,\u0012\u0001\t\t\u0003C!j\u0011A\t\u0006\u0003G\u0011\nQ\u0001\\8hi)T!!\n\u0014\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0013aA8sO&\u0011\u0011F\t\u0002\u0007\u0019><w-\u001a:\t\r-J\u0001\u0015!\u0003!\u0003\u001dawnZ4fe\u0002Bq!L\u0005C\u0002\u0013\u0005a&\u0001\fEK\u001a\fW\u000f\u001c;DQ\u0016\u001c7.\u00138uKJ4\u0018\r\\'t+\u0005y\u0003CA\u000b1\u0013\t\tdC\u0001\u0003M_:<\u0007BB\u001a\nA\u0003%q&A\fEK\u001a\fW\u000f\u001c;DQ\u0016\u001c7.\u00138uKJ4\u0018\r\\'tA\u0019A!B\u0001C\u0001\u0002\u0003\u0005QgE\u00025\u0019QA\u0001b\u000e\u001b\u0003\u0006\u0004%\t\u0001O\u0001\u0012I\u0016\u001c\u0018N]3e%\u0006$X\rU3s'\u0016\u001cW#A\u001d\u0011\u0005UQ\u0014BA\u001e\u0017\u0005\u0019!u.\u001e2mK\"AQ\b\u000eB\u0001B\u0003%\u0011(\u0001\neKNL'/\u001a3SCR,\u0007+\u001a:TK\u000e\u0004\u0003\u0002C 5\u0005\u000b\u0007I\u0011\u0001\u0018\u0002\u001f\rDWmY6J]R,'O^1m\u001bND\u0001\"\u0011\u001b\u0003\u0002\u0003\u0006IaL\u0001\u0011G\",7m[%oi\u0016\u0014h/\u00197Ng\u0002B\u0001b\u0011\u001b\u0003\u0006\u0004%\t\u0001R\u0001\ri\"\u0014x\u000e\u001e;mK\u0012{wO\\\u000b\u0002\u000bB\u0011QCR\u0005\u0003\u000fZ\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005Ji\t\u0005\t\u0015!\u0003F\u00035!\bN]8ui2,Gi\\<oA!A1\n\u000eBC\u0002\u0013\u0005A*\u0001\u0003uS6,W#A'\u0011\u0005!q\u0015BA(\u0003\u0005\u0011!\u0016.\\3\t\u0011E#$\u0011!Q\u0001\n5\u000bQ\u0001^5nK\u0002BQa\u0007\u001b\u0005\u0002M#R\u0001V+W/b\u0003\"\u0001\u0003\u001b\t\u000b]\u0012\u0006\u0019A\u001d\t\u000b}\u0012\u0006\u0019A\u0018\t\u000b\r\u0013\u0006\u0019A#\t\u000b-\u0013\u0006\u0019A'\t\u000fi#$\u0019!C\u00057\u0006!An\\2l+\u0005a\u0001BB/5A\u0003%A\"A\u0003m_\u000e\\\u0007\u0005C\u0004`i\u0001\u0007I\u0011\u0002\u0018\u0002\u001bA,'/[8e'R\f'\u000f\u001e(t\u0011\u001d\tG\u00071A\u0005\n\t\f\u0011\u0003]3sS>$7\u000b^1si:\u001bx\fJ3r)\t\u0019g\r\u0005\u0002\u0016I&\u0011QM\u0006\u0002\u0005+:LG\u000fC\u0004hA\u0006\u0005\t\u0019A\u0018\u0002\u0007a$\u0013\u0007\u0003\u0004ji\u0001\u0006KaL\u0001\u000fa\u0016\u0014\u0018n\u001c3Ti\u0006\u0014HOT:!\u0011\u001dYG\u00071A\u0005\na\nQb\u001c2tKJ4X\rZ*p\r\u0006\u0014\bbB75\u0001\u0004%IA\\\u0001\u0012_\n\u001cXM\u001d<fIN{g)\u0019:`I\u0015\fHCA2p\u0011\u001d9G.!AA\u0002eBa!\u001d\u001b!B\u0013I\u0014AD8cg\u0016\u0014h/\u001a3T_\u001a\u000b'\u000f\t\u0005\u00067Q\"\ta\u001d\u000b\u0004)R,\b\"B\u001cs\u0001\u0004I\u0004\"B\"s\u0001\u0004)\u0005\"B\u000e5\t\u00039HC\u0001+y\u0011\u00159d\u000f1\u0001:\u0011\u0015QH\u0007\"\u0001|\u00035i\u0017-\u001f2f)\"\u0014x\u000e\u001e;mKR\u00111\r \u0005\u0006{f\u0004\r!O\u0001\t_\n\u001cXM\u001d<fI\"\u0012Ag \t\u0004\u0011\u0005\u0005\u0011bAA\u0002\u0005\tian\u001c8uQJ,\u0017\rZ:bM\u0016\u0004")
public class Throttler
implements ScalaObject {
    private final double desiredRatePerSec;
    private final long checkIntervalMs;
    private final boolean throttleDown;
    private final Time time;
    private final Object lock;
    private long periodStartNs;
    private double observedSoFar;

    public static final long DefaultCheckIntervalMs() {
        return Throttler$.MODULE$.DefaultCheckIntervalMs();
    }

    public static final Logger logger() {
        return Throttler$.MODULE$.logger();
    }

    public double desiredRatePerSec() {
        return this.desiredRatePerSec;
    }

    public long checkIntervalMs() {
        return this.checkIntervalMs;
    }

    public boolean throttleDown() {
        return this.throttleDown;
    }

    public Time time() {
        return this.time;
    }

    private Object lock() {
        return this.lock;
    }

    private long periodStartNs() {
        return this.periodStartNs;
    }

    private void periodStartNs_$eq(long l) {
        this.periodStartNs = l;
    }

    private double observedSoFar() {
        return this.observedSoFar;
    }

    private void observedSoFar_$eq(double d) {
        this.observedSoFar = d;
    }

    public Throttler(double desiredRatePerSec, boolean throttleDown) {
        this(desiredRatePerSec, Throttler$.MODULE$.DefaultCheckIntervalMs(), throttleDown, SystemTime$.MODULE$);
    }

    public Throttler(double desiredRatePerSec) {
        this(desiredRatePerSec, Throttler$.MODULE$.DefaultCheckIntervalMs(), true, SystemTime$.MODULE$);
    }

    public void maybeThrottle(double observed) {
        Object object = this.lock();
        synchronized (object) {
            BoxedUnit boxedUnit;
            this.observedSoFar_$eq(this.observedSoFar() + observed);
            long now = this.time().nanoseconds();
            long ellapsedNs = now - this.periodStartNs();
            if (ellapsedNs > this.checkIntervalMs() * (long)Time$.MODULE$.NsPerMs() && this.observedSoFar() > 0.0) {
                boolean needAdjustment;
                double rateInSecs = this.observedSoFar() * (double)Time$.MODULE$.NsPerSec() / (double)ellapsedNs;
                boolean bl = needAdjustment = !(this.throttleDown() ^ rateInSecs > this.desiredRatePerSec());
                if (needAdjustment) {
                    double desiredRateMs = this.desiredRatePerSec() / (double)Time$.MODULE$.MsPerSec();
                    long ellapsedMs = ellapsedNs / (long)Time$.MODULE$.NsPerMs();
                    long sleepTime = package$.MODULE$.round(this.observedSoFar() / desiredRateMs - (double)ellapsedMs);
                    if (sleepTime > 0L) {
                        if (Throttler$.MODULE$.logger().isDebugEnabled()) {
                            Throttler$.MODULE$.logger().debug((Object)new StringBuilder().append((Object)"Natural rate is ").append((Object)BoxesRunTime.boxToDouble((double)rateInSecs)).append((Object)" per second but desired rate is ").append((Object)BoxesRunTime.boxToDouble((double)this.desiredRatePerSec())).append((Object)", sleeping for ").append((Object)BoxesRunTime.boxToLong((long)sleepTime)).append((Object)" ms to compensate.").toString());
                        }
                        this.time().sleep(sleepTime);
                    }
                }
                this.periodStartNs_$eq(now);
                this.observedSoFar_$eq(0.0);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public Throttler(double desiredRatePerSec, long checkIntervalMs, boolean throttleDown, Time time) {
        this.desiredRatePerSec = desiredRatePerSec;
        this.checkIntervalMs = checkIntervalMs;
        this.throttleDown = throttleDown;
        this.time = time;
        this.lock = new Object();
        this.periodStartNs = time.nanoseconds();
        this.observedSoFar = 0.0;
    }
}

