/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.concurrent.CountDownLatch;
import kafka.consumer.Consumer$;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerConnector;
import kafka.consumer.KafkaMessageStream;
import kafka.consumer.TopicEventHandler;
import kafka.consumer.ZookeeperTopicEventWatcher;
import kafka.message.Message;
import kafka.producer.Producer;
import kafka.producer.ProducerConfig;
import kafka.serializer.DefaultDecoder;
import kafka.server.EmbeddedConsumer$;
import kafka.server.EmbeddedConsumer$MirroringThread$;
import kafka.server.KafkaServer;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\tua\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0004\u0003!\u0015k'-\u001a3eK\u0012\u001cuN\\:v[\u0016\u0014(BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001A\u0001\u0003\t\t\u0003\u00139i\u0011A\u0003\u0006\u0003\u00171\tA\u0001\\1oO*\tQ\"\u0001\u0003kCZ\f\u0017BA\b\u000b\u0005\u0019y%M[3diB\u0019\u0011\u0003\u0006\f\u000e\u0003IQ!a\u0005\u0003\u0002\u0011\r|gn];nKJL!!\u0006\n\u0003#Q{\u0007/[2Fm\u0016tG\u000fS1oI2,'\u000f\u0005\u0002\u0018;9\u0011\u0001dG\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\u00051\u0001K]3eK\u001aL!AH\u0010\u0003\rM#(/\u001b8h\u0015\ta\u0012\u0004\u0005\u0002\u0019C%\u0011!%\u0007\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000f\u0003\u0005%\u0001\t\u0015\r\u0011\"\u0003&\u00039\u0019wN\\:v[\u0016\u00148i\u001c8gS\u001e,\u0012A\n\t\u0003#\u001dJ!\u0001\u000b\n\u0003\u001d\r{gn];nKJ\u001cuN\u001c4jO\"A!\u0006\u0001B\u0001B\u0003%a%A\bd_:\u001cX/\\3s\u0007>tg-[4!\u0011!a\u0003A!b\u0001\n\u0013i\u0013A\u00049s_\u0012,8-\u001a:D_:4\u0017nZ\u000b\u0002]A\u0011qFM\u0007\u0002a)\u0011\u0011\u0007B\u0001\taJ|G-^2fe&\u00111\u0007\r\u0002\u000f!J|G-^2fe\u000e{gNZ5h\u0011!)\u0004A!A!\u0002\u0013q\u0013a\u00049s_\u0012,8-\u001a:D_:4\u0017n\u001a\u0011\t\u0011]\u0002!Q1A\u0005\na\n1b[1gW\u0006\u001cVM\u001d<feV\t\u0011\b\u0005\u0002;w5\t!!\u0003\u0002=\u0005\tY1*\u00194lCN+'O^3s\u0011!q\u0004A!A!\u0002\u0013I\u0014\u0001D6bM.\f7+\u001a:wKJ\u0004\u0003\"\u0002!\u0001\t\u0003\t\u0015A\u0002\u001fj]&$h\b\u0006\u0003C\u0007\u0012+\u0005C\u0001\u001e\u0001\u0011\u0015!s\b1\u0001'\u0011\u0015as\b1\u0001/\u0011\u00159t\b1\u0001:\u0011\u001d9\u0005A1A\u0005\n!\u000ba\u0001\\8hO\u0016\u0014X#A%\u0011\u0005)\u000bV\"A&\u000b\u00051k\u0015!\u00027pORR'B\u0001(P\u0003\u0019\t\u0007/Y2iK*\t\u0001+A\u0002pe\u001eL!AU&\u0003\r1{wmZ3s\u0011\u0019!\u0006\u0001)A\u0005\u0013\u00069An\\4hKJ\u0004\u0003b\u0002,\u0001\u0005\u0004%IaV\u0001\u0010o\"LG/\u001a'jgR$v\u000e]5dgV\t\u0001\fE\u0002Z=\u0002l\u0011A\u0017\u0006\u00037r\u000b\u0011\"[7nkR\f'\r\\3\u000b\u0005uK\u0012AC2pY2,7\r^5p]&\u0011qL\u0017\u0002\u0005\u0019&\u001cH\u000f\u0005\u0002\nC&\u0011aD\u0003\u0005\u0007G\u0002\u0001\u000b\u0011\u0002-\u0002!]D\u0017\u000e^3MSN$Hk\u001c9jGN\u0004\u0003bB3\u0001\u0005\u0004%IaV\u0001\u0010E2\f7m\u001b'jgR$v\u000e]5dg\"1q\r\u0001Q\u0001\na\u000b\u0001C\u00197bG.d\u0015n\u001d;U_BL7m\u001d\u0011\t\u000f%\u0004\u0001\u0019!C\u0005U\u0006aQ.\u001b:s_J$v\u000e]5dgV\t1\u000eE\u0002miZq!!\u001c:\u000f\u00059\fX\"A8\u000b\u0005A4\u0011A\u0002\u001fs_>$h(C\u0001\u001b\u0013\t\u0019\u0018$A\u0004qC\u000e\\\u0017mZ3\n\u0005U4(aA*fc*\u00111/\u0007\u0005\bq\u0002\u0001\r\u0011\"\u0003z\u0003Ai\u0017N\u001d:peR{\u0007/[2t?\u0012*\u0017\u000f\u0006\u0002{{B\u0011\u0001d_\u0005\u0003yf\u0011A!\u00168ji\"9ap^A\u0001\u0002\u0004Y\u0017a\u0001=%c!9\u0011\u0011\u0001\u0001!B\u0013Y\u0017!D7jeJ|'\u000fV8qS\u000e\u001c\b\u0005C\u0005\u0002\u0006\u0001\u0001\r\u0011\"\u0003\u0002\b\u0005\t2m\u001c8tk6,'oQ8o]\u0016\u001cGo\u001c:\u0016\u0005\u0005%\u0001cA\t\u0002\f%\u0019\u0011Q\u0002\n\u0003#\r{gn];nKJ\u001cuN\u001c8fGR|'\u000fC\u0005\u0002\u0012\u0001\u0001\r\u0011\"\u0003\u0002\u0014\u0005)2m\u001c8tk6,'oQ8o]\u0016\u001cGo\u001c:`I\u0015\fHc\u0001>\u0002\u0016!Ia0a\u0004\u0002\u0002\u0003\u0007\u0011\u0011\u0002\u0005\t\u00033\u0001\u0001\u0015)\u0003\u0002\n\u0005\u00112m\u001c8tk6,'oQ8o]\u0016\u001cGo\u001c:!\u0011%\ti\u0002\u0001a\u0001\n\u0013\ty\"A\tu_BL7-\u0012<f]R<\u0016\r^2iKJ,\"!!\t\u0011\u0007E\t\u0019#C\u0002\u0002&I\u0011!DW8pW\u0016,\u0007/\u001a:U_BL7-\u0012<f]R<\u0016\r^2iKJD\u0011\"!\u000b\u0001\u0001\u0004%I!a\u000b\u0002+Q|\u0007/[2Fm\u0016tGoV1uG\",'o\u0018\u0013fcR\u0019!0!\f\t\u0013y\f9#!AA\u0002\u0005\u0005\u0002\u0002CA\u0019\u0001\u0001\u0006K!!\t\u0002%Q|\u0007/[2Fm\u0016tGoV1uG\",'\u000f\t\u0005\tc\u0001\u0011\r\u0011\"\u0003\u00026U\u0011\u0011q\u0007\t\b_\u0005e\u0012QHA\"\u0013\r\tY\u0004\r\u0002\t!J|G-^2feB\u0019\u0001$a\u0010\n\u0007\u0005\u0005\u0013D\u0001\u0003Ok2d\u0007\u0003BA#\u0003\u0017j!!a\u0012\u000b\u0007\u0005%C!A\u0004nKN\u001c\u0018mZ3\n\t\u00055\u0013q\t\u0002\b\u001b\u0016\u001c8/Y4f\u0011!\t\t\u0006\u0001Q\u0001\n\u0005]\u0012!\u00039s_\u0012,8-\u001a:!\u0011%\t)\u0006\u0001a\u0001\n\u0003\t9&\u0001\u0006uQJ,\u0017\r\u001a'jgR,\"!!\u0017\u0011\tes\u00161\f\t\u0005\u0003;\ny&D\u0001\u0001\r)\t\t\u0007\u0001C\u0001\u0002\u0003\u0005\u00111\r\u0002\u0010\u001b&\u0014(o\u001c:j]\u001e$\u0006N]3bIN)\u0011qLA3AA\u0019\u0011\"a\u001a\n\u0007\u0005%$B\u0001\u0004UQJ,\u0017\r\u001a\u0005\f\u0003[\nyF!b\u0001\n\u0003\ty'\u0001\u0004tiJ,\u0017-\\\u000b\u0003\u0003c\u0002R!EA:\u0003\u0007J1!!\u001e\u0013\u0005IY\u0015MZ6b\u001b\u0016\u001c8/Y4f'R\u0014X-Y7\t\u0017\u0005e\u0014q\fB\u0001B\u0003%\u0011\u0011O\u0001\bgR\u0014X-Y7!\u0011-\ti(a\u0018\u0003\u0006\u0004%\t!a \u0002\u000bQ|\u0007/[2\u0016\u0003YA!\"a!\u0002`\t\u0005\t\u0015!\u0003\u0017\u0003\u0019!x\u000e]5dA!Y\u0011qQA0\u0005\u000b\u0007I\u0011AAE\u0003!!\bN]3bI&#WCAAF!\rA\u0012QR\u0005\u0004\u0003\u001fK\"aA%oi\"Y\u00111SA0\u0005\u0003\u0005\u000b\u0011BAF\u0003%!\bN]3bI&#\u0007\u0005C\u0004A\u0003?\"\t!a&\u0015\u0011\u0005m\u0013\u0011TAN\u0003;C\u0001\"!\u001c\u0002\u0016\u0002\u0007\u0011\u0011\u000f\u0005\b\u0003{\n)\n1\u0001\u0017\u0011!\t9)!&A\u0002\u0005-\u0005BCAQ\u0003?\u0012\r\u0011\"\u0001\u0002$\u0006\u00012\u000f[;uI><hnQ8na2,G/Z\u000b\u0003\u0003K\u0003B!a*\u000226\u0011\u0011\u0011\u0016\u0006\u0005\u0003W\u000bi+\u0001\u0006d_:\u001cWO\u001d:f]RT1!a,\r\u0003\u0011)H/\u001b7\n\t\u0005M\u0016\u0011\u0016\u0002\u000f\u0007>,h\u000e\u001e#po:d\u0015\r^2i\u0011%\t9,a\u0018!\u0002\u0013\t)+A\ttQV$Hm\\<o\u0007>l\u0007\u000f\\3uK\u0002B!\"a/\u0002`\t\u0007I\u0011AA@\u0003\u0011q\u0017-\\3\t\u0011\u0005}\u0016q\fQ\u0001\nY\tQA\\1nK\u0002B\u0001bRA0\u0005\u0004%I\u0001\u0013\u0005\b)\u0006}\u0003\u0015!\u0003J\u0011!\t9-a\u0018\u0005B\u0005%\u0017a\u0001:v]R\t!\u0010\u0003\u0005\u0002N\u0006}C\u0011AAh\u0003!\u0019\b.\u001e;e_^tW#\u0001>\t\u0013\u0005M\u0007\u00011A\u0005\u0002\u0005U\u0017A\u0004;ie\u0016\fG\rT5ti~#S-\u001d\u000b\u0004u\u0006]\u0007\"\u0003@\u0002R\u0006\u0005\t\u0019AA-\u0011!\tY\u000e\u0001Q!\n\u0005e\u0013a\u0003;ie\u0016\fG\rT5ti\u0002Bq!a8\u0001\t\u0013\t\t/\u0001\bjgR{\u0007/[2BY2|w/\u001a3\u0015\t\u0005\r\u0018\u0011\u001e\t\u00041\u0005\u0015\u0018bAAt3\t9!i\\8mK\u0006t\u0007bBA?\u0003;\u0004\rA\u0006\u0005\b\u0003[\u0004A\u0011AAx\u0003AA\u0017M\u001c3mKR{\u0007/[2Fm\u0016tG\u000fF\u0002{\u0003cDq!a=\u0002l\u0002\u00071.A\u0005bY2$v\u000e]5dg\"\"\u00111^A|!\rI\u0011\u0011`\u0005\u0004\u0003wT!\u0001C(wKJ\u0014\u0018\u000eZ3\t\u000f\u0005}\b\u0001\"\u0003\u0003\u0002\u0005aQ.Y6f)>\u0004\u0018nY'baR!!1\u0001B\u0006!\u001d\u0011)Aa\u0002\u0017\u0003\u0017k\u0011\u0001X\u0005\u0004\u0005\u0013a&aA'ba\"1\u0011.!@A\u0002-DqAa\u0004\u0001\t\u0013\u0011\t\"A\fti\u0006\u0014HOT3x\u0007>t7/^7feRC'/Z1egR\u0019!Pa\u0005\t\u0011\tU!Q\u0002a\u0001\u0005\u0007\t\u0001\u0002^8qS\u000el\u0015\r\u001d\u0005\b\u00053\u0001A\u0011AAe\u0003\u001d\u0019H/\u0019:ukBDq!!4\u0001\t\u0003\tI\r")
public class EmbeddedConsumer
implements TopicEventHandler<String>,
ScalaObject {
    private final ConsumerConfig consumerConfig;
    private final ProducerConfig producerConfig;
    private final KafkaServer kafkaServer;
    private final Logger logger;
    private final List<String> whiteListTopics;
    private final List<String> blackListTopics;
    private Seq<String> mirrorTopics;
    private ConsumerConnector consumerConnector;
    private ZookeeperTopicEventWatcher topicEventWatcher;
    private final Producer kafka$server$EmbeddedConsumer$$producer;
    private List<MirroringThread> threadList;

    private ConsumerConfig consumerConfig() {
        return this.consumerConfig;
    }

    private ProducerConfig producerConfig() {
        return this.producerConfig;
    }

    private KafkaServer kafkaServer() {
        return this.kafkaServer;
    }

    private Logger logger() {
        return this.logger;
    }

    private List<String> whiteListTopics() {
        return this.whiteListTopics;
    }

    private List<String> blackListTopics() {
        return this.blackListTopics;
    }

    private Seq<String> mirrorTopics() {
        return this.mirrorTopics;
    }

    private void mirrorTopics_$eq(Seq<String> seq) {
        this.mirrorTopics = seq;
    }

    private ConsumerConnector consumerConnector() {
        return this.consumerConnector;
    }

    private void consumerConnector_$eq(ConsumerConnector consumerConnector) {
        this.consumerConnector = consumerConnector;
    }

    private ZookeeperTopicEventWatcher topicEventWatcher() {
        return this.topicEventWatcher;
    }

    private void topicEventWatcher_$eq(ZookeeperTopicEventWatcher zookeeperTopicEventWatcher) {
        this.topicEventWatcher = zookeeperTopicEventWatcher;
    }

    public final Producer kafka$server$EmbeddedConsumer$$producer() {
        return this.kafka$server$EmbeddedConsumer$$producer;
    }

    public List<MirroringThread> threadList() {
        return this.threadList;
    }

    public void threadList_$eq(List<MirroringThread> list) {
        this.threadList = list;
    }

    public final boolean kafka$server$EmbeddedConsumer$$isTopicAllowed(String topic) {
        return Predef$.MODULE$.augmentString(this.consumerConfig().mirrorTopicsWhitelist()).nonEmpty() ? this.whiteListTopics().contains((Object)topic) : !this.blackListTopics().contains((Object)topic);
    }

    @Override
    @Override
    public void handleTopicEvent(Seq<String> allTopics) {
        Seq deletedTopics;
        Seq<String> seq;
        Seq newMirrorTopics$1 = (Seq)allTopics.filter((Function1)new $anonfun$3(this));
        Seq addedTopics = (Seq)newMirrorTopics$1.filterNot((Function1)new $anonfun$4(this, seq = this.mirrorTopics()));
        if (addedTopics.nonEmpty()) {
            this.logger().info((Object)Predef$.MODULE$.augmentString("topic event: added topics = %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{addedTopics})));
        }
        if ((deletedTopics = (Seq)this.mirrorTopics().filterNot((Function1)new $anonfun$5(this, newMirrorTopics$1))).nonEmpty()) {
            this.logger().info((Object)Predef$.MODULE$.augmentString("topic event: deleted topics = %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{deletedTopics})));
        }
        this.mirrorTopics_$eq((Seq<String>)newMirrorTopics$1);
        if (addedTopics.nonEmpty() || deletedTopics.nonEmpty()) {
            this.logger().info((Object)Predef$.MODULE$.augmentString("mirror topics = %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.mirrorTopics()})));
            this.startNewConsumerThreads(this.makeTopicMap(this.mirrorTopics()));
        }
    }

    private Map<String, Integer> makeTopicMap(Seq<String> mirrorTopics) {
        return mirrorTopics.nonEmpty() ? Utils$.MODULE$.getConsumerTopicMap(mirrorTopics.mkString("", Predef$.MODULE$.augmentString(":%d,").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.consumerConfig().mirrorConsumerNumThreads())})), Predef$.MODULE$.augmentString(":%d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.consumerConfig().mirrorConsumerNumThreads())})))) : Utils$.MODULE$.getConsumerTopicMap("");
    }

    private void startNewConsumerThreads(Map<String, Integer> topicMap) {
        if (topicMap.nonEmpty()) {
            if (this.consumerConnector() != null) {
                this.consumerConnector().shutdown();
            }
            this.threadList().foreach((Function1)new $anonfun$startNewConsumerThreads$1(this));
            this.consumerConnector_$eq(Consumer$.MODULE$.create(this.consumerConfig()));
            ConsumerConnector qual$1 = this.consumerConnector();
            Map<String, Integer> x$7 = topicMap;
            DefaultDecoder x$8 = qual$1.createMessageStreams$default$2();
            Map<String, List<KafkaMessageStream<Message>>> topicMessageStreams = qual$1.createMessageStreams(x$7, x$8);
            topicMessageStreams.foreach((Function1)new $anonfun$startNewConsumerThreads$2(this));
            this.threadList().foreach((Function1)new $anonfun$startNewConsumerThreads$3(this));
        } else {
            this.logger().info((Object)"Not starting mirroring threads (mirror topic list is empty)");
        }
    }

    public void startup() {
        this.topicEventWatcher_$eq(new ZookeeperTopicEventWatcher(this.consumerConfig(), this));
    }

    public void shutdown() {
        if (this.topicEventWatcher() != null) {
            this.topicEventWatcher().shutdown();
        }
        this.logger().info((Object)"Stopped the ZK watcher for new topics, now stopping the Kafka consumers");
        if (this.consumerConnector() != null) {
            this.consumerConnector().shutdown();
        }
        this.logger().info((Object)"Stopped the kafka consumer threads for existing topics, now stopping the existing mirroring threads");
        this.threadList().foreach((Function1)new $anonfun$shutdown$1(this));
        this.logger().info((Object)"Stopped all existing mirroring threads, now stopping the producer");
        this.kafka$server$EmbeddedConsumer$$producer().close();
        this.logger().info((Object)"Successfully shutdown this Kafka mirror");
    }

    public EmbeddedConsumer(ConsumerConfig consumerConfig, ProducerConfig producerConfig, KafkaServer kafkaServer) {
        this.consumerConfig = consumerConfig;
        this.producerConfig = producerConfig;
        this.kafkaServer = kafkaServer;
        this.logger = Logger.getLogger(this.getClass());
        this.whiteListTopics = (List)Predef$.MODULE$.refArrayOps((Object[])consumerConfig.mirrorTopicsWhitelist().split(",")).toList().map((Function1)new $anonfun$1(this), List$.MODULE$.canBuildFrom());
        this.blackListTopics = (List)Predef$.MODULE$.refArrayOps((Object[])consumerConfig.mirrorTopicsBlackList().split(",")).toList().map((Function1)new $anonfun$2(this), List$.MODULE$.canBuildFrom());
        this.mirrorTopics = Nil$.MODULE$;
        this.consumerConnector = null;
        this.topicEventWatcher = null;
        this.kafka$server$EmbeddedConsumer$$producer = new Producer(producerConfig);
        this.threadList = Nil$.MODULE$;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MirroringThread
    extends Thread
    implements ScalaObject {
        private final KafkaMessageStream<Message> stream;
        private final String topic;
        private final int threadId;
        private final CountDownLatch shutdownComplete;
        private final String name;
        private final Logger logger;
        public final /* synthetic */ EmbeddedConsumer $outer;

        public KafkaMessageStream<Message> stream() {
            return this.stream;
        }

        public String topic() {
            return this.topic;
        }

        public int threadId() {
            return this.threadId;
        }

        public CountDownLatch shutdownComplete() {
            return this.shutdownComplete;
        }

        public String name() {
            return this.name;
        }

        private Logger logger() {
            return this.logger;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            this.logger().info((Object)Predef$.MODULE$.augmentString("Starting mirroring thread %s for topic %s and stream %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name(), this.topic(), BoxesRunTime.boxToInteger((int)this.threadId())})));
            try {
                this.stream().foreach((Function1)new MirroringThread$$anonfun$run$1(this));
                this.shutdownComplete().countDown();
            }
            catch (Throwable throwable) {
                try {
                    this.logger().fatal((Object)Predef$.MODULE$.any2stringadd((Object)throwable).$plus(Utils$.MODULE$.stackTrace(throwable)));
                    this.logger().fatal((Object)new StringBuilder().append((Object)this.topic()).append((Object)" stream ").append((Object)BoxesRunTime.boxToInteger((int)this.threadId())).append((Object)" unexpectedly exited").toString());
                    this.shutdownComplete().countDown();
                }
                catch (Throwable throwable2) {
                    this.shutdownComplete().countDown();
                    this.logger().info((Object)Predef$.MODULE$.augmentString("Stopped mirroring thread %s for topic %s and stream %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name(), this.topic(), BoxesRunTime.boxToInteger((int)this.threadId())})));
                    throw throwable2;
                }
                this.logger().info((Object)Predef$.MODULE$.augmentString("Stopped mirroring thread %s for topic %s and stream %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name(), this.topic(), BoxesRunTime.boxToInteger((int)this.threadId())})));
                return;
            }
            this.logger().info((Object)Predef$.MODULE$.augmentString("Stopped mirroring thread %s for topic %s and stream %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name(), this.topic(), BoxesRunTime.boxToInteger((int)this.threadId())})));
        }

        public void shutdown() {
            try {
                this.shutdownComplete().await();
            }
            catch (InterruptedException interruptedException) {
                this.logger().fatal((Object)new StringBuilder().append((Object)"Shutdown of thread ").append((Object)this.name()).append((Object)" interrupted. ").append((Object)"Mirroring thread might leak data!").toString());
            }
        }

        public /* synthetic */ EmbeddedConsumer kafka$server$EmbeddedConsumer$MirroringThread$$$outer() {
            return this.$outer;
        }

        public MirroringThread(EmbeddedConsumer $outer, KafkaMessageStream<Message> stream, String topic, int threadId) {
            this.stream = stream;
            this.topic = topic;
            this.threadId = threadId;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.shutdownComplete = new CountDownLatch(1);
            this.name = Predef$.MODULE$.augmentString("kafka-embedded-consumer-%s-%d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)threadId)}));
            this.setDaemon(false);
            this.setName(this.name());
            this.logger = Logger.getLogger((String)this.name());
        }
    }
}

