/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import kafka.api.MultiProducerRequest;
import kafka.api.MultiProducerRequest$;
import kafka.api.ProducerRequest;
import kafka.api.ProducerRequest$;
import kafka.api.RequestKeys$;
import kafka.message.ByteBufferMessageSet;
import kafka.network.BoundedByteBufferSend;
import kafka.producer.SyncProducer$;
import kafka.producer.SyncProducer$$anonfun$kafka$producer$SyncProducer$;
import kafka.producer.SyncProducerConfig;
import kafka.producer.SyncProducerStats$;
import kafka.utils.SystemTime$;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]u!B\u0001\u0003\u0011\u000b9\u0011\u0001D*z]\u000e\u0004&o\u001c3vG\u0016\u0014(BA\u0002\u0005\u0003!\u0001(o\u001c3vG\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019A!B\u0001C\u0001\u0002#\u00151B\u0001\u0007Ts:\u001c\u0007K]8ek\u000e,'oE\u0002\n\u0019Q\u0001\"!\u0004\n\u000e\u00039Q!a\u0004\t\u0002\t1\fgn\u001a\u0006\u0002#\u0005!!.\u0019<b\u0013\t\u0019bB\u0001\u0004PE*,7\r\u001e\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000fC\u0003\u001c\u0013\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002\u000f!9a$\u0003b\u0001\n\u0003y\u0012A\u0003*fcV,7\u000f^&fsV\t\u0001\u0005\u0005\u0002\u0016C%\u0011!E\u0006\u0002\u0006'\"|'\u000f\u001e\u0005\u0007I%\u0001\u000b\u0011\u0002\u0011\u0002\u0017I+\u0017/^3ti.+\u0017\u0010\t\u0004\t\u0015\t!\t\u0011!A\u0001MM\u0019Q\u0005\u0004\u000b\t\u0011!*#Q1A\u0005\u0002%\naaY8oM&<W#\u0001\u0016\u0011\u0005!Y\u0013B\u0001\u0017\u0003\u0005I\u0019\u0016P\\2Qe>$WoY3s\u0007>tg-[4\t\u00119*#\u0011!Q\u0001\n)\nqaY8oM&<\u0007\u0005C\u0003\u001cK\u0011\u0005\u0001\u0007\u0006\u00022eA\u0011\u0001\"\n\u0005\u0006Q=\u0002\rA\u000b\u0005\bi\u0015\u0012\r\u0011\"\u00036\u0003\u0019awnZ4feV\ta\u0007\u0005\u00028}5\t\u0001H\u0003\u0002:u\u0005)An\\45U*\u00111\bP\u0001\u0007CB\f7\r[3\u000b\u0003u\n1a\u001c:h\u0013\ty\u0004H\u0001\u0004M_\u001e<WM\u001d\u0005\u0007\u0003\u0016\u0002\u000b\u0011\u0002\u001c\u0002\u000f1|wmZ3sA!91)\nb\u0001\n\u0013!\u0015aE'bq\u000e{gN\\3di\n\u000b7m[8gM6\u001bX#A#\u0011\u0005U1\u0015BA$\u0017\u0005\rIe\u000e\u001e\u0005\u0007\u0013\u0016\u0002\u000b\u0011B#\u0002)5\u000b\u0007pQ8o]\u0016\u001cGOQ1dW>4g-T:!\u0011\u001dYU\u00051A\u0005\n1\u000bqa\u00195b]:,G.F\u0001N!\tq5+D\u0001P\u0015\t\u0001\u0016+\u0001\u0005dQ\u0006tg.\u001a7t\u0015\t\u0011\u0006#A\u0002oS>L!\u0001V(\u0003\u001bM{7m[3u\u0007\"\fgN\\3m\u0011\u001d1V\u00051A\u0005\n]\u000b1b\u00195b]:,Gn\u0018\u0013fcR\u0011\u0001l\u0017\t\u0003+eK!A\u0017\f\u0003\tUs\u0017\u000e\u001e\u0005\b9V\u000b\t\u00111\u0001N\u0003\rAH%\r\u0005\u0007=\u0016\u0002\u000b\u0015B'\u0002\u0011\rD\u0017M\u001c8fY\u0002Bq\u0001Y\u0013A\u0002\u0013%A)\u0001\ttK:$xJ\\\"p]:,7\r^5p]\"9!-\na\u0001\n\u0013\u0019\u0017\u0001F:f]R|enQ8o]\u0016\u001cG/[8o?\u0012*\u0017\u000f\u0006\u0002YI\"9A,YA\u0001\u0002\u0004)\u0005B\u00024&A\u0003&Q)A\ttK:$xJ\\\"p]:,7\r^5p]\u0002Bq\u0001[\u0013C\u0002\u0013%\u0011.\u0001\u0003m_\u000e\\W#\u0001\u0007\t\r-,\u0003\u0015!\u0003\r\u0003\u0015awnY6!\u0011\u001diW\u00051A\u0005\n9\f\u0001b\u001d5vi\u0012|wO\\\u000b\u0002_B\u0011Q\u0003]\u0005\u0003cZ\u0011qAQ8pY\u0016\fg\u000eC\u0004tK\u0001\u0007I\u0011\u0002;\u0002\u0019MDW\u000f\u001e3po:|F%Z9\u0015\u0005a+\bb\u0002/s\u0003\u0003\u0005\ra\u001c\u0005\u0007o\u0016\u0002\u000b\u0015B8\u0002\u0013MDW\u000f\u001e3po:\u0004\u0003F\u0001<z!\t)\"0\u0003\u0002|-\tAao\u001c7bi&dW\rC\u0003~K\u0011%a0\u0001\twKJLg-_*f]\u0012\u0014UO\u001a4feR\u0011\u0001l \u0005\b\u0003\u0003a\b\u0019AA\u0002\u0003\u0019\u0011WO\u001a4feB!\u0011QAA\u0004\u001b\u0005\t\u0016bAA\u0005#\nQ!)\u001f;f\u0005V4g-\u001a:\t\u000f\u00055Q\u0005\"\u0003\u0002\u0010\u0005!1/\u001a8e)\rA\u0016\u0011\u0003\u0005\t\u0003\u001b\tY\u00011\u0001\u0002\u0014A!\u0011QCA\u000e\u001b\t\t9BC\u0002\u0002\u001a\u0011\tqA\\3uo>\u00148.\u0003\u0003\u0002\u001e\u0005]!!\u0006\"pk:$W\r\u001a\"zi\u0016\u0014UO\u001a4feN+g\u000e\u001a\u0005\b\u0003\u001b)C\u0011AA\u0011)\u001dA\u00161EA\u001b\u0003sA\u0001\"!\n\u0002 \u0001\u0007\u0011qE\u0001\u0006i>\u0004\u0018n\u0019\t\u0005\u0003S\tyCD\u0002\u0016\u0003WI1!!\f\u0017\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011GA\u001a\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u0006\f\t\u000f\u0005]\u0012q\u0004a\u0001\u000b\u0006I\u0001/\u0019:uSRLwN\u001c\u0005\t\u0003w\ty\u00021\u0001\u0002>\u0005AQ.Z:tC\u001e,7\u000f\u0005\u0003\u0002@\u0005\u0015SBAA!\u0015\r\t\u0019\u0005B\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\t9%!\u0011\u0003)\tKH/\u001a\"vM\u001a,'/T3tg\u0006<WmU3u\u0011\u001d\ti!\nC\u0001\u0003\u0017\"R\u0001WA'\u0003\u001fB\u0001\"!\n\u0002J\u0001\u0007\u0011q\u0005\u0005\t\u0003w\tI\u00051\u0001\u0002>!9\u00111K\u0013\u0005\u0002\u0005U\u0013!C7vYRL7+\u001a8e)\rA\u0016q\u000b\u0005\t\u00033\n\t\u00061\u0001\u0002\\\u0005A\u0001O]8ek\u000e,7\u000fE\u0003\u0016\u0003;\n\t'C\u0002\u0002`Y\u0011Q!\u0011:sCf\u0004B!a\u0019\u0002j5\u0011\u0011Q\r\u0006\u0004\u0003O\"\u0011aA1qS&!\u00111NA3\u0005=\u0001&o\u001c3vG\u0016\u0014(+Z9vKN$\bbBA8K\u0011\u0005\u0011\u0011O\u0001\u0006G2|7/\u001a\u000b\u00021\"9\u0011QO\u0013\u0005\n\u0005]\u0014!\u0005<fe&4\u00170T3tg\u0006<WmU5{KR\u0019\u0001,!\u001f\t\u0011\u0005m\u00121\u000fa\u0001\u0003{Aq!! &\t\u0013\t\t(\u0001\u0006eSN\u001cwN\u001c8fGRDq!!!&\t\u0013\t\u0019)A\u0004d_:tWm\u0019;\u0015\u00035Cq!a\"&\t\u0013\t\t(A\nhKR|%/T1lK\u000e{gN\\3di&|g\u000eK\u0002&\u0003\u0017\u0003B!!$\u0002\u00146\u0011\u0011q\u0012\u0006\u0004\u0003##\u0011!B;uS2\u001c\u0018\u0002BAK\u0003\u001f\u0013!\u0002\u001e5sK\u0006$7/\u00194f\u0001")
public class SyncProducer
implements ScalaObject {
    private final SyncProducerConfig config;
    private final Logger kafka$producer$SyncProducer$$logger;
    private final int MaxConnectBackoffMs;
    private SocketChannel kafka$producer$SyncProducer$$channel;
    private int sentOnConnection;
    private final Object lock;
    private volatile boolean shutdown;

    public static final short RequestKey() {
        return SyncProducer$.MODULE$.RequestKey();
    }

    public SyncProducerConfig config() {
        return this.config;
    }

    public final Logger kafka$producer$SyncProducer$$logger() {
        return this.kafka$producer$SyncProducer$$logger;
    }

    private int MaxConnectBackoffMs() {
        return this.MaxConnectBackoffMs;
    }

    public final SocketChannel kafka$producer$SyncProducer$$channel() {
        return this.kafka$producer$SyncProducer$$channel;
    }

    private void kafka$producer$SyncProducer$$channel_$eq(SocketChannel socketChannel) {
        this.kafka$producer$SyncProducer$$channel = socketChannel;
    }

    private int sentOnConnection() {
        return this.sentOnConnection;
    }

    private void sentOnConnection_$eq(int n) {
        this.sentOnConnection = n;
    }

    private Object lock() {
        return this.lock;
    }

    private boolean shutdown() {
        return this.shutdown;
    }

    private void shutdown_$eq(boolean bl) {
        this.shutdown = bl;
    }

    private void verifySendBuffer(ByteBuffer buffer) {
        if (this.kafka$producer$SyncProducer$$logger().isTraceEnabled()) {
            this.kafka$producer$SyncProducer$$logger().trace((Object)new StringBuilder().append((Object)"verifying sendbuffer of size ").append((Object)BoxesRunTime.boxToInteger((int)buffer.limit())).toString());
            short requestTypeId = buffer.getShort();
            if (requestTypeId == RequestKeys$.MODULE$.MultiProduce()) {
                try {
                    MultiProducerRequest request = MultiProducerRequest$.MODULE$.readFrom(buffer);
                    Predef$.MODULE$.refArrayOps((Object[])request.produces()).foreach((Function1)new $anonfun$verifySendBuffer$1(this));
                }
                catch (Throwable throwable) {
                    this.kafka$producer$SyncProducer$$logger().trace((Object)new StringBuilder().append((Object)"error verifying sendbuffer ").append((Object)throwable).append((Object)Utils$.MODULE$.stackTrace(throwable)).toString());
                }
            }
        }
    }

    private void send(BoundedByteBufferSend send$1) {
        Object object = this.lock();
        synchronized (object) {
            this.verifySendBuffer(send$1.buffer().slice());
            long startTime = SystemTime$.MODULE$.nanoseconds();
            this.getOrMakeConnection();
            this.liftedTree1$1(send$1);
            this.sentOnConnection_$eq(this.sentOnConnection() + 1);
            if (this.sentOnConnection() >= this.config().reconnectInterval()) {
                this.disconnect();
                this.kafka$producer$SyncProducer$$channel_$eq(this.connect());
                this.sentOnConnection_$eq(0);
            }
            long endTime = SystemTime$.MODULE$.nanoseconds();
            SyncProducerStats$.MODULE$.recordProduceRequest(endTime - startTime);
            return;
        }
    }

    public void send(String topic, int partition, ByteBufferMessageSet messages) {
        this.kafka$producer$SyncProducer$$verifyMessageSize(messages);
        int setSize = (int)messages.sizeInBytes();
        if (this.kafka$producer$SyncProducer$$logger().isTraceEnabled()) {
            this.kafka$producer$SyncProducer$$logger().trace((Object)new StringBuilder().append((Object)"Got message set with ").append((Object)BoxesRunTime.boxToInteger((int)setSize)).append((Object)" bytes to send").toString());
        }
        this.send(new BoundedByteBufferSend(new ProducerRequest(topic, partition, messages)));
    }

    public void send(String topic, ByteBufferMessageSet messages) {
        this.send(topic, ProducerRequest$.MODULE$.RandomPartition(), messages);
    }

    public void multiSend(ProducerRequest[] produces) {
        Predef$.MODULE$.refArrayOps((Object[])produces).foreach((Function1)new $anonfun$multiSend$1(this));
        long setSize = BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.refArrayOps((Object[])produces).foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2)new $anonfun$2(this)));
        if (this.kafka$producer$SyncProducer$$logger().isTraceEnabled()) {
            this.kafka$producer$SyncProducer$$logger().trace((Object)new StringBuilder().append((Object)"Got multi message sets with ").append((Object)BoxesRunTime.boxToLong((long)setSize)).append((Object)" bytes to send").toString());
        }
        this.send(new BoundedByteBufferSend(new MultiProducerRequest(produces)));
    }

    public void close() {
        Object object = this.lock();
        synchronized (object) {
            this.disconnect();
            this.shutdown_$eq(true);
            return;
        }
    }

    public final void kafka$producer$SyncProducer$$verifyMessageSize(ByteBufferMessageSet messages) {
        messages.foreach((Function1)new $anonfun$kafka$producer$SyncProducer$$verifyMessageSize$1(this));
    }

    private void disconnect() {
        try {
            if (this.kafka$producer$SyncProducer$$channel() != null) {
                this.kafka$producer$SyncProducer$$logger().info((Object)new StringBuilder().append((Object)"Disconnecting from ").append((Object)this.config().host()).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)this.config().port())).toString());
                Utils$.MODULE$.swallow((Function2<Object, Throwable, Object>)new $anonfun$disconnect$3(this), (Function0<Object>)new $anonfun$disconnect$1(this));
                Utils$.MODULE$.swallow((Function2<Object, Throwable, Object>)new $anonfun$disconnect$4(this), (Function0<Object>)new $anonfun$disconnect$2(this));
                this.kafka$producer$SyncProducer$$channel_$eq(null);
            }
        }
        catch (Exception exception) {
            this.kafka$producer$SyncProducer$$logger().error((Object)"Error on disconnect: ", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private SocketChannel connect() {
        void var1_1;
        SocketChannel channel = null;
        int connectBackoffMs = 1;
        long beginTimeMs = SystemTime$.MODULE$.milliseconds();
        while (channel == null) {
            if (this.shutdown()) return var1_1;
            {
                channel = SocketChannel.open();
                channel.socket().setSendBufferSize(this.config().bufferSize());
                channel.configureBlocking(true);
                channel.socket().setSoTimeout(this.config().socketTimeoutMs());
                channel.socket().setKeepAlive(true);
                channel.connect(new InetSocketAddress(this.config().host(), this.config().port()));
                this.kafka$producer$SyncProducer$$logger().info((Object)new StringBuilder().append((Object)"Connected to ").append((Object)this.config().host()).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)this.config().port())).append((Object)" for producing").toString());
            }
        }
        return var1_1;
    }

    private void getOrMakeConnection() {
        if (this.kafka$producer$SyncProducer$$channel() == null) {
            this.kafka$producer$SyncProducer$$channel_$eq(this.connect());
        }
    }

    private final int liftedTree1$1(BoundedByteBufferSend boundedByteBufferSend) {
        int exceptionResult1 = 0;
        try {
            exceptionResult1 = boundedByteBufferSend.writeCompletely(this.kafka$producer$SyncProducer$$channel());
            return exceptionResult1;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (IOException iOException) {
            this.disconnect();
            throw iOException;
        }
    }

    public SyncProducer(SyncProducerConfig config) {
        this.config = config;
        this.kafka$producer$SyncProducer$$logger = Logger.getLogger(this.getClass());
        this.MaxConnectBackoffMs = 60000;
        this.kafka$producer$SyncProducer$$channel = null;
        this.sentOnConnection = 0;
        this.lock = new Object();
        this.shutdown = false;
        this.kafka$producer$SyncProducer$$logger().debug((Object)"Instantiating Scala Sync Producer");
    }
}

