/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer;

import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Broker;
import kafka.common.InvalidConfigException;
import kafka.common.InvalidPartitionException;
import kafka.common.NoBrokersForPartitionException;
import kafka.producer.BrokerPartitionInfo;
import kafka.producer.ConfigBrokerPartitionInfo;
import kafka.producer.DefaultPartitioner;
import kafka.producer.Partitioner;
import kafka.producer.Producer$;
import kafka.producer.ProducerConfig;
import kafka.producer.ProducerData;
import kafka.producer.ProducerPool;
import kafka.producer.ZKBrokerPartitionInfo;
import kafka.producer.async.CallbackHandler;
import kafka.producer.async.EventHandler;
import kafka.serializer.Encoder;
import kafka.utils.Utils$;
import kafka.utils.ZKConfig;
import org.apache.log4j.Logger;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001B\u0001\u0003\u0001\u001d\u0011\u0001\u0002\u0015:pIV\u001cWM\u001d\u0006\u0003\u0007\u0011\t\u0001\u0002\u001d:pIV\u001cWM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u0001Qc\u0001\u0005%gM\u0019\u0001!C\t\u0011\u0005)yQ\"A\u0006\u000b\u00051i\u0011\u0001\u00027b]\u001eT\u0011AD\u0001\u0005U\u00064\u0018-\u0003\u0002\u0011\u0017\t1qJ\u00196fGR\u0004\"AE\u000b\u000e\u0003MQ\u0011\u0001F\u0001\u0006g\u000e\fG.Y\u0005\u0003-M\u00111bU2bY\u0006|%M[3di\"A\u0001\u0004\u0001B\u0001B\u0003%\u0011$\u0001\u0004d_:4\u0017n\u001a\t\u00035mi\u0011AA\u0005\u00039\t\u0011a\u0002\u0015:pIV\u001cWM]\"p]\u001aLw\r\u0003\u0005\u001f\u0001\t\u0005\t\u0015!\u0003 \u0003-\u0001\u0018M\u001d;ji&|g.\u001a:\u0011\u0007i\u0001#%\u0003\u0002\"\u0005\tY\u0001+\u0019:uSRLwN\\3s!\t\u0019C\u0005\u0004\u0001\u0005\u0011\u0015\u0002A\u0011!AC\u0002\u0019\u0012\u0011aS\t\u0003O)\u0002\"A\u0005\u0015\n\u0005%\u001a\"a\u0002(pi\"Lgn\u001a\t\u0003%-J!\u0001L\n\u0003\u0007\u0005s\u0017\u0010\u0003\u0005/\u0001\t\u0005\t\u0015!\u00030\u00031\u0001(o\u001c3vG\u0016\u0014\bk\\8m!\rQ\u0002GM\u0005\u0003c\t\u0011A\u0002\u0015:pIV\u001cWM\u001d)p_2\u0004\"aI\u001a\u0005\u0011Q\u0002A\u0011!AC\u0002\u0019\u0012\u0011A\u0016\u0005\tm\u0001\u0011\t\u0011)A\u0005o\u0005!\u0002o\u001c9vY\u0006$X\r\u0015:pIV\u001cWM\u001d)p_2\u0004\"A\u0005\u001d\n\u0005e\u001a\"a\u0002\"p_2,\u0017M\u001c\u0005\tw\u0001\u0011\t\u0019!C\u0005y\u0005\u0019\"M]8lKJ\u0004\u0016M\u001d;ji&|g.\u00138g_V\tQ\b\u0005\u0002\u001b}%\u0011qH\u0001\u0002\u0014\u0005J|7.\u001a:QCJ$\u0018\u000e^5p]&sgm\u001c\u0005\t\u0003\u0002\u0011\t\u0019!C\u0005\u0005\u00069\"M]8lKJ\u0004\u0016M\u001d;ji&|g.\u00138g_~#S-\u001d\u000b\u0003\u0007\u001a\u0003\"A\u0005#\n\u0005\u0015\u001b\"\u0001B+oSRDqa\u0012!\u0002\u0002\u0003\u0007Q(A\u0002yIEB\u0001\"\u0013\u0001\u0003\u0002\u0003\u0006K!P\u0001\u0015EJ|7.\u001a:QCJ$\u0018\u000e^5p]&sgm\u001c\u0011\t\u000b-\u0003A\u0011\u0001'\u0002\rqJg.\u001b;?)\u0019iej\u0014)R%B!!\u0004\u0001\u00123\u0011\u0015A\"\n1\u0001\u001a\u0011\u0015q\"\n1\u0001 \u0011\u0015q#\n1\u00010\u0011\u00151$\n1\u00018\u0011\u0015Y$\n1\u0001>\u0011\u001d!\u0006A1A\u0005\nU\u000ba\u0001\\8hO\u0016\u0014X#\u0001,\u0011\u0005]sV\"\u0001-\u000b\u0005eS\u0016!\u00027pORR'BA.]\u0003\u0019\t\u0007/Y2iK*\tQ,A\u0002pe\u001eL!a\u0018-\u0003\r1{wmZ3s\u0011\u0019\t\u0007\u0001)A\u0005-\u00069An\\4hKJ\u0004\u0003bB2\u0001\u0005\u0004%I\u0001Z\u0001\fQ\u0006\u001c8\u000b[;uI><h.F\u0001f!\t1W.D\u0001h\u0015\tA\u0017.\u0001\u0004bi>l\u0017n\u0019\u0006\u0003U.\f!bY8oGV\u0014(/\u001a8u\u0015\taW\"\u0001\u0003vi&d\u0017B\u00018h\u00055\tEo\\7jG\n{w\u000e\\3b]\"1\u0001\u000f\u0001Q\u0001\n\u0015\fA\u0002[1t'\",H\u000fZ8x]\u0002BqA\u001d\u0001C\u0002\u0013%1/\u0001\u0004sC:$w.\\\u000b\u0002iB\u0011QO^\u0007\u0002W&\u0011qo\u001b\u0002\u0007%\u0006tGm\\7\t\re\u0004\u0001\u0015!\u0003u\u0003\u001d\u0011\u0018M\u001c3p[\u0002Bqa\u001f\u0001C\u0002\u0013%A0A\u0005{W\u0016s\u0017M\u00197fIV\tq\u0007\u0003\u0004\u007f\u0001\u0001\u0006IaN\u0001\u000bu.,e.\u00192mK\u0012\u0004\u0003BB&\u0001\t\u0003\t\t\u0001F\u0002N\u0003\u0007AQ\u0001G@A\u0002eAaa\u0013\u0001\u0005\u0002\u0005\u001dAcC'\u0002\n\u0005-\u00111DA\u0016\u0003kAa\u0001GA\u0003\u0001\u0004I\u0002\u0002CA\u0007\u0003\u000b\u0001\r!a\u0004\u0002\u000f\u0015t7m\u001c3feB)\u0011\u0011CA\fe5\u0011\u00111\u0003\u0006\u0004\u0003+!\u0011AC:fe&\fG.\u001b>fe&!\u0011\u0011DA\n\u0005\u001d)enY8eKJD\u0001\"!\b\u0002\u0006\u0001\u0007\u0011qD\u0001\rKZ,g\u000e\u001e%b]\u0012dWM\u001d\t\u0006\u0003C\t9CM\u0007\u0003\u0003GQ1!!\n\u0003\u0003\u0015\t7/\u001f8d\u0013\u0011\tI#a\t\u0003\u0019\u00153XM\u001c;IC:$G.\u001a:\t\u0011\u00055\u0012Q\u0001a\u0001\u0003_\t!b\u00192l\u0011\u0006tG\r\\3s!\u0015\t\t#!\r3\u0013\u0011\t\u0019$a\t\u0003\u001f\r\u000bG\u000e\u001c2bG.D\u0015M\u001c3mKJDaAHA\u0003\u0001\u0004y\u0002bBA\u001d\u0001\u0011\u0005\u00111H\u0001\u0005g\u0016tG\rF\u0002D\u0003{A\u0001\"a\u0010\u00028\u0001\u0007\u0011\u0011I\u0001\raJ|G-^2fe\u0012\u000bG/\u0019\t\u0006%\u0005\r\u0013qI\u0005\u0004\u0003\u000b\u001a\"A\u0003\u001fsKB,\u0017\r^3e}A)!$!\u0013#e%\u0019\u00111\n\u0002\u0003\u0019A\u0013x\u000eZ;dKJ$\u0015\r^1\t\u000f\u0005=\u0003\u0001\"\u0003\u0002R\u00051!p[*f]\u0012$2aQA*\u0011!\ty$!\u0014A\u0002\u0005\u0005\u0003bBA,\u0001\u0011%\u0011\u0011L\u0001\u000bG>tg-[4TK:$GcA\"\u0002\\!A\u0011qHA+\u0001\u0004\t\t\u0005C\u0004\u0002`\u0001!I!!\u0019\u00021\u001d,G\u000fU1si&$\u0018n\u001c8MSN$hi\u001c:U_BL7\r\u0006\u0003\u0002d\u0005\u001d\u0005CBA3\u0003k\nYH\u0004\u0003\u0002h\u0005Ed\u0002BA5\u0003_j!!a\u001b\u000b\u0007\u00055d!\u0001\u0004=e>|GOP\u0005\u0002)%\u0019\u00111O\n\u0002\u000fA\f7m[1hK&!\u0011qOA=\u0005\r\u0019V-\u001d\u0006\u0004\u0003g\u001a\u0002\u0003BA?\u0003\u0007k!!a \u000b\u0007\u0005\u0005E!A\u0004dYV\u001cH/\u001a:\n\t\u0005\u0015\u0015q\u0010\u0002\n!\u0006\u0014H/\u001b;j_:D\u0001\"!#\u0002^\u0001\u0007\u0011qI\u0001\u0003a\u0012Dq!!$\u0001\t\u0013\ty)\u0001\u0007hKR\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0004\u0002\u0012\u0006]\u00151\u0014\t\u0004%\u0005M\u0015bAAK'\t\u0019\u0011J\u001c;\t\u000f\u0005e\u00151\u0012a\u0001E\u0005\u00191.Z=\t\u0011\u0005u\u00151\u0012a\u0001\u0003#\u000bQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\bbBAQ\u0001\u0011%\u00111U\u0001\faJ|G-^2fe\u000e\u00137\u000eF\u0004D\u0003K\u000bI+a/\t\u0011\u0005\u001d\u0016q\u0014a\u0001\u0003#\u000b1AY5e\u0011!\tY+a(A\u0002\u00055\u0016\u0001\u00025pgR\u0004B!a,\u00026:\u0019!#!-\n\u0007\u0005M6#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003o\u000bIL\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003g\u001b\u0002\u0002CA_\u0003?\u0003\r!!%\u0002\tA|'\u000f\u001e\u0005\b\u0003\u0003\u0004A\u0011AAb\u0003\u0015\u0019Gn\\:f)\u0005\u0019\u0005")
public class Producer<K, V>
implements ScalaObject {
    public final ProducerConfig kafka$producer$Producer$$config;
    private final Partitioner<K> partitioner;
    public final ProducerPool kafka$producer$Producer$$producerPool;
    private final boolean populateProducerPool;
    private BrokerPartitionInfo kafka$producer$Producer$$brokerPartitionInfo;
    private final Logger kafka$producer$Producer$$logger;
    private final AtomicBoolean hasShutdown;
    private final Random kafka$producer$Producer$$random;
    private final boolean zkEnabled;

    public final BrokerPartitionInfo kafka$producer$Producer$$brokerPartitionInfo() {
        return this.kafka$producer$Producer$$brokerPartitionInfo;
    }

    private void kafka$producer$Producer$$brokerPartitionInfo_$eq(BrokerPartitionInfo brokerPartitionInfo) {
        this.kafka$producer$Producer$$brokerPartitionInfo = brokerPartitionInfo;
    }

    public final Logger kafka$producer$Producer$$logger() {
        return this.kafka$producer$Producer$$logger;
    }

    private AtomicBoolean hasShutdown() {
        return this.hasShutdown;
    }

    public final Random kafka$producer$Producer$$random() {
        return this.kafka$producer$Producer$$random;
    }

    private boolean zkEnabled() {
        return this.zkEnabled;
    }

    public Producer(ProducerConfig config) {
        this(config, (Partitioner)Utils$.MODULE$.getObject(config.partitionerClass()), new ProducerPool(config, (Encoder)Utils$.MODULE$.getObject(config.serializerClass())), true, null);
    }

    public Producer(ProducerConfig config, Encoder<V> encoder, EventHandler<V> eventHandler, CallbackHandler<V> cbkHandler, Partitioner<K> partitioner) {
        this(config, partitioner == null ? new DefaultPartitioner() : partitioner, new ProducerPool<V>(config, encoder, eventHandler, cbkHandler), true, null);
    }

    public void send(Seq<ProducerData<K, V>> producerData) {
        boolean bl;
        block4: {
            block3: {
                block2: {
                    bl = this.zkEnabled();
                    if (!bl) break block2;
                    this.zkSend(producerData);
                    break block3;
                }
                if (bl) break block4;
                this.configSend(producerData);
            }
            return;
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    private void zkSend(Seq<ProducerData<K, V>> producerData) {
        Seq producerPoolRequests = (Seq)producerData.map((Function1)new $anonfun$3(this), Seq$.MODULE$.canBuildFrom());
        this.kafka$producer$Producer$$producerPool.send(producerPoolRequests);
    }

    private void configSend(Seq<ProducerData<K, V>> producerData) {
        Seq producerPoolRequests = (Seq)producerData.map((Function1)new $anonfun$4(this), Seq$.MODULE$.canBuildFrom());
        this.kafka$producer$Producer$$producerPool.send(producerPoolRequests);
    }

    /*
     * WARNING - void declaration
     */
    public final Seq kafka$producer$Producer$$getPartitionListForTopic(ProducerData pd) {
        void var2_2;
        int totalNumPartitions;
        if (this.kafka$producer$Producer$$logger().isDebugEnabled()) {
            this.kafka$producer$Producer$$logger().debug((Object)new StringBuilder().append((Object)"Getting the number of broker partitions registered for topic: ").append((Object)pd.getTopic()).toString());
        }
        Seq topicPartitionsList = this.kafka$producer$Producer$$brokerPartitionInfo().getBrokerPartitionInfo(pd.getTopic()).toSeq();
        if (this.kafka$producer$Producer$$logger().isDebugEnabled()) {
            this.kafka$producer$Producer$$logger().debug((Object)new StringBuilder().append((Object)"Broker partitions registered for topic: ").append((Object)pd.getTopic()).append((Object)" = ").append((Object)topicPartitionsList).toString());
        }
        if ((totalNumPartitions = topicPartitionsList.length()) == 0) {
            throw new NoBrokersForPartitionException(new StringBuilder().append((Object)"Partition = ").append(pd.getKey()).toString());
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final int kafka$producer$Producer$$getPartition(Object key, int numPartitions) {
        void var3_3;
        int partition;
        if (numPartitions <= 0) {
            throw new InvalidPartitionException(new StringBuilder().append((Object)"Invalid number of partitions: ").append((Object)BoxesRunTime.boxToInteger((int)numPartitions)).append((Object)"\n Valid values are > 0").toString());
        }
        int n = partition = key == null ? this.kafka$producer$Producer$$random().nextInt(numPartitions) : this.partitioner.partition(key, numPartitions);
        if (partition < 0 || partition >= numPartitions) {
            throw new InvalidPartitionException(new StringBuilder().append((Object)"Invalid partition id : ").append((Object)BoxesRunTime.boxToInteger((int)partition)).append((Object)"\n Valid values are in the range inclusive [0, ").append((Object)BoxesRunTime.boxToInteger((int)(numPartitions - 1))).append((Object)"]").toString());
        }
        return (int)var3_3;
    }

    public final void kafka$producer$Producer$$producerCbk(int bid, String host, int port) {
        if (this.populateProducerPool) {
            this.kafka$producer$Producer$$producerPool.addProducer(new Broker(bid, host, host, port));
        } else {
            this.kafka$producer$Producer$$logger().debug((Object)"Skipping the callback since populateProducerPool = false");
        }
    }

    public void close() {
        boolean canShutdown = this.hasShutdown().compareAndSet(false, true);
        if (canShutdown) {
            this.kafka$producer$Producer$$producerPool.close();
            this.kafka$producer$Producer$$brokerPartitionInfo().close();
        }
    }

    public Producer(ProducerConfig config, Partitioner<K> partitioner, ProducerPool<V> producerPool, boolean populateProducerPool, BrokerPartitionInfo brokerPartitionInfo) {
        this.kafka$producer$Producer$$config = config;
        this.partitioner = partitioner;
        this.kafka$producer$Producer$$producerPool = producerPool;
        this.populateProducerPool = populateProducerPool;
        this.kafka$producer$Producer$$brokerPartitionInfo = brokerPartitionInfo;
        this.kafka$producer$Producer$$logger = Logger.getLogger(Producer.class);
        this.hasShutdown = new AtomicBoolean(false);
        if (Utils$.MODULE$.propertyExists(config.zkConnect()) || Utils$.MODULE$.propertyExists(config.brokerList())) {
            if (Utils$.MODULE$.propertyExists(config.zkConnect()) && Utils$.MODULE$.propertyExists(config.brokerList())) {
                this.kafka$producer$Producer$$logger().warn((Object)"Both zk.connect and broker.list provided (zk.connect takes precedence).");
            }
            this.kafka$producer$Producer$$random = new Random();
            this.zkEnabled = Utils$.MODULE$.propertyExists(config.zkConnect());
            if (this.kafka$producer$Producer$$brokerPartitionInfo() == null) {
                boolean bl = this.zkEnabled();
                if (bl) {
                    Properties zkProps = new Properties();
                    zkProps.put("zk.connect", config.zkConnect());
                    zkProps.put("zk.sessiontimeout.ms", ((Object)BoxesRunTime.boxToInteger((int)config.zkSessionTimeoutMs())).toString());
                    zkProps.put("zk.connectiontimeout.ms", ((Object)BoxesRunTime.boxToInteger((int)config.zkConnectionTimeoutMs())).toString());
                    zkProps.put("zk.synctime.ms", ((Object)BoxesRunTime.boxToInteger((int)config.zkSyncTimeMs())).toString());
                    this.kafka$producer$Producer$$brokerPartitionInfo_$eq(new ZKBrokerPartitionInfo(new ZKConfig(zkProps), (Function3<Integer, String, Integer, Object>)new $anonfun$1(this)));
                } else if (!bl) {
                    this.kafka$producer$Producer$$brokerPartitionInfo_$eq(new ConfigBrokerPartitionInfo(config));
                } else {
                    throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                }
            }
            if (populateProducerPool) {
                Map<Integer, Broker> allBrokers = this.kafka$producer$Producer$$brokerPartitionInfo().getAllBrokerInfo();
                allBrokers.foreach((Function1)new $anonfun$2(this));
            }
            return;
        }
        throw new InvalidConfigException("At least one of zk.connect or broker.list must be specified");
    }
}

