/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import kafka.network.InvalidRequestException;
import kafka.network.Receive;
import kafka.network.Receive$class;
import kafka.network.Transmission$class;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00154\u0011\"\u0001\u0002\u0005\u0002\u0003\u0005\t\u0001\u0002\u0004\u00031\t{WO\u001c3fI\nKH/\u001a\"vM\u001a,'OU3dK&4XM\u0003\u0002\u0004\t\u00059a.\u001a;x_J\\'\"A\u0003\u0002\u000b-\fgm[1\u0014\t\u00019qb\u0005\t\u0003\u00115i\u0011!\u0003\u0006\u0003\u0015-\tA\u0001\\1oO*\tA\"\u0001\u0003kCZ\f\u0017B\u0001\b\n\u0005\u0019y%M[3diB\u0011\u0001#E\u0007\u0002\u0005%\u0011!C\u0001\u0002\b%\u0016\u001cW-\u001b<f!\t!r#D\u0001\u0016\u0015\u00051\u0012!B:dC2\f\u0017B\u0001\r\u0016\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011i\u0001!Q1A\u0005\u0002q\tq!\\1y'&TXm\u0001\u0001\u0016\u0003u\u0001\"\u0001\u0006\u0010\n\u0005})\"aA%oi\"A\u0011\u0005\u0001B\u0001B\u0003%Q$\u0001\u0005nCb\u001c\u0016N_3!\u0011\u0015\u0019\u0003\u0001\"\u0001%\u0003\u0019a\u0014N\\5u}Q\u0011QE\n\t\u0003!\u0001AQA\u0007\u0012A\u0002uAq\u0001\u000b\u0001C\u0002\u0013%\u0011&\u0001\u0006tSj,')\u001e4gKJ,\u0012A\u000b\t\u0003W9j\u0011\u0001\f\u0006\u0003[-\t1A\\5p\u0013\tyCF\u0001\u0006CsR,')\u001e4gKJDa!\r\u0001!\u0002\u0013Q\u0013aC:ju\u0016\u0014UO\u001a4fe\u0002Bqa\r\u0001A\u0002\u0013%\u0011&A\u0007d_:$XM\u001c;Ck\u001a4WM\u001d\u0005\bk\u0001\u0001\r\u0011\"\u00037\u0003E\u0019wN\u001c;f]R\u0014UO\u001a4fe~#S-\u001d\u000b\u0003oi\u0002\"\u0001\u0006\u001d\n\u0005e*\"\u0001B+oSRDqa\u000f\u001b\u0002\u0002\u0003\u0007!&A\u0002yIEBa!\u0010\u0001!B\u0013Q\u0013AD2p]R,g\u000e\u001e\"vM\u001a,'\u000f\t\u0005\u0006G\u0001!\ta\u0010\u000b\u0002K!9\u0011\t\u0001a\u0001\n\u0003\u0011\u0015\u0001C2p[BdW\r^3\u0016\u0003\r\u0003\"\u0001\u0006#\n\u0005\u0015+\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u000f\u0002\u0001\r\u0011\"\u0001I\u00031\u0019w.\u001c9mKR,w\fJ3r)\t9\u0014\nC\u0004<\r\u0006\u0005\t\u0019A\"\t\r-\u0003\u0001\u0015)\u0003D\u0003%\u0019w.\u001c9mKR,\u0007\u0005C\u0003N\u0001\u0011\u0005\u0011&\u0001\u0004ck\u001a4WM\u001d\u0005\u0006\u001f\u0002!\t\u0001U\u0001\te\u0016\fGM\u0012:p[R\u0011Q$\u0015\u0005\u0006%:\u0003\raU\u0001\bG\"\fgN\\3m!\t!v+D\u0001V\u0015\t1F&\u0001\u0005dQ\u0006tg.\u001a7t\u0013\tAVKA\nSK\u0006$\u0017M\u00197f\u0005f$Xm\u00115b]:,G\u000eC\u0003[\u0001\u0011%1,\u0001\ncsR,')\u001e4gKJ\fE\u000e\\8dCR,GC\u0001\u0016]\u0011\u0015i\u0016\f1\u0001\u001e\u0003\u0011\u0019\u0018N_3)\u0005\u0001y\u0006C\u00011d\u001b\u0005\t'B\u00012\u0005\u0003\u0015)H/\u001b7t\u0013\t!\u0017MA\u0007o_:$\bN]3bIN\fg-\u001a")
public class BoundedByteBufferReceive
implements Receive,
ScalaObject {
    private final int maxSize;
    private final ByteBuffer sizeBuffer;
    private ByteBuffer contentBuffer;
    private boolean complete;
    private final Logger logger;

    public int readCompletely(ReadableByteChannel channel) {
        return Receive$class.readCompletely(this, channel);
    }

    public Logger logger() {
        return this.logger;
    }

    public void kafka$network$Transmission$_setter_$logger_$eq(Logger logger) {
        this.logger = logger;
    }

    public void expectIncomplete() {
        Transmission$class.expectIncomplete(this);
    }

    public void expectComplete() {
        Transmission$class.expectComplete(this);
    }

    public int maxSize() {
        return this.maxSize;
    }

    private ByteBuffer sizeBuffer() {
        return this.sizeBuffer;
    }

    private ByteBuffer contentBuffer() {
        return this.contentBuffer;
    }

    private void contentBuffer_$eq(ByteBuffer byteBuffer) {
        this.contentBuffer = byteBuffer;
    }

    public BoundedByteBufferReceive() {
        this(Integer.MAX_VALUE);
    }

    public boolean complete() {
        return this.complete;
    }

    public void complete_$eq(boolean bl) {
        this.complete = bl;
    }

    public ByteBuffer buffer() {
        this.expectComplete();
        return this.contentBuffer();
    }

    /*
     * WARNING - void declaration
     */
    public int readFrom(ReadableByteChannel channel) {
        void var2_2;
        this.expectIncomplete();
        int read2 = 0;
        if (this.sizeBuffer().remaining() > 0) {
            read2 += Utils$.MODULE$.read(channel, this.sizeBuffer());
        }
        if (this.contentBuffer() == null && !this.sizeBuffer().hasRemaining()) {
            this.sizeBuffer().rewind();
            int size2 = this.sizeBuffer().getInt();
            if (size2 <= 0) {
                throw new InvalidRequestException(Predef$.MODULE$.augmentString("%d is not a valid request size.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)size2)})));
            }
            if (size2 > this.maxSize()) {
                throw new InvalidRequestException(Predef$.MODULE$.augmentString("Request of length %d is not valid, it is larger than the maximum size of %d bytes.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)size2), BoxesRunTime.boxToInteger((int)this.maxSize())})));
            }
            this.contentBuffer_$eq(this.byteBufferAllocate(size2));
        }
        if (this.contentBuffer() != null) {
            read2 = Utils$.MODULE$.read(channel, this.contentBuffer());
            if (!this.contentBuffer().hasRemaining()) {
                this.contentBuffer().rewind();
                this.complete_$eq(true);
            }
        }
        return (int)var2_2;
    }

    private ByteBuffer byteBufferAllocate(int size2) {
        ByteBuffer buffer = null;
        try {
            buffer = ByteBuffer.allocate(size2);
            return buffer;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new RuntimeException(new StringBuilder().append((Object)"OOME with size ").append((Object)BoxesRunTime.boxToInteger((int)size2)).toString(), outOfMemoryError);
        }
    }

    public BoundedByteBufferReceive(int maxSize) {
        this.maxSize = maxSize;
        Transmission$class.$init$(this);
        Receive$class.$init$(this);
        this.sizeBuffer = ByteBuffer.allocate(4);
        this.contentBuffer = null;
        this.complete = false;
    }
}

