/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kafka.common.UnknownCodecException;
import kafka.message.ByteBufferBackedInputStream;
import kafka.message.ByteBufferMessageSet;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.CompressionCodec;
import kafka.message.CompressionUtils$;
import kafka.message.DefaultCompressionCodec$;
import kafka.message.GZIPCompressionCodec$;
import kafka.message.Message;
import kafka.message.MessageSet$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.ScalaObject;
import scala.collection.Iterable;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompressionUtils$
implements ScalaObject {
    public static final CompressionUtils$ MODULE$;
    private final Logger logger;

    static {
        new CompressionUtils$();
    }

    private Logger logger() {
        return this.logger;
    }

    public Message compress(Iterable<Message> messages) {
        return this.compress(messages, DefaultCompressionCodec$.MODULE$);
    }

    /*
     * Loose catch block
     */
    public Message compress(Iterable<Message> messages, CompressionCodec compressionCodec) {
        GZIPOutputStream gzipOutput;
        ByteArrayOutputStream outputStream;
        Message message;
        GZIPOutputStream gzipOutput2;
        ByteArrayOutputStream outputStream2;
        CompressionCodec compressionCodec2 = compressionCodec;
        DefaultCompressionCodec$ defaultCompressionCodec$ = DefaultCompressionCodec$.MODULE$;
        CompressionCodec compressionCodec3 = compressionCodec2;
        if (!(defaultCompressionCodec$ != null ? !defaultCompressionCodec$.equals(compressionCodec3) : compressionCodec3 != null)) {
            Message oneCompressedMessage;
            outputStream2 = new ByteArrayOutputStream();
            gzipOutput2 = new GZIPOutputStream(outputStream2);
            if (this.logger().isDebugEnabled()) {
                this.logger().debug((Object)new StringBuilder().append((Object)"Allocating message byte buffer of size = ").append((Object)BoxesRunTime.boxToInteger((int)MessageSet$.MODULE$.messageSetSize(messages))).toString());
            }
            ByteBuffer messageByteBuffer$1 = ByteBuffer.allocate(MessageSet$.MODULE$.messageSetSize(messages));
            messages.foreach((Function1)new anonfun.compress.1(messageByteBuffer$1));
            messageByteBuffer$1.rewind();
            gzipOutput2.write(messageByteBuffer$1.array());
            message = oneCompressedMessage = new Message(outputStream2.toByteArray(), compressionCodec);
        }
        GZIPCompressionCodec$ gZIPCompressionCodec$ = GZIPCompressionCodec$.MODULE$;
        CompressionCodec compressionCodec4 = compressionCodec2;
        if (!(gZIPCompressionCodec$ != null ? !gZIPCompressionCodec$.equals(compressionCodec4) : compressionCodec4 != null)) {
            Message oneCompressedMessage;
            outputStream = new ByteArrayOutputStream();
            gzipOutput = new GZIPOutputStream(outputStream);
            if (this.logger().isDebugEnabled()) {
                this.logger().debug((Object)new StringBuilder().append((Object)"Allocating message byte buffer of size = ").append((Object)BoxesRunTime.boxToInteger((int)MessageSet$.MODULE$.messageSetSize(messages))).toString());
            }
            ByteBuffer messageByteBuffer$2 = ByteBuffer.allocate(MessageSet$.MODULE$.messageSetSize(messages));
            messages.foreach((Function1)new anonfun.compress.2(messageByteBuffer$2));
            messageByteBuffer$2.rewind();
            gzipOutput.write(messageByteBuffer$2.array());
            message = oneCompressedMessage = new Message(outputStream.toByteArray(), compressionCodec);
            return message;
        }
        throw new UnknownCodecException(new StringBuilder().append((Object)"Unknown Codec: ").append((Object)compressionCodec).toString());
        catch (IOException iOException) {
            this.logger().error((Object)"Error while writing to the GZIP output stream", (Throwable)iOException);
            throw iOException;
        }
        finally {
            if (gzipOutput2 != null) {
                gzipOutput2.close();
            }
            if (outputStream2 != null) {
                outputStream2.close();
            }
        }
        catch (IOException iOException) {
            this.logger().error((Object)"Error while writing to the GZIP output stream", (Throwable)iOException);
            throw iOException;
        }
        finally {
            if (gzipOutput != null) {
                gzipOutput.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    /*
     * Loose catch block
     */
    public ByteBufferMessageSet decompress(Message message) {
        GZIPInputStream gzipIn$1;
        ByteArrayOutputStream outputStream$1;
        block19: {
            ByteBufferMessageSet byteBufferMessageSet;
            block18: {
                ByteBuffer outputBuffer;
                CompressionCodec compressionCodec;
                block17: {
                    compressionCodec = message.compressionCodec();
                    DefaultCompressionCodec$ defaultCompressionCodec$ = DefaultCompressionCodec$.MODULE$;
                    CompressionCodec compressionCodec2 = compressionCodec;
                    if (defaultCompressionCodec$ != null ? !defaultCompressionCodec$.equals(compressionCodec2) : compressionCodec2 != null) break block17;
                    outputStream$1 = new ByteArrayOutputStream();
                    ByteBufferBackedInputStream inputStream = new ByteBufferBackedInputStream(message.payload());
                    gzipIn$1 = new GZIPInputStream(inputStream);
                    byte[] intermediateBuffer$1 = new byte[1024];
                    package$.MODULE$.Stream().continually((Function0)new anonfun.decompress.1(gzipIn$1, intermediateBuffer$1)).takeWhile((Function1)new anonfun.decompress.2()).foreach((Function1)new anonfun.decompress.3(outputStream$1, intermediateBuffer$1));
                    ByteBuffer outputBuffer2 = ByteBuffer.allocate(outputStream$1.size());
                    outputBuffer2.put(outputStream$1.toByteArray());
                    outputBuffer2.rewind();
                    byte[] outputByteArray = outputStream$1.toByteArray();
                    byteBufferMessageSet = new ByteBufferMessageSet(outputBuffer2, ByteBufferMessageSet$.MODULE$.init$default$2(), ByteBufferMessageSet$.MODULE$.init$default$3());
                    break block18;
                }
                GZIPCompressionCodec$ gZIPCompressionCodec$ = GZIPCompressionCodec$.MODULE$;
                CompressionCodec compressionCodec3 = compressionCodec;
                if (gZIPCompressionCodec$ != null ? !gZIPCompressionCodec$.equals(compressionCodec3) : compressionCodec3 != null) break block19;
                ByteArrayOutputStream outputStream$2 = new ByteArrayOutputStream();
                ByteBufferBackedInputStream inputStream = new ByteBufferBackedInputStream(message.payload());
                GZIPInputStream gzipIn$2 = new GZIPInputStream(inputStream);
                byte[] intermediateBuffer$2 = new byte[1024];
                try {
                    package$.MODULE$.Stream().continually((Function0)new anonfun.decompress.4(gzipIn$2, intermediateBuffer$2)).takeWhile((Function1)new anonfun.decompress.5()).foreach((Function1)new anonfun.decompress.6(outputStream$2, intermediateBuffer$2));
                    outputBuffer = ByteBuffer.allocate(outputStream$2.size());
                    outputBuffer.put(outputStream$2.toByteArray());
                }
                catch (IOException iOException) {
                    this.logger().error((Object)"Error while reading from the GZIP input stream", (Throwable)iOException);
                    throw iOException;
                }
                finally {
                    if (gzipIn$2 != null) {
                        gzipIn$2.close();
                    }
                    if (outputStream$2 != null) {
                        outputStream$2.close();
                    }
                }
                outputBuffer.rewind();
                byte[] outputByteArray = outputStream$2.toByteArray();
                byteBufferMessageSet = new ByteBufferMessageSet(outputBuffer, ByteBufferMessageSet$.MODULE$.init$default$2(), ByteBufferMessageSet$.MODULE$.init$default$3());
            }
            return byteBufferMessageSet;
        }
        throw new UnknownCodecException(new StringBuilder().append((Object)"Unknown Codec: ").append((Object)message.compressionCodec()).toString());
        catch (IOException iOException) {
            this.logger().error((Object)"Error while reading from the GZIP input stream", (Throwable)iOException);
            throw iOException;
        }
        finally {
            if (gzipIn$1 != null) {
                gzipIn$1.close();
            }
            if (outputStream$1 != null) {
                outputStream$1.close();
            }
        }
    }

    private CompressionUtils$() {
        MODULE$ = this;
        this.logger = Logger.getLogger(this.getClass());
    }
}

