/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kafka.api.OffsetRequest;
import kafka.api.OffsetRequest$;
import kafka.log.Log$;
import kafka.log.LogSegment;
import kafka.log.LogStats;
import kafka.log.SegmentList;
import kafka.message.FileMessageSet;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.utils.Range;
import kafka.utils.SystemTime$;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest;
import scala.reflect.ClassManifest$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\t=sAB\u0001\u0003\u0011\u000b\u0011a!A\u0002M_\u001eT!a\u0001\u0003\u0002\u00071|wMC\u0001\u0006\u0003\u0015Y\u0017MZ6b!\t9\u0001\"D\u0001\u0003\r%I!\u0001\"A\u0001\u0012\u000b\u0011!BA\u0002M_\u001e\u001c2\u0001C\u0006\u0014!\ta\u0011#D\u0001\u000e\u0015\tqq\"\u0001\u0003mC:<'\"\u0001\t\u0002\t)\fg/Y\u0005\u0003%5\u0011aa\u00142kK\u000e$\bC\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"aC*dC2\fwJ\u00196fGRDQA\u0007\u0005\u0005\u0002q\ta\u0001P5oSRt4\u0001\u0001\u000b\u0002\r!9a\u0004\u0003b\u0001\n\u0003y\u0012A\u0003$jY\u0016\u001cVO\u001a4jqV\t\u0001\u0005\u0005\u0002\rC%\u0011!%\u0004\u0002\u0007'R\u0014\u0018N\\4\t\r\u0011B\u0001\u0015!\u0003!\u0003-1\u0015\u000e\\3Tk\u001a4\u0017\u000e\u001f\u0011\t\u000b\u0019BA\u0011A\u0014\u0002\u0013\u0019Lg\u000e\u001a*b]\u001e,WC\u0001\u0015/)\u0011I#h\u0010#\u0011\u0007QQC&\u0003\u0002,+\t1q\n\u001d;j_:\u0004\"!\f\u0018\r\u0001\u0011Aq&\nC\u0001\u0002\u000b\u0007\u0001GA\u0001U#\t\tD\u0007\u0005\u0002\u0015e%\u00111'\u0006\u0002\b\u001d>$\b.\u001b8h!\t)\u0004(D\u00017\u0015\t9D!A\u0003vi&d7/\u0003\u0002:m\t)!+\u00198hK\")1(\na\u0001y\u00051!/\u00198hKN\u00042\u0001F\u001f-\u0013\tqTCA\u0003BeJ\f\u0017\u0010C\u0003AK\u0001\u0007\u0011)A\u0003wC2,X\r\u0005\u0002\u0015\u0005&\u00111)\u0006\u0002\u0005\u0019>tw\rC\u0003FK\u0001\u0007a)A\u0005beJ\f\u0017pU5{KB\u0011AcR\u0005\u0003\u0011V\u00111!\u00138u\u0011\u00151\u0003\u0002\"\u0001K+\tYe\nF\u0002M\u001fF\u00032\u0001\u0006\u0016N!\tic\n\u0002\u00050\u0013\u0012\u0005\tQ1\u00011\u0011\u0015Y\u0014\n1\u0001Q!\r!R(\u0014\u0005\u0006\u0001&\u0003\r!\u0011\u0005\u0006'\"!\t\u0001V\u0001\u000f]\u0006lWM\u0012:p[>3gm]3u)\t)6\f\u0005\u0002W3:\u0011AcV\u0005\u00031V\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0012[\u0015\tAV\u0003C\u0003]%\u0002\u0007\u0011)\u0001\u0004pM\u001a\u001cX\r\u001e\u0004\n\u0013\t!\t\u0011!A\u0001\u0005y\u001b2!X\u0006\u0014\u0011!\u0001WL!b\u0001\n\u0003\t\u0017a\u00013jeV\t!\r\u0005\u0002dM6\tAM\u0003\u0002f\u001f\u0005\u0011\u0011n\\\u0005\u0003O\u0012\u0014AAR5mK\"A\u0011.\u0018B\u0001B\u0003%!-\u0001\u0003eSJ\u0004\u0003\u0002C6^\u0005\u000b\u0007I\u0011\u00017\u0002\u000f5\f\u0007pU5{KV\t\u0011\t\u0003\u0005o;\n\u0005\t\u0015!\u0003B\u0003!i\u0017\r_*ju\u0016\u0004\u0003\u0002\u00039^\u0005\u000b\u0007I\u0011A9\u0002\u001b\u0019dWo\u001d5J]R,'O^1m+\u00051\u0005\u0002C:^\u0005\u0003\u0005\u000b\u0011\u0002$\u0002\u001d\u0019dWo\u001d5J]R,'O^1mA!AQ/\u0018BC\u0002\u0013\u0005a/\u0001\u0007oK\u0016$'+Z2pm\u0016\u0014\u00180F\u0001x!\t!\u00020\u0003\u0002z+\t9!i\\8mK\u0006t\u0007\u0002C>^\u0005\u0003\u0005\u000b\u0011B<\u0002\u001b9,W\r\u001a*fG>4XM]=!\u0011\u0015QR\f\"\u0001~)!qx0!\u0001\u0002\u0004\u0005\u0015\u0001CA\u0004^\u0011\u0015\u0001G\u00101\u0001c\u0011\u0015YG\u00101\u0001B\u0011\u0015\u0001H\u00101\u0001G\u0011\u0015)H\u00101\u0001x\u0011%\tI!\u0018b\u0001\n\u0013\tY!\u0001\u0004m_\u001e<WM]\u000b\u0003\u0003\u001b\u0001B!a\u0004\u0002\u001e5\u0011\u0011\u0011\u0003\u0006\u0005\u0003'\t)\"A\u0003m_\u001e$$N\u0003\u0003\u0002\u0018\u0005e\u0011AB1qC\u000eDWM\u0003\u0002\u0002\u001c\u0005\u0019qN]4\n\t\u0005}\u0011\u0011\u0003\u0002\u0007\u0019><w-\u001a:\t\u0011\u0005\rR\f)A\u0005\u0003\u001b\tq\u0001\\8hO\u0016\u0014\b\u0005C\u0005\u0002(u\u0013\r\u0011\"\u0003\u0002*\u0005!An\\2l+\u0005Y\u0001bBA\u0017;\u0002\u0006IaC\u0001\u0006Y>\u001c7\u000e\t\u0005\n\u0003ci&\u0019!C\u0005\u0003g\t\u0011\"\u001e8gYV\u001c\b.\u001a3\u0016\u0005\u0005U\u0002\u0003BA\u001c\u0003\u000bj!!!\u000f\u000b\t\u0005m\u0012QH\u0001\u0007CR|W.[2\u000b\t\u0005}\u0012\u0011I\u0001\u000bG>t7-\u001e:sK:$(bAA\"\u001f\u0005!Q\u000f^5m\u0013\u0011\t9%!\u000f\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0011!\tY%\u0018Q\u0001\n\u0005U\u0012AC;oM2,8\u000f[3eA!I\u0011qJ/C\u0002\u0013%\u0011\u0011K\u0001\u0010Y\u0006\u001cHO\u001a7vg\",G\rV5nKV\u0011\u00111\u000b\t\u0005\u0003o\t)&\u0003\u0003\u0002X\u0005e\"AC!u_6L7\rT8oO\"A\u00111L/!\u0002\u0013\t\u0019&\u0001\tmCN$h\r\\;tQ\u0016$G+[7fA!Q\u0011qL/C\u0002\u0013\u0005!!!\u0019\u0002\u0011M,w-\\3oiN,\"!a\u0019\u0011\u000b\u001d\t)'!\u001b\n\u0007\u0005\u001d$AA\u0006TK\u001elWM\u001c;MSN$\bcA\u0004\u0002l%\u0019\u0011Q\u000e\u0002\u0003\u00151{wmU3h[\u0016tG\u000f\u0003\u0005\u0002ru\u0003\u000b\u0011BA2\u0003%\u0019XmZ7f]R\u001c\b\u0005\u0003\u0005\u0002vu\u0013\r\u0011\"\u0001 \u0003\u0011q\u0017-\\3\t\u000f\u0005eT\f)A\u0005A\u0005)a.Y7fA!I\u0011QP/C\u0002\u0013%\u0011qP\u0001\tY><7\u000b^1ugV\u0011\u0011\u0011\u0011\t\u0004\u000f\u0005\r\u0015bAAC\u0005\tAAj\\4Ti\u0006$8\u000f\u0003\u0005\u0002\nv\u0003\u000b\u0011BAA\u0003%awnZ*uCR\u001c\b\u0005C\u0004\u0002\u000ev#I!a$\u0002\u00191|\u0017\rZ*fO6,g\u000e^:\u0015\u0005\u0005\r\u0004bBAJ;\u0012%\u0011QS\u0001\u0011m\u0006d\u0017\u000eZ1uKN+w-\\3oiN$B!a&\u0002\u001eB\u0019A#!'\n\u0007\u0005mUC\u0001\u0003V]&$\b\u0002CA0\u0003#\u0003\r!a(\u0011\r\u0005\u0005\u00161UA5\u001b\t\t\t%\u0003\u0003\u0002&\u0006\u0005#!C!se\u0006LH*[:u\u0011\u0019\tI+\u0018C\u0001c\u0006\u0001b.^7cKJ|emU3h[\u0016tGo\u001d\u0005\b\u0003[kF\u0011AAX\u0003\u0015\u0019Gn\\:f)\t\t9\nC\u0004\u00024v#\t!!.\u0002\r\u0005\u0004\b/\u001a8e)\u0011\t9*a.\t\u0011\u0005e\u0016\u0011\u0017a\u0001\u0003w\u000b\u0001\"\\3tg\u0006<Wm\u001d\t\u0005\u0003{\u000b\u0019-\u0004\u0002\u0002@*\u0019\u0011\u0011\u0019\u0003\u0002\u000f5,7o]1hK&!\u0011QYA`\u0005)iUm]:bO\u0016\u001cV\r\u001e\u0005\b\u0003\u0013lF\u0011AAf\u0003\u0011\u0011X-\u00193\u0015\r\u0005m\u0016QZAh\u0011\u0019a\u0016q\u0019a\u0001\u0003\"9\u0011\u0011[Ad\u0001\u00041\u0015A\u00027f]\u001e$\b\u000eC\u0004\u0002Vv#\t!a6\u0002!5\f'o\u001b#fY\u0016$X\rZ,iS2,G\u0003BAm\u0003c\u0004b!a7\u0002l\u0006%d\u0002BAo\u0003OtA!a8\u0002f6\u0011\u0011\u0011\u001d\u0006\u0004\u0003G\\\u0012A\u0002\u001fs_>$h(C\u0001\u0017\u0013\r\tI/F\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti/a<\u0003\u0007M+\u0017OC\u0002\u0002jVA\u0001\"a=\u0002T\u0002\u0007\u0011Q_\u0001\naJ,G-[2bi\u0016\u0004b\u0001FA|\u0003S:\u0018bAA}+\tIa)\u001e8di&|g.\r\u0005\u0007\u0003{lF\u0011\u00017\u0002\tML'0\u001a\u0005\u0007\u0005\u0003iF\u0011\u00017\u0002!9,\u0007\u0010^!qa\u0016tGm\u00144gg\u0016$\bB\u0002B\u0003;\u0012\u0005A.\u0001\thKRD\u0015n\u001a5xCR,'/T1sW\"9!\u0011B/\u0005\n\t-\u0011!C7bs\n,'k\u001c7m)\u0011\t9J!\u0004\t\u0011\t=!q\u0001a\u0001\u0003S\nqa]3h[\u0016tG\u000fC\u0004\u0003\u0014u#\t!a,\u0002\tI|G\u000e\u001c\u0005\b\u0005/iF\u0011\u0002B\r\u0003)i\u0017-\u001f2f\r2,8\u000f\u001b\u000b\u0005\u0003/\u0013Y\u0002C\u0004\u0003\u001e\tU\u0001\u0019\u0001$\u0002!9,XNY3s\u001f\u001alUm]:bO\u0016\u001c\bb\u0002B\u0011;\u0012\u0005\u0011qV\u0001\u0006M2,8\u000f\u001b\u0005\b\u0005KiF\u0011\u0001B\u0014\u0003A9W\r^(gMN,Go\u001d\"fM>\u0014X\r\u0006\u0003\u0003*\t-\u0002c\u0001\u000b>\u0003\"A!Q\u0006B\u0012\u0001\u0004\u0011y#A\u0004sKF,Xm\u001d;\u0011\t\tE\"qG\u0007\u0003\u0005gQ1A!\u000e\u0005\u0003\r\t\u0007/[\u0005\u0005\u0005s\u0011\u0019DA\u0007PM\u001a\u001cX\r\u001e*fcV,7\u000f\u001e\u0005\b\u0005{iF\u0011\u0001B \u000319W\r\u001e+pa&\u001cg*Y7f)\u0005)\u0006b\u0002B\";\u0012\u0005!QI\u0001\u0013O\u0016$H*Y:u\r2,8\u000f[3e)&lW\rF\u0001BQ\ri&\u0011\n\t\u0004k\t-\u0013b\u0001B'm\tQA\u000f\u001b:fC\u0012\u001c\u0018MZ3")
public class Log
implements ScalaObject {
    private final File dir;
    private final long maxSize;
    private final int flushInterval;
    private final boolean needRecovery;
    private final Logger logger;
    private final Object lock;
    private final AtomicInteger unflushed;
    private final AtomicLong lastflushedTime;
    private final SegmentList<LogSegment> segments;
    private final String name;
    private final LogStats logStats;

    public static final String nameFromOffset(long l) {
        return Log$.MODULE$.nameFromOffset(l);
    }

    public static final <T extends Range> Option<T> findRange(T[] TArray, long l) {
        return Log$.MODULE$.findRange((Range[])TArray, l);
    }

    public static final <T extends Range> Option<T> findRange(T[] TArray, long l, int n) {
        return Log$.MODULE$.findRange((Range[])TArray, l, n);
    }

    public static final String FileSuffix() {
        return Log$.MODULE$.FileSuffix();
    }

    public File dir() {
        return this.dir;
    }

    public long maxSize() {
        return this.maxSize;
    }

    public int flushInterval() {
        return this.flushInterval;
    }

    public boolean needRecovery() {
        return this.needRecovery;
    }

    private Logger logger() {
        return this.logger;
    }

    private Object lock() {
        return this.lock;
    }

    private AtomicInteger unflushed() {
        return this.unflushed;
    }

    private AtomicLong lastflushedTime() {
        return this.lastflushedTime;
    }

    public SegmentList<LogSegment> segments() {
        return this.segments;
    }

    public String name() {
        return this.name;
    }

    private LogStats logStats() {
        return this.logStats;
    }

    private SegmentList<LogSegment> loadSegments() {
        boolean bl;
        ArrayList<LogSegment> accum$1 = new ArrayList<LogSegment>();
        File[] ls = this.dir().listFiles();
        if (ls != null) {
            Predef$.MODULE$.refArrayOps((Object[])ls).withFilter((Function1)new $anonfun$loadSegments$1(this)).foreach((Function1)new $anonfun$loadSegments$2(this, accum$1));
        }
        if (accum$1.size() == 0) {
            File newFile = new File(this.dir(), Log$.MODULE$.nameFromOffset(0L));
            FileMessageSet set = new FileMessageSet(newFile, true);
            bl = accum$1.add(new LogSegment(newFile, set, 0L));
        } else {
            Collections.sort(accum$1, new $anon$1(this));
            this.validateSegments(accum$1);
            LogSegment last = accum$1.remove(accum$1.size() - 1);
            last.messageSet().close();
            this.logger().info((Object)new StringBuilder().append((Object)"Loading the last segment ").append((Object)last.file().getAbsolutePath()).append((Object)" in mutable mode, recovery ").append((Object)BoxesRunTime.boxToBoolean((boolean)this.needRecovery())).toString());
            LogSegment mutable = new LogSegment(last.file(), new FileMessageSet(last.file(), true, new AtomicBoolean(this.needRecovery())), last.start());
            bl = accum$1.add(mutable);
        }
        return new SegmentList<LogSegment>((Seq<LogSegment>)Predef$.MODULE$.wrapRefArray(accum$1.toArray((Object[])new LogSegment[accum$1.size()])), (ClassManifest<LogSegment>)ClassManifest$.MODULE$.classType(LogSegment.class));
    }

    private void validateSegments(ArrayList<LogSegment> segments$1) {
        Object object = this.lock();
        synchronized (object) {
            Predef$.MODULE$.intWrapper(0).until(segments$1.size() - 1).foreach$mVc$sp((Function1)new $anonfun$validateSegments$1(this, segments$1));
            return;
        }
    }

    public int numberOfSegments() {
        return ((LogSegment[])this.segments().view()).length;
    }

    public void close() {
        Object object = this.lock();
        synchronized (object) {
            Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).foreach((Function1)new $anonfun$close$1(this));
            return;
        }
    }

    public void append(MessageSet messages) {
        IntRef numberOfMessages$1 = new IntRef(0);
        messages.foreach((Function1)new $anonfun$append$1(this, numberOfMessages$1));
        this.logStats().recordAppendedMessages(numberOfMessages$1.elem);
        Object object = this.lock();
        synchronized (object) {
            LogSegment segment = (LogSegment)Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).last();
            segment.messageSet().append(messages);
            this.maybeFlush(numberOfMessages$1.elem);
            this.maybeRoll(segment);
            return;
        }
    }

    public MessageSet read(long offset, int length) {
        MessageSet messageSet;
        LogSegment[] view = (LogSegment[])this.segments().view();
        Option option = Log$.MODULE$.findRange(view, offset, view.length);
        if (option instanceof Some) {
            LogSegment logSegment;
            Some some = (Some)option;
            LogSegment segment = logSegment = (LogSegment)some.x();
            messageSet = segment.messageSet().read(offset - segment.start(), length);
        } else {
            messageSet = MessageSet$.MODULE$.Empty();
        }
        return messageSet;
    }

    public Seq<LogSegment> markDeletedWhile(Function1<LogSegment, Boolean> predicate) {
        Object object = this.lock();
        synchronized (object) {
            LogSegment[] view = (LogSegment[])this.segments().view();
            LogSegment[] deletable = (LogSegment[])Predef$.MODULE$.refArrayOps((Object[])view).takeWhile(predicate);
            Predef$.MODULE$.refArrayOps((Object[])deletable).foreach((Function1)new $anonfun$markDeletedWhile$1(this));
            int numToDelete = Predef$.MODULE$.refArrayOps((Object[])deletable).size();
            if (numToDelete == Predef$.MODULE$.refArrayOps((Object[])view).size()) {
                this.roll();
            }
            Seq<LogSegment> seq = this.segments().trunc(numToDelete);
            return seq;
        }
    }

    public long size() {
        return BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2)new $anonfun$size$1(this)));
    }

    public long nextAppendOffset() {
        this.flush();
        LogSegment last = (LogSegment)Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).last();
        return last.start() + last.size();
    }

    public long getHighwaterMark() {
        return ((LogSegment)Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).last()).messageSet().highWaterMark();
    }

    private void maybeRoll(LogSegment segment) {
        if (segment.messageSet().sizeInBytes() > this.maxSize()) {
            this.roll();
        }
    }

    public void roll() {
        Object object = this.lock();
        synchronized (object) {
            LogSegment last = (LogSegment)Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).last();
            long newOffset = this.nextAppendOffset();
            File newFile = new File(this.dir(), Log$.MODULE$.nameFromOffset(newOffset));
            if (this.logger().isDebugEnabled()) {
                this.logger().debug((Object)new StringBuilder().append((Object)"Rolling log '").append((Object)this.name()).append((Object)"' to ").append((Object)newFile.getName()).toString());
            }
            this.segments().append((Seq<LogSegment>)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{new LogSegment(newFile, new FileMessageSet(newFile, true), newOffset)}), (ClassManifest<LogSegment>)ClassManifest$.MODULE$.classType(LogSegment.class));
            return;
        }
    }

    private void maybeFlush(int numberOfMessages) {
        if (this.unflushed().addAndGet(numberOfMessages) >= this.flushInterval()) {
            this.flush();
        }
    }

    public void flush() {
        if (this.unflushed().get() == 0) {
            return;
        }
        Object object = this.lock();
        synchronized (object) {
            if (this.logger().isDebugEnabled()) {
                this.logger().debug((Object)new StringBuilder().append((Object)"Flushing log '").append((Object)this.name()).append((Object)"' last flushed: ").append((Object)BoxesRunTime.boxToLong((long)this.getLastFlushedTime())).append((Object)" current time: ").append((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())).toString());
            }
            ((LogSegment)Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).last()).messageSet().flush();
            this.unflushed().set(0);
            this.lastflushedTime().set(System.currentTimeMillis());
            return;
        }
    }

    public long[] getOffsetsBefore(OffsetRequest request) {
        LogSegment[] segsArray$1 = (LogSegment[])this.segments().view();
        ObjectRef offsetTimeArray$1 = new ObjectRef(null);
        offsetTimeArray$1.elem = ((LogSegment)Predef$.MODULE$.refArrayOps((Object[])segsArray$1).last()).size() > 0L ? new Tuple2[segsArray$1.length + 1] : new Tuple2[segsArray$1.length];
        Predef$.MODULE$.intWrapper(0).until(segsArray$1.length).foreach$mVc$sp((Function1)new $anonfun$getOffsetsBefore$1(this, segsArray$1, offsetTimeArray$1));
        if (((LogSegment)Predef$.MODULE$.refArrayOps((Object[])segsArray$1).last()).size() > 0L) {
            ((Tuple2[])offsetTimeArray$1.elem)[segsArray$1.length] = new Tuple2.mcLL.sp(((LogSegment)Predef$.MODULE$.refArrayOps((Object[])segsArray$1).last()).start() + ((LogSegment)Predef$.MODULE$.refArrayOps((Object[])segsArray$1).last()).messageSet().highWaterMark(), SystemTime$.MODULE$.milliseconds());
        }
        IntRef startIndex$1 = new IntRef(-1);
        long l = request.time();
        if (l == OffsetRequest$.MODULE$.LatestTime()) {
            startIndex$1.elem = ((Tuple2[])offsetTimeArray$1.elem).length - 1;
        } else if (l == OffsetRequest$.MODULE$.EarliestTime()) {
            startIndex$1.elem = 0;
        } else {
            boolean isFound = false;
            if (this.logger().isDebugEnabled()) {
                Logger logger = this.logger();
                StringBuilder stringBuilder = new StringBuilder().append((Object)"Offset time array = ");
                Predef$.MODULE$.refArrayOps((Object[])((Tuple2[])offsetTimeArray$1.elem)).foreach((Function1)new $anonfun$getOffsetsBefore$3(this));
                logger.debug((Object)stringBuilder.append((Object)BoxedUnit.UNIT).toString());
            }
            startIndex$1.elem = ((Tuple2[])offsetTimeArray$1.elem).length - 1;
            while (startIndex$1.elem >= 0 && !isFound) {
                if (((Tuple2[])offsetTimeArray$1.elem)[startIndex$1.elem]._2$mcL$sp() <= request.time()) {
                    isFound = true;
                    continue;
                }
                --startIndex$1.elem;
            }
        }
        int retSize = Predef$.MODULE$.intWrapper(request.maxNumOffsets()).min(startIndex$1.elem + 1);
        long[] ret$1 = new long[retSize];
        Predef$.MODULE$.intWrapper(0).until(retSize).foreach$mVc$sp((Function1)new $anonfun$getOffsetsBefore$2(this, offsetTimeArray$1, startIndex$1, ret$1));
        return ret$1;
    }

    public String getTopicName() {
        return this.name().substring(0, this.name().lastIndexOf("-"));
    }

    public long getLastFlushedTime() {
        return this.lastflushedTime().get();
    }

    public Log(File dir, long maxSize, int flushInterval, boolean needRecovery) {
        this.dir = dir;
        this.maxSize = maxSize;
        this.flushInterval = flushInterval;
        this.needRecovery = needRecovery;
        this.logger = Logger.getLogger(Log.class);
        this.lock = new Object();
        this.unflushed = new AtomicInteger(0);
        this.lastflushedTime = new AtomicLong(System.currentTimeMillis());
        this.segments = this.loadSegments();
        this.name = dir.getName();
        this.logStats = new LogStats(this);
        Utils$.MODULE$.registerMBean(this.logStats(), new StringBuilder().append((Object)"kafka:type=kafka.logs.").append((Object)dir.getName()).toString());
    }
}

