/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import kafka.api.FetchRequest;
import kafka.api.MultiFetchRequest;
import kafka.api.MultiFetchResponse;
import kafka.api.OffsetRequest;
import kafka.api.OffsetRequest$;
import kafka.consumer.SimpleConsumer$;
import kafka.consumer.SimpleConsumerStats$;
import kafka.message.ByteBufferMessageSet;
import kafka.network.BoundedByteBufferReceive;
import kafka.network.BoundedByteBufferSend;
import kafka.network.Receive;
import kafka.network.Request;
import kafka.utils.SystemTime$;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.ScalaObject;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest;
import scala.reflect.ClassManifest$;
import scala.reflect.Manifest$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u00055d\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0004\u0003\u001dMKW\u000e\u001d7f\u0007>t7/^7fe*\u00111\u0001B\u0001\tG>t7/^7fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001A\u0001\u0003\u0005\u0002\n\u001d5\t!B\u0003\u0002\f\u0019\u0005!A.\u00198h\u0015\u0005i\u0011\u0001\u00026bm\u0006L!a\u0004\u0006\u0003\r=\u0013'.Z2u!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011]\u0001!Q1A\u0005\u0002a\tA\u0001[8tiV\t\u0011\u0004\u0005\u0002\u001b;9\u0011\u0011cG\u0005\u00039I\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0010 \u0005\u0019\u0019FO]5oO*\u0011AD\u0005\u0005\tC\u0001\u0011\t\u0011)A\u00053\u0005)\u0001n\\:uA!A1\u0005\u0001BC\u0002\u0013\u0005A%\u0001\u0003q_J$X#A\u0013\u0011\u0005E1\u0013BA\u0014\u0013\u0005\rIe\u000e\u001e\u0005\tS\u0001\u0011\t\u0011)A\u0005K\u0005)\u0001o\u001c:uA!A1\u0006\u0001BC\u0002\u0013\u0005A%A\u0005t_RKW.Z8vi\"AQ\u0006\u0001B\u0001B\u0003%Q%\u0001\u0006t_RKW.Z8vi\u0002B\u0001b\f\u0001\u0003\u0006\u0004%\t\u0001J\u0001\u000bEV4g-\u001a:TSj,\u0007\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\u0002\u0017\t,hMZ3s'&TX\r\t\u0005\u0006g\u0001!\t\u0001N\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bU:\u0004(\u000f\u001e\u0011\u0005Y\u0002Q\"\u0001\u0002\t\u000b]\u0011\u0004\u0019A\r\t\u000b\r\u0012\u0004\u0019A\u0013\t\u000b-\u0012\u0004\u0019A\u0013\t\u000b=\u0012\u0004\u0019A\u0013\t\u000fq\u0002!\u0019!C\u0005{\u00051An\\4hKJ,\u0012A\u0010\t\u0003\u007f\u0019k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000bQ\u0001\\8hi)T!a\u0011#\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0015aA8sO&\u0011q\t\u0011\u0002\u0007\u0019><w-\u001a:\t\r%\u0003\u0001\u0015!\u0003?\u0003\u001dawnZ4fe\u0002Bqa\u0013\u0001A\u0002\u0013%A*A\u0004dQ\u0006tg.\u001a7\u0016\u00035\u0003\"AT*\u000e\u0003=S!\u0001U)\u0002\u0011\rD\u0017M\u001c8fYNT!A\u0015\u0007\u0002\u00079Lw.\u0003\u0002U\u001f\ni1k\\2lKR\u001c\u0005.\u00198oK2DqA\u0016\u0001A\u0002\u0013%q+A\u0006dQ\u0006tg.\u001a7`I\u0015\fHC\u0001-\\!\t\t\u0012,\u0003\u0002[%\t!QK\\5u\u0011\u001daV+!AA\u00025\u000b1\u0001\u001f\u00132\u0011\u0019q\u0006\u0001)Q\u0005\u001b\u0006A1\r[1o]\u0016d\u0007\u0005C\u0004a\u0001\t\u0007I\u0011B1\u0002\t1|7m[\u000b\u0002\u0011!11\r\u0001Q\u0001\n!\tQ\u0001\\8dW\u0002BQ!\u001a\u0001\u0005\n\u0019\fqaY8o]\u0016\u001cG\u000fF\u0001N\u0011\u0015A\u0007\u0001\"\u0003j\u0003\u0015\u0019Gn\\:f)\tA&\u000eC\u0003LO\u0002\u0007Q\nC\u0003i\u0001\u0011\u0005A\u000eF\u0001Y\u0011\u0015q\u0007\u0001\"\u0001p\u0003\u00151W\r^2i)\t\u0001h\u000f\u0005\u0002ri6\t!O\u0003\u0002t\t\u00059Q.Z:tC\u001e,\u0017BA;s\u0005Q\u0011\u0015\u0010^3Ck\u001a4WM]'fgN\fw-Z*fi\")q/\u001ca\u0001q\u00069!/Z9vKN$\bCA=}\u001b\u0005Q(BA>\u0005\u0003\r\t\u0007/[\u0005\u0003{j\u0014ABR3uG\"\u0014V-];fgRDaa \u0001\u0005\u0002\u0005\u0005\u0011AC7vYRLg-\u001a;dQR!\u00111AA\u0005!\rI\u0018QA\u0005\u0004\u0003\u000fQ(AE'vYRLg)\u001a;dQJ+7\u000f]8og\u0016Dq!a\u0003\u007f\u0001\u0004\ti!A\u0004gKR\u001c\u0007.Z:\u0011\tE\ty\u0001_\u0005\u0004\u0003#\u0011\"A\u0003\u001fsKB,\u0017\r^3e}!9\u0011Q\u0003\u0001\u0005\u0002\u0005]\u0011\u0001E4fi>3gm]3ug\n+gm\u001c:f))\tI\"!\n\u0002*\u00055\u0012\u0011\u0007\t\u0006#\u0005m\u0011qD\u0005\u0004\u0003;\u0011\"!B!se\u0006L\bcA\t\u0002\"%\u0019\u00111\u0005\n\u0003\t1{gn\u001a\u0005\b\u0003O\t\u0019\u00021\u0001\u001a\u0003\u0015!x\u000e]5d\u0011\u001d\tY#a\u0005A\u0002\u0015\n\u0011\u0002]1si&$\u0018n\u001c8\t\u0011\u0005=\u00121\u0003a\u0001\u0003?\tA\u0001^5nK\"9\u00111GA\n\u0001\u0004)\u0013!D7bq:+Xn\u00144gg\u0016$8\u000fC\u0004\u00028\u0001!I!!\u000f\u0002\u0017M,g\u000e\u001a*fcV,7\u000f\u001e\u000b\u0004K\u0005m\u0002bB<\u00026\u0001\u0007\u0011Q\b\t\u0005\u0003\u007f\t)%\u0004\u0002\u0002B)\u0019\u00111\t\u0003\u0002\u000f9,Go^8sW&!\u0011qIA!\u0005\u001d\u0011V-];fgRDq!a\u0013\u0001\t\u0013\ti%A\u0006hKR\u0014Vm\u001d9p]N,GCAA(!\u0019\t\u0012\u0011KA+K%\u0019\u00111\u000b\n\u0003\rQ+\b\u000f\\33!\u0011\ty$a\u0016\n\t\u0005e\u0013\u0011\t\u0002\b%\u0016\u001cW-\u001b<f\u0011\u0019\ti\u0006\u0001C\u0005Y\u0006\u0019r-\u001a;Pe6\u000b7.Z\"p]:,7\r^5p]\"\u001a\u0001!!\u0019\u0011\t\u0005\r\u0014\u0011N\u0007\u0003\u0003KR1!a\u001a\u0005\u0003\u0015)H/\u001b7t\u0013\u0011\tY'!\u001a\u0003\u0015QD'/Z1eg\u00064W\r")
public class SimpleConsumer
implements ScalaObject {
    private final String host;
    private final int port;
    private final int soTimeout;
    private final int bufferSize;
    private final Logger kafka$consumer$SimpleConsumer$$logger;
    private SocketChannel channel;
    private final Object lock;

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public int soTimeout() {
        return this.soTimeout;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public final Logger kafka$consumer$SimpleConsumer$$logger() {
        return this.kafka$consumer$SimpleConsumer$$logger;
    }

    private SocketChannel channel() {
        return this.channel;
    }

    private void channel_$eq(SocketChannel socketChannel) {
        this.channel = socketChannel;
    }

    private Object lock() {
        return this.lock;
    }

    /*
     * WARNING - void declaration
     */
    private SocketChannel connect() {
        void var2_2;
        this.close();
        InetSocketAddress address = new InetSocketAddress(this.host(), this.port());
        SocketChannel channel = SocketChannel.open();
        if (this.kafka$consumer$SimpleConsumer$$logger().isDebugEnabled()) {
            this.kafka$consumer$SimpleConsumer$$logger().debug((Object)new StringBuilder().append((Object)"Connected to ").append((Object)address).append((Object)" for fetching.").toString());
        }
        channel.configureBlocking(true);
        channel.socket().setReceiveBufferSize(this.bufferSize());
        channel.socket().setSoTimeout(this.soTimeout());
        channel.socket().setKeepAlive(true);
        channel.connect(address);
        if (this.kafka$consumer$SimpleConsumer$$logger().isTraceEnabled()) {
            this.kafka$consumer$SimpleConsumer$$logger().trace((Object)new StringBuilder().append((Object)"requested receive buffer size=").append((Object)BoxesRunTime.boxToInteger((int)this.bufferSize())).append((Object)" actual receive buffer size= ").append((Object)BoxesRunTime.boxToInteger((int)channel.socket().getReceiveBufferSize())).toString());
            this.kafka$consumer$SimpleConsumer$$logger().trace((Object)new StringBuilder().append((Object)"soTimeout=").append((Object)BoxesRunTime.boxToInteger((int)this.soTimeout())).append((Object)" actual soTimeout= ").append((Object)BoxesRunTime.boxToInteger((int)channel.socket().getSoTimeout())).toString());
        }
        return var2_2;
    }

    private void close(SocketChannel channel$1) {
        if (this.kafka$consumer$SimpleConsumer$$logger().isDebugEnabled()) {
            this.kafka$consumer$SimpleConsumer$$logger().debug((Object)new StringBuilder().append((Object)"Disconnecting from ").append((Object)channel$1.socket().getRemoteSocketAddress()).toString());
        }
        Utils$.MODULE$.swallow((Function2<Object, Throwable, Object>)new $anonfun$close$3(this), (Function0<Object>)new $anonfun$close$1(this, channel$1));
        Utils$.MODULE$.swallow((Function2<Object, Throwable, Object>)new $anonfun$close$4(this), (Function0<Object>)new $anonfun$close$2(this, channel$1));
    }

    public void close() {
        Object object = this.lock();
        synchronized (object) {
            if (this.channel() != null) {
                this.close(this.channel());
            }
            this.channel_$eq(null);
            return;
        }
    }

    public ByteBufferMessageSet fetch(FetchRequest request$1) {
        Object object = this.lock();
        synchronized (object) {
            long startTime = SystemTime$.MODULE$.nanoseconds();
            this.getOrMakeConnection();
            ObjectRef response$1 = new ObjectRef(null);
            this.liftedTree1$1(request$1, response$1);
            long endTime = SystemTime$.MODULE$.nanoseconds();
            SimpleConsumerStats$.MODULE$.recordFetchRequest(endTime - startTime);
            SimpleConsumerStats$.MODULE$.recordConsumptionThroughput(((Receive)((Tuple2)response$1.elem)._1()).buffer().limit());
            ByteBufferMessageSet byteBufferMessageSet = new ByteBufferMessageSet(((Receive)((Tuple2)response$1.elem)._1()).buffer(), request$1.offset(), ((Tuple2)response$1.elem)._2$mcI$sp());
            return byteBufferMessageSet;
        }
    }

    public MultiFetchResponse multifetch(Seq<FetchRequest> fetches$1) {
        Object object = this.lock();
        synchronized (object) {
            long startTime = SystemTime$.MODULE$.nanoseconds();
            this.getOrMakeConnection();
            ObjectRef response$2 = new ObjectRef(null);
            this.liftedTree2$1(fetches$1, response$2);
            long endTime = SystemTime$.MODULE$.nanoseconds();
            SimpleConsumerStats$.MODULE$.recordFetchRequest(endTime - startTime);
            SimpleConsumerStats$.MODULE$.recordConsumptionThroughput(((Receive)((Tuple2)response$2.elem)._1()).buffer().limit());
            MultiFetchResponse multiFetchResponse = new MultiFetchResponse(((Receive)((Tuple2)response$2.elem)._1()).buffer(), fetches$1.length(), (long[])Predef$.MODULE$.refArrayOps((Object[])fetches$1.toArray(ClassManifest$.MODULE$.classType(FetchRequest.class))).map((Function1)new $anonfun$multifetch$1(this), Array$.MODULE$.canBuildFrom((ClassManifest)Manifest$.MODULE$.Long())));
            return multiFetchResponse;
        }
    }

    public long[] getOffsetsBefore(String topic$1, int partition$1, long time$1, int maxNumOffsets$1) {
        Object object = this.lock();
        synchronized (object) {
            this.getOrMakeConnection();
            ObjectRef response$3 = new ObjectRef(null);
            this.liftedTree3$1(topic$1, partition$1, time$1, maxNumOffsets$1, response$3);
            long[] lArray = OffsetRequest$.MODULE$.deserializeOffsetArray(((Receive)((Tuple2)response$3.elem)._1()).buffer());
            return lArray;
        }
    }

    private int sendRequest(Request request) {
        BoundedByteBufferSend send2 = new BoundedByteBufferSend(request);
        return send2.writeCompletely(this.channel());
    }

    private Tuple2<Receive, Integer> getResponse() {
        BoundedByteBufferReceive response = new BoundedByteBufferReceive();
        response.readCompletely(this.channel());
        short errorCode = response.buffer().getShort();
        return new Tuple2((Object)response, (Object)BoxesRunTime.boxToInteger((int)errorCode));
    }

    private void getOrMakeConnection() {
        if (this.channel() == null) {
            this.channel_$eq(this.connect());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void liftedTree1$1(FetchRequest fetchRequest, ObjectRef objectRef) {
        try {
            this.sendRequest(fetchRequest);
            objectRef.elem = this.getResponse();
            return;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (IOException iOException) {
            this.kafka$consumer$SimpleConsumer$$logger().info((Object)new StringBuilder().append((Object)"fetch reconnect due to ").append((Object)iOException).toString());
            try {
                this.channel_$eq(this.connect());
                this.sendRequest(fetchRequest);
                objectRef.elem = this.getResponse();
                return;
            }
            catch (IOException iOException2) {
                this.channel_$eq(null);
                throw iOException2;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void liftedTree2$1(Seq seq, ObjectRef objectRef) {
        try {
            this.sendRequest(new MultiFetchRequest((FetchRequest[])seq.toArray(ClassManifest$.MODULE$.classType(FetchRequest.class))));
            objectRef.elem = this.getResponse();
            return;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (IOException iOException) {
            this.kafka$consumer$SimpleConsumer$$logger().info((Object)new StringBuilder().append((Object)"multifetch reconnect due to ").append((Object)iOException).toString());
            try {
                this.channel_$eq(this.connect());
                this.sendRequest(new MultiFetchRequest((FetchRequest[])seq.toArray(ClassManifest$.MODULE$.classType(FetchRequest.class))));
                objectRef.elem = this.getResponse();
                return;
            }
            catch (IOException iOException2) {
                this.channel_$eq(null);
                throw iOException2;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void liftedTree3$1(String string, int n, long l, int n2, ObjectRef objectRef) {
        try {
            this.sendRequest(new OffsetRequest(string, n, l, n2));
            objectRef.elem = this.getResponse();
            return;
        }
        catch (IOException iOException) {
            this.kafka$consumer$SimpleConsumer$$logger().info((Object)new StringBuilder().append((Object)"getOffsetsBefore reconnect due to ").append((Object)iOException).toString());
            try {
                this.channel_$eq(this.connect());
                this.sendRequest(new OffsetRequest(string, n, l, n2));
                objectRef.elem = this.getResponse();
                return;
            }
            catch (IOException iOException2) {
                this.channel_$eq(null);
                throw iOException2;
            }
        }
    }

    public SimpleConsumer(String host, int port, int soTimeout, int bufferSize) {
        this.host = host;
        this.port = port;
        this.soTimeout = soTimeout;
        this.bufferSize = bufferSize;
        this.kafka$consumer$SimpleConsumer$$logger = Logger.getLogger(this.getClass());
        this.channel = null;
        this.lock = new Object();
    }
}

