/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kafka.cluster.Partition;
import kafka.common.ErrorMapping$;
import kafka.consumer.FetchedDataChunk;
import kafka.message.ByteBufferMessageSet;
import org.apache.log4j.Logger;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005uc!C\u0001\u0003\t\u0003\u0005\t\u0011\u0001\u0002\u0007\u0005I\u0001\u0016M\u001d;ji&|g\u000eV8qS\u000eLeNZ8\u000b\u0005\r!\u0011\u0001C2p]N,X.\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c2\u0001A\u0004\u0010!\tAQ\"D\u0001\n\u0015\tQ1\"\u0001\u0003mC:<'\"\u0001\u0007\u0002\t)\fg/Y\u0005\u0003\u001d%\u0011aa\u00142kK\u000e$\bC\u0001\t\u0014\u001b\u0005\t\"\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\t\"aC*dC2\fwJ\u00196fGRD\u0001B\u0006\u0001\u0003\u0006\u0004%\t\u0001G\u0001\u0006i>\u0004\u0018nY\u0002\u0001+\u0005I\u0002C\u0001\u000e\u001e\u001d\t\u00012$\u0003\u0002\u001d#\u00051\u0001K]3eK\u001aL!AH\u0010\u0003\rM#(/\u001b8h\u0015\ta\u0012\u0003\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003\u001a\u0003\u0019!x\u000e]5dA!A1\u0005\u0001BC\u0002\u0013\u0005A%\u0001\u0005ce>\\WM]%e+\u0005)\u0003C\u0001\t'\u0013\t9\u0013CA\u0002J]RD\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006I!J\u0001\nEJ|7.\u001a:JI\u0002B\u0001b\u000b\u0001\u0003\u0006\u0004%\t\u0001L\u0001\na\u0006\u0014H/\u001b;j_:,\u0012!\f\t\u0003]Ej\u0011a\f\u0006\u0003a\u0011\tqa\u00197vgR,'/\u0003\u00023_\tI\u0001+\u0019:uSRLwN\u001c\u0005\ti\u0001\u0011\t\u0011)A\u0005[\u0005Q\u0001/\u0019:uSRLwN\u001c\u0011\t\u0011Y\u0002!Q1A\u0005\n]\n!b\u00195v].\fV/Z;f+\u0005A\u0004cA\u001d?\u00016\t!H\u0003\u0002<y\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005uZ\u0011\u0001B;uS2L!a\u0010\u001e\u0003\u001b\tcwnY6j]\u001e\fV/Z;f!\t\t%)D\u0001\u0003\u0013\t\u0019%A\u0001\tGKR\u001c\u0007.\u001a3ECR\f7\t[;oW\"AQ\t\u0001B\u0001B\u0003%\u0001(A\u0006dQVt7.U;fk\u0016\u0004\u0003\u0002C$\u0001\u0005\u000b\u0007I\u0011\u0002%\u0002\u001d\r|gn];nK\u0012|eMZ:fiV\t\u0011\n\u0005\u0002K\u001b6\t1J\u0003\u0002Mu\u00051\u0011\r^8nS\u000eL!AT&\u0003\u0015\u0005#x.\\5d\u0019>tw\r\u0003\u0005Q\u0001\t\u0005\t\u0015!\u0003J\u0003=\u0019wN\\:v[\u0016$wJ\u001a4tKR\u0004\u0003\u0002\u0003*\u0001\u0005\u000b\u0007I\u0011\u0002%\u0002\u001b\u0019,Go\u00195fI>3gm]3u\u0011!!\u0006A!A!\u0002\u0013I\u0015A\u00044fi\u000eDW\rZ(gMN,G\u000f\t\u0005\t-\u0002\u0011)\u0019!C\u0005/\u0006Ia-\u001a;dQNK'0Z\u000b\u00021B\u0011!*W\u0005\u00035.\u0013Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\b\u0002\u0003/\u0001\u0005\u0003\u0005\u000b\u0011\u0002-\u0002\u0015\u0019,Go\u00195TSj,\u0007\u0005C\u0003_\u0001\u0011\u0005q,\u0001\u0004=S:LGO\u0010\u000b\tA\u0006\u00147\rZ3gOB\u0011\u0011\t\u0001\u0005\u0006-u\u0003\r!\u0007\u0005\u0006Gu\u0003\r!\n\u0005\u0006Wu\u0003\r!\f\u0005\u0006mu\u0003\r\u0001\u000f\u0005\u0006\u000fv\u0003\r!\u0013\u0005\u0006%v\u0003\r!\u0013\u0005\u0006-v\u0003\r\u0001\u0017\u0005\bS\u0002\u0011\r\u0011\"\u0003k\u0003\u0019awnZ4feV\t1\u000e\u0005\u0002mg6\tQN\u0003\u0002o_\u0006)An\\45U*\u0011\u0001/]\u0001\u0007CB\f7\r[3\u000b\u0003I\f1a\u001c:h\u0013\t!XN\u0001\u0004M_\u001e<WM\u001d\u0005\u0007m\u0002\u0001\u000b\u0011B6\u0002\u000f1|wmZ3sA!)\u0001\u0010\u0001C\u0001s\u0006\u0001r-\u001a;D_:\u001cX/\\3PM\u001a\u001cX\r\u001e\u000b\u0002uB\u0011\u0001c_\u0005\u0003yF\u0011A\u0001T8oO\")a\u0010\u0001C\u0001s\u0006qq-\u001a;GKR\u001c\u0007n\u00144gg\u0016$\bbBA\u0001\u0001\u0011\u0005\u00111A\u0001\u0013e\u0016\u001cX\r^\"p]N,X.Z(gMN,G\u000f\u0006\u0003\u0002\u0006\u0005-\u0001c\u0001\t\u0002\b%\u0019\u0011\u0011B\t\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003\u001by\b\u0019\u0001>\u0002!9,woQ8ogVlWm\u00144gg\u0016$\bbBA\t\u0001\u0011\u0005\u00111C\u0001\u0011e\u0016\u001cX\r\u001e$fi\u000eDwJ\u001a4tKR$B!!\u0002\u0002\u0016!9\u0011qCA\b\u0001\u0004Q\u0018A\u00048fo\u001a+Go\u00195PM\u001a\u001cX\r\u001e\u0005\b\u00037\u0001A\u0011AA\u000f\u0003\u001d)g.];fk\u0016$RA_A\u0010\u0003_A\u0001\"!\t\u0002\u001a\u0001\u0007\u00111E\u0001\t[\u0016\u001c8/Y4fgB!\u0011QEA\u0016\u001b\t\t9CC\u0002\u0002*\u0011\tq!\\3tg\u0006<W-\u0003\u0003\u0002.\u0005\u001d\"\u0001\u0006\"zi\u0016\u0014UO\u001a4fe6+7o]1hKN+G\u000fC\u0004\u00022\u0005e\u0001\u0019\u0001>\u0002\u0017\u0019,Go\u00195PM\u001a\u001cX\r\u001e\u0005\b\u0003k\u0001A\u0011AA\u001c\u00031)g.];fk\u0016,%O]8s)\u0019\t)!!\u000f\u0002V!A\u00111HA\u001a\u0001\u0004\ti$A\u0001f!\u0011\ty$a\u0014\u000f\t\u0005\u0005\u00131\n\b\u0005\u0003\u0007\nI%\u0004\u0002\u0002F)\u0019\u0011qI\f\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0012bAA'#\u00059\u0001/Y2lC\u001e,\u0017\u0002BA)\u0003'\u0012\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u00055\u0013\u0003C\u0004\u00022\u0005M\u0002\u0019\u0001>\t\u000f\u0005e\u0003\u0001\"\u0011\u0002\\\u0005AAo\\*ue&tw\rF\u0001\u001a\u0001")
public class PartitionTopicInfo
implements ScalaObject {
    private final String topic;
    private final int brokerId;
    private final Partition partition;
    private final BlockingQueue<FetchedDataChunk> chunkQueue;
    private final AtomicLong consumedOffset;
    private final AtomicLong fetchedOffset;
    private final AtomicInteger fetchSize;
    private final Logger logger;

    public String topic() {
        return this.topic;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public Partition partition() {
        return this.partition;
    }

    private BlockingQueue<FetchedDataChunk> chunkQueue() {
        return this.chunkQueue;
    }

    private AtomicLong consumedOffset() {
        return this.consumedOffset;
    }

    private AtomicLong fetchedOffset() {
        return this.fetchedOffset;
    }

    private AtomicInteger fetchSize() {
        return this.fetchSize;
    }

    private Logger logger() {
        return this.logger;
    }

    public long getConsumeOffset() {
        return this.consumedOffset().get();
    }

    public long getFetchOffset() {
        return this.fetchedOffset().get();
    }

    public void resetConsumeOffset(long newConsumeOffset) {
        this.consumedOffset().set(newConsumeOffset);
        if (this.logger().isDebugEnabled()) {
            this.logger().debug((Object)new StringBuilder().append((Object)"reset consume offset of ").append((Object)this).append((Object)" to ").append((Object)BoxesRunTime.boxToLong((long)newConsumeOffset)).toString());
        }
    }

    public void resetFetchOffset(long newFetchOffset) {
        this.fetchedOffset().set(newFetchOffset);
        if (this.logger().isDebugEnabled()) {
            this.logger().debug((Object)Predef$.MODULE$.augmentString("reset fetch offset of ( %s ) to %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this, BoxesRunTime.boxToLong((long)newFetchOffset)})));
        }
    }

    public long enqueue(ByteBufferMessageSet messages, long fetchOffset) {
        long size2 = messages.validBytes();
        if (size2 > 0L) {
            if (this.logger().isTraceEnabled()) {
                this.logger().trace((Object)new StringBuilder().append((Object)"Updating fetch offset = ").append((Object)BoxesRunTime.boxToLong((long)this.fetchedOffset().get())).append((Object)" with size = ").append((Object)BoxesRunTime.boxToLong((long)size2)).toString());
            }
            this.chunkQueue().put(new FetchedDataChunk(messages, this, fetchOffset));
            long newOffset = this.fetchedOffset().addAndGet(size2);
            if (this.logger().isDebugEnabled()) {
                this.logger().debug((Object)Predef$.MODULE$.augmentString("updated fetch offset of ( %s ) to %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this, BoxesRunTime.boxToLong((long)newOffset)})));
            }
        }
        return size2;
    }

    public void enqueueError(Throwable e, long fetchOffset) {
        ByteBufferMessageSet messages = new ByteBufferMessageSet(ErrorMapping$.MODULE$.EmptyByteBuffer(), 0L, ErrorMapping$.MODULE$.codeFor(e.getClass()));
        this.chunkQueue().put(new FetchedDataChunk(messages, this, fetchOffset));
    }

    public String toString() {
        return new StringBuilder().append((Object)this.topic()).append((Object)":").append((Object)this.partition().toString()).append((Object)": fetched offset = ").append((Object)BoxesRunTime.boxToLong((long)this.fetchedOffset().get())).append((Object)": consumed offset = ").append((Object)BoxesRunTime.boxToLong((long)this.consumedOffset().get())).toString();
    }

    public PartitionTopicInfo(String topic, int brokerId, Partition partition, BlockingQueue<FetchedDataChunk> chunkQueue, AtomicLong consumedOffset, AtomicLong fetchedOffset, AtomicInteger fetchSize) {
        this.topic = topic;
        this.brokerId = brokerId;
        this.partition = partition;
        this.chunkQueue = chunkQueue;
        this.consumedOffset = consumedOffset;
        this.fetchedOffset = fetchedOffset;
        this.fetchSize = fetchSize;
        this.logger = Logger.getLogger(this.getClass());
        if (this.logger().isDebugEnabled()) {
            this.logger().debug((Object)new StringBuilder().append((Object)"initial consumer offset of ").append((Object)this).append((Object)" is ").append((Object)BoxesRunTime.boxToLong((long)consumedOffset.get())).toString());
            this.logger().debug((Object)new StringBuilder().append((Object)"initial fetch offset of ").append((Object)this).append((Object)" is ").append((Object)BoxesRunTime.boxToLong((long)fetchedOffset.get())).toString());
        }
    }
}

