(ns storm-commons.spouts
  (:require [backtype.storm.clojure :refer [spout-spec]])
  (:import (storm.kafka KafkaSpout SpoutConfig StringScheme ZkHosts)
           (backtype.storm.spout SchemeAsMultiScheme)
           (io.latent.storm.rabbitmq RabbitMQMessageScheme RabbitMQSpout UnanchoredRabbitMQSpout)
           (io.latent.storm.rabbitmq.config ConnectionConfig
                                            ConsumerConfigBuilder)))

;; rabbitmq spout
(defn- rabbitmq-spout-config
  [uri queue]
  (-> (ConsumerConfigBuilder. )
      (.connection (ConnectionConfig. uri))
      (.queue queue)
      (.prefetch 200)
      (.requeueOnFail)
      (.build)
      (.asMap)))

(defn rabbitmq-spout-spec
  "Returns rabbitmq spout with configuration."
  [uri queue & opts]
  (apply spout-spec
         (UnanchoredRabbitMQSpout. (RabbitMQMessageScheme.
                                    (StringScheme.)
                                    "e" "p"))
         :conf (rabbitmq-spout-config uri queue)
         opts))

;; kafka spout
(defn kafka-spout
  [zks topic root id]
  (let [kafka-config (SpoutConfig. (ZkHosts. zks) topic root id)
        _ (set! (. kafka-config scheme) (SchemeAsMultiScheme. (StringScheme.)))]
    (KafkaSpout. kafka-config)))

(defn kafka-spout-spec
  "Returns kafka spout with configuration."
  [zks topic root id & opts]
  (apply spout-spec (kafka-spout zks topic root id) opts))
