(ns storm-commons.bolts
  (:require [backtype.storm.clojure :refer [defbolt emit-bolt! ack! bolt]]
            [cheshire.core :refer [generate-string parse-string]]
            [clojure.java.io :refer [writer]]
            [storm-commons.rabbitmq :as rabbitmq]
            [storm-commons.kafka :as kafka]))

;; TODO abstraction

(defn write-to-kafka
  [uri topic msg]
  (let [producer-conf {"metadata.broker.list" uri
                       "serializer.class" "kafka.serializer.DefaultEncoder"
                       "partitioner.class" "kafka.producer.DefaultPartitioner"}]
    (kafka/send-message producer-conf topic msg)))

(defbolt kafka-bolt []
  {:params [kafka-uri topic-name]}
  [tuple collector]
  (let [msg (.getValue tuple 0)]
    (write-to-kafka kafka-uri topic-name (generate-string msg))
    (ack! collector tuple)))

(defn write-to-rabbitmq
  [rabbitmq-uri queue-name msg]
  (rabbitmq/send-message rabbitmq-uri queue-name msg))

(defbolt rabbitmq-bolt []
  {:params [rabbitmq-uri queue-name]}
  [tuple collector]
  (let [msg (.getValue tuple 0)]
    (write-to-rabbitmq rabbitmq-uri queue-name (generate-string msg))
    (ack! collector tuple)))

(defn append-to-log
  [log-path content]
  (with-open [wrtr (writer log-path :append true)]
    (.write wrtr (str content "\n"))))

(defbolt log-bolt []
  {:params [log-path]}
  [tuple collector]
  (let [content (.getString tuple 0)]
    (append-to-log log-path content)
    (ack! collector tuple)))
