(defproject storm-commons "0.1.1"
  :description "Storm commons library"
  :url "http://github.com/huaban/storm-commons"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :scp {:name "git"
        :url "https://github.com/huaban/storm-commons"}
  :signing {:gpg-key "507DEB0B"}
  :deploy-repositories [["clojars" {:creds :gpg}]]
  :dependencies [[clj-http "0.9.2"]
                 [enlive "1.1.5"]
                 [org.apache.kafka/kafka_2.10 "0.8.1.1" :scope "provided"
                  :exclusions [org.apache.zookeeper/zookeeper
                               log4j/log4j]]
                 [com.novemberain/langohr "2.11.0"]
                 [io.latent/storm-rabbitmq "0.5.10"]]
  :profiles {:dev
             {:dependencies [[org.clojure/clojure "1.5.1"]
                             [org.apache.storm/storm-core "0.9.2-incubating"]
                             [org.apache.storm/storm-kafka "0.9.2-incubating"]]}})
