(ns storm-commons.rabbitmq
  (:gen-class)
  (:require [langohr.core :as rmq]
            [langohr.channel :as lch]
            [langohr.queue :as lq]
            [langohr.basic :as lb]))

(def ^{:const true}
  default-exchange-name "")

(def conn (atom nil))

(defn send-message
  [uri queue message]
  (if (nil? @conn)
    (reset! conn (rmq/connect {:uri uri})))
  (let [ch    (lch/open @conn)
        qname queue]
    (lb/publish ch default-exchange-name qname message :content-type "text/plain")
    (rmq/close ch)))
