(ns storm-commons.kafka
  (:import [kafka.javaapi.producer Producer]
           [kafka.producer ProducerConfig KeyedMessage]
           [java.util List]
           [java.util Properties]))

(defn as-properties
  [m]
  (let [props (Properties. )]
    (doseq [[n v] m]
      (.setProperty props n v))
    props))

(defn producer
  "Creates a Producer. m is the configuration
   metadata.broker.list : \"server:port,server:port\""
  [m]
  (Producer. (ProducerConfig. (as-properties m))))

(defn message
  ([topic value] (message topic nil value))
  ([topic key value] (KeyedMessage. topic key value)))

(defn send-message
  ([producer-conf topic value]
     (send-message producer-conf topic nil value))
  ([producer-conf topic key value]
     (.send (producer producer-conf) (message topic key (.getBytes value)))))

(defn send-messages
  [^Producer producer ^List messages]
  (.send producer messages))
