(ns stock-grok.s.market.stats
  (:require
   [clojure.spec.alpha :as s :refer [nilable]]
   [stock-grok.s.db.crux :as c]
   [stock-grok.s.market :as mkt]
   [stock-grok.s.util :as util]
   [crux.api]))

(s/def ::headline :crux.db/id)
(s/def ::symbol ::mkt/symbol)
(s/def ::companyName (nilable string?))
(s/def ::marketcap (nilable number?))
(s/def ::week52high (nilable number?))
(s/def ::week52low (nilable number?))
(s/def ::week52change (nilable number?))
(s/def ::sharesOutstanding (nilable number?))
(s/def ::avg30Volume (nilable number?))
(s/def ::avg10Volume (nilable number?))
(s/def ::float (nilable number?))
(s/def ::employees (nilable number?))
(s/def ::ttmEPS (nilable number?))
(s/def ::ttmDividendRate (nilable number?))
(s/def ::dividendYield (nilable number?))
(s/def ::nextDividendDate (nilable string?))
(s/def ::exDividendDate (nilable string?))
(s/def ::nextEarningsDate (nilable string?))
(s/def ::peRatio (nilable number?))
(s/def ::beta (nilable number?))
(s/def ::day200MovingAvg (nilable number?))
(s/def ::day50MovingAvg (nilable number?))
(s/def ::maxPercentChange (nilable number?))
(s/def ::year5ChangePercent (nilable number?))
(s/def ::year2ChangePercent (nilable number?))
(s/def ::year1ChangePercent (nilable number?))
(s/def ::ytdChangePercent (nilable number?))
(s/def ::month6ChangePercent (nilable number?))
(s/def ::month3ChangePercent (nilable number?))
(s/def ::month1ChangePercent (nilable number?))
(s/def ::day30ChangePercent (nilable number?))
(s/def ::day5ChangePercent (nilable number?))
(s/def ::rsiWilders14 (nilable number?))

(s/def ::entity
  (s/and ::c/entity
         (s/keys :req [::symbol ::headline]
                 :opt [::companyName ::marketcap ::week52high ::week52low ::week52change
                       ::sharesOutstanding ::avg10Volume ::avg10Volume ::float ::employees
                       ::ttmEPS ::ttmDividendRate ::dividendYield ::nextEarningsDate
                       ::nextDividendDate ::exDividendDate ::peRatio ::beta ::day200MovingAvg
                       ::day50MovingAvg ::maxPercentChange ::year1ChangePercent ::year2ChangePercent
                       ::year5ChangePercent ::ytdChangePercent ::month1ChangePercent
                       ::month3ChangePercent ::month6ChangePercent ::day30ChangePercent
                       ::day5ChangePercent ::rsiWilders14])))

(defn map-ns [k]
  (util/map-namespace (namespace ::entity) k))
