(ns stock-grok.s.headline
  (:require
   [stock-grok.s.util :as util]
   [stock-grok.s.market :as m]
   [stock-grok.s.db.crux :as c]
   [clojure.spec.alpha :as s]))

(s/def ::tickers (s/and set? (s/coll-of ::m/symbol)))
(s/def ::keywords (s/and set? (s/coll-of string?)))
(s/def ::title string?)
(s/def ::url string?)
(s/def ::published inst?)
(s/def ::airtable-ids (s/and set? (s/coll-of string?)))
(s/def ::image-url (s/nilable string?))

(s/def ::entity
  (s/and ::c/entity
         (s/keys :req [::title ::url]
                 :opt [::keywords ::tickers
                       ::published  ::airtable-ids])))


(defn map-ns [k]
  (util/map-namespace (namespace ::tickers) k))
