(defproject stock-grok/spec "0.7.0"
  :description "SG data and boundary specifications"
  :url "http://example.com/FIXME"
  :license {:name "EPL-2.0 OR GPL-2.0-or-later WITH Classpath-exception-2.0"
            :url  "https://www.eclipse.org/legal/epl-2.0/"}

  :plugins [[lein-cloverage "1.0.13"]
            [lein-shell "0.5.0"]
            [lein-ancient "0.6.15"]
            [lein-changelog "0.3.2"]
            [nicheware/lein-gitlab-wagon "1.0.0"]]

  :source-paths ["src"]

  :profiles {:dev {:dependencies [[org.clojure/clojure "1.10.1"]]}}

  :deploy-repositories
  [["releases" {:url   "gitlab://gitlab.com/api/v4/projects/14205575/packages/maven"
                :username "Job-Token"
                :password :env/ci_job_token
                :sign-releases false}]]

  :aliases
  {"update-readme-version" ["shell" "sed" "-i" "s/\\\\[stock-grok\\.util\\.messaging \"[0-9.]*\"\\\\]/[stock-grok\\.util\\.messaging \"${:version}\"]/" "README.md"]}

  :release-tasks
  [["shell" "git" "diff" "--exit-code"]
   ["change" "version" "leiningen.release/bump-version"]
   ["change" "version" "leiningen.release/bump-version" "release"]
   ["changelog" "release"]
   ["update-readme-version"]
   ["vcs" "commit"]
   ["vcs" "tag"]
   ["deploy" "releases"]
   ["vcs" "push"]])
