(ns ikota.core
  (:require [cuerdas.core :as cc]))

(declare hiccup->str)

(defn extract-tag-id-css-classes [tag-maybe-id-css-classes]
  (let [as-str (name tag-maybe-id-css-classes)
        chunks (clojure.string/split as-str #"\.")
        tag-with-maybe-id (first chunks)
        [tag id] (clojure.string/split tag-with-maybe-id #"#")
        css-classes (rest chunks)]
    [tag id css-classes]))

(defn style-map->css-str [m]
  (->> m
       (map (fn [[k v]]
              (let [css-key (name k)
                    css-val (cond
                              (keyword? v) (name v)
                              (number? v) (str v "px")
                              :else v)]
                (cc/format "%s: %s" css-key css-val))))
       (clojure.string/join "; ")))

(defn- attribute-map->str [attribute-map]
  (clojure.string/join " " (for [[k v] attribute-map]
                             (if (= k :style)
                               (cc/format "style=\"%s\"" (style-map->css-str v))
                               (cc/format "%s=\"%s\"" (name k) v)))))



(defn- well-formed-html-str [tag-maybe-id-css-classes attr-map hiccup-content]
  (let [[tag-name id css-classes] (extract-tag-id-css-classes tag-maybe-id-css-classes)
        attribute-map (if (empty? css-classes)
                        attr-map
                        (assoc attr-map :class (clojure.string/join " " css-classes)))
        attribute-map (if (nil? id)
                        attribute-map
                        (assoc attribute-map :id id))
        attributes (attribute-map->str attribute-map)]
    (cond
      (or (= tag-name "link")
          (= tag-name "input")) (cc/format "<%s %s>" tag-name attributes)
      :else (let [begin-tag (cc/format "<%s %s>" tag-name attributes)
                  body (hiccup->str hiccup-content)
                  end-tag (cc/format "</%s>" tag-name) 
                  well-formed [begin-tag body end-tag]
                  html-str (clojure.string/join " " well-formed)]
              html-str))))

(defn hiccup->str [hiccup]
  (if (-> hiccup sequential? not)
    hiccup
    (let [tag-with-css-classes (first hiccup)
          maybe-attribute-map (second hiccup)]
      (cond
        (and (keyword? tag-with-css-classes)
             (map? maybe-attribute-map)) (well-formed-html-str tag-with-css-classes
                                                               maybe-attribute-map
                                                               (rest (rest hiccup)))
        (keyword? tag-with-css-classes) (well-formed-html-str tag-with-css-classes
                                                              {}
                                                              (rest hiccup))
        :else (clojure.string/join " " (map hiccup->str hiccup))))))
