/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit.ws;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.httpkit.ws.WebSocketClientHandler;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.handler.codec.http.HttpRequestEncoder;
import org.jboss.netty.handler.codec.http.HttpResponseDecoder;
import org.jboss.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketVersion;

public class WebSocketClient {
    private final URI uri;
    ClientBootstrap bootstrap;
    Channel ch = null;
    private BlockingQueue<WebSocketFrame> queue = new ArrayBlockingQueue<WebSocketFrame>(10);

    public static void main(String[] args) throws Exception {
        WebSocketClient client = new WebSocketClient("ws://localhost:9090/ws2/ws");
        client.sendMessage("{:length 3145728, :times 1}");
        for (int i = 0; i < 1; ++i) {
            Object message = client.getMessage();
            if (!(message instanceof String)) continue;
            System.out.println(((String)message).length());
        }
    }

    public WebSocketClient(String url) throws Exception {
        this.bootstrap = new ClientBootstrap((ChannelFactory)new NioClientSocketChannelFactory((Executor)Executors.newFixedThreadPool(1), (Executor)Executors.newFixedThreadPool(1)));
        this.uri = new URI(url);
        HashMap customHeaders = new HashMap();
        final WebSocketClientHandshaker handshaker = new WebSocketClientHandshakerFactory().newHandshaker(this.uri, WebSocketVersion.V13, null, false, customHeaders);
        final CountDownLatch latch = new CountDownLatch(1);
        this.bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                pipeline.addLast("decoder", (ChannelHandler)new HttpResponseDecoder());
                pipeline.addLast("encoder", (ChannelHandler)new HttpRequestEncoder());
                pipeline.addLast("ws-handler", (ChannelHandler)new WebSocketClientHandler(handshaker, WebSocketClient.this.queue, latch));
                return pipeline;
            }
        });
        ChannelFuture future = this.bootstrap.connect((SocketAddress)new InetSocketAddress(this.uri.getHost(), this.uri.getPort()));
        future.syncUninterruptibly();
        this.ch = future.getChannel();
        handshaker.handshake(this.ch).syncUninterruptibly();
        latch.await();
    }

    public void sendMessage(String message) {
        this.ch.write((Object)new TextWebSocketFrame(message));
    }

    public void sendFragmentedMesg(String message, int frameCount) {
        int i;
        int length = message.length();
        int frame = length / frameCount;
        for (i = 0; i < length - frame; i += frame) {
            this.ch.write((Object)new TextWebSocketFrame(false, 0, message.substring(i, i + frame)));
        }
        this.ch.write((Object)new TextWebSocketFrame(message.substring(i)));
    }

    public void sendFragmentedMesg(String message) {
        int i;
        int length = message.length();
        int perframe = Math.min(4000, new Random().nextInt(length / 2) + 40);
        for (i = 0; i < length - perframe; i += perframe) {
            this.ch.write((Object)new TextWebSocketFrame(false, 0, message.substring(i, i + perframe)));
        }
        this.ch.write((Object)new TextWebSocketFrame(message.substring(i)));
    }

    public void sendBinaryData(byte[] data) {
        this.ch.write((Object)new BinaryWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])data)));
    }

    public Object getMessage() throws InterruptedException {
        WebSocketFrame frame = this.queue.poll(5L, TimeUnit.SECONDS);
        if (frame instanceof TextWebSocketFrame) {
            return ((TextWebSocketFrame)frame).getText();
        }
        if (frame instanceof BinaryWebSocketFrame) {
            return frame.getBinaryData().array();
        }
        return frame;
    }

    public String ping(String data) throws Exception {
        byte[] bytes = data.getBytes();
        this.ch.write((Object)new PingWebSocketFrame(ChannelBuffers.copiedBuffer((byte[])bytes)));
        WebSocketFrame frame = this.queue.poll(5L, TimeUnit.SECONDS);
        if (frame instanceof PongWebSocketFrame) {
            ChannelBuffer d = frame.getBinaryData();
            return new String(d.array(), 0, d.readableBytes());
        }
        throw new Exception("pong frame expected, instead of " + frame);
    }

    public void close() throws Exception {
        this.ch.write((Object)new CloseWebSocketFrame());
        WebSocketFrame frame = this.queue.poll(5L, TimeUnit.SECONDS);
        if (!(frame instanceof CloseWebSocketFrame)) {
            throw new Exception("CloseWebSocketFrame excepted");
        }
        this.ch.close();
        this.ch.getCloseFuture().awaitUninterruptibly();
        this.bootstrap.releaseExternalResources();
    }
}

