/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit.server;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.httpkit.server.Task;
import org.httpkit.server.ThreadPool;
import org.httpkit.server.ThreadPool2;
import org.httpkit.server.ThreadPool3;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ThreadPoolTest {
    final int total = 4000000;
    final int thread = 100;
    Object pool;
    AtomicInteger counter;
    long start = System.currentTimeMillis();

    @Before
    public void setup() {
        this.counter = new AtomicInteger(0);
        this.start = System.currentTimeMillis();
    }

    @After
    public void tearDown() {
        long time = System.currentTimeMillis() - this.start;
        System.out.println(this.pool.getClass().getName() + "\t" + this.counter.get() + " " + time + "ms");
    }

    @Test
    public void testHomeMakeQueue() throws InterruptedException {
        ThreadPool3 p = new ThreadPool3(100, 4000000);
        this.pool = p;
        int c = 0;
        while (c++ < 4000000) {
            p.submit(new Task(this.counter));
        }
        p.coseAndwait();
    }

    @Test
    public void testPool2() throws InterruptedException {
        ThreadPool2 p = new ThreadPool2(100, 4000000);
        this.pool = p;
        int c = 0;
        while (c++ < 4000000) {
            p.submit(new Task(this.counter));
        }
        p.coseAndwait();
    }

    @Test
    public void testPool22() throws InterruptedException {
        ThreadPool2 p = new ThreadPool2(100, 4000000);
        this.pool = p;
        int c = 0;
        while (c++ < 4000000) {
            p.submit(new Task(this.counter));
        }
        p.coseAndwait();
    }

    @Test
    public void testHomeMade() throws InterruptedException {
        ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(4000000);
        ThreadPool p = new ThreadPool(100, queue);
        this.pool = p;
        int c = 0;
        while (c++ < 4000000) {
            p.submit(new Task(this.counter));
        }
        p.coseAndwait();
    }

    @Test
    public void testJDKS() throws InterruptedException {
        ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(4000000);
        ThreadPoolExecutor exes = new ThreadPoolExecutor(100, 100, 0L, TimeUnit.MILLISECONDS, queue);
        this.pool = exes;
        int c = 0;
        while (c++ < 4000000) {
            exes.submit(new Task(this.counter));
        }
        exes.shutdown();
        exes.awaitTermination(1000L, TimeUnit.SECONDS);
    }

    @Test
    public void testHomeMade2() throws InterruptedException {
        ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(4000000);
        ThreadPool p = new ThreadPool(100, queue);
        int c = 0;
        this.pool = p;
        while (c++ < 4000000) {
            p.submit(new Task(this.counter));
        }
        p.coseAndwait();
    }

    @Test
    public void testJDKS2() throws InterruptedException {
        ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(4000000);
        ThreadPoolExecutor exes = new ThreadPoolExecutor(100, 100, 0L, TimeUnit.MILLISECONDS, queue);
        int c = 0;
        this.pool = exes;
        while (c++ < 4000000) {
            exes.submit(new Task(this.counter));
        }
        exes.shutdown();
        exes.awaitTermination(1000L, TimeUnit.SECONDS);
    }

    @Test
    public void testHomeMakeQueue2() throws InterruptedException {
        ThreadPool3 p = new ThreadPool3(100, 4000000);
        int c = 0;
        this.pool = p;
        while (c++ < 4000000) {
            p.submit(new Task(this.counter));
        }
        p.coseAndwait();
    }
}

