/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit.server;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class ThreadPool3 {
    private final Worker[] workers;
    private volatile boolean closed = false;
    private final CountDownLatch latch;
    private BlockingQueue queue;

    public ThreadPool3(int size, int total) {
        this.workers = new Worker[size];
        this.queue = new BlockingQueue(total);
        this.latch = new CountDownLatch(size);
        for (int i = 0; i < size; ++i) {
            this.workers[i] = new Worker(this.queue);
            this.workers[i].t.start();
        }
    }

    public void submit(Runnable task) {
        this.queue.offer(task);
    }

    public void coseAndwait() throws InterruptedException {
        this.closed = true;
        for (Worker w : this.workers) {
            w.t.interrupt();
        }
        this.latch.await();
    }

    class Worker
    implements Runnable {
        final BlockingQueue queue;
        final Thread t;

        public Worker(BlockingQueue queue) {
            this.queue = queue;
            this.t = new Thread(this);
        }

        @Override
        public void run() {
            Runnable r;
            while ((r = this.queue.take()) != null) {
                r.run();
            }
            ThreadPool3.this.latch.countDown();
        }
    }

    class BlockingQueue {
        final Runnable[] items;
        int takeIndex;
        int putIndex;
        int count;
        final ReentrantLock lock;
        private final Condition notEmpty;

        public BlockingQueue(int capacity) {
            this.items = new Runnable[capacity];
            this.lock = new ReentrantLock();
            this.notEmpty = this.lock.newCondition();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean offer(Runnable r) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                if (this.count == this.items.length) {
                    boolean bl = false;
                    return bl;
                }
                this.items[this.putIndex] = r;
                this.putIndex = ++this.putIndex == this.items.length ? 0 : this.putIndex;
                ++this.count;
                if (this.count == 1) {
                    this.notEmpty.signal();
                }
                boolean bl = true;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Runnable take() {
            ReentrantLock lock = this.lock;
            while (true) {
                lock.lock();
                try {
                    if (this.count > 0) {
                        Runnable[] items = this.items;
                        Runnable r = items[this.takeIndex];
                        items[this.takeIndex] = null;
                        this.takeIndex = ++this.takeIndex == items.length ? 0 : this.takeIndex;
                        --this.count;
                        Runnable runnable = r;
                        return runnable;
                    }
                    if (ThreadPool3.this.closed) {
                        Runnable items = null;
                        return items;
                    }
                    this.notEmpty.await();
                }
                catch (InterruptedException interruptedException) {}
                continue;
                finally {
                    lock.unlock();
                    continue;
                }
                break;
            }
        }
    }
}

