/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit.client;

import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLEngine;
import org.httpkit.BytesInputStream;
import org.httpkit.HttpMethod;
import org.httpkit.client.HttpClient;
import org.httpkit.client.IFilter;
import org.httpkit.client.IResponseHandler;
import org.httpkit.client.RequestConfig;
import org.httpkit.client.RespListener;
import org.httpkit.client.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpsClientTest {
    public static final String AGENT = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_0) AppleWebKit/537.31 (KHTML, like Gecko) Chrome/26.0.1410.65 Safari/537.31";
    private static Logger logger = LoggerFactory.getLogger(HttpsClientTest.class);

    public static void main(String[] args) throws IOException, InterruptedException {
        HttpClient client = new HttpClient();
        String[] urls = new String[]{"https://localhost:9898/spec"};
        ExecutorService pool = Executors.newCachedThreadPool();
        for (String url : urls) {
            final CountDownLatch cd = new CountDownLatch(1);
            SSLEngine engine = SslContextFactory.getClientContext().createSSLEngine();
            RequestConfig cfg = new RequestConfig(HttpMethod.POST, null, null, 40000, -1);
            TreeMap<String, String> headers = new TreeMap<String, String>();
            for (int i = 0; i < 33; ++i) {
                headers.put("X-long-header" + i, "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_0) AppleWebKit/537.31 (KHTML, like Gecko) Chrome/26.0.1410.65 Safari/537.31Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_0) AppleWebKit/537.31 (KHTML, like Gecko) Chrome/26.0.1410.65 Safari/537.31Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_0) AppleWebKit/537.31 (KHTML, like Gecko) Chrome/26.0.1410.65 Safari/537.31Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_0) AppleWebKit/537.31 (KHTML, like Gecko) Chrome/26.0.1410.65 Safari/537.31");
            }
            headers.put("User-Agent", AGENT);
            StringBuilder body = new StringBuilder(16384);
            for (int i = 0; i < 16384; ++i) {
                body.append(i);
            }
            client.exec(url, cfg, null, new RespListener(new IResponseHandler(){

                @Override
                public void onSuccess(int status, Map<String, String> headers, Object body) {
                    int length = body instanceof String ? ((String)body).length() : ((BytesInputStream)body).available();
                    System.out.println(body);
                    logger.info("{}, {}, {}", new Object[]{status, headers, length});
                    cd.countDown();
                }

                @Override
                public void onThrowable(Throwable t) {
                    logger.error("error", t);
                    cd.countDown();
                }
            }, IFilter.ACCEPT_ALL, pool, 1));
            cd.await();
        }
    }
}

