/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import junit.framework.Assert;
import org.httpkit.HttpMethod;
import org.httpkit.HttpStatus;
import org.httpkit.HttpVersion;
import org.httpkit.LineTooLargeException;
import org.httpkit.ProtocolException;
import org.httpkit.client.AbortException;
import org.httpkit.client.Decoder;
import org.httpkit.client.IRespListener;
import org.httpkit.client.State;
import org.httpkit.codec.Utils;
import org.junit.Test;

public class HttpClientDecoderTest {
    boolean onCompleteCallded = false;

    @Test
    public void testDecodeChunkedResponse() throws IOException, LineTooLargeException, ProtocolException, AbortException {
        Decoder decoder = new Decoder(new IRespListener(){

            @Override
            public void onThrowable(Throwable t) {
                throw new RuntimeException(t);
            }

            @Override
            public void onInitialLineReceived(HttpVersion version, HttpStatus status) throws AbortException {
                Assert.assertEquals((Object)((Object)HttpVersion.HTTP_1_1), (Object)((Object)version));
                Assert.assertEquals((Object)status, (Object)HttpStatus.OK);
            }

            @Override
            public void onHeadersReceived(Map<String, String> headers) throws AbortException {
                Assert.assertNotNull((Object)headers.get("transfer-encoding"));
            }

            @Override
            public void onCompleted() {
                HttpClientDecoderTest.this.onCompleteCallded = true;
            }

            @Override
            public void onBodyReceived(byte[] buf, int length) throws AbortException {
                Assert.assertEquals((int)2869, (int)length);
            }
        }, HttpMethod.GET);
        ByteBuffer buffer = ByteBuffer.wrap(Utils.readAll("beta_shield_chunked"));
        State s = decoder.decode(buffer);
        Assert.assertEquals((String)"state should be ALL_READ", (Object)((Object)s), (Object)((Object)State.ALL_READ));
        Assert.assertTrue((boolean)this.onCompleteCallded);
    }
}

