/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.Set;

public class MakeIdleHttpConnection {
    static int CONCURENCY = 4000;
    static final int PORT = 4348;
    static final InetSocketAddress[] ADDRS = new InetSocketAddress[]{new InetSocketAddress("127.0.0.1", 4348)};
    static final byte[] REQUEST = "GET / HTTP/1.1\r\nHost: 127.0.0.1\r\n\r\n".getBytes();
    static int opened = 0;
    static int connected = 0;
    static final Random r = new Random();
    static final ByteBuffer buffer = ByteBuffer.allocateDirect(65536);
    static Selector selector;
    static final PriorityQueue<PendingClose> pendingClose;

    public static int randIdleTime() {
        return r.nextInt(40000) + 8000;
    }

    public static void handlePendingClose() throws IOException {
        PendingClose p;
        long now = System.currentTimeMillis();
        while ((p = pendingClose.peek()) != null && p.closeTime < now) {
            MakeIdleHttpConnection.close(p.key.channel());
            pendingClose.poll();
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        long now;
        if (args.length > 0) {
            CONCURENCY = Integer.parseInt(args[0]);
        }
        selector = Selector.open();
        long start = System.currentTimeMillis();
        long lastPrintTime = 0L;
        while ((now = System.currentTimeMillis()) - start <= 1200000L) {
            for (int i = 0; i < 20 && connected < CONCURENCY; ++i) {
                for (InetSocketAddress addr : ADDRS) {
                    MakeIdleHttpConnection.connect(addr);
                }
            }
            int select = selector.select(2000L);
            MakeIdleHttpConnection.handlePendingClose();
            if (select <= 0) continue;
            Set<SelectionKey> selectedKeys = selector.selectedKeys();
            for (SelectionKey key : selectedKeys) {
                SocketChannel ch = (SocketChannel)key.channel();
                if (key.isConnectable()) {
                    try {
                        if (!ch.finishConnect()) continue;
                        ++connected;
                        key.interestOps(4);
                    }
                    catch (Exception e) {
                        ch.close();
                    }
                    continue;
                }
                if (key.isWritable()) {
                    ch.write(ByteBuffer.wrap(REQUEST));
                    key.interestOps(1);
                    continue;
                }
                if (!key.isReadable()) continue;
                buffer.clear();
                try {
                    int read = ch.read(buffer);
                    if (read == -1) {
                        MakeIdleHttpConnection.close(ch);
                        continue;
                    }
                    key.cancel();
                    pendingClose.add(new PendingClose(key, now + (long)MakeIdleHttpConnection.randIdleTime()));
                }
                catch (Exception e) {
                    MakeIdleHttpConnection.close(ch);
                }
            }
            selectedKeys.clear();
            Thread.sleep(20L);
            if (now - lastPrintTime < 1000L) continue;
            lastPrintTime = now;
            System.out.println("connection opened: " + opened + "; connected: " + connected);
        }
    }

    public static void close(SelectableChannel ch) {
        --connected;
        try {
            ch.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void connect(InetSocketAddress addr) throws IOException, SocketException, ClosedChannelException {
        ++opened;
        SocketChannel ch = SocketChannel.open();
        ch.configureBlocking(false);
        ch.socket().setReuseAddress(true);
        ch.register(selector, 8);
        ch.connect(addr);
    }

    static {
        pendingClose = new PriorityQueue();
    }
}

