/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.Set;

public class ConcurrencyBench {
    static final int PER_IP = 20000;
    static final InetSocketAddress[] ADDRS = new InetSocketAddress[20];
    static final int CONCURENCY = 20000 * ADDRS.length;
    static final Random r;
    static final PriorityQueue<Connnection> connections;
    static int opened;
    static int connected;
    static int requestsSent;
    static long bytesReceived;
    static long startTime;
    static final ByteBuffer buffer;
    static Selector selector;
    static long lastReportTime;
    static final byte CR = 13;
    static final byte LF = 10;
    static final String CL = "content-length: ";

    public static ByteBuffer randRequest() {
        int length = r.nextInt(10240);
        String uri = "/?length=" + length;
        return ByteBuffer.wrap(("GET " + uri + " HTTP/1.1\r\nHost: localhost\r\n\r\n").getBytes());
    }

    public static int randidelTime() {
        int seconds = 10 + r.nextInt(90);
        return seconds * 1000;
    }

    public static void activeIdelConnection(long now) {
        Connnection c;
        while ((c = connections.peek()) != null && c.hasIdelEnoughTime(now)) {
            c.key.attach(new Attachment());
            c.key.interestOps(4);
            connections.poll();
        }
    }

    static void reportPerSeconds(long now) {
        if (now - lastReportTime > 1000L) {
            long time = now - startTime;
            double thoughput = (double)bytesReceived / (double)time * 1000.0 / 1024.0 / 1024.0;
            double rps = (double)requestsSent / (double)time * 1000.0;
            System.out.printf("time %ds, concurrency: %d, total requests: %d, thoughput: %.2fM/s, %.2f requests/seconds\n", time / 1000L, connected, requestsSent, thoughput, rps);
            lastReportTime = now;
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        selector = Selector.open();
        while (true) {
            long now = System.currentTimeMillis();
            for (int i = 0; i < 100 && opened < CONCURENCY; ++opened, ++i) {
                SocketChannel ch = SocketChannel.open();
                ch.configureBlocking(false);
                ch.socket().setReuseAddress(true);
                ch.register(selector, 8, new Attachment());
                ch.connect(ADDRS[opened % ADDRS.length]);
            }
            int select = selector.select(2000L);
            if (select > 0) {
                Set<SelectionKey> selectedKeys = selector.selectedKeys();
                for (SelectionKey key : selectedKeys) {
                    if (key.isConnectable()) {
                        ConcurrencyBench.finishConnect(key);
                        continue;
                    }
                    if (key.isWritable()) {
                        ConcurrencyBench.writeRequest(key);
                        continue;
                    }
                    if (!key.isReadable()) continue;
                    ConcurrencyBench.readResponse(key, now);
                }
                selectedKeys.clear();
            }
            ConcurrencyBench.activeIdelConnection(now);
            ConcurrencyBench.reportPerSeconds(now);
            if (opened >= CONCURENCY) continue;
            Thread.sleep(20L);
        }
    }

    private static void readResponse(SelectionKey key, long now) {
        SocketChannel ch = (SocketChannel)key.channel();
        buffer.clear();
        try {
            int read = ch.read(buffer);
            if (read == -1) {
                System.out.println("remote closed cleanly");
                ConcurrencyBench.close(ch);
            } else if (read > 0) {
                bytesReceived += (long)read;
                buffer.flip();
                Attachment att = (Attachment)key.attachment();
                if (att.responseLength == -1) {
                    String line = ConcurrencyBench.readLine(buffer);
                    while (line.length() > 0) {
                        if ((line = line.toLowerCase()).startsWith(CL)) {
                            String length = line.substring(CL.length());
                            att.bytesNeedRead = att.responseLength = Integer.valueOf(length).intValue();
                        }
                        line = ConcurrencyBench.readLine(buffer);
                    }
                    att.bytesNeedRead -= buffer.remaining();
                } else {
                    att.bytesNeedRead -= read;
                }
                if (att.bytesNeedRead == 0) {
                    connections.add(new Connnection(key, now + (long)ConcurrencyBench.randidelTime()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ConcurrencyBench.close(ch);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String readLine(ByteBuffer buffer) {
        StringBuilder sb = new StringBuilder(64);
        while (true) {
            char b = (char)buffer.get();
            switch (b) {
                case '\r': {
                    if (buffer.get() != 10) break;
                    return sb.toString();
                }
                case '\n': {
                    return sb.toString();
                }
            }
            sb.append(b);
        }
    }

    private static void writeRequest(SelectionKey key) throws IOException {
        SocketChannel ch = (SocketChannel)key.channel();
        ch.write(ConcurrencyBench.randRequest());
        ++requestsSent;
        key.interestOps(1);
    }

    private static void finishConnect(SelectionKey key) {
        SocketChannel ch = (SocketChannel)key.channel();
        try {
            if (ch.finishConnect()) {
                ++connected;
                key.interestOps(4);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void close(SelectableChannel ch) {
        --connected;
        try {
            ch.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        int PORT = 8000;
        int IP_START = 200;
        for (int i = 0; i < ADDRS.length; ++i) {
            ConcurrencyBench.ADDRS[i] = new InetSocketAddress("192.168.1." + (i + 200), 8000);
        }
        r = new Random();
        connections = new PriorityQueue(CONCURENCY);
        opened = 0;
        connected = 0;
        requestsSent = 0;
        bytesReceived = 0L;
        startTime = System.currentTimeMillis();
        buffer = ByteBuffer.allocateDirect(65536);
        lastReportTime = 0L;
    }
}

