(ns ant-ui.core
  (:require [cljsjs.antd]
            [reagent.core :as r]))

(def ^:private antd js/window.antd)

;; =============================================================================
;; Layout

(def layout* (.-Layout antd))
(def layout (r/adapt-react-class layout*))
(def layout-header (r/adapt-react-class (.-Header layout*)))
(def layout-content (r/adapt-react-class (.-Content layout*)))
(def layout-footer (r/adapt-react-class (.-Footer layout*)))
(def layout-sider (r/adapt-react-class (.-Sider layout*)))

;; =============================================================================
;; Misc

(def button (r/adapt-react-class (.-Button antd)))
(def card (r/adapt-react-class (.-Card antd)))
(def dropdown (r/adapt-react-class (.-Dropdown antd)))
(def icon (r/adapt-react-class (.-Icon antd)))

;; =============================================================================
;; Menu

(def ^:private menu* (.-Menu antd))
(def menu (r/adapt-react-class menu*))
(def sub-menu (r/adapt-react-class (.-SubMenu menu*)))
(def menu-item (r/adapt-react-class (.-Item menu*)))

;; =============================================================================
;; Tabs

(def ^:private tabs* (.-Tabs antd))
(def tabs (r/adapt-react-class tabs*))
(def tab-pane (r/adapt-react-class (.-TabPane tabs*)))

;; =============================================================================
;; Steps

(def ^:private steps* (.-Steps antd))
(def steps (r/adapt-react-class steps*))
(def step (r/adapt-react-class (.-Step steps*)))

;; =============================================================================
;; Form

(def ^:private form* (.-Form antd))
(def form (r/adapt-react-class form*))
(def form-item (r/adapt-react-class (.-Item form*)))

;; =============================================================================
;; Inputs

(def input (r/adapt-react-class (.-Input antd)))
(def input-number (r/adapt-react-class (.-InputNumber antd)))

;; =============================================================================
;; Checkbox

(def checkbox (r/adapt-react-class (.-Checkbox antd)))

;; =============================================================================
;; Tooltip

(def tooltip (r/adapt-react-class (.-Tooltip antd)))

;; =============================================================================
;; Timeline

(def ^:private timeline* (.-Timeline antd))
(def timeline (r/adapt-react-class timeline*))
(def timeline-item (r/adapt-react-class (.-Item timeline*)))

;; =============================================================================
;; Modal

(def modal (r/adapt-react-class (.-Modal antd)))

;; =============================================================================
;; Autocomplete

(def autocomplete (r/adapt-react-class (.-AutoComplete antd)))

;; =============================================================================
;; Select

(def select* (.-Select antd))
(def select (r/adapt-react-class select*))
(def select-option (r/adapt-react-class (.-Option select*)))

;; =============================================================================
;; Breadcrumbs

(def breadcrumb* (.-Breadcrumb antd))
(def breadcrumb (r/adapt-react-class breadcrumb*))
(def breadcrumb-item (r/adapt-react-class (.-Item breadcrumb*)))

;; =============================================================================
;; Grid

(def row (r/adapt-react-class (.-Row antd)))
(def col (r/adapt-react-class (.-Col antd)))

;; =============================================================================
;; Radio

(def radio* (.-Radio antd))
(def radio (r/adapt-react-class radio*))
(def radio-group (r/adapt-react-class (.-Group radio*)))
(def radio-button (r/adapt-react-class (.-Button radio*)))

;; =============================================================================
;; Table

(def table (r/adapt-react-class (.-Table antd)))

;; =============================================================================
;; Date Picker

(def date-picker* (.-DatePicker antd))
(def date-picker (r/adapt-react-class date-picker*))
(def month-picker (r/adapt-react-class (.-MonthPicker date-picker*)))
(def range-picker (r/adapt-react-class (.-RangePicker date-picker*)))

;; =============================================================================
;; Popconfirm

(def popconfirm (r/adapt-react-class (.-Popconfirm antd)))
