(defproject st/common
  "0.9.5"
  :description "The Standard Treasury Common Library"
  :url "https://github.com/standardtreasury/common"
  :dependencies [
                 [cheshire "5.4.0"]
                 [clams "0.1.0" :exclusions [potemkin]]
                 [clj-time "0.8.0"]
                 [com.cemerick/url "0.1.1"]
                 [com.github.stephenc.eaio-uuid/uuid "3.4.0"]
                 [com.novemberain/monger "3.0.0-rc2"]
                 [ctdean/iter "0.4.0" :exclusions [org.clojure/tools.reader]]
                 [environ "1.0.0"]
                 [http-kit "2.1.19"]
                 [org.postgresql/postgresql "9.3-1102-jdbc41"]
                 [ragtime "0.4.1"]
                 [korma "0.4.0" :exclusions [org.clojure/java.jdbc]]
                 [org.clojure/clojure "1.7.0"]
                 [org.clojure/tools.logging "0.3.1"]
                 [org.slf4j/slf4j-log4j12 "1.7.7"]
                 ;; holding plumbing at 0.3.3 until this is resolved:
                 ;; https://github.com/Prismatic/plumbing/issues/74
                 [prismatic/plumbing "0.3.3"]
                 [prismatic/schema "0.3.1"]
                 [robert/hooke "1.3.0"]
                 [slingshot "0.12.1"]
                 ]
  :plugins [[lein-ancient "0.5.5"]
            [lein-environ "1.0.0"]
            [org.clojars.cvillecsteele/lein-git-version "1.0.0"]]
  :aot [common.db.migrate common.db.load]
  :profiles
  {:uberjar {:aot :all}
   :dev {:dependencies [[http-kit.fake "0.2.2"]]}}
  :license {:name "The MIT License"
            :url "https://opensource.org/licenses/MIT"}
  :min-lein-version "2.0.0")
