(ns common.crypto
  "Crypto tools.
  >> ctdean")

(defn byte-array->hex-string
  "Take a byte array and convert it to a hex string."
  ([array] (byte-array->hex-string array false))
  ([array plain]
     (let [s (new String (org.apache.commons.codec.binary.Hex/encodeHex array))]
       (if plain
           s
           (->> s
                (partition-all 8)
                (interpose "-")
                (map #(apply str %))
                (apply str))))))

(defn hex-string->byte-array
  "Take a string of hex chars and convert it ot a decoded byte array."
  [s]
  (org.apache.commons.codec.binary.Hex/decodeHex (.toCharArray s)))

(defn sha1-bytes
  "Return the sha1 hash code of a string as a byte array."
  [s]
  (let [md (java.security.MessageDigest/getInstance "SHA1")]
    (.update md (.getBytes s))
    (.digest md)))

(defn sha1
  "Return the sha1 hash code of a string as a hex string"
  [s]
  (byte-array->hex-string (sha1-bytes s) true))
