(defproject st/common
  "0.10.2"
  :description "The Standard Treasury Common Library"
  :url "https://github.com/standardtreasury/common"
  :dependencies [
                 [cheshire "5.5.0"]
                 [clams "0.2.6" :exclusions [potemkin]]
                 [clj-time "0.11.0"]
                 [com.cemerick/url "0.1.1"]
                 [com.github.stephenc.eaio-uuid/uuid "3.4.0"]
                 [commons-codec "1.6"]
                 [ctdean/iter "0.10.1" :exclusions [org.clojure/tools.reader]]
                 [http-kit "2.1.19"]
                 [org.clojure/clojure "1.7.0"]
                 [org.clojure/java.jdbc "0.4.2"]
                 [org.postgresql/postgresql "9.3-1102-jdbc41"]
                 [ragtime "0.4.1"]
                 [org.clojure/tools.logging "0.3.1"]
                 [org.slf4j/slf4j-log4j12 "1.7.13"]
                 [robert/hooke "1.3.0"]
                 ]
  :aot [common.KeyNotFoundException common.db.migrate common.db.load]
  :profiles
  {:uberjar {:aot :all}
   :dev {:dependencies [[http-kit.fake "0.2.2"]
                        [org.clojure/test.check "0.7.0"]]}}
  :license {:name "The MIT License"
            :url "https://opensource.org/licenses/MIT"}
  :min-lein-version "2.0.0")
