(ns srnp.mailbox.client
  "Client for the SRNP mailbox web service."
  (:import org.joda.time.DateTime)
  (:use [environ.core :only (env)]
        [coercer.core :only (coerce)])
  (:require [indolent.client :as client]
            [clj-time.format :as time]))

(defn list-messages
  "Retrieve a list of messages for the supplied recipient."
  ([recipient]
     (list-messages (env :srnp-mailbox-url) recipient))
  ([service recipient]
     (->> (client/get [service recipient])
          :recipients
          (map #(update-in % [:modified] coerce DateTime)))))
