(ns srnp.mailbox.client
  "Client for the SRNP mailbox web service."
  (:use [environ.core :only (env)])
  (:require [clj-http.client :as http]
            [ring.util.codec :as codec]))

(defn- response-body [resp]
  (if (= 200 (:status resp))
    (:body resp)))

(defn list-messages
  "Retrieve a list of messages for the supplied recipient."
  ([recipient]
     (list-messages (env :srnp-mailbox-url) recipient))
  ([service-url recipient]
     (response-body
      (http/get
       (str service-url "/" (codec/url-encode recipient))
       {:as :json}))))
