/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.test;

import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.ConnectionObserver;
import net.spy.memcached.DefaultConnectionFactory;
import net.spy.memcached.MemcachedClient;

public class ObserverToy {
    public static void main(String[] args) throws Exception {
        final ConnectionObserver obs = new ConnectionObserver(){

            public void connectionEstablished(SocketAddress sa, int reconnectCount) {
                System.out.println("*** Established:  " + sa + " count=" + reconnectCount);
            }

            public void connectionLost(SocketAddress sa) {
                System.out.println("*** Lost connection:  " + sa);
            }
        };
        MemcachedClient c = new MemcachedClient(new DefaultConnectionFactory(){

            @Override
            public Collection<ConnectionObserver> getInitialObservers() {
                return Collections.singleton(obs);
            }

            @Override
            public boolean isDaemon() {
                return false;
            }
        }, AddrUtil.getAddresses("localhost:11212"));
        while (true) {
            c.waitForQueues(1L, TimeUnit.SECONDS);
            Thread.sleep(1000L);
        }
    }
}

