/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.test;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.DefaultConnectionFactory;
import net.spy.memcached.MemcachedClient;

public class MemcachedThreadBench
extends TestCase {
    public void testCrap() throws Exception {
        MemcachedThreadBench.main(new String[]{"10000", "100", "11211", "100"});
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 4) {
            args = new String[]{"1000", "100", "11211", "100"};
            System.out.println("Usage: java " + MemcachedThreadBench.class.getName() + " <runs> <start> <port> <threads>");
        }
        int runs = Integer.parseInt(args[0]);
        int start = Integer.parseInt(args[1]);
        String serverlist = "127.0.0.1:" + args[2];
        int threads = Integer.parseInt(args[3]);
        MemcachedClient client = new MemcachedClient(new DefaultConnectionFactory(100000, 32768), AddrUtil.getAddresses(serverlist));
        WorkerStat[] statArray = new WorkerStat[threads];
        Thread[] threadArray = new Thread[threads];
        WorkerStat mainStat = new WorkerStat();
        mainStat.runs = runs * threads;
        long begin = System.currentTimeMillis();
        int i = 0;
        while (i < threads) {
            statArray[i] = new WorkerStat();
            statArray[i].start = start + i * runs;
            statArray[i].runs = runs;
            threadArray[i] = new SetterThread(client, statArray[i]);
            threadArray[i].start();
            ++i;
        }
        i = 0;
        while (i < threads) {
            threadArray[i].join();
            ++i;
        }
        mainStat.setterTime = System.currentTimeMillis() - begin;
        begin = System.currentTimeMillis();
        i = 0;
        while (i < threads) {
            threadArray[i] = new GetterThread(client, statArray[i]);
            threadArray[i].start();
            ++i;
        }
        i = 0;
        while (i < threads) {
            threadArray[i].join();
            ++i;
        }
        mainStat.getterTime = System.currentTimeMillis() - begin;
        client.shutdown();
        WorkerStat totalStat = new WorkerStat();
        System.out.println("Thread\tstart\truns\tset time(ms)\tget time(ms)");
        int i2 = 0;
        while (i2 < threads) {
            System.out.println(i2 + "\t" + statArray[i2].start + "\t" + statArray[i2].runs + "\t" + statArray[i2].setterTime + "\t\t" + statArray[i2].getterTime);
            totalStat.runs += statArray[i2].runs;
            totalStat.setterTime += statArray[i2].setterTime;
            totalStat.getterTime += statArray[i2].getterTime;
            ++i2;
        }
        System.out.println("\nAvg\t\t" + runs + "\t" + totalStat.setterTime / (long)threads + "\t\t" + totalStat.getterTime / (long)threads);
        System.out.println("\nTotal\t\t" + totalStat.runs + "\t" + totalStat.setterTime + "\t\t" + totalStat.getterTime);
        System.out.println("\tReqPerSecond\tset - " + (long)(1000 * totalStat.runs) / totalStat.setterTime + "\tget - " + (long)(1000 * totalStat.runs) / totalStat.getterTime);
        System.out.println("\nMain\t\t" + mainStat.runs + "\t" + mainStat.setterTime + "\t\t" + mainStat.getterTime);
        System.out.println("\tReqPerSecond\tset - " + (long)(1000 * mainStat.runs) / mainStat.setterTime + "\tget - " + (long)(1000 * mainStat.runs) / mainStat.getterTime);
    }

    private static class GetterThread
    extends Thread {
        private final MemcachedClient mc;
        private final WorkerStat stat;

        GetterThread(MemcachedClient c, WorkerStat st) {
            this.stat = st;
            this.mc = c;
        }

        public void run() {
            String keyBase = "testKey";
            long begin = System.currentTimeMillis();
            int i = this.stat.start;
            while (i < this.stat.start + this.stat.runs) {
                String str = (String)this.mc.get(i + keyBase);
                assert (str != null);
                ++i;
            }
            long end = System.currentTimeMillis();
            this.stat.getterTime = end - begin;
        }
    }

    private static class SetterThread
    extends Thread {
        private static final AtomicInteger total = new AtomicInteger(0);
        private static final int MAX_QUEUE = 10000;
        private final MemcachedClient mc;
        private final WorkerStat stat;

        SetterThread(MemcachedClient c, WorkerStat st) {
            this.stat = st;
            this.mc = c;
        }

        public void run() {
            String keyBase = "testKey";
            String object = "This is a test of an object blah blah es, serialization does not seem to slow things down so much.  The gzip compression is horrible horrible performance, so we only use it for very large objects.  I have not done any heavy benchmarking recently";
            long begin = System.currentTimeMillis();
            int i = this.stat.start;
            while (i < this.stat.start + this.stat.runs) {
                this.mc.set(i + keyBase, 3600, object);
                if (total.incrementAndGet() >= 10000) {
                    this.flush();
                }
                ++i;
            }
            long end = System.currentTimeMillis();
            this.stat.setterTime = end - begin;
        }

        private synchronized void flush() {
            if (total.intValue() >= 10000) {
                this.mc.waitForQueues(5L, TimeUnit.SECONDS);
                total.set(0);
            }
        }
    }

    private static class WorkerStat {
        public int start = 0;
        public int runs = 0;
        public long setterTime = 0L;
        public long getterTime = 0L;
    }
}

