/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.test;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.BinaryConnectionFactory;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.compat.SpyObject;
import net.spy.memcached.util.CacheLoader;

public class LoaderTest
extends SpyObject
implements Runnable {
    private final int count;
    private MemcachedClient client;

    public LoaderTest(int c) {
        this.count = c;
    }

    public void init() throws Exception {
        this.client = new MemcachedClient(new BinaryConnectionFactory(), AddrUtil.getAddresses("localhost:11211"));
    }

    public void shutdown() throws Exception {
        this.client.shutdown();
    }

    public void run() {
        CacheLoader cl = new CacheLoader(this.client);
        Future<Boolean> f = null;
        int i = 0;
        while (i < this.count) {
            f = cl.push("k" + i, "some value");
            ++i;
        }
        if (f != null) {
            try {
                f.get(1L, TimeUnit.MINUTES);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] a) throws Exception {
        LoaderTest lt = new LoaderTest(1000000);
        lt.init();
        long start = System.currentTimeMillis();
        try {
            lt.run();
        }
        finally {
            lt.shutdown();
        }
        long end = System.currentTimeMillis();
        System.out.println("Runtime:  " + (end - start) + "ms");
    }
}

