/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.binary;

import java.util.ArrayList;
import java.util.Collection;
import net.spy.memcached.ops.BaseOperationFactory;
import net.spy.memcached.ops.CASOperation;
import net.spy.memcached.ops.ConcatenationOperation;
import net.spy.memcached.ops.ConcatenationType;
import net.spy.memcached.ops.DeleteOperation;
import net.spy.memcached.ops.FlushOperation;
import net.spy.memcached.ops.GetOperation;
import net.spy.memcached.ops.GetsOperation;
import net.spy.memcached.ops.KeyedOperation;
import net.spy.memcached.ops.MultiGetOperationCallback;
import net.spy.memcached.ops.MultiGetsOperationCallback;
import net.spy.memcached.ops.Mutator;
import net.spy.memcached.ops.MutatorOperation;
import net.spy.memcached.ops.NoopOperation;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.StatsOperation;
import net.spy.memcached.ops.StoreOperation;
import net.spy.memcached.ops.StoreType;
import net.spy.memcached.ops.VersionOperation;
import net.spy.memcached.protocol.binary.ConcatenationOperationImpl;
import net.spy.memcached.protocol.binary.DeleteOperationImpl;
import net.spy.memcached.protocol.binary.FlushOperationImpl;
import net.spy.memcached.protocol.binary.GetOperationImpl;
import net.spy.memcached.protocol.binary.MultiGetOperationImpl;
import net.spy.memcached.protocol.binary.MutatorOperationImpl;
import net.spy.memcached.protocol.binary.NoopOperationImpl;
import net.spy.memcached.protocol.binary.StatsOperationImpl;
import net.spy.memcached.protocol.binary.StoreOperationImpl;
import net.spy.memcached.protocol.binary.VersionOperationImpl;

public class BinaryOperationFactory
extends BaseOperationFactory {
    @Override
    public DeleteOperation delete(String key, OperationCallback operationCallback) {
        return new DeleteOperationImpl(key, operationCallback);
    }

    @Override
    public FlushOperation flush(int delay, OperationCallback cb) {
        return new FlushOperationImpl(cb);
    }

    @Override
    public GetOperation get(String key, GetOperation.Callback callback) {
        return new GetOperationImpl(key, callback);
    }

    @Override
    public GetOperation get(Collection<String> value, GetOperation.Callback cb) {
        return new MultiGetOperationImpl(value, cb);
    }

    @Override
    public GetsOperation gets(String key, GetsOperation.Callback cb) {
        return new GetOperationImpl(key, cb);
    }

    @Override
    public MutatorOperation mutate(Mutator m, String key, int by, long def, int exp, OperationCallback cb) {
        return new MutatorOperationImpl(m, key, by, def, exp, cb);
    }

    @Override
    public StatsOperation stats(String arg, StatsOperation.Callback cb) {
        return new StatsOperationImpl(arg, cb);
    }

    @Override
    public StoreOperation store(StoreType storeType, String key, int flags, int exp, byte[] data, OperationCallback cb) {
        return new StoreOperationImpl(storeType, key, flags, exp, data, 0L, cb);
    }

    @Override
    public VersionOperation version(OperationCallback cb) {
        return new VersionOperationImpl(cb);
    }

    @Override
    public NoopOperation noop(OperationCallback cb) {
        return new NoopOperationImpl(cb);
    }

    @Override
    public CASOperation cas(StoreType type, String key, long casId, int flags, int exp, byte[] data, OperationCallback cb) {
        return new StoreOperationImpl(type, key, flags, exp, data, casId, cb);
    }

    @Override
    public ConcatenationOperation cat(ConcatenationType catType, long casId, String key, byte[] data, OperationCallback cb) {
        return new ConcatenationOperationImpl(catType, key, data, casId, cb);
    }

    @Override
    protected Collection<? extends Operation> cloneGet(KeyedOperation op) {
        ArrayList<GetsOperation> rv = new ArrayList<GetsOperation>();
        MultiGetOperationCallback getCb = null;
        MultiGetsOperationCallback getsCb = null;
        if (op.getCallback() instanceof GetOperation.Callback) {
            getCb = new MultiGetOperationCallback(op.getCallback(), op.getKeys().size());
        } else {
            getsCb = new MultiGetsOperationCallback(op.getCallback(), op.getKeys().size());
        }
        for (String k : op.getKeys()) {
            rv.add((GetsOperation)(getCb == null ? this.gets(k, getsCb) : this.get(k, (GetOperation.Callback)getCb)));
        }
        return rv;
    }
}

