/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.spy.memcached.internal.CheckedOperationTimeoutException;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationState;

public class BulkGetFuture<T>
implements Future<Map<String, T>> {
    private final Map<String, Future<T>> rvMap;
    private final Collection<Operation> ops;
    private final CountDownLatch latch;
    private boolean cancelled = false;

    public BulkGetFuture(Map<String, Future<T>> m, Collection<Operation> getOps, CountDownLatch l) {
        this.rvMap = m;
        this.ops = getOps;
        this.latch = l;
    }

    @Override
    public boolean cancel(boolean ign) {
        boolean rv = false;
        for (Operation operation : this.ops) {
            rv |= operation.getState() == OperationState.WRITING;
            operation.cancel();
        }
        for (Future future : this.rvMap.values()) {
            future.cancel(ign);
        }
        this.cancelled = true;
        return rv;
    }

    @Override
    public Map<String, T> get() throws InterruptedException, ExecutionException {
        try {
            return this.get(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new RuntimeException("Timed out waiting forever", e);
        }
    }

    @Override
    public Map<String, T> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.latch.await(timeout, unit)) {
            HashSet<Operation> timedoutOps = new HashSet<Operation>();
            for (Operation op : this.ops) {
                if (op.getState() == OperationState.COMPLETE) continue;
                timedoutOps.add(op);
            }
            throw new CheckedOperationTimeoutException("Operation timed out.", timedoutOps);
        }
        for (Operation op : this.ops) {
            if (op.isCancelled()) {
                throw new ExecutionException(new RuntimeException("Cancelled"));
            }
            if (!op.hasErrored()) continue;
            throw new ExecutionException(op.getException());
        }
        HashMap<String, T> m = new HashMap<String, T>();
        for (Map.Entry<String, Future<T>> me : this.rvMap.entrySet()) {
            m.put(me.getKey(), me.getValue().get());
        }
        return m;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.latch.getCount() == 0L;
    }
}

