/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.compat.log;

import net.spy.memcached.compat.log.Level;
import net.spy.memcached.compat.log.Logger;

public abstract class AbstractLogger
implements Logger {
    private final String name;

    protected AbstractLogger(String nm) {
        if (nm == null) {
            throw new NullPointerException("Logger name may not be null.");
        }
        this.name = nm;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Throwable getThrowable(Object[] args) {
        Throwable rv = null;
        if (args.length > 0 && args[args.length - 1] instanceof Throwable) {
            rv = (Throwable)args[args.length - 1];
        }
        return rv;
    }

    @Override
    public abstract boolean isDebugEnabled();

    @Override
    public abstract boolean isInfoEnabled();

    @Override
    public void debug(Object message, Throwable exception) {
        this.log(Level.DEBUG, message, exception);
    }

    @Override
    public void debug(String message, Object ... args) {
        if (this.isDebugEnabled()) {
            this.debug((Object)String.format(message, args), this.getThrowable(args));
        }
    }

    @Override
    public void debug(Object message) {
        this.debug(message, null);
    }

    @Override
    public void info(Object message, Throwable exception) {
        this.log(Level.INFO, message, exception);
    }

    @Override
    public void info(String message, Object ... args) {
        if (this.isInfoEnabled()) {
            this.info((Object)String.format(message, args), this.getThrowable(args));
        }
    }

    @Override
    public void info(Object message) {
        this.info(message, null);
    }

    @Override
    public void warn(Object message, Throwable exception) {
        this.log(Level.WARN, message, exception);
    }

    @Override
    public void warn(String message, Object ... args) {
        this.warn((Object)String.format(message, args), this.getThrowable(args));
    }

    @Override
    public void warn(Object message) {
        this.warn(message, null);
    }

    @Override
    public void error(Object message, Throwable exception) {
        this.log(Level.ERROR, message, exception);
    }

    @Override
    public void error(String message, Object ... args) {
        this.error((Object)String.format(message, args), this.getThrowable(args));
    }

    @Override
    public void error(Object message) {
        this.error(message, null);
    }

    @Override
    public void fatal(Object message, Throwable exception) {
        this.log(Level.FATAL, message, exception);
    }

    @Override
    public void fatal(String message, Object ... args) {
        this.fatal((Object)String.format(message, args), this.getThrowable(args));
    }

    @Override
    public void fatal(Object message) {
        this.fatal(message, null);
    }

    @Override
    public void log(Level level, Object message) {
        this.log(level, message, null);
    }

    @Override
    public abstract void log(Level var1, Object var2, Throwable var3);
}

