/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class BuildInfo
extends Properties {
    public BuildInfo() throws IOException {
        this("net/spy/memcached/build.properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BuildInfo(String resource) throws IOException {
        ClassLoader cl = this.getClass().getClassLoader();
        InputStream is = cl.getResourceAsStream(resource);
        if (is == null) {
            throw new IOException("No resources found for " + resource);
        }
        try {
            this.load(is);
        }
        finally {
            is.close();
        }
    }

    public Date getBuildDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm");
        Date rv = null;
        try {
            rv = sdf.parse(this.getProperty("build.date"));
        }
        catch (ParseException pe) {
            throw new RuntimeException("Invalid date from build properties file", pe);
        }
        return rv;
    }

    public URL getFile(String rel) throws FileNotFoundException {
        ClassLoader cl = this.getClass().getClassLoader();
        URL u = cl.getResource(rel);
        if (u == null) {
            throw new FileNotFoundException("Can't find " + rel);
        }
        return u;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        if (this.getProperty("build.number") != null) {
            sb.append("build ");
            sb.append(this.getProperty("build.number"));
        }
        sb.append(" on ");
        sb.append(this.getBuildDate());
        sb.append("\nBuild platform:  java ");
        sb.append(this.getProperty("java.version"));
        sb.append(" from ");
        sb.append(this.getProperty("java.vendor"));
        sb.append(" on ");
        sb.append(this.getProperty("os.name"));
        sb.append(" version ");
        sb.append(this.getProperty("os.version"));
        if (this.getProperty("tree.version") != null) {
            sb.append("\nTree version:  ");
            sb.append(this.getProperty("tree.version"));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        BuildInfo bi = new BuildInfo();
        String cl = "%CHANGELOG%";
        System.out.println("spy.jar " + bi);
        if (!cl.equals("net/spy/memcached/changelog.txt")) {
            if (args.length > 0 && args[0].equals("-c")) {
                System.out.println(" -- Changelog:\n");
                URL u = bi.getFile("net/spy/memcached/changelog.txt");
                InputStream is = u.openStream();
                try {
                    byte[] data = new byte[8192];
                    int bread = 0;
                    do {
                        if ((bread = is.read(data)) <= 0) continue;
                        System.out.write(data, 0, bread);
                    } while (bread != -1);
                }
                finally {
                    is.close();
                }
            } else {
                System.out.println("(add -c to see the recent changelog)");
            }
        }
    }
}

