(ns splendid.jfx
  (:import (splendid SplendidJFX)
           (javafx.application Platform)
           (javafx.event EventHandler)
           (javafx.scene Node Scene)
           (javafx.scene.layout FlowPane GridPane HBox Pane VBox)
           (javafx.stage Stage)))

(defn launch-application
  "Launches a JFX app. The `init-fn` will be called with the primary Stage."
  [^clojure.lang.IFn init-fn]
  (SplendidJFX/launchApplication init-fn))

(defn launch-empty-application
  "Opens a JFX Stage and returns it. Useful during development."
  []
  (let [s (promise)]
   (SplendidJFX/launchApplication
    (fn [^Stage stage]
      (.setScene stage (Scene. (Pane.), 640.0, 480.0))
      (.show stage)
      (deliver s stage)))
   @s))

(defmacro jfx
  "Runs `body` on the JavaFX Application Thread and blocks until execution has
  finished and returns its result."
  [& body]
  `(let [f# (fn [] ~@body)
         p# (promise)]
     (if (Platform/isFxApplicationThread)
       (f#)
       (do
         (Platform/runLater #(deliver p# (f#)))
         @p#))))
