// Compiled by ClojureScript 0.0-2227
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function fn_handler(f){if(typeof cljs.core.async.t20029 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t20029 = (function (f,fn_handler,meta20030){
this.f = f;
this.fn_handler = fn_handler;
this.meta20030 = meta20030;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t20029.cljs$lang$type = true;
cljs.core.async.t20029.cljs$lang$ctorStr = "cljs.core.async/t20029";
cljs.core.async.t20029.cljs$lang$ctorPrWriter = (function (this__9852__auto__,writer__9853__auto__,opt__9854__auto__){return cljs.core._write.call(null,writer__9853__auto__,"cljs.core.async/t20029");
});
cljs.core.async.t20029.prototype.cljs$core$async$impl$protocols$Handler$ = true;
cljs.core.async.t20029.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return true;
});
cljs.core.async.t20029.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return self__.f;
});
cljs.core.async.t20029.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20031){var self__ = this;
var _20031__$1 = this;return self__.meta20030;
});
cljs.core.async.t20029.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20031,meta20030__$1){var self__ = this;
var _20031__$1 = this;return (new cljs.core.async.t20029(self__.f,self__.fn_handler,meta20030__$1));
});
cljs.core.async.__GT_t20029 = (function __GT_t20029(f__$1,fn_handler__$1,meta20030){return (new cljs.core.async.t20029(f__$1,fn_handler__$1,meta20030));
});
}
return (new cljs.core.async.t20029(f,fn_handler,null));
});
/**
* Returns a fixed buffer of size n. When full, puts will block/park.
*/
cljs.core.async.buffer = (function buffer(n){return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
* Returns a buffer of size n. When full, puts will complete but
* val will be dropped (no transfer).
*/
cljs.core.async.dropping_buffer = (function dropping_buffer(n){return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
* Returns a buffer of size n. When full, puts will complete, and be
* buffered, but oldest elements in buffer will be dropped (not
* transferred).
*/
cljs.core.async.sliding_buffer = (function sliding_buffer(n){return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
* Returns true if a channel created with buff will never block. That is to say,
* puts into this buffer will never cause the buffer to be full.
*/
cljs.core.async.unblocking_buffer_QMARK_ = (function unblocking_buffer_QMARK_(buff){var G__20033 = buff;if(G__20033)
{var bit__9935__auto__ = null;if(cljs.core.truth_((function (){var or__9285__auto__ = bit__9935__auto__;if(cljs.core.truth_(or__9285__auto__))
{return or__9285__auto__;
} else
{return G__20033.cljs$core$async$impl$protocols$UnblockingBuffer$;
}
})()))
{return true;
} else
{if((!G__20033.cljs$lang$protocol_mask$partition$))
{return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,G__20033);
} else
{return false;
}
}
} else
{return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,G__20033);
}
});
/**
* Creates a channel with an optional buffer. If buf-or-n is a number,
* will create and use a fixed buffer of that size.
*/
cljs.core.async.chan = (function() {
var chan = null;
var chan__0 = (function (){return chan.call(null,null);
});
var chan__1 = (function (buf_or_n){var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,0))?null:buf_or_n);return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1));
});
chan = function(buf_or_n){
switch(arguments.length){
case 0:
return chan__0.call(this);
case 1:
return chan__1.call(this,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
chan.cljs$core$IFn$_invoke$arity$0 = chan__0;
chan.cljs$core$IFn$_invoke$arity$1 = chan__1;
return chan;
})()
;
/**
* Returns a channel that will close after msecs
*/
cljs.core.async.timeout = (function timeout(msecs){return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
* takes a val from port. Must be called inside a (go ...) block. Will
* return nil if closed. Will park if nothing is available.
* Returns true unless port is already closed
*/
cljs.core.async._LT__BANG_ = (function _LT__BANG_(port){if(null)
{return null;
} else
{throw (new Error(("Assert failed: <! used not in (go ...) block\n"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,null)))));
}
});
/**
* Asynchronously takes a val from port, passing to fn1. Will pass nil
* if closed. If on-caller? (default true) is true, and value is
* immediately available, will call fn1 on calling thread.
* Returns nil.
*/
cljs.core.async.take_BANG_ = (function() {
var take_BANG_ = null;
var take_BANG___2 = (function (port,fn1){return take_BANG_.call(null,port,fn1,true);
});
var take_BANG___3 = (function (port,fn1,on_caller_QMARK_){var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));if(cljs.core.truth_(ret))
{var val_20034 = cljs.core.deref.call(null,ret);if(cljs.core.truth_(on_caller_QMARK_))
{fn1.call(null,val_20034);
} else
{cljs.core.async.impl.dispatch.run.call(null,((function (val_20034,ret){
return (function (){return fn1.call(null,val_20034);
});})(val_20034,ret))
);
}
} else
{}
return null;
});
take_BANG_ = function(port,fn1,on_caller_QMARK_){
switch(arguments.length){
case 2:
return take_BANG___2.call(this,port,fn1);
case 3:
return take_BANG___3.call(this,port,fn1,on_caller_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
take_BANG_.cljs$core$IFn$_invoke$arity$2 = take_BANG___2;
take_BANG_.cljs$core$IFn$_invoke$arity$3 = take_BANG___3;
return take_BANG_;
})()
;
cljs.core.async.nop = (function nop(_){return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
* puts a val into port. nil values are not allowed. Must be called
* inside a (go ...) block. Will park if no buffer space is available.
* Returns true unless port is already closed.
*/
cljs.core.async._GT__BANG_ = (function _GT__BANG_(port,val){if(null)
{return null;
} else
{throw (new Error(("Assert failed: >! used not in (go ...) block\n"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,null)))));
}
});
/**
* Asynchronously puts a val into port, calling fn0 (if supplied) when
* complete. nil values are not allowed. Will throw if closed. If
* on-caller? (default true) is true, and the put is immediately
* accepted, will call fn0 on calling thread.  Returns nil.
*/
cljs.core.async.put_BANG_ = (function() {
var put_BANG_ = null;
var put_BANG___2 = (function (port,val){var temp__4090__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);if(cljs.core.truth_(temp__4090__auto__))
{var ret = temp__4090__auto__;return cljs.core.deref.call(null,ret);
} else
{return true;
}
});
var put_BANG___3 = (function (port,val,fn1){return put_BANG_.call(null,port,val,fn1,true);
});
var put_BANG___4 = (function (port,val,fn1,on_caller_QMARK_){var temp__4090__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));if(cljs.core.truth_(temp__4090__auto__))
{var retb = temp__4090__auto__;var ret = cljs.core.deref.call(null,retb);if(cljs.core.truth_(on_caller_QMARK_))
{fn1.call(null,ret);
} else
{cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4090__auto__){
return (function (){return fn1.call(null,ret);
});})(ret,retb,temp__4090__auto__))
);
}
return ret;
} else
{return true;
}
});
put_BANG_ = function(port,val,fn1,on_caller_QMARK_){
switch(arguments.length){
case 2:
return put_BANG___2.call(this,port,val);
case 3:
return put_BANG___3.call(this,port,val,fn1);
case 4:
return put_BANG___4.call(this,port,val,fn1,on_caller_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
put_BANG_.cljs$core$IFn$_invoke$arity$2 = put_BANG___2;
put_BANG_.cljs$core$IFn$_invoke$arity$3 = put_BANG___3;
put_BANG_.cljs$core$IFn$_invoke$arity$4 = put_BANG___4;
return put_BANG_;
})()
;
cljs.core.async.close_BANG_ = (function close_BANG_(port){return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function random_array(n){var a = (new Array(n));var n__10141__auto___20035 = n;var x_20036 = 0;while(true){
if((x_20036 < n__10141__auto___20035))
{(a[x_20036] = 0);
{
var G__20037 = (x_20036 + 1);
x_20036 = G__20037;
continue;
}
} else
{}
break;
}
var i = 1;while(true){
if(cljs.core._EQ_.call(null,i,n))
{return a;
} else
{var j = cljs.core.rand_int.call(null,i);(a[i] = (a[j]));
(a[j] = i);
{
var G__20038 = (i + 1);
i = G__20038;
continue;
}
}
break;
}
});
cljs.core.async.alt_flag = (function alt_flag(){var flag = cljs.core.atom.call(null,true);if(typeof cljs.core.async.t20042 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t20042 = (function (flag,alt_flag,meta20043){
this.flag = flag;
this.alt_flag = alt_flag;
this.meta20043 = meta20043;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t20042.cljs$lang$type = true;
cljs.core.async.t20042.cljs$lang$ctorStr = "cljs.core.async/t20042";
cljs.core.async.t20042.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__9852__auto__,writer__9853__auto__,opt__9854__auto__){return cljs.core._write.call(null,writer__9853__auto__,"cljs.core.async/t20042");
});})(flag))
;
cljs.core.async.t20042.prototype.cljs$core$async$impl$protocols$Handler$ = true;
cljs.core.async.t20042.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){var self__ = this;
var ___$1 = this;return cljs.core.deref.call(null,self__.flag);
});})(flag))
;
cljs.core.async.t20042.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){var self__ = this;
var ___$1 = this;cljs.core.reset_BANG_.call(null,self__.flag,null);
return true;
});})(flag))
;
cljs.core.async.t20042.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_20044){var self__ = this;
var _20044__$1 = this;return self__.meta20043;
});})(flag))
;
cljs.core.async.t20042.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_20044,meta20043__$1){var self__ = this;
var _20044__$1 = this;return (new cljs.core.async.t20042(self__.flag,self__.alt_flag,meta20043__$1));
});})(flag))
;
cljs.core.async.__GT_t20042 = ((function (flag){
return (function __GT_t20042(flag__$1,alt_flag__$1,meta20043){return (new cljs.core.async.t20042(flag__$1,alt_flag__$1,meta20043));
});})(flag))
;
}
return (new cljs.core.async.t20042(flag,alt_flag,null));
});
cljs.core.async.alt_handler = (function alt_handler(flag,cb){if(typeof cljs.core.async.t20048 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t20048 = (function (cb,flag,alt_handler,meta20049){
this.cb = cb;
this.flag = flag;
this.alt_handler = alt_handler;
this.meta20049 = meta20049;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t20048.cljs$lang$type = true;
cljs.core.async.t20048.cljs$lang$ctorStr = "cljs.core.async/t20048";
cljs.core.async.t20048.cljs$lang$ctorPrWriter = (function (this__9852__auto__,writer__9853__auto__,opt__9854__auto__){return cljs.core._write.call(null,writer__9853__auto__,"cljs.core.async/t20048");
});
cljs.core.async.t20048.prototype.cljs$core$async$impl$protocols$Handler$ = true;
cljs.core.async.t20048.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});
cljs.core.async.t20048.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){var self__ = this;
var ___$1 = this;cljs.core.async.impl.protocols.commit.call(null,self__.flag);
return self__.cb;
});
cljs.core.async.t20048.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20050){var self__ = this;
var _20050__$1 = this;return self__.meta20049;
});
cljs.core.async.t20048.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20050,meta20049__$1){var self__ = this;
var _20050__$1 = this;return (new cljs.core.async.t20048(self__.cb,self__.flag,self__.alt_handler,meta20049__$1));
});
cljs.core.async.__GT_t20048 = (function __GT_t20048(cb__$1,flag__$1,alt_handler__$1,meta20049){return (new cljs.core.async.t20048(cb__$1,flag__$1,alt_handler__$1,meta20049));
});
}
return (new cljs.core.async.t20048(cb,flag,alt_handler,null));
});
/**
* returns derefable [val port] if immediate, nil if enqueued
*/
cljs.core.async.do_alts = (function do_alts(fret,ports,opts){var flag = cljs.core.async.alt_flag.call(null);var n = cljs.core.count.call(null,ports);var idxs = cljs.core.async.random_array.call(null,n);var priority = new cljs.core.Keyword(null,"priority","priority",4143410454).cljs$core$IFn$_invoke$arity$1(opts);var ret = (function (){var i = 0;while(true){
if((i < n))
{var idx = (cljs.core.truth_(priority)?i:(idxs[i]));var port = cljs.core.nth.call(null,ports,idx);var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,0):null);var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,1);return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__20051_SHARP_){return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__20051_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__20052_SHARP_){return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__20052_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));if(cljs.core.truth_(vbox))
{return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__9285__auto__ = wport;if(cljs.core.truth_(or__9285__auto__))
{return or__9285__auto__;
} else
{return port;
}
})()], null));
} else
{{
var G__20053 = (i + 1);
i = G__20053;
continue;
}
}
} else
{return null;
}
break;
}
})();var or__9285__auto__ = ret;if(cljs.core.truth_(or__9285__auto__))
{return or__9285__auto__;
} else
{if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",2558708147)))
{var temp__4092__auto__ = (function (){var and__9273__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);if(cljs.core.truth_(and__9273__auto__))
{return cljs.core.async.impl.protocols.commit.call(null,flag);
} else
{return and__9273__auto__;
}
})();if(cljs.core.truth_(temp__4092__auto__))
{var got = temp__4092__auto__;return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",2558708147).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",2558708147)], null));
} else
{return null;
}
} else
{return null;
}
}
});
/**
* Completes at most one of several channel operations. Must be called
* inside a (go ...) block. ports is a vector of channel endpoints,
* which can be either a channel to take from or a vector of
* [channel-to-put-to val-to-put], in any combination. Takes will be
* made as if by <!, and puts will be made as if by >!. Unless
* the :priority option is true, if more than one port operation is
* ready a non-deterministic choice will be made. If no operation is
* ready and a :default value is supplied, [default-val :default] will
* be returned, otherwise alts! will park until the first operation to
* become ready completes. Returns [val port] of the completed
* operation, where val is the value taken for takes, and a
* boolean (true unless already closed, as per put!) for puts.
* 
* opts are passed as :key val ... Supported options:
* 
* :default val - the value to use if none of the operations are immediately ready
* :priority true - (default nil) when true, the operations will be tried in order.
* 
* Note: there is no guarantee that the port exps or val exprs will be
* used, nor in what order should they be, so they should not be
* depended upon for side effects.
* @param {...*} var_args
*/
cljs.core.async.alts_BANG_ = (function() { 
var alts_BANG___delegate = function (ports,p__20054){var map__20056 = p__20054;var map__20056__$1 = ((cljs.core.seq_QMARK_.call(null,map__20056))?cljs.core.apply.call(null,cljs.core.hash_map,map__20056):map__20056);var opts = map__20056__$1;if(null)
{return null;
} else
{throw (new Error(("Assert failed: alts! used not in (go ...) block\n"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,null)))));
}
};
var alts_BANG_ = function (ports,var_args){
var p__20054 = null;if (arguments.length > 1) {
  p__20054 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return alts_BANG___delegate.call(this,ports,p__20054);};
alts_BANG_.cljs$lang$maxFixedArity = 1;
alts_BANG_.cljs$lang$applyTo = (function (arglist__20057){
var ports = cljs.core.first(arglist__20057);
var p__20054 = cljs.core.rest(arglist__20057);
return alts_BANG___delegate(ports,p__20054);
});
alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = alts_BANG___delegate;
return alts_BANG_;
})()
;
/**
* Takes a function and a source channel, and returns a channel which
* contains the values produced by applying f to each value taken from
* the source channel
*/
cljs.core.async.map_LT_ = (function map_LT_(f,ch){if(typeof cljs.core.async.t20065 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t20065 = (function (ch,f,map_LT_,meta20066){
this.ch = ch;
this.f = f;
this.map_LT_ = map_LT_;
this.meta20066 = meta20066;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t20065.cljs$lang$type = true;
cljs.core.async.t20065.cljs$lang$ctorStr = "cljs.core.async/t20065";
cljs.core.async.t20065.cljs$lang$ctorPrWriter = (function (this__9852__auto__,writer__9853__auto__,opt__9854__auto__){return cljs.core._write.call(null,writer__9853__auto__,"cljs.core.async/t20065");
});
cljs.core.async.t20065.prototype.cljs$core$async$impl$protocols$WritePort$ = true;
cljs.core.async.t20065.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});
cljs.core.async.t20065.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;
cljs.core.async.t20065.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){var self__ = this;
var ___$1 = this;var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){if(typeof cljs.core.async.t20068 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t20068 = (function (fn1,_,meta20066,ch,f,map_LT_,meta20069){
this.fn1 = fn1;
this._ = _;
this.meta20066 = meta20066;
this.ch = ch;
this.f = f;
this.map_LT_ = map_LT_;
this.meta20069 = meta20069;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t20068.cljs$lang$type = true;
cljs.core.async.t20068.cljs$lang$ctorStr = "cljs.core.async/t20068";
cljs.core.async.t20068.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__9852__auto__,writer__9853__auto__,opt__9854__auto__){return cljs.core._write.call(null,writer__9853__auto__,"cljs.core.async/t20068");
});})(___$1))
;
cljs.core.async.t20068.prototype.cljs$core$async$impl$protocols$Handler$ = true;
cljs.core.async.t20068.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$3){var self__ = this;
var ___$4 = this;return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;
cljs.core.async.t20068.prototype.cljs$core$async$impl$protocols$Handler$lock_id$arity$1 = ((function (___$1){
return (function (___$3){var self__ = this;
var ___$4 = this;return cljs.core.async.impl.protocols.lock_id.call(null,self__.fn1);
});})(___$1))
;
cljs.core.async.t20068.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$3){var self__ = this;
var ___$4 = this;var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);return ((function (f1,___$4,___$1){
return (function (p1__20058_SHARP_){return f1.call(null,(((p1__20058_SHARP_ == null))?null:self__.f.call(null,p1__20058_SHARP_)));
});
;})(f1,___$4,___$1))
});})(___$1))
;
cljs.core.async.t20068.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_20070){var self__ = this;
var _20070__$1 = this;return self__.meta20069;
});})(___$1))
;
cljs.core.async.t20068.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_20070,meta20069__$1){var self__ = this;
var _20070__$1 = this;return (new cljs.core.async.t20068(self__.fn1,self__._,self__.meta20066,self__.ch,self__.f,self__.map_LT_,meta20069__$1));
});})(___$1))
;
cljs.core.async.__GT_t20068 = ((function (___$1){
return (function __GT_t20068(fn1__$1,___$2,meta20066__$1,ch__$2,f__$2,map_LT___$2,meta20069){return (new cljs.core.async.t20068(fn1__$1,___$2,meta20066__$1,ch__$2,f__$2,map_LT___$2,meta20069));
});})(___$1))
;
}
return (new cljs.core.async.t20068(fn1,___$1,self__.meta20066,self__.ch,self__.f,self__.map_LT_,null));
})());if(cljs.core.truth_((function (){var and__9273__auto__ = ret;if(cljs.core.truth_(and__9273__auto__))
{return !((cljs.core.deref.call(null,ret) == null));
} else
{return and__9273__auto__;
}
})()))
{return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else
{return ret;
}
});
cljs.core.async.t20065.prototype.cljs$core$async$impl$protocols$Channel$ = true;
cljs.core.async.t20065.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});
cljs.core.async.t20065.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});
cljs.core.async.t20065.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20067){var self__ = this;
var _20067__$1 = this;return self__.meta20066;
});
cljs.core.async.t20065.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20067,meta20066__$1){var self__ = this;
var _20067__$1 = this;return (new cljs.core.async.t20065(self__.ch,self__.f,self__.map_LT_,meta20066__$1));
});
cljs.core.async.__GT_t20065 = (function __GT_t20065(ch__$1,f__$1,map_LT___$1,meta20066){return (new cljs.core.async.t20065(ch__$1,f__$1,map_LT___$1,meta20066));
});
}
return (new cljs.core.async.t20065(ch,f,map_LT_,null));
});
/**
* Takes a function and a target channel, and returns a channel which
* applies f to each value before supplying it to the target channel.
*/
cljs.core.async.map_GT_ = (function map_GT_(f,ch){if(typeof cljs.core.async.t20074 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t20074 = (function (ch,f,map_GT_,meta20075){
this.ch = ch;
this.f = f;
this.map_GT_ = map_GT_;
this.meta20075 = meta20075;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t20074.cljs$lang$type = true;
cljs.core.async.t20074.cljs$lang$ctorStr = "cljs.core.async/t20074";
cljs.core.async.t20074.cljs$lang$ctorPrWriter = (function (this__9852__auto__,writer__9853__auto__,opt__9854__auto__){return cljs.core._write.call(null,writer__9853__auto__,"cljs.core.async/t20074");
});
cljs.core.async.t20074.prototype.cljs$core$async$impl$protocols$WritePort$ = true;
cljs.core.async.t20074.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});
cljs.core.async.t20074.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;
cljs.core.async.t20074.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});
cljs.core.async.t20074.prototype.cljs$core$async$impl$protocols$Channel$ = true;
cljs.core.async.t20074.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});
cljs.core.async.t20074.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20076){var self__ = this;
var _20076__$1 = this;return self__.meta20075;
});
cljs.core.async.t20074.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20076,meta20075__$1){var self__ = this;
var _20076__$1 = this;return (new cljs.core.async.t20074(self__.ch,self__.f,self__.map_GT_,meta20075__$1));
});
cljs.core.async.__GT_t20074 = (function __GT_t20074(ch__$1,f__$1,map_GT___$1,meta20075){return (new cljs.core.async.t20074(ch__$1,f__$1,map_GT___$1,meta20075));
});
}
return (new cljs.core.async.t20074(ch,f,map_GT_,null));
});
/**
* Takes a predicate and a target channel, and returns a channel which
* supplies only the values for which the predicate returns true to the
* target channel.
*/
cljs.core.async.filter_GT_ = (function filter_GT_(p,ch){if(typeof cljs.core.async.t20080 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t20080 = (function (ch,p,filter_GT_,meta20081){
this.ch = ch;
this.p = p;
this.filter_GT_ = filter_GT_;
this.meta20081 = meta20081;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t20080.cljs$lang$type = true;
cljs.core.async.t20080.cljs$lang$ctorStr = "cljs.core.async/t20080";
cljs.core.async.t20080.cljs$lang$ctorPrWriter = (function (this__9852__auto__,writer__9853__auto__,opt__9854__auto__){return cljs.core._write.call(null,writer__9853__auto__,"cljs.core.async/t20080");
});
cljs.core.async.t20080.prototype.cljs$core$async$impl$protocols$WritePort$ = true;
cljs.core.async.t20080.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){var self__ = this;
var ___$1 = this;if(cljs.core.truth_(self__.p.call(null,val)))
{return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else
{return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});
cljs.core.async.t20080.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;
cljs.core.async.t20080.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});
cljs.core.async.t20080.prototype.cljs$core$async$impl$protocols$Channel$ = true;
cljs.core.async.t20080.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});
cljs.core.async.t20080.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});
cljs.core.async.t20080.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20082){var self__ = this;
var _20082__$1 = this;return self__.meta20081;
});
cljs.core.async.t20080.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20082,meta20081__$1){var self__ = this;
var _20082__$1 = this;return (new cljs.core.async.t20080(self__.ch,self__.p,self__.filter_GT_,meta20081__$1));
});
cljs.core.async.__GT_t20080 = (function __GT_t20080(ch__$1,p__$1,filter_GT___$1,meta20081){return (new cljs.core.async.t20080(ch__$1,p__$1,filter_GT___$1,meta20081));
});
}
return (new cljs.core.async.t20080(ch,p,filter_GT_,null));
});
/**
* Takes a predicate and a target channel, and returns a channel which
* supplies only the values for which the predicate returns false to the
* target channel.
*/
cljs.core.async.remove_GT_ = (function remove_GT_(p,ch){return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
* Takes a predicate and a source channel, and returns a channel which
* contains only the values taken from the source channel for which the
* predicate returns true. The returned channel will be unbuffered by
* default, or a buf-or-n can be supplied. The channel will close
* when the source channel closes.
*/
cljs.core.async.filter_LT_ = (function() {
var filter_LT_ = null;
var filter_LT___2 = (function (p,ch){return filter_LT_.call(null,p,ch,null);
});
var filter_LT___3 = (function (p,ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__11722__auto___20165 = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,((function (c__11722__auto___20165,out){
return (function (){var f__11723__auto__ = (function (){var switch__11651__auto__ = ((function (c__11722__auto___20165,out){
return (function (state_20144){var state_val_20145 = (state_20144[1]);if((state_val_20145 === 1))
{var state_20144__$1 = state_20144;var statearr_20146_20166 = state_20144__$1;(statearr_20146_20166[2] = null);
(statearr_20146_20166[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20145 === 2))
{var state_20144__$1 = state_20144;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20144__$1,4,ch);
} else
{if((state_val_20145 === 3))
{var inst_20142 = (state_20144[2]);var state_20144__$1 = state_20144;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20144__$1,inst_20142);
} else
{if((state_val_20145 === 4))
{var inst_20126 = (state_20144[7]);var inst_20126__$1 = (state_20144[2]);var inst_20127 = (inst_20126__$1 == null);var state_20144__$1 = (function (){var statearr_20147 = state_20144;(statearr_20147[7] = inst_20126__$1);
return statearr_20147;
})();if(cljs.core.truth_(inst_20127))
{var statearr_20148_20167 = state_20144__$1;(statearr_20148_20167[1] = 5);
} else
{var statearr_20149_20168 = state_20144__$1;(statearr_20149_20168[1] = 6);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20145 === 5))
{var inst_20129 = cljs.core.async.close_BANG_.call(null,out);var state_20144__$1 = state_20144;var statearr_20150_20169 = state_20144__$1;(statearr_20150_20169[2] = inst_20129);
(statearr_20150_20169[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20145 === 6))
{var inst_20126 = (state_20144[7]);var inst_20131 = p.call(null,inst_20126);var state_20144__$1 = state_20144;if(cljs.core.truth_(inst_20131))
{var statearr_20151_20170 = state_20144__$1;(statearr_20151_20170[1] = 8);
} else
{var statearr_20152_20171 = state_20144__$1;(statearr_20152_20171[1] = 9);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20145 === 7))
{var inst_20140 = (state_20144[2]);var state_20144__$1 = state_20144;var statearr_20153_20172 = state_20144__$1;(statearr_20153_20172[2] = inst_20140);
(statearr_20153_20172[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20145 === 8))
{var inst_20126 = (state_20144[7]);var state_20144__$1 = state_20144;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20144__$1,11,out,inst_20126);
} else
{if((state_val_20145 === 9))
{var state_20144__$1 = state_20144;var statearr_20154_20173 = state_20144__$1;(statearr_20154_20173[2] = null);
(statearr_20154_20173[1] = 10);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20145 === 10))
{var inst_20137 = (state_20144[2]);var state_20144__$1 = (function (){var statearr_20155 = state_20144;(statearr_20155[8] = inst_20137);
return statearr_20155;
})();var statearr_20156_20174 = state_20144__$1;(statearr_20156_20174[2] = null);
(statearr_20156_20174[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20145 === 11))
{var inst_20134 = (state_20144[2]);var state_20144__$1 = state_20144;var statearr_20157_20175 = state_20144__$1;(statearr_20157_20175[2] = inst_20134);
(statearr_20157_20175[1] = 10);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11722__auto___20165,out))
;return ((function (switch__11651__auto__,c__11722__auto___20165,out){
return (function() {
var state_machine__11652__auto__ = null;
var state_machine__11652__auto____0 = (function (){var statearr_20161 = [null,null,null,null,null,null,null,null,null];(statearr_20161[0] = state_machine__11652__auto__);
(statearr_20161[1] = 1);
return statearr_20161;
});
var state_machine__11652__auto____1 = (function (state_20144){while(true){
var ret_value__11653__auto__ = (function (){try{while(true){
var result__11654__auto__ = switch__11651__auto__.call(null,state_20144);if(cljs.core.keyword_identical_QMARK_.call(null,result__11654__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__11654__auto__;
}
break;
}
}catch (e20162){if((e20162 instanceof Object))
{var ex__11655__auto__ = e20162;var statearr_20163_20176 = state_20144;(statearr_20163_20176[5] = ex__11655__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20144);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e20162;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11653__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__20177 = state_20144;
state_20144 = G__20177;
continue;
}
} else
{return ret_value__11653__auto__;
}
break;
}
});
state_machine__11652__auto__ = function(state_20144){
switch(arguments.length){
case 0:
return state_machine__11652__auto____0.call(this);
case 1:
return state_machine__11652__auto____1.call(this,state_20144);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11652__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11652__auto____0;
state_machine__11652__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11652__auto____1;
return state_machine__11652__auto__;
})()
;})(switch__11651__auto__,c__11722__auto___20165,out))
})();var state__11724__auto__ = (function (){var statearr_20164 = f__11723__auto__.call(null);(statearr_20164[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11722__auto___20165);
return statearr_20164;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11724__auto__);
});})(c__11722__auto___20165,out))
);
return out;
});
filter_LT_ = function(p,ch,buf_or_n){
switch(arguments.length){
case 2:
return filter_LT___2.call(this,p,ch);
case 3:
return filter_LT___3.call(this,p,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
filter_LT_.cljs$core$IFn$_invoke$arity$2 = filter_LT___2;
filter_LT_.cljs$core$IFn$_invoke$arity$3 = filter_LT___3;
return filter_LT_;
})()
;
/**
* Takes a predicate and a source channel, and returns a channel which
* contains only the values taken from the source channel for which the
* predicate returns false. The returned channel will be unbuffered by
* default, or a buf-or-n can be supplied. The channel will close
* when the source channel closes.
*/
cljs.core.async.remove_LT_ = (function() {
var remove_LT_ = null;
var remove_LT___2 = (function (p,ch){return remove_LT_.call(null,p,ch,null);
});
var remove_LT___3 = (function (p,ch,buf_or_n){return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});
remove_LT_ = function(p,ch,buf_or_n){
switch(arguments.length){
case 2:
return remove_LT___2.call(this,p,ch);
case 3:
return remove_LT___3.call(this,p,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
remove_LT_.cljs$core$IFn$_invoke$arity$2 = remove_LT___2;
remove_LT_.cljs$core$IFn$_invoke$arity$3 = remove_LT___3;
return remove_LT_;
})()
;
cljs.core.async.mapcat_STAR_ = (function mapcat_STAR_(f,in$,out){var c__11722__auto__ = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,((function (c__11722__auto__){
return (function (){var f__11723__auto__ = (function (){var switch__11651__auto__ = ((function (c__11722__auto__){
return (function (state_20343){var state_val_20344 = (state_20343[1]);if((state_val_20344 === 1))
{var state_20343__$1 = state_20343;var statearr_20345_20386 = state_20343__$1;(statearr_20345_20386[2] = null);
(statearr_20345_20386[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20344 === 2))
{var state_20343__$1 = state_20343;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20343__$1,4,in$);
} else
{if((state_val_20344 === 3))
{var inst_20341 = (state_20343[2]);var state_20343__$1 = state_20343;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20343__$1,inst_20341);
} else
{if((state_val_20344 === 4))
{var inst_20284 = (state_20343[7]);var inst_20284__$1 = (state_20343[2]);var inst_20285 = (inst_20284__$1 == null);var state_20343__$1 = (function (){var statearr_20346 = state_20343;(statearr_20346[7] = inst_20284__$1);
return statearr_20346;
})();if(cljs.core.truth_(inst_20285))
{var statearr_20347_20387 = state_20343__$1;(statearr_20347_20387[1] = 5);
} else
{var statearr_20348_20388 = state_20343__$1;(statearr_20348_20388[1] = 6);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20344 === 5))
{var inst_20287 = cljs.core.async.close_BANG_.call(null,out);var state_20343__$1 = state_20343;var statearr_20349_20389 = state_20343__$1;(statearr_20349_20389[2] = inst_20287);
(statearr_20349_20389[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20344 === 6))
{var inst_20284 = (state_20343[7]);var inst_20293 = f.call(null,inst_20284);var inst_20294 = cljs.core.seq.call(null,inst_20293);var inst_20295 = inst_20294;var inst_20296 = null;var inst_20297 = 0;var inst_20298 = 0;var state_20343__$1 = (function (){var statearr_20350 = state_20343;(statearr_20350[8] = inst_20298);
(statearr_20350[9] = inst_20297);
(statearr_20350[10] = inst_20296);
(statearr_20350[11] = inst_20295);
return statearr_20350;
})();var statearr_20351_20390 = state_20343__$1;(statearr_20351_20390[2] = null);
(statearr_20351_20390[1] = 8);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20344 === 7))
{var inst_20339 = (state_20343[2]);var state_20343__$1 = state_20343;var statearr_20352_20391 = state_20343__$1;(statearr_20352_20391[2] = inst_20339);
(statearr_20352_20391[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20344 === 8))
{var inst_20298 = (state_20343[8]);var inst_20297 = (state_20343[9]);var inst_20300 = (inst_20298 < inst_20297);var inst_20301 = inst_20300;var state_20343__$1 = state_20343;if(cljs.core.truth_(inst_20301))
{var statearr_20353_20392 = state_20343__$1;(statearr_20353_20392[1] = 10);
} else
{var statearr_20354_20393 = state_20343__$1;(statearr_20354_20393[1] = 11);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20344 === 9))
{var inst_20331 = (state_20343[2]);var inst_20332 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);var state_20343__$1 = (function (){var statearr_20355 = state_20343;(statearr_20355[12] = inst_20331);
return statearr_20355;
})();if(cljs.core.truth_(inst_20332))
{var statearr_20356_20394 = state_20343__$1;(statearr_20356_20394[1] = 21);
} else
{var statearr_20357_20395 = state_20343__$1;(statearr_20357_20395[1] = 22);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20344 === 10))
{var inst_20298 = (state_20343[8]);var inst_20296 = (state_20343[10]);var inst_20303 = cljs.core._nth.call(null,inst_20296,inst_20298);var state_20343__$1 = state_20343;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20343__$1,13,out,inst_20303);
} else
{if((state_val_20344 === 11))
{var inst_20295 = (state_20343[11]);var inst_20309 = (state_20343[13]);var inst_20309__$1 = cljs.core.seq.call(null,inst_20295);var state_20343__$1 = (function (){var statearr_20361 = state_20343;(statearr_20361[13] = inst_20309__$1);
return statearr_20361;
})();if(inst_20309__$1)
{var statearr_20362_20396 = state_20343__$1;(statearr_20362_20396[1] = 14);
} else
{var statearr_20363_20397 = state_20343__$1;(statearr_20363_20397[1] = 15);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20344 === 12))
{var inst_20329 = (state_20343[2]);var state_20343__$1 = state_20343;var statearr_20364_20398 = state_20343__$1;(statearr_20364_20398[2] = inst_20329);
(statearr_20364_20398[1] = 9);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20344 === 13))
{var inst_20298 = (state_20343[8]);var inst_20297 = (state_20343[9]);var inst_20296 = (state_20343[10]);var inst_20295 = (state_20343[11]);var inst_20305 = (state_20343[2]);var inst_20306 = (inst_20298 + 1);var tmp20358 = inst_20297;var tmp20359 = inst_20296;var tmp20360 = inst_20295;var inst_20295__$1 = tmp20360;var inst_20296__$1 = tmp20359;var inst_20297__$1 = tmp20358;var inst_20298__$1 = inst_20306;var state_20343__$1 = (function (){var statearr_20365 = state_20343;(statearr_20365[8] = inst_20298__$1);
(statearr_20365[9] = inst_20297__$1);
(statearr_20365[10] = inst_20296__$1);
(statearr_20365[14] = inst_20305);
(statearr_20365[11] = inst_20295__$1);
return statearr_20365;
})();var statearr_20366_20399 = state_20343__$1;(statearr_20366_20399[2] = null);
(statearr_20366_20399[1] = 8);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20344 === 14))
{var inst_20309 = (state_20343[13]);var inst_20311 = cljs.core.chunked_seq_QMARK_.call(null,inst_20309);var state_20343__$1 = state_20343;if(inst_20311)
{var statearr_20367_20400 = state_20343__$1;(statearr_20367_20400[1] = 17);
} else
{var statearr_20368_20401 = state_20343__$1;(statearr_20368_20401[1] = 18);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20344 === 15))
{var state_20343__$1 = state_20343;var statearr_20369_20402 = state_20343__$1;(statearr_20369_20402[2] = null);
(statearr_20369_20402[1] = 16);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20344 === 16))
{var inst_20327 = (state_20343[2]);var state_20343__$1 = state_20343;var statearr_20370_20403 = state_20343__$1;(statearr_20370_20403[2] = inst_20327);
(statearr_20370_20403[1] = 12);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20344 === 17))
{var inst_20309 = (state_20343[13]);var inst_20313 = cljs.core.chunk_first.call(null,inst_20309);var inst_20314 = cljs.core.chunk_rest.call(null,inst_20309);var inst_20315 = cljs.core.count.call(null,inst_20313);var inst_20295 = inst_20314;var inst_20296 = inst_20313;var inst_20297 = inst_20315;var inst_20298 = 0;var state_20343__$1 = (function (){var statearr_20371 = state_20343;(statearr_20371[8] = inst_20298);
(statearr_20371[9] = inst_20297);
(statearr_20371[10] = inst_20296);
(statearr_20371[11] = inst_20295);
return statearr_20371;
})();var statearr_20372_20404 = state_20343__$1;(statearr_20372_20404[2] = null);
(statearr_20372_20404[1] = 8);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20344 === 18))
{var inst_20309 = (state_20343[13]);var inst_20318 = cljs.core.first.call(null,inst_20309);var state_20343__$1 = state_20343;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20343__$1,20,out,inst_20318);
} else
{if((state_val_20344 === 19))
{var inst_20324 = (state_20343[2]);var state_20343__$1 = state_20343;var statearr_20373_20405 = state_20343__$1;(statearr_20373_20405[2] = inst_20324);
(statearr_20373_20405[1] = 16);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20344 === 20))
{var inst_20309 = (state_20343[13]);var inst_20320 = (state_20343[2]);var inst_20321 = cljs.core.next.call(null,inst_20309);var inst_20295 = inst_20321;var inst_20296 = null;var inst_20297 = 0;var inst_20298 = 0;var state_20343__$1 = (function (){var statearr_20374 = state_20343;(statearr_20374[8] = inst_20298);
(statearr_20374[9] = inst_20297);
(statearr_20374[10] = inst_20296);
(statearr_20374[11] = inst_20295);
(statearr_20374[15] = inst_20320);
return statearr_20374;
})();var statearr_20375_20406 = state_20343__$1;(statearr_20375_20406[2] = null);
(statearr_20375_20406[1] = 8);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20344 === 21))
{var state_20343__$1 = state_20343;var statearr_20376_20407 = state_20343__$1;(statearr_20376_20407[2] = null);
(statearr_20376_20407[1] = 23);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20344 === 22))
{var state_20343__$1 = state_20343;var statearr_20377_20408 = state_20343__$1;(statearr_20377_20408[2] = null);
(statearr_20377_20408[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20344 === 23))
{var inst_20337 = (state_20343[2]);var state_20343__$1 = state_20343;var statearr_20378_20409 = state_20343__$1;(statearr_20378_20409[2] = inst_20337);
(statearr_20378_20409[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11722__auto__))
;return ((function (switch__11651__auto__,c__11722__auto__){
return (function() {
var state_machine__11652__auto__ = null;
var state_machine__11652__auto____0 = (function (){var statearr_20382 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_20382[0] = state_machine__11652__auto__);
(statearr_20382[1] = 1);
return statearr_20382;
});
var state_machine__11652__auto____1 = (function (state_20343){while(true){
var ret_value__11653__auto__ = (function (){try{while(true){
var result__11654__auto__ = switch__11651__auto__.call(null,state_20343);if(cljs.core.keyword_identical_QMARK_.call(null,result__11654__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__11654__auto__;
}
break;
}
}catch (e20383){if((e20383 instanceof Object))
{var ex__11655__auto__ = e20383;var statearr_20384_20410 = state_20343;(statearr_20384_20410[5] = ex__11655__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20343);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e20383;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11653__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__20411 = state_20343;
state_20343 = G__20411;
continue;
}
} else
{return ret_value__11653__auto__;
}
break;
}
});
state_machine__11652__auto__ = function(state_20343){
switch(arguments.length){
case 0:
return state_machine__11652__auto____0.call(this);
case 1:
return state_machine__11652__auto____1.call(this,state_20343);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11652__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11652__auto____0;
state_machine__11652__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11652__auto____1;
return state_machine__11652__auto__;
})()
;})(switch__11651__auto__,c__11722__auto__))
})();var state__11724__auto__ = (function (){var statearr_20385 = f__11723__auto__.call(null);(statearr_20385[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11722__auto__);
return statearr_20385;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11724__auto__);
});})(c__11722__auto__))
);
return c__11722__auto__;
});
/**
* Takes a function and a source channel, and returns a channel which
* contains the values in each collection produced by applying f to
* each value taken from the source channel. f must return a
* collection.
* 
* The returned channel will be unbuffered by default, or a buf-or-n
* can be supplied. The channel will close when the source channel
* closes.
*/
cljs.core.async.mapcat_LT_ = (function() {
var mapcat_LT_ = null;
var mapcat_LT___2 = (function (f,in$){return mapcat_LT_.call(null,f,in$,null);
});
var mapcat_LT___3 = (function (f,in$,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);cljs.core.async.mapcat_STAR_.call(null,f,in$,out);
return out;
});
mapcat_LT_ = function(f,in$,buf_or_n){
switch(arguments.length){
case 2:
return mapcat_LT___2.call(this,f,in$);
case 3:
return mapcat_LT___3.call(this,f,in$,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = mapcat_LT___2;
mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = mapcat_LT___3;
return mapcat_LT_;
})()
;
/**
* Takes a function and a target channel, and returns a channel which
* applies f to each value put, then supplies each element of the result
* to the target channel. f must return a collection.
* 
* The returned channel will be unbuffered by default, or a buf-or-n
* can be supplied. The target channel will be closed when the source
* channel closes.
*/
cljs.core.async.mapcat_GT_ = (function() {
var mapcat_GT_ = null;
var mapcat_GT___2 = (function (f,out){return mapcat_GT_.call(null,f,out,null);
});
var mapcat_GT___3 = (function (f,out,buf_or_n){var in$ = cljs.core.async.chan.call(null,buf_or_n);cljs.core.async.mapcat_STAR_.call(null,f,in$,out);
return in$;
});
mapcat_GT_ = function(f,out,buf_or_n){
switch(arguments.length){
case 2:
return mapcat_GT___2.call(this,f,out);
case 3:
return mapcat_GT___3.call(this,f,out,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = mapcat_GT___2;
mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = mapcat_GT___3;
return mapcat_GT_;
})()
;
/**
* Takes elements from the from channel and supplies them to the to
* channel. By default, the to channel will be closed when the from
* channel closes, but can be determined by the close?  parameter. Will
* stop consuming the from channel if the to channel closes
*/
cljs.core.async.pipe = (function() {
var pipe = null;
var pipe__2 = (function (from,to){return pipe.call(null,from,to,true);
});
var pipe__3 = (function (from,to,close_QMARK_){var c__11722__auto___20506 = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,((function (c__11722__auto___20506){
return (function (){var f__11723__auto__ = (function (){var switch__11651__auto__ = ((function (c__11722__auto___20506){
return (function (state_20482){var state_val_20483 = (state_20482[1]);if((state_val_20483 === 1))
{var state_20482__$1 = state_20482;var statearr_20484_20507 = state_20482__$1;(statearr_20484_20507[2] = null);
(statearr_20484_20507[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20483 === 2))
{var state_20482__$1 = state_20482;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20482__$1,4,from);
} else
{if((state_val_20483 === 3))
{var inst_20480 = (state_20482[2]);var state_20482__$1 = state_20482;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20482__$1,inst_20480);
} else
{if((state_val_20483 === 4))
{var inst_20461 = (state_20482[7]);var inst_20461__$1 = (state_20482[2]);var inst_20462 = (inst_20461__$1 == null);var state_20482__$1 = (function (){var statearr_20485 = state_20482;(statearr_20485[7] = inst_20461__$1);
return statearr_20485;
})();if(cljs.core.truth_(inst_20462))
{var statearr_20486_20508 = state_20482__$1;(statearr_20486_20508[1] = 5);
} else
{var statearr_20487_20509 = state_20482__$1;(statearr_20487_20509[1] = 6);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20483 === 5))
{var state_20482__$1 = state_20482;if(cljs.core.truth_(close_QMARK_))
{var statearr_20488_20510 = state_20482__$1;(statearr_20488_20510[1] = 8);
} else
{var statearr_20489_20511 = state_20482__$1;(statearr_20489_20511[1] = 9);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20483 === 6))
{var inst_20461 = (state_20482[7]);var state_20482__$1 = state_20482;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20482__$1,11,to,inst_20461);
} else
{if((state_val_20483 === 7))
{var inst_20478 = (state_20482[2]);var state_20482__$1 = state_20482;var statearr_20490_20512 = state_20482__$1;(statearr_20490_20512[2] = inst_20478);
(statearr_20490_20512[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20483 === 8))
{var inst_20465 = cljs.core.async.close_BANG_.call(null,to);var state_20482__$1 = state_20482;var statearr_20491_20513 = state_20482__$1;(statearr_20491_20513[2] = inst_20465);
(statearr_20491_20513[1] = 10);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20483 === 9))
{var state_20482__$1 = state_20482;var statearr_20492_20514 = state_20482__$1;(statearr_20492_20514[2] = null);
(statearr_20492_20514[1] = 10);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20483 === 10))
{var inst_20468 = (state_20482[2]);var state_20482__$1 = state_20482;var statearr_20493_20515 = state_20482__$1;(statearr_20493_20515[2] = inst_20468);
(statearr_20493_20515[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20483 === 11))
{var inst_20471 = (state_20482[2]);var state_20482__$1 = state_20482;if(cljs.core.truth_(inst_20471))
{var statearr_20494_20516 = state_20482__$1;(statearr_20494_20516[1] = 12);
} else
{var statearr_20495_20517 = state_20482__$1;(statearr_20495_20517[1] = 13);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20483 === 12))
{var state_20482__$1 = state_20482;var statearr_20496_20518 = state_20482__$1;(statearr_20496_20518[2] = null);
(statearr_20496_20518[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20483 === 13))
{var state_20482__$1 = state_20482;var statearr_20497_20519 = state_20482__$1;(statearr_20497_20519[2] = null);
(statearr_20497_20519[1] = 14);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20483 === 14))
{var inst_20476 = (state_20482[2]);var state_20482__$1 = state_20482;var statearr_20498_20520 = state_20482__$1;(statearr_20498_20520[2] = inst_20476);
(statearr_20498_20520[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11722__auto___20506))
;return ((function (switch__11651__auto__,c__11722__auto___20506){
return (function() {
var state_machine__11652__auto__ = null;
var state_machine__11652__auto____0 = (function (){var statearr_20502 = [null,null,null,null,null,null,null,null];(statearr_20502[0] = state_machine__11652__auto__);
(statearr_20502[1] = 1);
return statearr_20502;
});
var state_machine__11652__auto____1 = (function (state_20482){while(true){
var ret_value__11653__auto__ = (function (){try{while(true){
var result__11654__auto__ = switch__11651__auto__.call(null,state_20482);if(cljs.core.keyword_identical_QMARK_.call(null,result__11654__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__11654__auto__;
}
break;
}
}catch (e20503){if((e20503 instanceof Object))
{var ex__11655__auto__ = e20503;var statearr_20504_20521 = state_20482;(statearr_20504_20521[5] = ex__11655__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20482);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e20503;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11653__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__20522 = state_20482;
state_20482 = G__20522;
continue;
}
} else
{return ret_value__11653__auto__;
}
break;
}
});
state_machine__11652__auto__ = function(state_20482){
switch(arguments.length){
case 0:
return state_machine__11652__auto____0.call(this);
case 1:
return state_machine__11652__auto____1.call(this,state_20482);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11652__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11652__auto____0;
state_machine__11652__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11652__auto____1;
return state_machine__11652__auto__;
})()
;})(switch__11651__auto__,c__11722__auto___20506))
})();var state__11724__auto__ = (function (){var statearr_20505 = f__11723__auto__.call(null);(statearr_20505[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11722__auto___20506);
return statearr_20505;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11724__auto__);
});})(c__11722__auto___20506))
);
return to;
});
pipe = function(from,to,close_QMARK_){
switch(arguments.length){
case 2:
return pipe__2.call(this,from,to);
case 3:
return pipe__3.call(this,from,to,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pipe.cljs$core$IFn$_invoke$arity$2 = pipe__2;
pipe.cljs$core$IFn$_invoke$arity$3 = pipe__3;
return pipe;
})()
;
/**
* Takes a predicate and a source channel and returns a vector of two
* channels, the first of which will contain the values for which the
* predicate returned true, the second those for which it returned
* false.
* 
* The out channels will be unbuffered by default, or two buf-or-ns can
* be supplied. The channels will close after the source channel has
* closed.
*/
cljs.core.async.split = (function() {
var split = null;
var split__2 = (function (p,ch){return split.call(null,p,ch,null,null);
});
var split__4 = (function (p,ch,t_buf_or_n,f_buf_or_n){var tc = cljs.core.async.chan.call(null,t_buf_or_n);var fc = cljs.core.async.chan.call(null,f_buf_or_n);var c__11722__auto___20623 = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,((function (c__11722__auto___20623,tc,fc){
return (function (){var f__11723__auto__ = (function (){var switch__11651__auto__ = ((function (c__11722__auto___20623,tc,fc){
return (function (state_20598){var state_val_20599 = (state_20598[1]);if((state_val_20599 === 1))
{var state_20598__$1 = state_20598;var statearr_20600_20624 = state_20598__$1;(statearr_20600_20624[2] = null);
(statearr_20600_20624[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20599 === 2))
{var state_20598__$1 = state_20598;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20598__$1,4,ch);
} else
{if((state_val_20599 === 3))
{var inst_20596 = (state_20598[2]);var state_20598__$1 = state_20598;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20598__$1,inst_20596);
} else
{if((state_val_20599 === 4))
{var inst_20575 = (state_20598[7]);var inst_20575__$1 = (state_20598[2]);var inst_20576 = (inst_20575__$1 == null);var state_20598__$1 = (function (){var statearr_20601 = state_20598;(statearr_20601[7] = inst_20575__$1);
return statearr_20601;
})();if(cljs.core.truth_(inst_20576))
{var statearr_20602_20625 = state_20598__$1;(statearr_20602_20625[1] = 5);
} else
{var statearr_20603_20626 = state_20598__$1;(statearr_20603_20626[1] = 6);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20599 === 5))
{var inst_20578 = cljs.core.async.close_BANG_.call(null,tc);var inst_20579 = cljs.core.async.close_BANG_.call(null,fc);var state_20598__$1 = (function (){var statearr_20604 = state_20598;(statearr_20604[8] = inst_20578);
return statearr_20604;
})();var statearr_20605_20627 = state_20598__$1;(statearr_20605_20627[2] = inst_20579);
(statearr_20605_20627[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20599 === 6))
{var inst_20575 = (state_20598[7]);var inst_20581 = p.call(null,inst_20575);var state_20598__$1 = state_20598;if(cljs.core.truth_(inst_20581))
{var statearr_20606_20628 = state_20598__$1;(statearr_20606_20628[1] = 9);
} else
{var statearr_20607_20629 = state_20598__$1;(statearr_20607_20629[1] = 10);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20599 === 7))
{var inst_20594 = (state_20598[2]);var state_20598__$1 = state_20598;var statearr_20608_20630 = state_20598__$1;(statearr_20608_20630[2] = inst_20594);
(statearr_20608_20630[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20599 === 8))
{var inst_20587 = (state_20598[2]);var state_20598__$1 = state_20598;if(cljs.core.truth_(inst_20587))
{var statearr_20609_20631 = state_20598__$1;(statearr_20609_20631[1] = 12);
} else
{var statearr_20610_20632 = state_20598__$1;(statearr_20610_20632[1] = 13);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20599 === 9))
{var state_20598__$1 = state_20598;var statearr_20611_20633 = state_20598__$1;(statearr_20611_20633[2] = tc);
(statearr_20611_20633[1] = 11);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20599 === 10))
{var state_20598__$1 = state_20598;var statearr_20612_20634 = state_20598__$1;(statearr_20612_20634[2] = fc);
(statearr_20612_20634[1] = 11);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20599 === 11))
{var inst_20575 = (state_20598[7]);var inst_20585 = (state_20598[2]);var state_20598__$1 = state_20598;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20598__$1,8,inst_20585,inst_20575);
} else
{if((state_val_20599 === 12))
{var state_20598__$1 = state_20598;var statearr_20613_20635 = state_20598__$1;(statearr_20613_20635[2] = null);
(statearr_20613_20635[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20599 === 13))
{var state_20598__$1 = state_20598;var statearr_20614_20636 = state_20598__$1;(statearr_20614_20636[2] = null);
(statearr_20614_20636[1] = 14);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20599 === 14))
{var inst_20592 = (state_20598[2]);var state_20598__$1 = state_20598;var statearr_20615_20637 = state_20598__$1;(statearr_20615_20637[2] = inst_20592);
(statearr_20615_20637[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11722__auto___20623,tc,fc))
;return ((function (switch__11651__auto__,c__11722__auto___20623,tc,fc){
return (function() {
var state_machine__11652__auto__ = null;
var state_machine__11652__auto____0 = (function (){var statearr_20619 = [null,null,null,null,null,null,null,null,null];(statearr_20619[0] = state_machine__11652__auto__);
(statearr_20619[1] = 1);
return statearr_20619;
});
var state_machine__11652__auto____1 = (function (state_20598){while(true){
var ret_value__11653__auto__ = (function (){try{while(true){
var result__11654__auto__ = switch__11651__auto__.call(null,state_20598);if(cljs.core.keyword_identical_QMARK_.call(null,result__11654__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__11654__auto__;
}
break;
}
}catch (e20620){if((e20620 instanceof Object))
{var ex__11655__auto__ = e20620;var statearr_20621_20638 = state_20598;(statearr_20621_20638[5] = ex__11655__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20598);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e20620;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11653__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__20639 = state_20598;
state_20598 = G__20639;
continue;
}
} else
{return ret_value__11653__auto__;
}
break;
}
});
state_machine__11652__auto__ = function(state_20598){
switch(arguments.length){
case 0:
return state_machine__11652__auto____0.call(this);
case 1:
return state_machine__11652__auto____1.call(this,state_20598);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11652__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11652__auto____0;
state_machine__11652__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11652__auto____1;
return state_machine__11652__auto__;
})()
;})(switch__11651__auto__,c__11722__auto___20623,tc,fc))
})();var state__11724__auto__ = (function (){var statearr_20622 = f__11723__auto__.call(null);(statearr_20622[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11722__auto___20623);
return statearr_20622;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11724__auto__);
});})(c__11722__auto___20623,tc,fc))
);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});
split = function(p,ch,t_buf_or_n,f_buf_or_n){
switch(arguments.length){
case 2:
return split__2.call(this,p,ch);
case 4:
return split__4.call(this,p,ch,t_buf_or_n,f_buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
split.cljs$core$IFn$_invoke$arity$2 = split__2;
split.cljs$core$IFn$_invoke$arity$4 = split__4;
return split;
})()
;
/**
* f should be a function of 2 arguments. Returns a channel containing
* the single result of applying f to init and the first item from the
* channel, then applying f to that result and the 2nd item, etc. If
* the channel closes without yielding items, returns init and f is not
* called. ch must close before reduce produces a result.
*/
cljs.core.async.reduce = (function reduce(f,init,ch){var c__11722__auto__ = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,((function (c__11722__auto__){
return (function (){var f__11723__auto__ = (function (){var switch__11651__auto__ = ((function (c__11722__auto__){
return (function (state_20686){var state_val_20687 = (state_20686[1]);if((state_val_20687 === 7))
{var inst_20682 = (state_20686[2]);var state_20686__$1 = state_20686;var statearr_20688_20704 = state_20686__$1;(statearr_20688_20704[2] = inst_20682);
(statearr_20688_20704[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20687 === 6))
{var inst_20675 = (state_20686[7]);var inst_20672 = (state_20686[8]);var inst_20679 = f.call(null,inst_20672,inst_20675);var inst_20672__$1 = inst_20679;var state_20686__$1 = (function (){var statearr_20689 = state_20686;(statearr_20689[8] = inst_20672__$1);
return statearr_20689;
})();var statearr_20690_20705 = state_20686__$1;(statearr_20690_20705[2] = null);
(statearr_20690_20705[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20687 === 5))
{var inst_20672 = (state_20686[8]);var state_20686__$1 = state_20686;var statearr_20691_20706 = state_20686__$1;(statearr_20691_20706[2] = inst_20672);
(statearr_20691_20706[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20687 === 4))
{var inst_20675 = (state_20686[7]);var inst_20675__$1 = (state_20686[2]);var inst_20676 = (inst_20675__$1 == null);var state_20686__$1 = (function (){var statearr_20692 = state_20686;(statearr_20692[7] = inst_20675__$1);
return statearr_20692;
})();if(cljs.core.truth_(inst_20676))
{var statearr_20693_20707 = state_20686__$1;(statearr_20693_20707[1] = 5);
} else
{var statearr_20694_20708 = state_20686__$1;(statearr_20694_20708[1] = 6);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20687 === 3))
{var inst_20684 = (state_20686[2]);var state_20686__$1 = state_20686;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20686__$1,inst_20684);
} else
{if((state_val_20687 === 2))
{var state_20686__$1 = state_20686;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20686__$1,4,ch);
} else
{if((state_val_20687 === 1))
{var inst_20672 = init;var state_20686__$1 = (function (){var statearr_20695 = state_20686;(statearr_20695[8] = inst_20672);
return statearr_20695;
})();var statearr_20696_20709 = state_20686__$1;(statearr_20696_20709[2] = null);
(statearr_20696_20709[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
});})(c__11722__auto__))
;return ((function (switch__11651__auto__,c__11722__auto__){
return (function() {
var state_machine__11652__auto__ = null;
var state_machine__11652__auto____0 = (function (){var statearr_20700 = [null,null,null,null,null,null,null,null,null];(statearr_20700[0] = state_machine__11652__auto__);
(statearr_20700[1] = 1);
return statearr_20700;
});
var state_machine__11652__auto____1 = (function (state_20686){while(true){
var ret_value__11653__auto__ = (function (){try{while(true){
var result__11654__auto__ = switch__11651__auto__.call(null,state_20686);if(cljs.core.keyword_identical_QMARK_.call(null,result__11654__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__11654__auto__;
}
break;
}
}catch (e20701){if((e20701 instanceof Object))
{var ex__11655__auto__ = e20701;var statearr_20702_20710 = state_20686;(statearr_20702_20710[5] = ex__11655__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20686);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e20701;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11653__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__20711 = state_20686;
state_20686 = G__20711;
continue;
}
} else
{return ret_value__11653__auto__;
}
break;
}
});
state_machine__11652__auto__ = function(state_20686){
switch(arguments.length){
case 0:
return state_machine__11652__auto____0.call(this);
case 1:
return state_machine__11652__auto____1.call(this,state_20686);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11652__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11652__auto____0;
state_machine__11652__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11652__auto____1;
return state_machine__11652__auto__;
})()
;})(switch__11651__auto__,c__11722__auto__))
})();var state__11724__auto__ = (function (){var statearr_20703 = f__11723__auto__.call(null);(statearr_20703[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11722__auto__);
return statearr_20703;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11724__auto__);
});})(c__11722__auto__))
);
return c__11722__auto__;
});
/**
* Puts the contents of coll into the supplied channel.
* 
* By default the channel will be closed after the items are copied,
* but can be determined by the close? parameter.
* 
* Returns a channel which will close after the items are copied.
*/
cljs.core.async.onto_chan = (function() {
var onto_chan = null;
var onto_chan__2 = (function (ch,coll){return onto_chan.call(null,ch,coll,true);
});
var onto_chan__3 = (function (ch,coll,close_QMARK_){var c__11722__auto__ = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,((function (c__11722__auto__){
return (function (){var f__11723__auto__ = (function (){var switch__11651__auto__ = ((function (c__11722__auto__){
return (function (state_20785){var state_val_20786 = (state_20785[1]);if((state_val_20786 === 1))
{var inst_20761 = cljs.core.seq.call(null,coll);var inst_20762 = inst_20761;var state_20785__$1 = (function (){var statearr_20787 = state_20785;(statearr_20787[7] = inst_20762);
return statearr_20787;
})();var statearr_20788_20810 = state_20785__$1;(statearr_20788_20810[2] = null);
(statearr_20788_20810[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20786 === 2))
{var inst_20762 = (state_20785[7]);var state_20785__$1 = state_20785;if(cljs.core.truth_(inst_20762))
{var statearr_20789_20811 = state_20785__$1;(statearr_20789_20811[1] = 4);
} else
{var statearr_20790_20812 = state_20785__$1;(statearr_20790_20812[1] = 5);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20786 === 3))
{var inst_20783 = (state_20785[2]);var state_20785__$1 = state_20785;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20785__$1,inst_20783);
} else
{if((state_val_20786 === 4))
{var inst_20762 = (state_20785[7]);var inst_20765 = cljs.core.first.call(null,inst_20762);var state_20785__$1 = state_20785;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20785__$1,7,ch,inst_20765);
} else
{if((state_val_20786 === 5))
{var inst_20762 = (state_20785[7]);var state_20785__$1 = state_20785;var statearr_20791_20813 = state_20785__$1;(statearr_20791_20813[2] = inst_20762);
(statearr_20791_20813[1] = 6);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20786 === 6))
{var inst_20770 = (state_20785[2]);var state_20785__$1 = state_20785;if(cljs.core.truth_(inst_20770))
{var statearr_20792_20814 = state_20785__$1;(statearr_20792_20814[1] = 8);
} else
{var statearr_20793_20815 = state_20785__$1;(statearr_20793_20815[1] = 9);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20786 === 7))
{var inst_20767 = (state_20785[2]);var state_20785__$1 = state_20785;var statearr_20794_20816 = state_20785__$1;(statearr_20794_20816[2] = inst_20767);
(statearr_20794_20816[1] = 6);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20786 === 8))
{var inst_20762 = (state_20785[7]);var inst_20772 = cljs.core.next.call(null,inst_20762);var inst_20762__$1 = inst_20772;var state_20785__$1 = (function (){var statearr_20795 = state_20785;(statearr_20795[7] = inst_20762__$1);
return statearr_20795;
})();var statearr_20796_20817 = state_20785__$1;(statearr_20796_20817[2] = null);
(statearr_20796_20817[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20786 === 9))
{var state_20785__$1 = state_20785;if(cljs.core.truth_(close_QMARK_))
{var statearr_20797_20818 = state_20785__$1;(statearr_20797_20818[1] = 11);
} else
{var statearr_20798_20819 = state_20785__$1;(statearr_20798_20819[1] = 12);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20786 === 10))
{var inst_20781 = (state_20785[2]);var state_20785__$1 = state_20785;var statearr_20799_20820 = state_20785__$1;(statearr_20799_20820[2] = inst_20781);
(statearr_20799_20820[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20786 === 11))
{var inst_20776 = cljs.core.async.close_BANG_.call(null,ch);var state_20785__$1 = state_20785;var statearr_20800_20821 = state_20785__$1;(statearr_20800_20821[2] = inst_20776);
(statearr_20800_20821[1] = 13);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20786 === 12))
{var state_20785__$1 = state_20785;var statearr_20801_20822 = state_20785__$1;(statearr_20801_20822[2] = null);
(statearr_20801_20822[1] = 13);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_20786 === 13))
{var inst_20779 = (state_20785[2]);var state_20785__$1 = state_20785;var statearr_20802_20823 = state_20785__$1;(statearr_20802_20823[2] = inst_20779);
(statearr_20802_20823[1] = 10);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11722__auto__))
;return ((function (switch__11651__auto__,c__11722__auto__){
return (function() {
var state_machine__11652__auto__ = null;
var state_machine__11652__auto____0 = (function (){var statearr_20806 = [null,null,null,null,null,null,null,null];(statearr_20806[0] = state_machine__11652__auto__);
(statearr_20806[1] = 1);
return statearr_20806;
});
var state_machine__11652__auto____1 = (function (state_20785){while(true){
var ret_value__11653__auto__ = (function (){try{while(true){
var result__11654__auto__ = switch__11651__auto__.call(null,state_20785);if(cljs.core.keyword_identical_QMARK_.call(null,result__11654__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__11654__auto__;
}
break;
}
}catch (e20807){if((e20807 instanceof Object))
{var ex__11655__auto__ = e20807;var statearr_20808_20824 = state_20785;(statearr_20808_20824[5] = ex__11655__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20785);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e20807;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11653__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__20825 = state_20785;
state_20785 = G__20825;
continue;
}
} else
{return ret_value__11653__auto__;
}
break;
}
});
state_machine__11652__auto__ = function(state_20785){
switch(arguments.length){
case 0:
return state_machine__11652__auto____0.call(this);
case 1:
return state_machine__11652__auto____1.call(this,state_20785);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11652__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11652__auto____0;
state_machine__11652__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11652__auto____1;
return state_machine__11652__auto__;
})()
;})(switch__11651__auto__,c__11722__auto__))
})();var state__11724__auto__ = (function (){var statearr_20809 = f__11723__auto__.call(null);(statearr_20809[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11722__auto__);
return statearr_20809;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11724__auto__);
});})(c__11722__auto__))
);
return c__11722__auto__;
});
onto_chan = function(ch,coll,close_QMARK_){
switch(arguments.length){
case 2:
return onto_chan__2.call(this,ch,coll);
case 3:
return onto_chan__3.call(this,ch,coll,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
onto_chan.cljs$core$IFn$_invoke$arity$2 = onto_chan__2;
onto_chan.cljs$core$IFn$_invoke$arity$3 = onto_chan__3;
return onto_chan;
})()
;
/**
* Creates and returns a channel which contains the contents of coll,
* closing when exhausted.
*/
cljs.core.async.to_chan = (function to_chan(coll){var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,100,coll));cljs.core.async.onto_chan.call(null,ch,coll);
return ch;
});
cljs.core.async.Mux = (function (){var obj20827 = {};return obj20827;
})();
cljs.core.async.muxch_STAR_ = (function muxch_STAR_(_){if((function (){var and__9273__auto__ = _;if(and__9273__auto__)
{return _.cljs$core$async$Mux$muxch_STAR_$arity$1;
} else
{return and__9273__auto__;
}
})())
{return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else
{var x__9912__auto__ = (((_ == null))?null:_);return (function (){var or__9285__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__9912__auto__)]);if(or__9285__auto__)
{return or__9285__auto__;
} else
{var or__9285__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);if(or__9285__auto____$1)
{return or__9285__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
})().call(null,_);
}
});
cljs.core.async.Mult = (function (){var obj20829 = {};return obj20829;
})();
cljs.core.async.tap_STAR_ = (function tap_STAR_(m,ch,close_QMARK_){if((function (){var and__9273__auto__ = m;if(and__9273__auto__)
{return m.cljs$core$async$Mult$tap_STAR_$arity$3;
} else
{return and__9273__auto__;
}
})())
{return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else
{var x__9912__auto__ = (((m == null))?null:m);return (function (){var or__9285__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__9912__auto__)]);if(or__9285__auto__)
{return or__9285__auto__;
} else
{var or__9285__auto____$1 = (cljs.core.async.tap_STAR_["_"]);if(or__9285__auto____$1)
{return or__9285__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
})().call(null,m,ch,close_QMARK_);
}
});
cljs.core.async.untap_STAR_ = (function untap_STAR_(m,ch){if((function (){var and__9273__auto__ = m;if(and__9273__auto__)
{return m.cljs$core$async$Mult$untap_STAR_$arity$2;
} else
{return and__9273__auto__;
}
})())
{return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else
{var x__9912__auto__ = (((m == null))?null:m);return (function (){var or__9285__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__9912__auto__)]);if(or__9285__auto__)
{return or__9285__auto__;
} else
{var or__9285__auto____$1 = (cljs.core.async.untap_STAR_["_"]);if(or__9285__auto____$1)
{return or__9285__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
})().call(null,m,ch);
}
});
cljs.core.async.untap_all_STAR_ = (function untap_all_STAR_(m){if((function (){var and__9273__auto__ = m;if(and__9273__auto__)
{return m.cljs$core$async$Mult$untap_all_STAR_$arity$1;
} else
{return and__9273__auto__;
}
})())
{return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else
{var x__9912__auto__ = (((m == null))?null:m);return (function (){var or__9285__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__9912__auto__)]);if(or__9285__auto__)
{return or__9285__auto__;
} else
{var or__9285__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);if(or__9285__auto____$1)
{return or__9285__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
})().call(null,m);
}
});
/**
* Creates and returns a mult(iple) of the supplied channel. Channels
* containing copies of the channel can be created with 'tap', and
* detached with 'untap'.
* 
* Each item is distributed to all taps in parallel and synchronously,
* i.e. each tap must accept before the next item is distributed. Use
* buffering/windowing to prevent slow taps from holding up the mult.
* 
* Items received when there are no taps get dropped.
* 
* If a tap puts to a closed channel, it will be removed from the mult.
*/
cljs.core.async.mult = (function mult(ch){var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);var m = (function (){if(typeof cljs.core.async.t21051 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t21051 = (function (cs,ch,mult,meta21052){
this.cs = cs;
this.ch = ch;
this.mult = mult;
this.meta21052 = meta21052;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t21051.cljs$lang$type = true;
cljs.core.async.t21051.cljs$lang$ctorStr = "cljs.core.async/t21051";
cljs.core.async.t21051.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__9852__auto__,writer__9853__auto__,opt__9854__auto__){return cljs.core._write.call(null,writer__9853__auto__,"cljs.core.async/t21051");
});})(cs))
;
cljs.core.async.t21051.prototype.cljs$core$async$Mult$ = true;
cljs.core.async.t21051.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$2,close_QMARK_){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$2,close_QMARK_);
return null;
});})(cs))
;
cljs.core.async.t21051.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$2){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$2);
return null;
});})(cs))
;
cljs.core.async.t21051.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){var self__ = this;
var ___$1 = this;cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);
return null;
});})(cs))
;
cljs.core.async.t21051.prototype.cljs$core$async$Mux$ = true;
cljs.core.async.t21051.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){var self__ = this;
var ___$1 = this;return self__.ch;
});})(cs))
;
cljs.core.async.t21051.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_21053){var self__ = this;
var _21053__$1 = this;return self__.meta21052;
});})(cs))
;
cljs.core.async.t21051.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_21053,meta21052__$1){var self__ = this;
var _21053__$1 = this;return (new cljs.core.async.t21051(self__.cs,self__.ch,self__.mult,meta21052__$1));
});})(cs))
;
cljs.core.async.__GT_t21051 = ((function (cs){
return (function __GT_t21051(cs__$1,ch__$1,mult__$1,meta21052){return (new cljs.core.async.t21051(cs__$1,ch__$1,mult__$1,meta21052));
});})(cs))
;
}
return (new cljs.core.async.t21051(cs,ch,mult,null));
})();var dchan = cljs.core.async.chan.call(null,1);var dctr = cljs.core.atom.call(null,null);var done = ((function (cs,m,dchan,dctr){
return (function (_){if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === 0))
{return cljs.core.async.put_BANG_.call(null,dchan,true);
} else
{return null;
}
});})(cs,m,dchan,dctr))
;var c__11722__auto___21272 = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,((function (c__11722__auto___21272,cs,m,dchan,dctr,done){
return (function (){var f__11723__auto__ = (function (){var switch__11651__auto__ = ((function (c__11722__auto___21272,cs,m,dchan,dctr,done){
return (function (state_21184){var state_val_21185 = (state_21184[1]);if((state_val_21185 === 32))
{var inst_21125 = (state_21184[7]);var inst_21126 = (state_21184[8]);var inst_21127 = (state_21184[9]);var inst_21124 = (state_21184[10]);var inst_21139 = (state_21184[2]);var inst_21140 = (inst_21127 + 1);var tmp21186 = inst_21125;var tmp21187 = inst_21126;var tmp21188 = inst_21124;var inst_21124__$1 = tmp21188;var inst_21125__$1 = tmp21186;var inst_21126__$1 = tmp21187;var inst_21127__$1 = inst_21140;var state_21184__$1 = (function (){var statearr_21189 = state_21184;(statearr_21189[11] = inst_21139);
(statearr_21189[7] = inst_21125__$1);
(statearr_21189[8] = inst_21126__$1);
(statearr_21189[9] = inst_21127__$1);
(statearr_21189[10] = inst_21124__$1);
return statearr_21189;
})();var statearr_21190_21273 = state_21184__$1;(statearr_21190_21273[2] = null);
(statearr_21190_21273[1] = 25);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 1))
{var state_21184__$1 = state_21184;var statearr_21191_21274 = state_21184__$1;(statearr_21191_21274[2] = null);
(statearr_21191_21274[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 33))
{var inst_21143 = (state_21184[12]);var inst_21145 = cljs.core.chunked_seq_QMARK_.call(null,inst_21143);var state_21184__$1 = state_21184;if(inst_21145)
{var statearr_21192_21275 = state_21184__$1;(statearr_21192_21275[1] = 36);
} else
{var statearr_21193_21276 = state_21184__$1;(statearr_21193_21276[1] = 37);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 2))
{var state_21184__$1 = state_21184;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21184__$1,4,ch);
} else
{if((state_val_21185 === 34))
{var state_21184__$1 = state_21184;var statearr_21194_21277 = state_21184__$1;(statearr_21194_21277[2] = null);
(statearr_21194_21277[1] = 35);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 3))
{var inst_21182 = (state_21184[2]);var state_21184__$1 = state_21184;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21184__$1,inst_21182);
} else
{if((state_val_21185 === 35))
{var inst_21166 = (state_21184[2]);var state_21184__$1 = state_21184;var statearr_21195_21278 = state_21184__$1;(statearr_21195_21278[2] = inst_21166);
(statearr_21195_21278[1] = 29);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 4))
{var inst_21056 = (state_21184[13]);var inst_21056__$1 = (state_21184[2]);var inst_21057 = (inst_21056__$1 == null);var state_21184__$1 = (function (){var statearr_21196 = state_21184;(statearr_21196[13] = inst_21056__$1);
return statearr_21196;
})();if(cljs.core.truth_(inst_21057))
{var statearr_21197_21279 = state_21184__$1;(statearr_21197_21279[1] = 5);
} else
{var statearr_21198_21280 = state_21184__$1;(statearr_21198_21280[1] = 6);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 36))
{var inst_21143 = (state_21184[12]);var inst_21147 = cljs.core.chunk_first.call(null,inst_21143);var inst_21148 = cljs.core.chunk_rest.call(null,inst_21143);var inst_21149 = cljs.core.count.call(null,inst_21147);var inst_21124 = inst_21148;var inst_21125 = inst_21147;var inst_21126 = inst_21149;var inst_21127 = 0;var state_21184__$1 = (function (){var statearr_21199 = state_21184;(statearr_21199[7] = inst_21125);
(statearr_21199[8] = inst_21126);
(statearr_21199[9] = inst_21127);
(statearr_21199[10] = inst_21124);
return statearr_21199;
})();var statearr_21200_21281 = state_21184__$1;(statearr_21200_21281[2] = null);
(statearr_21200_21281[1] = 25);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 5))
{var inst_21063 = cljs.core.deref.call(null,cs);var inst_21064 = cljs.core.seq.call(null,inst_21063);var inst_21065 = inst_21064;var inst_21066 = null;var inst_21067 = 0;var inst_21068 = 0;var state_21184__$1 = (function (){var statearr_21201 = state_21184;(statearr_21201[14] = inst_21068);
(statearr_21201[15] = inst_21067);
(statearr_21201[16] = inst_21066);
(statearr_21201[17] = inst_21065);
return statearr_21201;
})();var statearr_21202_21282 = state_21184__$1;(statearr_21202_21282[2] = null);
(statearr_21202_21282[1] = 8);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 37))
{var inst_21143 = (state_21184[12]);var inst_21056 = (state_21184[13]);var inst_21152 = (state_21184[18]);var inst_21152__$1 = cljs.core.first.call(null,inst_21143);var inst_21153 = cljs.core.async.put_BANG_.call(null,inst_21152__$1,inst_21056,done);var state_21184__$1 = (function (){var statearr_21203 = state_21184;(statearr_21203[18] = inst_21152__$1);
return statearr_21203;
})();if(cljs.core.truth_(inst_21153))
{var statearr_21204_21283 = state_21184__$1;(statearr_21204_21283[1] = 39);
} else
{var statearr_21205_21284 = state_21184__$1;(statearr_21205_21284[1] = 40);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 6))
{var inst_21116 = (state_21184[19]);var inst_21115 = cljs.core.deref.call(null,cs);var inst_21116__$1 = cljs.core.keys.call(null,inst_21115);var inst_21117 = cljs.core.count.call(null,inst_21116__$1);var inst_21118 = cljs.core.reset_BANG_.call(null,dctr,inst_21117);var inst_21123 = cljs.core.seq.call(null,inst_21116__$1);var inst_21124 = inst_21123;var inst_21125 = null;var inst_21126 = 0;var inst_21127 = 0;var state_21184__$1 = (function (){var statearr_21206 = state_21184;(statearr_21206[20] = inst_21118);
(statearr_21206[7] = inst_21125);
(statearr_21206[8] = inst_21126);
(statearr_21206[9] = inst_21127);
(statearr_21206[10] = inst_21124);
(statearr_21206[19] = inst_21116__$1);
return statearr_21206;
})();var statearr_21207_21285 = state_21184__$1;(statearr_21207_21285[2] = null);
(statearr_21207_21285[1] = 25);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 38))
{var inst_21163 = (state_21184[2]);var state_21184__$1 = state_21184;var statearr_21208_21286 = state_21184__$1;(statearr_21208_21286[2] = inst_21163);
(statearr_21208_21286[1] = 35);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 7))
{var inst_21180 = (state_21184[2]);var state_21184__$1 = state_21184;var statearr_21209_21287 = state_21184__$1;(statearr_21209_21287[2] = inst_21180);
(statearr_21209_21287[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 39))
{var state_21184__$1 = state_21184;var statearr_21210_21288 = state_21184__$1;(statearr_21210_21288[2] = null);
(statearr_21210_21288[1] = 41);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 8))
{var inst_21068 = (state_21184[14]);var inst_21067 = (state_21184[15]);var inst_21070 = (inst_21068 < inst_21067);var inst_21071 = inst_21070;var state_21184__$1 = state_21184;if(cljs.core.truth_(inst_21071))
{var statearr_21211_21289 = state_21184__$1;(statearr_21211_21289[1] = 10);
} else
{var statearr_21212_21290 = state_21184__$1;(statearr_21212_21290[1] = 11);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 40))
{var inst_21152 = (state_21184[18]);var inst_21156 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);var inst_21157 = cljs.core.async.untap_STAR_.call(null,m,inst_21152);var state_21184__$1 = (function (){var statearr_21213 = state_21184;(statearr_21213[21] = inst_21156);
return statearr_21213;
})();var statearr_21214_21291 = state_21184__$1;(statearr_21214_21291[2] = inst_21157);
(statearr_21214_21291[1] = 41);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 9))
{var inst_21113 = (state_21184[2]);var state_21184__$1 = state_21184;var statearr_21215_21292 = state_21184__$1;(statearr_21215_21292[2] = inst_21113);
(statearr_21215_21292[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 41))
{var inst_21143 = (state_21184[12]);var inst_21159 = (state_21184[2]);var inst_21160 = cljs.core.next.call(null,inst_21143);var inst_21124 = inst_21160;var inst_21125 = null;var inst_21126 = 0;var inst_21127 = 0;var state_21184__$1 = (function (){var statearr_21216 = state_21184;(statearr_21216[7] = inst_21125);
(statearr_21216[8] = inst_21126);
(statearr_21216[9] = inst_21127);
(statearr_21216[10] = inst_21124);
(statearr_21216[22] = inst_21159);
return statearr_21216;
})();var statearr_21217_21293 = state_21184__$1;(statearr_21217_21293[2] = null);
(statearr_21217_21293[1] = 25);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 10))
{var inst_21068 = (state_21184[14]);var inst_21066 = (state_21184[16]);var inst_21074 = cljs.core._nth.call(null,inst_21066,inst_21068);var inst_21075 = cljs.core.nth.call(null,inst_21074,0,null);var inst_21076 = cljs.core.nth.call(null,inst_21074,1,null);var state_21184__$1 = (function (){var statearr_21218 = state_21184;(statearr_21218[23] = inst_21075);
return statearr_21218;
})();if(cljs.core.truth_(inst_21076))
{var statearr_21219_21294 = state_21184__$1;(statearr_21219_21294[1] = 13);
} else
{var statearr_21220_21295 = state_21184__$1;(statearr_21220_21295[1] = 14);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 42))
{var state_21184__$1 = state_21184;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21184__$1,45,dchan);
} else
{if((state_val_21185 === 11))
{var inst_21065 = (state_21184[17]);var inst_21085 = (state_21184[24]);var inst_21085__$1 = cljs.core.seq.call(null,inst_21065);var state_21184__$1 = (function (){var statearr_21221 = state_21184;(statearr_21221[24] = inst_21085__$1);
return statearr_21221;
})();if(inst_21085__$1)
{var statearr_21222_21296 = state_21184__$1;(statearr_21222_21296[1] = 16);
} else
{var statearr_21223_21297 = state_21184__$1;(statearr_21223_21297[1] = 17);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 43))
{var state_21184__$1 = state_21184;var statearr_21224_21298 = state_21184__$1;(statearr_21224_21298[2] = null);
(statearr_21224_21298[1] = 44);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 12))
{var inst_21111 = (state_21184[2]);var state_21184__$1 = state_21184;var statearr_21225_21299 = state_21184__$1;(statearr_21225_21299[2] = inst_21111);
(statearr_21225_21299[1] = 9);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 44))
{var inst_21177 = (state_21184[2]);var state_21184__$1 = (function (){var statearr_21226 = state_21184;(statearr_21226[25] = inst_21177);
return statearr_21226;
})();var statearr_21227_21300 = state_21184__$1;(statearr_21227_21300[2] = null);
(statearr_21227_21300[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 13))
{var inst_21075 = (state_21184[23]);var inst_21078 = cljs.core.async.close_BANG_.call(null,inst_21075);var state_21184__$1 = state_21184;var statearr_21228_21301 = state_21184__$1;(statearr_21228_21301[2] = inst_21078);
(statearr_21228_21301[1] = 15);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 45))
{var inst_21174 = (state_21184[2]);var state_21184__$1 = state_21184;var statearr_21232_21302 = state_21184__$1;(statearr_21232_21302[2] = inst_21174);
(statearr_21232_21302[1] = 44);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 14))
{var state_21184__$1 = state_21184;var statearr_21233_21303 = state_21184__$1;(statearr_21233_21303[2] = null);
(statearr_21233_21303[1] = 15);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 15))
{var inst_21068 = (state_21184[14]);var inst_21067 = (state_21184[15]);var inst_21066 = (state_21184[16]);var inst_21065 = (state_21184[17]);var inst_21081 = (state_21184[2]);var inst_21082 = (inst_21068 + 1);var tmp21229 = inst_21067;var tmp21230 = inst_21066;var tmp21231 = inst_21065;var inst_21065__$1 = tmp21231;var inst_21066__$1 = tmp21230;var inst_21067__$1 = tmp21229;var inst_21068__$1 = inst_21082;var state_21184__$1 = (function (){var statearr_21234 = state_21184;(statearr_21234[14] = inst_21068__$1);
(statearr_21234[15] = inst_21067__$1);
(statearr_21234[16] = inst_21066__$1);
(statearr_21234[17] = inst_21065__$1);
(statearr_21234[26] = inst_21081);
return statearr_21234;
})();var statearr_21235_21304 = state_21184__$1;(statearr_21235_21304[2] = null);
(statearr_21235_21304[1] = 8);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 16))
{var inst_21085 = (state_21184[24]);var inst_21087 = cljs.core.chunked_seq_QMARK_.call(null,inst_21085);var state_21184__$1 = state_21184;if(inst_21087)
{var statearr_21236_21305 = state_21184__$1;(statearr_21236_21305[1] = 19);
} else
{var statearr_21237_21306 = state_21184__$1;(statearr_21237_21306[1] = 20);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 17))
{var state_21184__$1 = state_21184;var statearr_21238_21307 = state_21184__$1;(statearr_21238_21307[2] = null);
(statearr_21238_21307[1] = 18);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 18))
{var inst_21109 = (state_21184[2]);var state_21184__$1 = state_21184;var statearr_21239_21308 = state_21184__$1;(statearr_21239_21308[2] = inst_21109);
(statearr_21239_21308[1] = 12);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 19))
{var inst_21085 = (state_21184[24]);var inst_21089 = cljs.core.chunk_first.call(null,inst_21085);var inst_21090 = cljs.core.chunk_rest.call(null,inst_21085);var inst_21091 = cljs.core.count.call(null,inst_21089);var inst_21065 = inst_21090;var inst_21066 = inst_21089;var inst_21067 = inst_21091;var inst_21068 = 0;var state_21184__$1 = (function (){var statearr_21240 = state_21184;(statearr_21240[14] = inst_21068);
(statearr_21240[15] = inst_21067);
(statearr_21240[16] = inst_21066);
(statearr_21240[17] = inst_21065);
return statearr_21240;
})();var statearr_21241_21309 = state_21184__$1;(statearr_21241_21309[2] = null);
(statearr_21241_21309[1] = 8);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 20))
{var inst_21085 = (state_21184[24]);var inst_21095 = cljs.core.first.call(null,inst_21085);var inst_21096 = cljs.core.nth.call(null,inst_21095,0,null);var inst_21097 = cljs.core.nth.call(null,inst_21095,1,null);var state_21184__$1 = (function (){var statearr_21242 = state_21184;(statearr_21242[27] = inst_21096);
return statearr_21242;
})();if(cljs.core.truth_(inst_21097))
{var statearr_21243_21310 = state_21184__$1;(statearr_21243_21310[1] = 22);
} else
{var statearr_21244_21311 = state_21184__$1;(statearr_21244_21311[1] = 23);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 21))
{var inst_21106 = (state_21184[2]);var state_21184__$1 = state_21184;var statearr_21245_21312 = state_21184__$1;(statearr_21245_21312[2] = inst_21106);
(statearr_21245_21312[1] = 18);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 22))
{var inst_21096 = (state_21184[27]);var inst_21099 = cljs.core.async.close_BANG_.call(null,inst_21096);var state_21184__$1 = state_21184;var statearr_21246_21313 = state_21184__$1;(statearr_21246_21313[2] = inst_21099);
(statearr_21246_21313[1] = 24);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 23))
{var state_21184__$1 = state_21184;var statearr_21247_21314 = state_21184__$1;(statearr_21247_21314[2] = null);
(statearr_21247_21314[1] = 24);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 24))
{var inst_21085 = (state_21184[24]);var inst_21102 = (state_21184[2]);var inst_21103 = cljs.core.next.call(null,inst_21085);var inst_21065 = inst_21103;var inst_21066 = null;var inst_21067 = 0;var inst_21068 = 0;var state_21184__$1 = (function (){var statearr_21248 = state_21184;(statearr_21248[28] = inst_21102);
(statearr_21248[14] = inst_21068);
(statearr_21248[15] = inst_21067);
(statearr_21248[16] = inst_21066);
(statearr_21248[17] = inst_21065);
return statearr_21248;
})();var statearr_21249_21315 = state_21184__$1;(statearr_21249_21315[2] = null);
(statearr_21249_21315[1] = 8);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 25))
{var inst_21126 = (state_21184[8]);var inst_21127 = (state_21184[9]);var inst_21129 = (inst_21127 < inst_21126);var inst_21130 = inst_21129;var state_21184__$1 = state_21184;if(cljs.core.truth_(inst_21130))
{var statearr_21250_21316 = state_21184__$1;(statearr_21250_21316[1] = 27);
} else
{var statearr_21251_21317 = state_21184__$1;(statearr_21251_21317[1] = 28);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 26))
{var inst_21116 = (state_21184[19]);var inst_21170 = (state_21184[2]);var inst_21171 = cljs.core.seq.call(null,inst_21116);var state_21184__$1 = (function (){var statearr_21252 = state_21184;(statearr_21252[29] = inst_21170);
return statearr_21252;
})();if(inst_21171)
{var statearr_21253_21318 = state_21184__$1;(statearr_21253_21318[1] = 42);
} else
{var statearr_21254_21319 = state_21184__$1;(statearr_21254_21319[1] = 43);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 27))
{var inst_21125 = (state_21184[7]);var inst_21056 = (state_21184[13]);var inst_21127 = (state_21184[9]);var inst_21132 = (state_21184[30]);var inst_21132__$1 = cljs.core._nth.call(null,inst_21125,inst_21127);var inst_21133 = cljs.core.async.put_BANG_.call(null,inst_21132__$1,inst_21056,done);var state_21184__$1 = (function (){var statearr_21255 = state_21184;(statearr_21255[30] = inst_21132__$1);
return statearr_21255;
})();if(cljs.core.truth_(inst_21133))
{var statearr_21256_21320 = state_21184__$1;(statearr_21256_21320[1] = 30);
} else
{var statearr_21257_21321 = state_21184__$1;(statearr_21257_21321[1] = 31);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 28))
{var inst_21143 = (state_21184[12]);var inst_21124 = (state_21184[10]);var inst_21143__$1 = cljs.core.seq.call(null,inst_21124);var state_21184__$1 = (function (){var statearr_21258 = state_21184;(statearr_21258[12] = inst_21143__$1);
return statearr_21258;
})();if(inst_21143__$1)
{var statearr_21259_21322 = state_21184__$1;(statearr_21259_21322[1] = 33);
} else
{var statearr_21260_21323 = state_21184__$1;(statearr_21260_21323[1] = 34);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 29))
{var inst_21168 = (state_21184[2]);var state_21184__$1 = state_21184;var statearr_21261_21324 = state_21184__$1;(statearr_21261_21324[2] = inst_21168);
(statearr_21261_21324[1] = 26);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 30))
{var state_21184__$1 = state_21184;var statearr_21262_21325 = state_21184__$1;(statearr_21262_21325[2] = null);
(statearr_21262_21325[1] = 32);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21185 === 31))
{var inst_21132 = (state_21184[30]);var inst_21136 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);var inst_21137 = cljs.core.async.untap_STAR_.call(null,m,inst_21132);var state_21184__$1 = (function (){var statearr_21263 = state_21184;(statearr_21263[31] = inst_21136);
return statearr_21263;
})();var statearr_21264_21326 = state_21184__$1;(statearr_21264_21326[2] = inst_21137);
(statearr_21264_21326[1] = 32);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11722__auto___21272,cs,m,dchan,dctr,done))
;return ((function (switch__11651__auto__,c__11722__auto___21272,cs,m,dchan,dctr,done){
return (function() {
var state_machine__11652__auto__ = null;
var state_machine__11652__auto____0 = (function (){var statearr_21268 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_21268[0] = state_machine__11652__auto__);
(statearr_21268[1] = 1);
return statearr_21268;
});
var state_machine__11652__auto____1 = (function (state_21184){while(true){
var ret_value__11653__auto__ = (function (){try{while(true){
var result__11654__auto__ = switch__11651__auto__.call(null,state_21184);if(cljs.core.keyword_identical_QMARK_.call(null,result__11654__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__11654__auto__;
}
break;
}
}catch (e21269){if((e21269 instanceof Object))
{var ex__11655__auto__ = e21269;var statearr_21270_21327 = state_21184;(statearr_21270_21327[5] = ex__11655__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21184);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e21269;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11653__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__21328 = state_21184;
state_21184 = G__21328;
continue;
}
} else
{return ret_value__11653__auto__;
}
break;
}
});
state_machine__11652__auto__ = function(state_21184){
switch(arguments.length){
case 0:
return state_machine__11652__auto____0.call(this);
case 1:
return state_machine__11652__auto____1.call(this,state_21184);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11652__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11652__auto____0;
state_machine__11652__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11652__auto____1;
return state_machine__11652__auto__;
})()
;})(switch__11651__auto__,c__11722__auto___21272,cs,m,dchan,dctr,done))
})();var state__11724__auto__ = (function (){var statearr_21271 = f__11723__auto__.call(null);(statearr_21271[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11722__auto___21272);
return statearr_21271;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11724__auto__);
});})(c__11722__auto___21272,cs,m,dchan,dctr,done))
);
return m;
});
/**
* Copies the mult source onto the supplied channel.
* 
* By default the channel will be closed when the source closes,
* but can be determined by the close? parameter.
*/
cljs.core.async.tap = (function() {
var tap = null;
var tap__2 = (function (mult,ch){return tap.call(null,mult,ch,true);
});
var tap__3 = (function (mult,ch,close_QMARK_){cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);
return ch;
});
tap = function(mult,ch,close_QMARK_){
switch(arguments.length){
case 2:
return tap__2.call(this,mult,ch);
case 3:
return tap__3.call(this,mult,ch,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
tap.cljs$core$IFn$_invoke$arity$2 = tap__2;
tap.cljs$core$IFn$_invoke$arity$3 = tap__3;
return tap;
})()
;
/**
* Disconnects a target channel from a mult
*/
cljs.core.async.untap = (function untap(mult,ch){return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
* Disconnects all target channels from a mult
*/
cljs.core.async.untap_all = (function untap_all(mult){return cljs.core.async.untap_all_STAR_.call(null,mult);
});
cljs.core.async.Mix = (function (){var obj21330 = {};return obj21330;
})();
cljs.core.async.admix_STAR_ = (function admix_STAR_(m,ch){if((function (){var and__9273__auto__ = m;if(and__9273__auto__)
{return m.cljs$core$async$Mix$admix_STAR_$arity$2;
} else
{return and__9273__auto__;
}
})())
{return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else
{var x__9912__auto__ = (((m == null))?null:m);return (function (){var or__9285__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__9912__auto__)]);if(or__9285__auto__)
{return or__9285__auto__;
} else
{var or__9285__auto____$1 = (cljs.core.async.admix_STAR_["_"]);if(or__9285__auto____$1)
{return or__9285__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
})().call(null,m,ch);
}
});
cljs.core.async.unmix_STAR_ = (function unmix_STAR_(m,ch){if((function (){var and__9273__auto__ = m;if(and__9273__auto__)
{return m.cljs$core$async$Mix$unmix_STAR_$arity$2;
} else
{return and__9273__auto__;
}
})())
{return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else
{var x__9912__auto__ = (((m == null))?null:m);return (function (){var or__9285__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__9912__auto__)]);if(or__9285__auto__)
{return or__9285__auto__;
} else
{var or__9285__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);if(or__9285__auto____$1)
{return or__9285__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
})().call(null,m,ch);
}
});
cljs.core.async.unmix_all_STAR_ = (function unmix_all_STAR_(m){if((function (){var and__9273__auto__ = m;if(and__9273__auto__)
{return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1;
} else
{return and__9273__auto__;
}
})())
{return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else
{var x__9912__auto__ = (((m == null))?null:m);return (function (){var or__9285__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__9912__auto__)]);if(or__9285__auto__)
{return or__9285__auto__;
} else
{var or__9285__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);if(or__9285__auto____$1)
{return or__9285__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
})().call(null,m);
}
});
cljs.core.async.toggle_STAR_ = (function toggle_STAR_(m,state_map){if((function (){var and__9273__auto__ = m;if(and__9273__auto__)
{return m.cljs$core$async$Mix$toggle_STAR_$arity$2;
} else
{return and__9273__auto__;
}
})())
{return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else
{var x__9912__auto__ = (((m == null))?null:m);return (function (){var or__9285__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__9912__auto__)]);if(or__9285__auto__)
{return or__9285__auto__;
} else
{var or__9285__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);if(or__9285__auto____$1)
{return or__9285__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
})().call(null,m,state_map);
}
});
cljs.core.async.solo_mode_STAR_ = (function solo_mode_STAR_(m,mode){if((function (){var and__9273__auto__ = m;if(and__9273__auto__)
{return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2;
} else
{return and__9273__auto__;
}
})())
{return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else
{var x__9912__auto__ = (((m == null))?null:m);return (function (){var or__9285__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__9912__auto__)]);if(or__9285__auto__)
{return or__9285__auto__;
} else
{var or__9285__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);if(or__9285__auto____$1)
{return or__9285__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
})().call(null,m,mode);
}
});
/**
* Creates and returns a mix of one or more input channels which will
* be put on the supplied out channel. Input sources can be added to
* the mix with 'admix', and removed with 'unmix'. A mix supports
* soloing, muting and pausing multiple inputs atomically using
* 'toggle', and can solo using either muting or pausing as determined
* by 'solo-mode'.
* 
* Each channel can have zero or more boolean modes set via 'toggle':
* 
* :solo - when true, only this (ond other soloed) channel(s) will appear
* in the mix output channel. :mute and :pause states of soloed
* channels are ignored. If solo-mode is :mute, non-soloed
* channels are muted, if :pause, non-soloed channels are
* paused.
* 
* :mute - muted channels will have their contents consumed but not included in the mix
* :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
*/
cljs.core.async.mix = (function mix(out){var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",1120344424),null,new cljs.core.Keyword(null,"mute","mute",1017267595),null], null), null);var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",1017440337));var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1017267595));var change = cljs.core.async.chan.call(null);var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){if(cljs.core.truth_(attr.call(null,v)))
{return cljs.core.conj.call(null,ret,c);
} else
{return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){var chs = cljs.core.deref.call(null,cs);var mode = cljs.core.deref.call(null,solo_mode);var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",1017440337),chs);var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",1120344424),chs);return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1123523302),solos,new cljs.core.Keyword(null,"mutes","mutes",1118168300),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1017267595),chs),new cljs.core.Keyword(null,"reads","reads",1122290959),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",1120344424))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;var m = (function (){if(typeof cljs.core.async.t21450 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t21450 = (function (pick,out,attrs,cs,calc_state,solo_modes,mix,changed,change,solo_mode,meta21451){
this.pick = pick;
this.out = out;
this.attrs = attrs;
this.cs = cs;
this.calc_state = calc_state;
this.solo_modes = solo_modes;
this.mix = mix;
this.changed = changed;
this.change = change;
this.solo_mode = solo_mode;
this.meta21451 = meta21451;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t21450.cljs$lang$type = true;
cljs.core.async.t21450.cljs$lang$ctorStr = "cljs.core.async/t21450";
cljs.core.async.t21450.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__9852__auto__,writer__9853__auto__,opt__9854__auto__){return cljs.core._write.call(null,writer__9853__auto__,"cljs.core.async/t21450");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t21450.prototype.cljs$core$async$Mix$ = true;
cljs.core.async.t21450.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t21450.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t21450.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){var self__ = this;
var ___$1 = this;cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t21450.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t21450.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){var self__ = this;
var ___$1 = this;if(cljs.core.truth_(self__.solo_modes.call(null,mode)))
{} else
{throw (new Error(("Assert failed: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(("mode must be one of: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)))+"\n"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",-1162732933,null),new cljs.core.Symbol(null,"mode","mode",-1637174436,null)))))));
}
cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t21450.prototype.cljs$core$async$Mux$ = true;
cljs.core.async.t21450.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){var self__ = this;
var ___$1 = this;return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t21450.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_21452){var self__ = this;
var _21452__$1 = this;return self__.meta21451;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t21450.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_21452,meta21451__$1){var self__ = this;
var _21452__$1 = this;return (new cljs.core.async.t21450(self__.pick,self__.out,self__.attrs,self__.cs,self__.calc_state,self__.solo_modes,self__.mix,self__.changed,self__.change,self__.solo_mode,meta21451__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.__GT_t21450 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function __GT_t21450(pick__$1,out__$1,attrs__$1,cs__$1,calc_state__$1,solo_modes__$1,mix__$1,changed__$1,change__$1,solo_mode__$1,meta21451){return (new cljs.core.async.t21450(pick__$1,out__$1,attrs__$1,cs__$1,calc_state__$1,solo_modes__$1,mix__$1,changed__$1,change__$1,solo_mode__$1,meta21451));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
}
return (new cljs.core.async.t21450(pick,out,attrs,cs,calc_state,solo_modes,mix,changed,change,solo_mode,null));
})();var c__11722__auto___21569 = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,((function (c__11722__auto___21569,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){var f__11723__auto__ = (function (){var switch__11651__auto__ = ((function (c__11722__auto___21569,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_21522){var state_val_21523 = (state_21522[1]);if((state_val_21523 === 1))
{var inst_21456 = (state_21522[7]);var inst_21456__$1 = calc_state.call(null);var inst_21457 = cljs.core.seq_QMARK_.call(null,inst_21456__$1);var state_21522__$1 = (function (){var statearr_21524 = state_21522;(statearr_21524[7] = inst_21456__$1);
return statearr_21524;
})();if(inst_21457)
{var statearr_21525_21570 = state_21522__$1;(statearr_21525_21570[1] = 2);
} else
{var statearr_21526_21571 = state_21522__$1;(statearr_21526_21571[1] = 3);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21523 === 2))
{var inst_21456 = (state_21522[7]);var inst_21459 = cljs.core.apply.call(null,cljs.core.hash_map,inst_21456);var state_21522__$1 = state_21522;var statearr_21527_21572 = state_21522__$1;(statearr_21527_21572[2] = inst_21459);
(statearr_21527_21572[1] = 4);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21523 === 3))
{var inst_21456 = (state_21522[7]);var state_21522__$1 = state_21522;var statearr_21528_21573 = state_21522__$1;(statearr_21528_21573[2] = inst_21456);
(statearr_21528_21573[1] = 4);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21523 === 4))
{var inst_21456 = (state_21522[7]);var inst_21462 = (state_21522[2]);var inst_21463 = cljs.core.get.call(null,inst_21462,new cljs.core.Keyword(null,"reads","reads",1122290959));var inst_21464 = cljs.core.get.call(null,inst_21462,new cljs.core.Keyword(null,"mutes","mutes",1118168300));var inst_21465 = cljs.core.get.call(null,inst_21462,new cljs.core.Keyword(null,"solos","solos",1123523302));var inst_21466 = inst_21456;var state_21522__$1 = (function (){var statearr_21529 = state_21522;(statearr_21529[8] = inst_21465);
(statearr_21529[9] = inst_21464);
(statearr_21529[10] = inst_21463);
(statearr_21529[11] = inst_21466);
return statearr_21529;
})();var statearr_21530_21574 = state_21522__$1;(statearr_21530_21574[2] = null);
(statearr_21530_21574[1] = 5);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21523 === 5))
{var inst_21466 = (state_21522[11]);var inst_21469 = cljs.core.seq_QMARK_.call(null,inst_21466);var state_21522__$1 = state_21522;if(inst_21469)
{var statearr_21531_21575 = state_21522__$1;(statearr_21531_21575[1] = 7);
} else
{var statearr_21532_21576 = state_21522__$1;(statearr_21532_21576[1] = 8);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21523 === 6))
{var inst_21520 = (state_21522[2]);var state_21522__$1 = state_21522;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21522__$1,inst_21520);
} else
{if((state_val_21523 === 7))
{var inst_21466 = (state_21522[11]);var inst_21471 = cljs.core.apply.call(null,cljs.core.hash_map,inst_21466);var state_21522__$1 = state_21522;var statearr_21533_21577 = state_21522__$1;(statearr_21533_21577[2] = inst_21471);
(statearr_21533_21577[1] = 9);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21523 === 8))
{var inst_21466 = (state_21522[11]);var state_21522__$1 = state_21522;var statearr_21534_21578 = state_21522__$1;(statearr_21534_21578[2] = inst_21466);
(statearr_21534_21578[1] = 9);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21523 === 9))
{var inst_21474 = (state_21522[12]);var inst_21474__$1 = (state_21522[2]);var inst_21475 = cljs.core.get.call(null,inst_21474__$1,new cljs.core.Keyword(null,"reads","reads",1122290959));var inst_21476 = cljs.core.get.call(null,inst_21474__$1,new cljs.core.Keyword(null,"mutes","mutes",1118168300));var inst_21477 = cljs.core.get.call(null,inst_21474__$1,new cljs.core.Keyword(null,"solos","solos",1123523302));var state_21522__$1 = (function (){var statearr_21535 = state_21522;(statearr_21535[13] = inst_21477);
(statearr_21535[14] = inst_21476);
(statearr_21535[12] = inst_21474__$1);
return statearr_21535;
})();return cljs.core.async.impl.ioc_helpers.ioc_alts_BANG_.call(null,state_21522__$1,10,inst_21475);
} else
{if((state_val_21523 === 10))
{var inst_21482 = (state_21522[15]);var inst_21481 = (state_21522[16]);var inst_21480 = (state_21522[2]);var inst_21481__$1 = cljs.core.nth.call(null,inst_21480,0,null);var inst_21482__$1 = cljs.core.nth.call(null,inst_21480,1,null);var inst_21483 = (inst_21481__$1 == null);var inst_21484 = cljs.core._EQ_.call(null,inst_21482__$1,change);var inst_21485 = (inst_21483) || (inst_21484);var state_21522__$1 = (function (){var statearr_21536 = state_21522;(statearr_21536[15] = inst_21482__$1);
(statearr_21536[16] = inst_21481__$1);
return statearr_21536;
})();if(cljs.core.truth_(inst_21485))
{var statearr_21537_21579 = state_21522__$1;(statearr_21537_21579[1] = 11);
} else
{var statearr_21538_21580 = state_21522__$1;(statearr_21538_21580[1] = 12);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21523 === 11))
{var inst_21481 = (state_21522[16]);var inst_21487 = (inst_21481 == null);var state_21522__$1 = state_21522;if(cljs.core.truth_(inst_21487))
{var statearr_21539_21581 = state_21522__$1;(statearr_21539_21581[1] = 14);
} else
{var statearr_21540_21582 = state_21522__$1;(statearr_21540_21582[1] = 15);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21523 === 12))
{var inst_21496 = (state_21522[17]);var inst_21477 = (state_21522[13]);var inst_21482 = (state_21522[15]);var inst_21496__$1 = inst_21477.call(null,inst_21482);var state_21522__$1 = (function (){var statearr_21541 = state_21522;(statearr_21541[17] = inst_21496__$1);
return statearr_21541;
})();if(cljs.core.truth_(inst_21496__$1))
{var statearr_21542_21583 = state_21522__$1;(statearr_21542_21583[1] = 17);
} else
{var statearr_21543_21584 = state_21522__$1;(statearr_21543_21584[1] = 18);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21523 === 13))
{var inst_21518 = (state_21522[2]);var state_21522__$1 = state_21522;var statearr_21544_21585 = state_21522__$1;(statearr_21544_21585[2] = inst_21518);
(statearr_21544_21585[1] = 6);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21523 === 14))
{var inst_21482 = (state_21522[15]);var inst_21489 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_21482);var state_21522__$1 = state_21522;var statearr_21545_21586 = state_21522__$1;(statearr_21545_21586[2] = inst_21489);
(statearr_21545_21586[1] = 16);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21523 === 15))
{var state_21522__$1 = state_21522;var statearr_21546_21587 = state_21522__$1;(statearr_21546_21587[2] = null);
(statearr_21546_21587[1] = 16);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21523 === 16))
{var inst_21492 = (state_21522[2]);var inst_21493 = calc_state.call(null);var inst_21466 = inst_21493;var state_21522__$1 = (function (){var statearr_21547 = state_21522;(statearr_21547[18] = inst_21492);
(statearr_21547[11] = inst_21466);
return statearr_21547;
})();var statearr_21548_21588 = state_21522__$1;(statearr_21548_21588[2] = null);
(statearr_21548_21588[1] = 5);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21523 === 17))
{var inst_21496 = (state_21522[17]);var state_21522__$1 = state_21522;var statearr_21549_21589 = state_21522__$1;(statearr_21549_21589[2] = inst_21496);
(statearr_21549_21589[1] = 19);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21523 === 18))
{var inst_21477 = (state_21522[13]);var inst_21482 = (state_21522[15]);var inst_21476 = (state_21522[14]);var inst_21499 = cljs.core.empty_QMARK_.call(null,inst_21477);var inst_21500 = inst_21476.call(null,inst_21482);var inst_21501 = cljs.core.not.call(null,inst_21500);var inst_21502 = (inst_21499) && (inst_21501);var state_21522__$1 = state_21522;var statearr_21550_21590 = state_21522__$1;(statearr_21550_21590[2] = inst_21502);
(statearr_21550_21590[1] = 19);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21523 === 19))
{var inst_21504 = (state_21522[2]);var state_21522__$1 = state_21522;if(cljs.core.truth_(inst_21504))
{var statearr_21551_21591 = state_21522__$1;(statearr_21551_21591[1] = 20);
} else
{var statearr_21552_21592 = state_21522__$1;(statearr_21552_21592[1] = 21);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21523 === 20))
{var inst_21481 = (state_21522[16]);var state_21522__$1 = state_21522;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21522__$1,23,out,inst_21481);
} else
{if((state_val_21523 === 21))
{var inst_21474 = (state_21522[12]);var inst_21466 = inst_21474;var state_21522__$1 = (function (){var statearr_21553 = state_21522;(statearr_21553[11] = inst_21466);
return statearr_21553;
})();var statearr_21554_21593 = state_21522__$1;(statearr_21554_21593[2] = null);
(statearr_21554_21593[1] = 5);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21523 === 22))
{var inst_21516 = (state_21522[2]);var state_21522__$1 = state_21522;var statearr_21555_21594 = state_21522__$1;(statearr_21555_21594[2] = inst_21516);
(statearr_21555_21594[1] = 13);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21523 === 23))
{var inst_21507 = (state_21522[2]);var state_21522__$1 = state_21522;if(cljs.core.truth_(inst_21507))
{var statearr_21556_21595 = state_21522__$1;(statearr_21556_21595[1] = 24);
} else
{var statearr_21557_21596 = state_21522__$1;(statearr_21557_21596[1] = 25);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21523 === 24))
{var inst_21474 = (state_21522[12]);var inst_21466 = inst_21474;var state_21522__$1 = (function (){var statearr_21558 = state_21522;(statearr_21558[11] = inst_21466);
return statearr_21558;
})();var statearr_21559_21597 = state_21522__$1;(statearr_21559_21597[2] = null);
(statearr_21559_21597[1] = 5);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21523 === 25))
{var state_21522__$1 = state_21522;var statearr_21560_21598 = state_21522__$1;(statearr_21560_21598[2] = null);
(statearr_21560_21598[1] = 26);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21523 === 26))
{var inst_21512 = (state_21522[2]);var state_21522__$1 = state_21522;var statearr_21561_21599 = state_21522__$1;(statearr_21561_21599[2] = inst_21512);
(statearr_21561_21599[1] = 22);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11722__auto___21569,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;return ((function (switch__11651__auto__,c__11722__auto___21569,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var state_machine__11652__auto__ = null;
var state_machine__11652__auto____0 = (function (){var statearr_21565 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_21565[0] = state_machine__11652__auto__);
(statearr_21565[1] = 1);
return statearr_21565;
});
var state_machine__11652__auto____1 = (function (state_21522){while(true){
var ret_value__11653__auto__ = (function (){try{while(true){
var result__11654__auto__ = switch__11651__auto__.call(null,state_21522);if(cljs.core.keyword_identical_QMARK_.call(null,result__11654__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__11654__auto__;
}
break;
}
}catch (e21566){if((e21566 instanceof Object))
{var ex__11655__auto__ = e21566;var statearr_21567_21600 = state_21522;(statearr_21567_21600[5] = ex__11655__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21522);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e21566;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11653__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__21601 = state_21522;
state_21522 = G__21601;
continue;
}
} else
{return ret_value__11653__auto__;
}
break;
}
});
state_machine__11652__auto__ = function(state_21522){
switch(arguments.length){
case 0:
return state_machine__11652__auto____0.call(this);
case 1:
return state_machine__11652__auto____1.call(this,state_21522);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11652__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11652__auto____0;
state_machine__11652__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11652__auto____1;
return state_machine__11652__auto__;
})()
;})(switch__11651__auto__,c__11722__auto___21569,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();var state__11724__auto__ = (function (){var statearr_21568 = f__11723__auto__.call(null);(statearr_21568[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11722__auto___21569);
return statearr_21568;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11724__auto__);
});})(c__11722__auto___21569,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);
return m;
});
/**
* Adds ch as an input to the mix
*/
cljs.core.async.admix = (function admix(mix,ch){return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
* Removes ch as an input to the mix
*/
cljs.core.async.unmix = (function unmix(mix,ch){return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
* removes all inputs from the mix
*/
cljs.core.async.unmix_all = (function unmix_all(mix){return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
* Atomically sets the state(s) of one or more channels in a mix. The
* state map is a map of channels -> channel-state-map. A
* channel-state-map is a map of attrs -> boolean, where attr is one or
* more of :mute, :pause or :solo. Any states supplied are merged with
* the current state.
* 
* Note that channels can be added to a mix via toggle, which can be
* used to add channels in a particular (e.g. paused) state.
*/
cljs.core.async.toggle = (function toggle(mix,state_map){return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
* Sets the solo mode of the mix. mode must be one of :mute or :pause
*/
cljs.core.async.solo_mode = (function solo_mode(mix,mode){return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});
cljs.core.async.Pub = (function (){var obj21603 = {};return obj21603;
})();
cljs.core.async.sub_STAR_ = (function sub_STAR_(p,v,ch,close_QMARK_){if((function (){var and__9273__auto__ = p;if(and__9273__auto__)
{return p.cljs$core$async$Pub$sub_STAR_$arity$4;
} else
{return and__9273__auto__;
}
})())
{return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else
{var x__9912__auto__ = (((p == null))?null:p);return (function (){var or__9285__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__9912__auto__)]);if(or__9285__auto__)
{return or__9285__auto__;
} else
{var or__9285__auto____$1 = (cljs.core.async.sub_STAR_["_"]);if(or__9285__auto____$1)
{return or__9285__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
})().call(null,p,v,ch,close_QMARK_);
}
});
cljs.core.async.unsub_STAR_ = (function unsub_STAR_(p,v,ch){if((function (){var and__9273__auto__ = p;if(and__9273__auto__)
{return p.cljs$core$async$Pub$unsub_STAR_$arity$3;
} else
{return and__9273__auto__;
}
})())
{return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else
{var x__9912__auto__ = (((p == null))?null:p);return (function (){var or__9285__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__9912__auto__)]);if(or__9285__auto__)
{return or__9285__auto__;
} else
{var or__9285__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);if(or__9285__auto____$1)
{return or__9285__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
})().call(null,p,v,ch);
}
});
cljs.core.async.unsub_all_STAR_ = (function() {
var unsub_all_STAR_ = null;
var unsub_all_STAR___1 = (function (p){if((function (){var and__9273__auto__ = p;if(and__9273__auto__)
{return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1;
} else
{return and__9273__auto__;
}
})())
{return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else
{var x__9912__auto__ = (((p == null))?null:p);return (function (){var or__9285__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__9912__auto__)]);if(or__9285__auto__)
{return or__9285__auto__;
} else
{var or__9285__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);if(or__9285__auto____$1)
{return or__9285__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
})().call(null,p);
}
});
var unsub_all_STAR___2 = (function (p,v){if((function (){var and__9273__auto__ = p;if(and__9273__auto__)
{return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2;
} else
{return and__9273__auto__;
}
})())
{return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else
{var x__9912__auto__ = (((p == null))?null:p);return (function (){var or__9285__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__9912__auto__)]);if(or__9285__auto__)
{return or__9285__auto__;
} else
{var or__9285__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);if(or__9285__auto____$1)
{return or__9285__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
})().call(null,p,v);
}
});
unsub_all_STAR_ = function(p,v){
switch(arguments.length){
case 1:
return unsub_all_STAR___1.call(this,p);
case 2:
return unsub_all_STAR___2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = unsub_all_STAR___1;
unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = unsub_all_STAR___2;
return unsub_all_STAR_;
})()
;
/**
* Creates and returns a pub(lication) of the supplied channel,
* partitioned into topics by the topic-fn. topic-fn will be applied to
* each value on the channel and the result will determine the 'topic'
* on which that value will be put. Channels can be subscribed to
* receive copies of topics using 'sub', and unsubscribed using
* 'unsub'. Each topic will be handled by an internal mult on a
* dedicated channel. By default these internal channels are
* unbuffered, but a buf-fn can be supplied which, given a topic,
* creates a buffer with desired properties.
* 
* Each item is distributed to all subs in parallel and synchronously,
* i.e. each sub must accept before the next item is distributed. Use
* buffering/windowing to prevent slow subs from holding up the pub.
* 
* Items received when there are no matching subs get dropped.
* 
* Note that if buf-fns are used then each topic is handled
* asynchronously, i.e. if a channel is subscribed to more than one
* topic it should not expect them to be interleaved identically with
* the source.
*/
cljs.core.async.pub = (function() {
var pub = null;
var pub__2 = (function (ch,topic_fn){return pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});
var pub__3 = (function (ch,topic_fn,buf_fn){var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);var ensure_mult = ((function (mults){
return (function (topic){var or__9285__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);if(cljs.core.truth_(or__9285__auto__))
{return or__9285__auto__;
} else
{return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__9285__auto__,mults){
return (function (p1__21604_SHARP_){if(cljs.core.truth_(p1__21604_SHARP_.call(null,topic)))
{return p1__21604_SHARP_;
} else
{return cljs.core.assoc.call(null,p1__21604_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__9285__auto__,mults))
),topic);
}
});})(mults))
;var p = (function (){if(typeof cljs.core.async.t21719 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t21719 = (function (ensure_mult,mults,buf_fn,topic_fn,ch,pub,meta21720){
this.ensure_mult = ensure_mult;
this.mults = mults;
this.buf_fn = buf_fn;
this.topic_fn = topic_fn;
this.ch = ch;
this.pub = pub;
this.meta21720 = meta21720;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t21719.cljs$lang$type = true;
cljs.core.async.t21719.cljs$lang$ctorStr = "cljs.core.async/t21719";
cljs.core.async.t21719.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__9852__auto__,writer__9853__auto__,opt__9854__auto__){return cljs.core._write.call(null,writer__9853__auto__,"cljs.core.async/t21719");
});})(mults,ensure_mult))
;
cljs.core.async.t21719.prototype.cljs$core$async$Pub$ = true;
cljs.core.async.t21719.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$2,close_QMARK_){var self__ = this;
var p__$1 = this;var m = self__.ensure_mult.call(null,topic);return cljs.core.async.tap.call(null,m,ch__$2,close_QMARK_);
});})(mults,ensure_mult))
;
cljs.core.async.t21719.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$2){var self__ = this;
var p__$1 = this;var temp__4092__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);if(cljs.core.truth_(temp__4092__auto__))
{var m = temp__4092__auto__;return cljs.core.async.untap.call(null,m,ch__$2);
} else
{return null;
}
});})(mults,ensure_mult))
;
cljs.core.async.t21719.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){var self__ = this;
var ___$1 = this;return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;
cljs.core.async.t21719.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){var self__ = this;
var ___$1 = this;return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;
cljs.core.async.t21719.prototype.cljs$core$async$Mux$ = true;
cljs.core.async.t21719.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){var self__ = this;
var ___$1 = this;return self__.ch;
});})(mults,ensure_mult))
;
cljs.core.async.t21719.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_21721){var self__ = this;
var _21721__$1 = this;return self__.meta21720;
});})(mults,ensure_mult))
;
cljs.core.async.t21719.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_21721,meta21720__$1){var self__ = this;
var _21721__$1 = this;return (new cljs.core.async.t21719(self__.ensure_mult,self__.mults,self__.buf_fn,self__.topic_fn,self__.ch,self__.pub,meta21720__$1));
});})(mults,ensure_mult))
;
cljs.core.async.__GT_t21719 = ((function (mults,ensure_mult){
return (function __GT_t21719(ensure_mult__$1,mults__$1,buf_fn__$1,topic_fn__$1,ch__$1,pub__$1,meta21720){return (new cljs.core.async.t21719(ensure_mult__$1,mults__$1,buf_fn__$1,topic_fn__$1,ch__$1,pub__$1,meta21720));
});})(mults,ensure_mult))
;
}
return (new cljs.core.async.t21719(ensure_mult,mults,buf_fn,topic_fn,ch,pub,null));
})();var c__11722__auto___21833 = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,((function (c__11722__auto___21833,mults,ensure_mult,p){
return (function (){var f__11723__auto__ = (function (){var switch__11651__auto__ = ((function (c__11722__auto___21833,mults,ensure_mult,p){
return (function (state_21789){var state_val_21790 = (state_21789[1]);if((state_val_21790 === 1))
{var state_21789__$1 = state_21789;var statearr_21791_21834 = state_21789__$1;(statearr_21791_21834[2] = null);
(statearr_21791_21834[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21790 === 2))
{var state_21789__$1 = state_21789;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21789__$1,4,ch);
} else
{if((state_val_21790 === 3))
{var inst_21787 = (state_21789[2]);var state_21789__$1 = state_21789;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21789__$1,inst_21787);
} else
{if((state_val_21790 === 4))
{var inst_21724 = (state_21789[7]);var inst_21724__$1 = (state_21789[2]);var inst_21725 = (inst_21724__$1 == null);var state_21789__$1 = (function (){var statearr_21792 = state_21789;(statearr_21792[7] = inst_21724__$1);
return statearr_21792;
})();if(cljs.core.truth_(inst_21725))
{var statearr_21793_21835 = state_21789__$1;(statearr_21793_21835[1] = 5);
} else
{var statearr_21794_21836 = state_21789__$1;(statearr_21794_21836[1] = 6);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21790 === 5))
{var inst_21731 = cljs.core.deref.call(null,mults);var inst_21732 = cljs.core.vals.call(null,inst_21731);var inst_21733 = cljs.core.seq.call(null,inst_21732);var inst_21734 = inst_21733;var inst_21735 = null;var inst_21736 = 0;var inst_21737 = 0;var state_21789__$1 = (function (){var statearr_21795 = state_21789;(statearr_21795[8] = inst_21735);
(statearr_21795[9] = inst_21734);
(statearr_21795[10] = inst_21737);
(statearr_21795[11] = inst_21736);
return statearr_21795;
})();var statearr_21796_21837 = state_21789__$1;(statearr_21796_21837[2] = null);
(statearr_21796_21837[1] = 8);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21790 === 6))
{var inst_21772 = (state_21789[12]);var inst_21724 = (state_21789[7]);var inst_21772__$1 = topic_fn.call(null,inst_21724);var inst_21773 = cljs.core.deref.call(null,mults);var inst_21774 = cljs.core.get.call(null,inst_21773,inst_21772__$1);var inst_21775 = cljs.core.async.muxch_STAR_.call(null,inst_21774);var state_21789__$1 = (function (){var statearr_21797 = state_21789;(statearr_21797[12] = inst_21772__$1);
return statearr_21797;
})();return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21789__$1,19,inst_21775,inst_21724);
} else
{if((state_val_21790 === 7))
{var inst_21785 = (state_21789[2]);var state_21789__$1 = state_21789;var statearr_21798_21838 = state_21789__$1;(statearr_21798_21838[2] = inst_21785);
(statearr_21798_21838[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21790 === 8))
{var inst_21737 = (state_21789[10]);var inst_21736 = (state_21789[11]);var inst_21739 = (inst_21737 < inst_21736);var inst_21740 = inst_21739;var state_21789__$1 = state_21789;if(cljs.core.truth_(inst_21740))
{var statearr_21802_21839 = state_21789__$1;(statearr_21802_21839[1] = 10);
} else
{var statearr_21803_21840 = state_21789__$1;(statearr_21803_21840[1] = 11);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21790 === 9))
{var inst_21770 = (state_21789[2]);var state_21789__$1 = state_21789;var statearr_21804_21841 = state_21789__$1;(statearr_21804_21841[2] = inst_21770);
(statearr_21804_21841[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21790 === 10))
{var inst_21735 = (state_21789[8]);var inst_21734 = (state_21789[9]);var inst_21737 = (state_21789[10]);var inst_21736 = (state_21789[11]);var inst_21742 = cljs.core._nth.call(null,inst_21735,inst_21737);var inst_21743 = cljs.core.async.muxch_STAR_.call(null,inst_21742);var inst_21744 = cljs.core.async.close_BANG_.call(null,inst_21743);var inst_21745 = (inst_21737 + 1);var tmp21799 = inst_21735;var tmp21800 = inst_21734;var tmp21801 = inst_21736;var inst_21734__$1 = tmp21800;var inst_21735__$1 = tmp21799;var inst_21736__$1 = tmp21801;var inst_21737__$1 = inst_21745;var state_21789__$1 = (function (){var statearr_21805 = state_21789;(statearr_21805[8] = inst_21735__$1);
(statearr_21805[9] = inst_21734__$1);
(statearr_21805[10] = inst_21737__$1);
(statearr_21805[11] = inst_21736__$1);
(statearr_21805[13] = inst_21744);
return statearr_21805;
})();var statearr_21806_21842 = state_21789__$1;(statearr_21806_21842[2] = null);
(statearr_21806_21842[1] = 8);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21790 === 11))
{var inst_21748 = (state_21789[14]);var inst_21734 = (state_21789[9]);var inst_21748__$1 = cljs.core.seq.call(null,inst_21734);var state_21789__$1 = (function (){var statearr_21807 = state_21789;(statearr_21807[14] = inst_21748__$1);
return statearr_21807;
})();if(inst_21748__$1)
{var statearr_21808_21843 = state_21789__$1;(statearr_21808_21843[1] = 13);
} else
{var statearr_21809_21844 = state_21789__$1;(statearr_21809_21844[1] = 14);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21790 === 12))
{var inst_21768 = (state_21789[2]);var state_21789__$1 = state_21789;var statearr_21810_21845 = state_21789__$1;(statearr_21810_21845[2] = inst_21768);
(statearr_21810_21845[1] = 9);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21790 === 13))
{var inst_21748 = (state_21789[14]);var inst_21750 = cljs.core.chunked_seq_QMARK_.call(null,inst_21748);var state_21789__$1 = state_21789;if(inst_21750)
{var statearr_21811_21846 = state_21789__$1;(statearr_21811_21846[1] = 16);
} else
{var statearr_21812_21847 = state_21789__$1;(statearr_21812_21847[1] = 17);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21790 === 14))
{var state_21789__$1 = state_21789;var statearr_21813_21848 = state_21789__$1;(statearr_21813_21848[2] = null);
(statearr_21813_21848[1] = 15);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21790 === 15))
{var inst_21766 = (state_21789[2]);var state_21789__$1 = state_21789;var statearr_21814_21849 = state_21789__$1;(statearr_21814_21849[2] = inst_21766);
(statearr_21814_21849[1] = 12);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21790 === 16))
{var inst_21748 = (state_21789[14]);var inst_21752 = cljs.core.chunk_first.call(null,inst_21748);var inst_21753 = cljs.core.chunk_rest.call(null,inst_21748);var inst_21754 = cljs.core.count.call(null,inst_21752);var inst_21734 = inst_21753;var inst_21735 = inst_21752;var inst_21736 = inst_21754;var inst_21737 = 0;var state_21789__$1 = (function (){var statearr_21815 = state_21789;(statearr_21815[8] = inst_21735);
(statearr_21815[9] = inst_21734);
(statearr_21815[10] = inst_21737);
(statearr_21815[11] = inst_21736);
return statearr_21815;
})();var statearr_21816_21850 = state_21789__$1;(statearr_21816_21850[2] = null);
(statearr_21816_21850[1] = 8);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21790 === 17))
{var inst_21748 = (state_21789[14]);var inst_21757 = cljs.core.first.call(null,inst_21748);var inst_21758 = cljs.core.async.muxch_STAR_.call(null,inst_21757);var inst_21759 = cljs.core.async.close_BANG_.call(null,inst_21758);var inst_21760 = cljs.core.next.call(null,inst_21748);var inst_21734 = inst_21760;var inst_21735 = null;var inst_21736 = 0;var inst_21737 = 0;var state_21789__$1 = (function (){var statearr_21817 = state_21789;(statearr_21817[15] = inst_21759);
(statearr_21817[8] = inst_21735);
(statearr_21817[9] = inst_21734);
(statearr_21817[10] = inst_21737);
(statearr_21817[11] = inst_21736);
return statearr_21817;
})();var statearr_21818_21851 = state_21789__$1;(statearr_21818_21851[2] = null);
(statearr_21818_21851[1] = 8);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21790 === 18))
{var inst_21763 = (state_21789[2]);var state_21789__$1 = state_21789;var statearr_21819_21852 = state_21789__$1;(statearr_21819_21852[2] = inst_21763);
(statearr_21819_21852[1] = 15);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21790 === 19))
{var inst_21777 = (state_21789[2]);var state_21789__$1 = state_21789;if(cljs.core.truth_(inst_21777))
{var statearr_21820_21853 = state_21789__$1;(statearr_21820_21853[1] = 20);
} else
{var statearr_21821_21854 = state_21789__$1;(statearr_21821_21854[1] = 21);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21790 === 20))
{var state_21789__$1 = state_21789;var statearr_21822_21855 = state_21789__$1;(statearr_21822_21855[2] = null);
(statearr_21822_21855[1] = 22);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21790 === 21))
{var inst_21772 = (state_21789[12]);var inst_21780 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_21772);var state_21789__$1 = state_21789;var statearr_21823_21856 = state_21789__$1;(statearr_21823_21856[2] = inst_21780);
(statearr_21823_21856[1] = 22);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21790 === 22))
{var inst_21782 = (state_21789[2]);var state_21789__$1 = (function (){var statearr_21824 = state_21789;(statearr_21824[16] = inst_21782);
return statearr_21824;
})();var statearr_21825_21857 = state_21789__$1;(statearr_21825_21857[2] = null);
(statearr_21825_21857[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11722__auto___21833,mults,ensure_mult,p))
;return ((function (switch__11651__auto__,c__11722__auto___21833,mults,ensure_mult,p){
return (function() {
var state_machine__11652__auto__ = null;
var state_machine__11652__auto____0 = (function (){var statearr_21829 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_21829[0] = state_machine__11652__auto__);
(statearr_21829[1] = 1);
return statearr_21829;
});
var state_machine__11652__auto____1 = (function (state_21789){while(true){
var ret_value__11653__auto__ = (function (){try{while(true){
var result__11654__auto__ = switch__11651__auto__.call(null,state_21789);if(cljs.core.keyword_identical_QMARK_.call(null,result__11654__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__11654__auto__;
}
break;
}
}catch (e21830){if((e21830 instanceof Object))
{var ex__11655__auto__ = e21830;var statearr_21831_21858 = state_21789;(statearr_21831_21858[5] = ex__11655__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21789);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e21830;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11653__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__21859 = state_21789;
state_21789 = G__21859;
continue;
}
} else
{return ret_value__11653__auto__;
}
break;
}
});
state_machine__11652__auto__ = function(state_21789){
switch(arguments.length){
case 0:
return state_machine__11652__auto____0.call(this);
case 1:
return state_machine__11652__auto____1.call(this,state_21789);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11652__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11652__auto____0;
state_machine__11652__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11652__auto____1;
return state_machine__11652__auto__;
})()
;})(switch__11651__auto__,c__11722__auto___21833,mults,ensure_mult,p))
})();var state__11724__auto__ = (function (){var statearr_21832 = f__11723__auto__.call(null);(statearr_21832[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11722__auto___21833);
return statearr_21832;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11724__auto__);
});})(c__11722__auto___21833,mults,ensure_mult,p))
);
return p;
});
pub = function(ch,topic_fn,buf_fn){
switch(arguments.length){
case 2:
return pub__2.call(this,ch,topic_fn);
case 3:
return pub__3.call(this,ch,topic_fn,buf_fn);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pub.cljs$core$IFn$_invoke$arity$2 = pub__2;
pub.cljs$core$IFn$_invoke$arity$3 = pub__3;
return pub;
})()
;
/**
* Subscribes a channel to a topic of a pub.
* 
* By default the channel will be closed when the source closes,
* but can be determined by the close? parameter.
*/
cljs.core.async.sub = (function() {
var sub = null;
var sub__3 = (function (p,topic,ch){return sub.call(null,p,topic,ch,true);
});
var sub__4 = (function (p,topic,ch,close_QMARK_){return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});
sub = function(p,topic,ch,close_QMARK_){
switch(arguments.length){
case 3:
return sub__3.call(this,p,topic,ch);
case 4:
return sub__4.call(this,p,topic,ch,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
sub.cljs$core$IFn$_invoke$arity$3 = sub__3;
sub.cljs$core$IFn$_invoke$arity$4 = sub__4;
return sub;
})()
;
/**
* Unsubscribes a channel from a topic of a pub
*/
cljs.core.async.unsub = (function unsub(p,topic,ch){return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
* Unsubscribes all channels from a pub, or a topic of a pub
*/
cljs.core.async.unsub_all = (function() {
var unsub_all = null;
var unsub_all__1 = (function (p){return cljs.core.async.unsub_all_STAR_.call(null,p);
});
var unsub_all__2 = (function (p,topic){return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});
unsub_all = function(p,topic){
switch(arguments.length){
case 1:
return unsub_all__1.call(this,p);
case 2:
return unsub_all__2.call(this,p,topic);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unsub_all.cljs$core$IFn$_invoke$arity$1 = unsub_all__1;
unsub_all.cljs$core$IFn$_invoke$arity$2 = unsub_all__2;
return unsub_all;
})()
;
/**
* Takes a function and a collection of source channels, and returns a
* channel which contains the values produced by applying f to the set
* of first items taken from each source channel, followed by applying
* f to the set of second items from each channel, until any one of the
* channels is closed, at which point the output channel will be
* closed. The returned channel will be unbuffered by default, or a
* buf-or-n can be supplied
*/
cljs.core.async.map = (function() {
var map = null;
var map__2 = (function (f,chs){return map.call(null,f,chs,null);
});
var map__3 = (function (f,chs,buf_or_n){var chs__$1 = cljs.core.vec.call(null,chs);var out = cljs.core.async.chan.call(null,buf_or_n);var cnt = cljs.core.count.call(null,chs__$1);var rets = cljs.core.object_array.call(null,cnt);var dchan = cljs.core.async.chan.call(null,1);var dctr = cljs.core.atom.call(null,null);var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){(rets[i] = ret);
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === 0))
{return cljs.core.async.put_BANG_.call(null,dchan,rets.slice(0));
} else
{return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));var c__11722__auto___21996 = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,((function (c__11722__auto___21996,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){var f__11723__auto__ = (function (){var switch__11651__auto__ = ((function (c__11722__auto___21996,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_21966){var state_val_21967 = (state_21966[1]);if((state_val_21967 === 1))
{var state_21966__$1 = state_21966;var statearr_21968_21997 = state_21966__$1;(statearr_21968_21997[2] = null);
(statearr_21968_21997[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21967 === 2))
{var inst_21929 = cljs.core.reset_BANG_.call(null,dctr,cnt);var inst_21930 = 0;var state_21966__$1 = (function (){var statearr_21969 = state_21966;(statearr_21969[7] = inst_21930);
(statearr_21969[8] = inst_21929);
return statearr_21969;
})();var statearr_21970_21998 = state_21966__$1;(statearr_21970_21998[2] = null);
(statearr_21970_21998[1] = 4);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21967 === 3))
{var inst_21964 = (state_21966[2]);var state_21966__$1 = state_21966;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21966__$1,inst_21964);
} else
{if((state_val_21967 === 4))
{var inst_21930 = (state_21966[7]);var inst_21932 = (inst_21930 < cnt);var state_21966__$1 = state_21966;if(cljs.core.truth_(inst_21932))
{var statearr_21971_21999 = state_21966__$1;(statearr_21971_21999[1] = 6);
} else
{var statearr_21972_22000 = state_21966__$1;(statearr_21972_22000[1] = 7);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21967 === 5))
{var inst_21950 = (state_21966[2]);var state_21966__$1 = (function (){var statearr_21973 = state_21966;(statearr_21973[9] = inst_21950);
return statearr_21973;
})();return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21966__$1,12,dchan);
} else
{if((state_val_21967 === 6))
{var state_21966__$1 = state_21966;var statearr_21974_22001 = state_21966__$1;(statearr_21974_22001[2] = null);
(statearr_21974_22001[1] = 11);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21967 === 7))
{var state_21966__$1 = state_21966;var statearr_21975_22002 = state_21966__$1;(statearr_21975_22002[2] = null);
(statearr_21975_22002[1] = 8);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21967 === 8))
{var inst_21948 = (state_21966[2]);var state_21966__$1 = state_21966;var statearr_21976_22003 = state_21966__$1;(statearr_21976_22003[2] = inst_21948);
(statearr_21976_22003[1] = 5);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21967 === 9))
{var inst_21930 = (state_21966[7]);var inst_21943 = (state_21966[2]);var inst_21944 = (inst_21930 + 1);var inst_21930__$1 = inst_21944;var state_21966__$1 = (function (){var statearr_21977 = state_21966;(statearr_21977[10] = inst_21943);
(statearr_21977[7] = inst_21930__$1);
return statearr_21977;
})();var statearr_21978_22004 = state_21966__$1;(statearr_21978_22004[2] = null);
(statearr_21978_22004[1] = 4);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21967 === 10))
{var inst_21934 = (state_21966[2]);var inst_21935 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);var state_21966__$1 = (function (){var statearr_21979 = state_21966;(statearr_21979[11] = inst_21934);
return statearr_21979;
})();var statearr_21980_22005 = state_21966__$1;(statearr_21980_22005[2] = inst_21935);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21966__$1);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21967 === 11))
{var inst_21930 = (state_21966[7]);var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_21966,10,Object,null,9);var inst_21939 = chs__$1.call(null,inst_21930);var inst_21940 = done.call(null,inst_21930);var inst_21941 = cljs.core.async.take_BANG_.call(null,inst_21939,inst_21940);var state_21966__$1 = state_21966;var statearr_21981_22006 = state_21966__$1;(statearr_21981_22006[2] = inst_21941);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21966__$1);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21967 === 12))
{var inst_21952 = (state_21966[12]);var inst_21952__$1 = (state_21966[2]);var inst_21953 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_21952__$1);var state_21966__$1 = (function (){var statearr_21982 = state_21966;(statearr_21982[12] = inst_21952__$1);
return statearr_21982;
})();if(cljs.core.truth_(inst_21953))
{var statearr_21983_22007 = state_21966__$1;(statearr_21983_22007[1] = 13);
} else
{var statearr_21984_22008 = state_21966__$1;(statearr_21984_22008[1] = 14);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21967 === 13))
{var inst_21955 = cljs.core.async.close_BANG_.call(null,out);var state_21966__$1 = state_21966;var statearr_21985_22009 = state_21966__$1;(statearr_21985_22009[2] = inst_21955);
(statearr_21985_22009[1] = 15);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21967 === 14))
{var inst_21952 = (state_21966[12]);var inst_21957 = cljs.core.apply.call(null,f,inst_21952);var state_21966__$1 = state_21966;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21966__$1,16,out,inst_21957);
} else
{if((state_val_21967 === 15))
{var inst_21962 = (state_21966[2]);var state_21966__$1 = state_21966;var statearr_21986_22010 = state_21966__$1;(statearr_21986_22010[2] = inst_21962);
(statearr_21986_22010[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_21967 === 16))
{var inst_21959 = (state_21966[2]);var state_21966__$1 = (function (){var statearr_21987 = state_21966;(statearr_21987[13] = inst_21959);
return statearr_21987;
})();var statearr_21988_22011 = state_21966__$1;(statearr_21988_22011[2] = null);
(statearr_21988_22011[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11722__auto___21996,chs__$1,out,cnt,rets,dchan,dctr,done))
;return ((function (switch__11651__auto__,c__11722__auto___21996,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var state_machine__11652__auto__ = null;
var state_machine__11652__auto____0 = (function (){var statearr_21992 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_21992[0] = state_machine__11652__auto__);
(statearr_21992[1] = 1);
return statearr_21992;
});
var state_machine__11652__auto____1 = (function (state_21966){while(true){
var ret_value__11653__auto__ = (function (){try{while(true){
var result__11654__auto__ = switch__11651__auto__.call(null,state_21966);if(cljs.core.keyword_identical_QMARK_.call(null,result__11654__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__11654__auto__;
}
break;
}
}catch (e21993){if((e21993 instanceof Object))
{var ex__11655__auto__ = e21993;var statearr_21994_22012 = state_21966;(statearr_21994_22012[5] = ex__11655__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21966);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e21993;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11653__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__22013 = state_21966;
state_21966 = G__22013;
continue;
}
} else
{return ret_value__11653__auto__;
}
break;
}
});
state_machine__11652__auto__ = function(state_21966){
switch(arguments.length){
case 0:
return state_machine__11652__auto____0.call(this);
case 1:
return state_machine__11652__auto____1.call(this,state_21966);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11652__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11652__auto____0;
state_machine__11652__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11652__auto____1;
return state_machine__11652__auto__;
})()
;})(switch__11651__auto__,c__11722__auto___21996,chs__$1,out,cnt,rets,dchan,dctr,done))
})();var state__11724__auto__ = (function (){var statearr_21995 = f__11723__auto__.call(null);(statearr_21995[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11722__auto___21996);
return statearr_21995;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11724__auto__);
});})(c__11722__auto___21996,chs__$1,out,cnt,rets,dchan,dctr,done))
);
return out;
});
map = function(f,chs,buf_or_n){
switch(arguments.length){
case 2:
return map__2.call(this,f,chs);
case 3:
return map__3.call(this,f,chs,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
map.cljs$core$IFn$_invoke$arity$2 = map__2;
map.cljs$core$IFn$_invoke$arity$3 = map__3;
return map;
})()
;
/**
* Takes a collection of source channels and returns a channel which
* contains all values taken from them. The returned channel will be
* unbuffered by default, or a buf-or-n can be supplied. The channel
* will close after all the source channels have closed.
*/
cljs.core.async.merge = (function() {
var merge = null;
var merge__1 = (function (chs){return merge.call(null,chs,null);
});
var merge__2 = (function (chs,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__11722__auto___22121 = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,((function (c__11722__auto___22121,out){
return (function (){var f__11723__auto__ = (function (){var switch__11651__auto__ = ((function (c__11722__auto___22121,out){
return (function (state_22097){var state_val_22098 = (state_22097[1]);if((state_val_22098 === 1))
{var inst_22068 = cljs.core.vec.call(null,chs);var inst_22069 = inst_22068;var state_22097__$1 = (function (){var statearr_22099 = state_22097;(statearr_22099[7] = inst_22069);
return statearr_22099;
})();var statearr_22100_22122 = state_22097__$1;(statearr_22100_22122[2] = null);
(statearr_22100_22122[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22098 === 2))
{var inst_22069 = (state_22097[7]);var inst_22071 = cljs.core.count.call(null,inst_22069);var inst_22072 = (inst_22071 > 0);var state_22097__$1 = state_22097;if(cljs.core.truth_(inst_22072))
{var statearr_22101_22123 = state_22097__$1;(statearr_22101_22123[1] = 4);
} else
{var statearr_22102_22124 = state_22097__$1;(statearr_22102_22124[1] = 5);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22098 === 3))
{var inst_22095 = (state_22097[2]);var state_22097__$1 = state_22097;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22097__$1,inst_22095);
} else
{if((state_val_22098 === 4))
{var inst_22069 = (state_22097[7]);var state_22097__$1 = state_22097;return cljs.core.async.impl.ioc_helpers.ioc_alts_BANG_.call(null,state_22097__$1,7,inst_22069);
} else
{if((state_val_22098 === 5))
{var inst_22091 = cljs.core.async.close_BANG_.call(null,out);var state_22097__$1 = state_22097;var statearr_22103_22125 = state_22097__$1;(statearr_22103_22125[2] = inst_22091);
(statearr_22103_22125[1] = 6);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22098 === 6))
{var inst_22093 = (state_22097[2]);var state_22097__$1 = state_22097;var statearr_22104_22126 = state_22097__$1;(statearr_22104_22126[2] = inst_22093);
(statearr_22104_22126[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22098 === 7))
{var inst_22076 = (state_22097[8]);var inst_22077 = (state_22097[9]);var inst_22076__$1 = (state_22097[2]);var inst_22077__$1 = cljs.core.nth.call(null,inst_22076__$1,0,null);var inst_22078 = cljs.core.nth.call(null,inst_22076__$1,1,null);var inst_22079 = (inst_22077__$1 == null);var state_22097__$1 = (function (){var statearr_22105 = state_22097;(statearr_22105[10] = inst_22078);
(statearr_22105[8] = inst_22076__$1);
(statearr_22105[9] = inst_22077__$1);
return statearr_22105;
})();if(cljs.core.truth_(inst_22079))
{var statearr_22106_22127 = state_22097__$1;(statearr_22106_22127[1] = 8);
} else
{var statearr_22107_22128 = state_22097__$1;(statearr_22107_22128[1] = 9);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22098 === 8))
{var inst_22078 = (state_22097[10]);var inst_22076 = (state_22097[8]);var inst_22077 = (state_22097[9]);var inst_22069 = (state_22097[7]);var inst_22081 = (function (){var c = inst_22078;var v = inst_22077;var vec__22074 = inst_22076;var cs = inst_22069;return ((function (c,v,vec__22074,cs,inst_22078,inst_22076,inst_22077,inst_22069,state_val_22098,c__11722__auto___22121,out){
return (function (p1__22014_SHARP_){return cljs.core.not_EQ_.call(null,c,p1__22014_SHARP_);
});
;})(c,v,vec__22074,cs,inst_22078,inst_22076,inst_22077,inst_22069,state_val_22098,c__11722__auto___22121,out))
})();var inst_22082 = cljs.core.filterv.call(null,inst_22081,inst_22069);var inst_22069__$1 = inst_22082;var state_22097__$1 = (function (){var statearr_22108 = state_22097;(statearr_22108[7] = inst_22069__$1);
return statearr_22108;
})();var statearr_22109_22129 = state_22097__$1;(statearr_22109_22129[2] = null);
(statearr_22109_22129[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22098 === 9))
{var inst_22077 = (state_22097[9]);var state_22097__$1 = state_22097;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22097__$1,11,out,inst_22077);
} else
{if((state_val_22098 === 10))
{var inst_22089 = (state_22097[2]);var state_22097__$1 = state_22097;var statearr_22111_22130 = state_22097__$1;(statearr_22111_22130[2] = inst_22089);
(statearr_22111_22130[1] = 6);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22098 === 11))
{var inst_22069 = (state_22097[7]);var inst_22086 = (state_22097[2]);var tmp22110 = inst_22069;var inst_22069__$1 = tmp22110;var state_22097__$1 = (function (){var statearr_22112 = state_22097;(statearr_22112[7] = inst_22069__$1);
(statearr_22112[11] = inst_22086);
return statearr_22112;
})();var statearr_22113_22131 = state_22097__$1;(statearr_22113_22131[2] = null);
(statearr_22113_22131[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11722__auto___22121,out))
;return ((function (switch__11651__auto__,c__11722__auto___22121,out){
return (function() {
var state_machine__11652__auto__ = null;
var state_machine__11652__auto____0 = (function (){var statearr_22117 = [null,null,null,null,null,null,null,null,null,null,null,null];(statearr_22117[0] = state_machine__11652__auto__);
(statearr_22117[1] = 1);
return statearr_22117;
});
var state_machine__11652__auto____1 = (function (state_22097){while(true){
var ret_value__11653__auto__ = (function (){try{while(true){
var result__11654__auto__ = switch__11651__auto__.call(null,state_22097);if(cljs.core.keyword_identical_QMARK_.call(null,result__11654__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__11654__auto__;
}
break;
}
}catch (e22118){if((e22118 instanceof Object))
{var ex__11655__auto__ = e22118;var statearr_22119_22132 = state_22097;(statearr_22119_22132[5] = ex__11655__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22097);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e22118;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11653__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__22133 = state_22097;
state_22097 = G__22133;
continue;
}
} else
{return ret_value__11653__auto__;
}
break;
}
});
state_machine__11652__auto__ = function(state_22097){
switch(arguments.length){
case 0:
return state_machine__11652__auto____0.call(this);
case 1:
return state_machine__11652__auto____1.call(this,state_22097);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11652__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11652__auto____0;
state_machine__11652__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11652__auto____1;
return state_machine__11652__auto__;
})()
;})(switch__11651__auto__,c__11722__auto___22121,out))
})();var state__11724__auto__ = (function (){var statearr_22120 = f__11723__auto__.call(null);(statearr_22120[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11722__auto___22121);
return statearr_22120;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11724__auto__);
});})(c__11722__auto___22121,out))
);
return out;
});
merge = function(chs,buf_or_n){
switch(arguments.length){
case 1:
return merge__1.call(this,chs);
case 2:
return merge__2.call(this,chs,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
merge.cljs$core$IFn$_invoke$arity$1 = merge__1;
merge.cljs$core$IFn$_invoke$arity$2 = merge__2;
return merge;
})()
;
/**
* Returns a channel containing the single (collection) result of the
* items taken from the channel conjoined to the supplied
* collection. ch must close before into produces a result.
*/
cljs.core.async.into = (function into(coll,ch){return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
* Returns a channel that will return, at most, n items from ch. After n items
* have been returned, or ch has been closed, the return chanel will close.
* 
* The output channel is unbuffered by default, unless buf-or-n is given.
*/
cljs.core.async.take = (function() {
var take = null;
var take__2 = (function (n,ch){return take.call(null,n,ch,null);
});
var take__3 = (function (n,ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__11722__auto___22226 = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,((function (c__11722__auto___22226,out){
return (function (){var f__11723__auto__ = (function (){var switch__11651__auto__ = ((function (c__11722__auto___22226,out){
return (function (state_22203){var state_val_22204 = (state_22203[1]);if((state_val_22204 === 1))
{var inst_22180 = 0;var state_22203__$1 = (function (){var statearr_22205 = state_22203;(statearr_22205[7] = inst_22180);
return statearr_22205;
})();var statearr_22206_22227 = state_22203__$1;(statearr_22206_22227[2] = null);
(statearr_22206_22227[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22204 === 2))
{var inst_22180 = (state_22203[7]);var inst_22182 = (inst_22180 < n);var state_22203__$1 = state_22203;if(cljs.core.truth_(inst_22182))
{var statearr_22207_22228 = state_22203__$1;(statearr_22207_22228[1] = 4);
} else
{var statearr_22208_22229 = state_22203__$1;(statearr_22208_22229[1] = 5);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22204 === 3))
{var inst_22200 = (state_22203[2]);var inst_22201 = cljs.core.async.close_BANG_.call(null,out);var state_22203__$1 = (function (){var statearr_22209 = state_22203;(statearr_22209[8] = inst_22200);
return statearr_22209;
})();return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22203__$1,inst_22201);
} else
{if((state_val_22204 === 4))
{var state_22203__$1 = state_22203;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22203__$1,7,ch);
} else
{if((state_val_22204 === 5))
{var state_22203__$1 = state_22203;var statearr_22210_22230 = state_22203__$1;(statearr_22210_22230[2] = null);
(statearr_22210_22230[1] = 6);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22204 === 6))
{var inst_22198 = (state_22203[2]);var state_22203__$1 = state_22203;var statearr_22211_22231 = state_22203__$1;(statearr_22211_22231[2] = inst_22198);
(statearr_22211_22231[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22204 === 7))
{var inst_22185 = (state_22203[9]);var inst_22185__$1 = (state_22203[2]);var inst_22186 = (inst_22185__$1 == null);var inst_22187 = cljs.core.not.call(null,inst_22186);var state_22203__$1 = (function (){var statearr_22212 = state_22203;(statearr_22212[9] = inst_22185__$1);
return statearr_22212;
})();if(inst_22187)
{var statearr_22213_22232 = state_22203__$1;(statearr_22213_22232[1] = 8);
} else
{var statearr_22214_22233 = state_22203__$1;(statearr_22214_22233[1] = 9);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22204 === 8))
{var inst_22185 = (state_22203[9]);var state_22203__$1 = state_22203;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22203__$1,11,out,inst_22185);
} else
{if((state_val_22204 === 9))
{var state_22203__$1 = state_22203;var statearr_22215_22234 = state_22203__$1;(statearr_22215_22234[2] = null);
(statearr_22215_22234[1] = 10);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22204 === 10))
{var inst_22195 = (state_22203[2]);var state_22203__$1 = state_22203;var statearr_22216_22235 = state_22203__$1;(statearr_22216_22235[2] = inst_22195);
(statearr_22216_22235[1] = 6);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22204 === 11))
{var inst_22180 = (state_22203[7]);var inst_22190 = (state_22203[2]);var inst_22191 = (inst_22180 + 1);var inst_22180__$1 = inst_22191;var state_22203__$1 = (function (){var statearr_22217 = state_22203;(statearr_22217[7] = inst_22180__$1);
(statearr_22217[10] = inst_22190);
return statearr_22217;
})();var statearr_22218_22236 = state_22203__$1;(statearr_22218_22236[2] = null);
(statearr_22218_22236[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11722__auto___22226,out))
;return ((function (switch__11651__auto__,c__11722__auto___22226,out){
return (function() {
var state_machine__11652__auto__ = null;
var state_machine__11652__auto____0 = (function (){var statearr_22222 = [null,null,null,null,null,null,null,null,null,null,null];(statearr_22222[0] = state_machine__11652__auto__);
(statearr_22222[1] = 1);
return statearr_22222;
});
var state_machine__11652__auto____1 = (function (state_22203){while(true){
var ret_value__11653__auto__ = (function (){try{while(true){
var result__11654__auto__ = switch__11651__auto__.call(null,state_22203);if(cljs.core.keyword_identical_QMARK_.call(null,result__11654__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__11654__auto__;
}
break;
}
}catch (e22223){if((e22223 instanceof Object))
{var ex__11655__auto__ = e22223;var statearr_22224_22237 = state_22203;(statearr_22224_22237[5] = ex__11655__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22203);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e22223;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11653__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__22238 = state_22203;
state_22203 = G__22238;
continue;
}
} else
{return ret_value__11653__auto__;
}
break;
}
});
state_machine__11652__auto__ = function(state_22203){
switch(arguments.length){
case 0:
return state_machine__11652__auto____0.call(this);
case 1:
return state_machine__11652__auto____1.call(this,state_22203);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11652__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11652__auto____0;
state_machine__11652__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11652__auto____1;
return state_machine__11652__auto__;
})()
;})(switch__11651__auto__,c__11722__auto___22226,out))
})();var state__11724__auto__ = (function (){var statearr_22225 = f__11723__auto__.call(null);(statearr_22225[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11722__auto___22226);
return statearr_22225;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11724__auto__);
});})(c__11722__auto___22226,out))
);
return out;
});
take = function(n,ch,buf_or_n){
switch(arguments.length){
case 2:
return take__2.call(this,n,ch);
case 3:
return take__3.call(this,n,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
take.cljs$core$IFn$_invoke$arity$2 = take__2;
take.cljs$core$IFn$_invoke$arity$3 = take__3;
return take;
})()
;
/**
* Returns a channel that will contain values from ch. Consecutive duplicate
* values will be dropped.
* 
* The output channel is unbuffered by default, unless buf-or-n is given.
*/
cljs.core.async.unique = (function() {
var unique = null;
var unique__1 = (function (ch){return unique.call(null,ch,null);
});
var unique__2 = (function (ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__11722__auto___22335 = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,((function (c__11722__auto___22335,out){
return (function (){var f__11723__auto__ = (function (){var switch__11651__auto__ = ((function (c__11722__auto___22335,out){
return (function (state_22310){var state_val_22311 = (state_22310[1]);if((state_val_22311 === 1))
{var inst_22287 = null;var state_22310__$1 = (function (){var statearr_22312 = state_22310;(statearr_22312[7] = inst_22287);
return statearr_22312;
})();var statearr_22313_22336 = state_22310__$1;(statearr_22313_22336[2] = null);
(statearr_22313_22336[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22311 === 2))
{var state_22310__$1 = state_22310;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22310__$1,4,ch);
} else
{if((state_val_22311 === 3))
{var inst_22307 = (state_22310[2]);var inst_22308 = cljs.core.async.close_BANG_.call(null,out);var state_22310__$1 = (function (){var statearr_22314 = state_22310;(statearr_22314[8] = inst_22307);
return statearr_22314;
})();return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22310__$1,inst_22308);
} else
{if((state_val_22311 === 4))
{var inst_22290 = (state_22310[9]);var inst_22290__$1 = (state_22310[2]);var inst_22291 = (inst_22290__$1 == null);var inst_22292 = cljs.core.not.call(null,inst_22291);var state_22310__$1 = (function (){var statearr_22315 = state_22310;(statearr_22315[9] = inst_22290__$1);
return statearr_22315;
})();if(inst_22292)
{var statearr_22316_22337 = state_22310__$1;(statearr_22316_22337[1] = 5);
} else
{var statearr_22317_22338 = state_22310__$1;(statearr_22317_22338[1] = 6);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22311 === 5))
{var inst_22290 = (state_22310[9]);var inst_22287 = (state_22310[7]);var inst_22294 = cljs.core._EQ_.call(null,inst_22290,inst_22287);var state_22310__$1 = state_22310;if(inst_22294)
{var statearr_22318_22339 = state_22310__$1;(statearr_22318_22339[1] = 8);
} else
{var statearr_22319_22340 = state_22310__$1;(statearr_22319_22340[1] = 9);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22311 === 6))
{var state_22310__$1 = state_22310;var statearr_22321_22341 = state_22310__$1;(statearr_22321_22341[2] = null);
(statearr_22321_22341[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22311 === 7))
{var inst_22305 = (state_22310[2]);var state_22310__$1 = state_22310;var statearr_22322_22342 = state_22310__$1;(statearr_22322_22342[2] = inst_22305);
(statearr_22322_22342[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22311 === 8))
{var inst_22287 = (state_22310[7]);var tmp22320 = inst_22287;var inst_22287__$1 = tmp22320;var state_22310__$1 = (function (){var statearr_22323 = state_22310;(statearr_22323[7] = inst_22287__$1);
return statearr_22323;
})();var statearr_22324_22343 = state_22310__$1;(statearr_22324_22343[2] = null);
(statearr_22324_22343[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22311 === 9))
{var inst_22290 = (state_22310[9]);var state_22310__$1 = state_22310;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22310__$1,11,out,inst_22290);
} else
{if((state_val_22311 === 10))
{var inst_22302 = (state_22310[2]);var state_22310__$1 = state_22310;var statearr_22325_22344 = state_22310__$1;(statearr_22325_22344[2] = inst_22302);
(statearr_22325_22344[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22311 === 11))
{var inst_22290 = (state_22310[9]);var inst_22299 = (state_22310[2]);var inst_22287 = inst_22290;var state_22310__$1 = (function (){var statearr_22326 = state_22310;(statearr_22326[10] = inst_22299);
(statearr_22326[7] = inst_22287);
return statearr_22326;
})();var statearr_22327_22345 = state_22310__$1;(statearr_22327_22345[2] = null);
(statearr_22327_22345[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11722__auto___22335,out))
;return ((function (switch__11651__auto__,c__11722__auto___22335,out){
return (function() {
var state_machine__11652__auto__ = null;
var state_machine__11652__auto____0 = (function (){var statearr_22331 = [null,null,null,null,null,null,null,null,null,null,null];(statearr_22331[0] = state_machine__11652__auto__);
(statearr_22331[1] = 1);
return statearr_22331;
});
var state_machine__11652__auto____1 = (function (state_22310){while(true){
var ret_value__11653__auto__ = (function (){try{while(true){
var result__11654__auto__ = switch__11651__auto__.call(null,state_22310);if(cljs.core.keyword_identical_QMARK_.call(null,result__11654__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__11654__auto__;
}
break;
}
}catch (e22332){if((e22332 instanceof Object))
{var ex__11655__auto__ = e22332;var statearr_22333_22346 = state_22310;(statearr_22333_22346[5] = ex__11655__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22310);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e22332;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11653__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__22347 = state_22310;
state_22310 = G__22347;
continue;
}
} else
{return ret_value__11653__auto__;
}
break;
}
});
state_machine__11652__auto__ = function(state_22310){
switch(arguments.length){
case 0:
return state_machine__11652__auto____0.call(this);
case 1:
return state_machine__11652__auto____1.call(this,state_22310);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11652__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11652__auto____0;
state_machine__11652__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11652__auto____1;
return state_machine__11652__auto__;
})()
;})(switch__11651__auto__,c__11722__auto___22335,out))
})();var state__11724__auto__ = (function (){var statearr_22334 = f__11723__auto__.call(null);(statearr_22334[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11722__auto___22335);
return statearr_22334;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11724__auto__);
});})(c__11722__auto___22335,out))
);
return out;
});
unique = function(ch,buf_or_n){
switch(arguments.length){
case 1:
return unique__1.call(this,ch);
case 2:
return unique__2.call(this,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unique.cljs$core$IFn$_invoke$arity$1 = unique__1;
unique.cljs$core$IFn$_invoke$arity$2 = unique__2;
return unique;
})()
;
/**
* Returns a channel that will contain vectors of n items taken from ch. The
* final vector in the return channel may be smaller than n if ch closed before
* the vector could be completely filled.
* 
* The output channel is unbuffered by default, unless buf-or-n is given
*/
cljs.core.async.partition = (function() {
var partition = null;
var partition__2 = (function (n,ch){return partition.call(null,n,ch,null);
});
var partition__3 = (function (n,ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__11722__auto___22482 = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,((function (c__11722__auto___22482,out){
return (function (){var f__11723__auto__ = (function (){var switch__11651__auto__ = ((function (c__11722__auto___22482,out){
return (function (state_22452){var state_val_22453 = (state_22452[1]);if((state_val_22453 === 1))
{var inst_22415 = (new Array(n));var inst_22416 = inst_22415;var inst_22417 = 0;var state_22452__$1 = (function (){var statearr_22454 = state_22452;(statearr_22454[7] = inst_22417);
(statearr_22454[8] = inst_22416);
return statearr_22454;
})();var statearr_22455_22483 = state_22452__$1;(statearr_22455_22483[2] = null);
(statearr_22455_22483[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22453 === 2))
{var state_22452__$1 = state_22452;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22452__$1,4,ch);
} else
{if((state_val_22453 === 3))
{var inst_22450 = (state_22452[2]);var state_22452__$1 = state_22452;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22452__$1,inst_22450);
} else
{if((state_val_22453 === 4))
{var inst_22420 = (state_22452[9]);var inst_22420__$1 = (state_22452[2]);var inst_22421 = (inst_22420__$1 == null);var inst_22422 = cljs.core.not.call(null,inst_22421);var state_22452__$1 = (function (){var statearr_22456 = state_22452;(statearr_22456[9] = inst_22420__$1);
return statearr_22456;
})();if(inst_22422)
{var statearr_22457_22484 = state_22452__$1;(statearr_22457_22484[1] = 5);
} else
{var statearr_22458_22485 = state_22452__$1;(statearr_22458_22485[1] = 6);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22453 === 5))
{var inst_22425 = (state_22452[10]);var inst_22420 = (state_22452[9]);var inst_22417 = (state_22452[7]);var inst_22416 = (state_22452[8]);var inst_22424 = (inst_22416[inst_22417] = inst_22420);var inst_22425__$1 = (inst_22417 + 1);var inst_22426 = (inst_22425__$1 < n);var state_22452__$1 = (function (){var statearr_22459 = state_22452;(statearr_22459[11] = inst_22424);
(statearr_22459[10] = inst_22425__$1);
return statearr_22459;
})();if(cljs.core.truth_(inst_22426))
{var statearr_22460_22486 = state_22452__$1;(statearr_22460_22486[1] = 8);
} else
{var statearr_22461_22487 = state_22452__$1;(statearr_22461_22487[1] = 9);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22453 === 6))
{var inst_22417 = (state_22452[7]);var inst_22438 = (inst_22417 > 0);var state_22452__$1 = state_22452;if(cljs.core.truth_(inst_22438))
{var statearr_22463_22488 = state_22452__$1;(statearr_22463_22488[1] = 12);
} else
{var statearr_22464_22489 = state_22452__$1;(statearr_22464_22489[1] = 13);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22453 === 7))
{var inst_22448 = (state_22452[2]);var state_22452__$1 = state_22452;var statearr_22465_22490 = state_22452__$1;(statearr_22465_22490[2] = inst_22448);
(statearr_22465_22490[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22453 === 8))
{var inst_22425 = (state_22452[10]);var inst_22416 = (state_22452[8]);var tmp22462 = inst_22416;var inst_22416__$1 = tmp22462;var inst_22417 = inst_22425;var state_22452__$1 = (function (){var statearr_22466 = state_22452;(statearr_22466[7] = inst_22417);
(statearr_22466[8] = inst_22416__$1);
return statearr_22466;
})();var statearr_22467_22491 = state_22452__$1;(statearr_22467_22491[2] = null);
(statearr_22467_22491[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22453 === 9))
{var inst_22416 = (state_22452[8]);var inst_22430 = cljs.core.vec.call(null,inst_22416);var state_22452__$1 = state_22452;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22452__$1,11,out,inst_22430);
} else
{if((state_val_22453 === 10))
{var inst_22436 = (state_22452[2]);var state_22452__$1 = state_22452;var statearr_22468_22492 = state_22452__$1;(statearr_22468_22492[2] = inst_22436);
(statearr_22468_22492[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22453 === 11))
{var inst_22432 = (state_22452[2]);var inst_22433 = (new Array(n));var inst_22416 = inst_22433;var inst_22417 = 0;var state_22452__$1 = (function (){var statearr_22469 = state_22452;(statearr_22469[12] = inst_22432);
(statearr_22469[7] = inst_22417);
(statearr_22469[8] = inst_22416);
return statearr_22469;
})();var statearr_22470_22493 = state_22452__$1;(statearr_22470_22493[2] = null);
(statearr_22470_22493[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22453 === 12))
{var inst_22416 = (state_22452[8]);var inst_22440 = cljs.core.vec.call(null,inst_22416);var state_22452__$1 = state_22452;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22452__$1,15,out,inst_22440);
} else
{if((state_val_22453 === 13))
{var state_22452__$1 = state_22452;var statearr_22471_22494 = state_22452__$1;(statearr_22471_22494[2] = null);
(statearr_22471_22494[1] = 14);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22453 === 14))
{var inst_22445 = (state_22452[2]);var inst_22446 = cljs.core.async.close_BANG_.call(null,out);var state_22452__$1 = (function (){var statearr_22472 = state_22452;(statearr_22472[13] = inst_22445);
return statearr_22472;
})();var statearr_22473_22495 = state_22452__$1;(statearr_22473_22495[2] = inst_22446);
(statearr_22473_22495[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22453 === 15))
{var inst_22442 = (state_22452[2]);var state_22452__$1 = state_22452;var statearr_22474_22496 = state_22452__$1;(statearr_22474_22496[2] = inst_22442);
(statearr_22474_22496[1] = 14);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11722__auto___22482,out))
;return ((function (switch__11651__auto__,c__11722__auto___22482,out){
return (function() {
var state_machine__11652__auto__ = null;
var state_machine__11652__auto____0 = (function (){var statearr_22478 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_22478[0] = state_machine__11652__auto__);
(statearr_22478[1] = 1);
return statearr_22478;
});
var state_machine__11652__auto____1 = (function (state_22452){while(true){
var ret_value__11653__auto__ = (function (){try{while(true){
var result__11654__auto__ = switch__11651__auto__.call(null,state_22452);if(cljs.core.keyword_identical_QMARK_.call(null,result__11654__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__11654__auto__;
}
break;
}
}catch (e22479){if((e22479 instanceof Object))
{var ex__11655__auto__ = e22479;var statearr_22480_22497 = state_22452;(statearr_22480_22497[5] = ex__11655__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22452);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e22479;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11653__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__22498 = state_22452;
state_22452 = G__22498;
continue;
}
} else
{return ret_value__11653__auto__;
}
break;
}
});
state_machine__11652__auto__ = function(state_22452){
switch(arguments.length){
case 0:
return state_machine__11652__auto____0.call(this);
case 1:
return state_machine__11652__auto____1.call(this,state_22452);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11652__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11652__auto____0;
state_machine__11652__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11652__auto____1;
return state_machine__11652__auto__;
})()
;})(switch__11651__auto__,c__11722__auto___22482,out))
})();var state__11724__auto__ = (function (){var statearr_22481 = f__11723__auto__.call(null);(statearr_22481[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11722__auto___22482);
return statearr_22481;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11724__auto__);
});})(c__11722__auto___22482,out))
);
return out;
});
partition = function(n,ch,buf_or_n){
switch(arguments.length){
case 2:
return partition__2.call(this,n,ch);
case 3:
return partition__3.call(this,n,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
partition.cljs$core$IFn$_invoke$arity$2 = partition__2;
partition.cljs$core$IFn$_invoke$arity$3 = partition__3;
return partition;
})()
;
/**
* Returns a channel that will contain vectors of items taken from ch. New
* vectors will be created whenever (f itm) returns a value that differs from
* the previous item's (f itm).
* 
* The output channel is unbuffered, unless buf-or-n is given
*/
cljs.core.async.partition_by = (function() {
var partition_by = null;
var partition_by__2 = (function (f,ch){return partition_by.call(null,f,ch,null);
});
var partition_by__3 = (function (f,ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__11722__auto___22641 = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,((function (c__11722__auto___22641,out){
return (function (){var f__11723__auto__ = (function (){var switch__11651__auto__ = ((function (c__11722__auto___22641,out){
return (function (state_22611){var state_val_22612 = (state_22611[1]);if((state_val_22612 === 1))
{var inst_22570 = [];var inst_22571 = inst_22570;var inst_22572 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",4382193538);var state_22611__$1 = (function (){var statearr_22613 = state_22611;(statearr_22613[7] = inst_22571);
(statearr_22613[8] = inst_22572);
return statearr_22613;
})();var statearr_22614_22642 = state_22611__$1;(statearr_22614_22642[2] = null);
(statearr_22614_22642[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22612 === 2))
{var state_22611__$1 = state_22611;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22611__$1,4,ch);
} else
{if((state_val_22612 === 3))
{var inst_22609 = (state_22611[2]);var state_22611__$1 = state_22611;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22611__$1,inst_22609);
} else
{if((state_val_22612 === 4))
{var inst_22575 = (state_22611[9]);var inst_22575__$1 = (state_22611[2]);var inst_22576 = (inst_22575__$1 == null);var inst_22577 = cljs.core.not.call(null,inst_22576);var state_22611__$1 = (function (){var statearr_22615 = state_22611;(statearr_22615[9] = inst_22575__$1);
return statearr_22615;
})();if(inst_22577)
{var statearr_22616_22643 = state_22611__$1;(statearr_22616_22643[1] = 5);
} else
{var statearr_22617_22644 = state_22611__$1;(statearr_22617_22644[1] = 6);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22612 === 5))
{var inst_22579 = (state_22611[10]);var inst_22575 = (state_22611[9]);var inst_22572 = (state_22611[8]);var inst_22579__$1 = f.call(null,inst_22575);var inst_22580 = cljs.core._EQ_.call(null,inst_22579__$1,inst_22572);var inst_22581 = cljs.core.keyword_identical_QMARK_.call(null,inst_22572,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",4382193538));var inst_22582 = (inst_22580) || (inst_22581);var state_22611__$1 = (function (){var statearr_22618 = state_22611;(statearr_22618[10] = inst_22579__$1);
return statearr_22618;
})();if(cljs.core.truth_(inst_22582))
{var statearr_22619_22645 = state_22611__$1;(statearr_22619_22645[1] = 8);
} else
{var statearr_22620_22646 = state_22611__$1;(statearr_22620_22646[1] = 9);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22612 === 6))
{var inst_22571 = (state_22611[7]);var inst_22596 = inst_22571.length;var inst_22597 = (inst_22596 > 0);var state_22611__$1 = state_22611;if(cljs.core.truth_(inst_22597))
{var statearr_22622_22647 = state_22611__$1;(statearr_22622_22647[1] = 12);
} else
{var statearr_22623_22648 = state_22611__$1;(statearr_22623_22648[1] = 13);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22612 === 7))
{var inst_22607 = (state_22611[2]);var state_22611__$1 = state_22611;var statearr_22624_22649 = state_22611__$1;(statearr_22624_22649[2] = inst_22607);
(statearr_22624_22649[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22612 === 8))
{var inst_22579 = (state_22611[10]);var inst_22575 = (state_22611[9]);var inst_22571 = (state_22611[7]);var inst_22584 = inst_22571.push(inst_22575);var tmp22621 = inst_22571;var inst_22571__$1 = tmp22621;var inst_22572 = inst_22579;var state_22611__$1 = (function (){var statearr_22625 = state_22611;(statearr_22625[11] = inst_22584);
(statearr_22625[7] = inst_22571__$1);
(statearr_22625[8] = inst_22572);
return statearr_22625;
})();var statearr_22626_22650 = state_22611__$1;(statearr_22626_22650[2] = null);
(statearr_22626_22650[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22612 === 9))
{var inst_22571 = (state_22611[7]);var inst_22587 = cljs.core.vec.call(null,inst_22571);var state_22611__$1 = state_22611;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22611__$1,11,out,inst_22587);
} else
{if((state_val_22612 === 10))
{var inst_22594 = (state_22611[2]);var state_22611__$1 = state_22611;var statearr_22627_22651 = state_22611__$1;(statearr_22627_22651[2] = inst_22594);
(statearr_22627_22651[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22612 === 11))
{var inst_22579 = (state_22611[10]);var inst_22575 = (state_22611[9]);var inst_22589 = (state_22611[2]);var inst_22590 = [];var inst_22591 = inst_22590.push(inst_22575);var inst_22571 = inst_22590;var inst_22572 = inst_22579;var state_22611__$1 = (function (){var statearr_22628 = state_22611;(statearr_22628[12] = inst_22589);
(statearr_22628[13] = inst_22591);
(statearr_22628[7] = inst_22571);
(statearr_22628[8] = inst_22572);
return statearr_22628;
})();var statearr_22629_22652 = state_22611__$1;(statearr_22629_22652[2] = null);
(statearr_22629_22652[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22612 === 12))
{var inst_22571 = (state_22611[7]);var inst_22599 = cljs.core.vec.call(null,inst_22571);var state_22611__$1 = state_22611;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22611__$1,15,out,inst_22599);
} else
{if((state_val_22612 === 13))
{var state_22611__$1 = state_22611;var statearr_22630_22653 = state_22611__$1;(statearr_22630_22653[2] = null);
(statearr_22630_22653[1] = 14);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22612 === 14))
{var inst_22604 = (state_22611[2]);var inst_22605 = cljs.core.async.close_BANG_.call(null,out);var state_22611__$1 = (function (){var statearr_22631 = state_22611;(statearr_22631[14] = inst_22604);
return statearr_22631;
})();var statearr_22632_22654 = state_22611__$1;(statearr_22632_22654[2] = inst_22605);
(statearr_22632_22654[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_22612 === 15))
{var inst_22601 = (state_22611[2]);var state_22611__$1 = state_22611;var statearr_22633_22655 = state_22611__$1;(statearr_22633_22655[2] = inst_22601);
(statearr_22633_22655[1] = 14);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11722__auto___22641,out))
;return ((function (switch__11651__auto__,c__11722__auto___22641,out){
return (function() {
var state_machine__11652__auto__ = null;
var state_machine__11652__auto____0 = (function (){var statearr_22637 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_22637[0] = state_machine__11652__auto__);
(statearr_22637[1] = 1);
return statearr_22637;
});
var state_machine__11652__auto____1 = (function (state_22611){while(true){
var ret_value__11653__auto__ = (function (){try{while(true){
var result__11654__auto__ = switch__11651__auto__.call(null,state_22611);if(cljs.core.keyword_identical_QMARK_.call(null,result__11654__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__11654__auto__;
}
break;
}
}catch (e22638){if((e22638 instanceof Object))
{var ex__11655__auto__ = e22638;var statearr_22639_22656 = state_22611;(statearr_22639_22656[5] = ex__11655__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22611);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e22638;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11653__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__22657 = state_22611;
state_22611 = G__22657;
continue;
}
} else
{return ret_value__11653__auto__;
}
break;
}
});
state_machine__11652__auto__ = function(state_22611){
switch(arguments.length){
case 0:
return state_machine__11652__auto____0.call(this);
case 1:
return state_machine__11652__auto____1.call(this,state_22611);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11652__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11652__auto____0;
state_machine__11652__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11652__auto____1;
return state_machine__11652__auto__;
})()
;})(switch__11651__auto__,c__11722__auto___22641,out))
})();var state__11724__auto__ = (function (){var statearr_22640 = f__11723__auto__.call(null);(statearr_22640[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11722__auto___22641);
return statearr_22640;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11724__auto__);
});})(c__11722__auto___22641,out))
);
return out;
});
partition_by = function(f,ch,buf_or_n){
switch(arguments.length){
case 2:
return partition_by__2.call(this,f,ch);
case 3:
return partition_by__3.call(this,f,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
partition_by.cljs$core$IFn$_invoke$arity$2 = partition_by__2;
partition_by.cljs$core$IFn$_invoke$arity$3 = partition_by__3;
return partition_by;
})()
;

//# sourceMappingURL=async.js.map