// Compiled by ClojureScript 0.0-2227
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('cljs.core.async');
goog.require('cljs.reader');
goog.require('goog.net.jsloader');
goog.require('goog.net.jsloader');
figwheel.client.log_style = "color:rgb(0,128,0);";
/**
* @param {...*} var_args
*/
figwheel.client.log = (function() { 
var log__delegate = function (p__19766,args){var map__19768 = p__19766;var map__19768__$1 = ((cljs.core.seq_QMARK_.call(null,map__19768))?cljs.core.apply.call(null,cljs.core.hash_map,map__19768):map__19768);var debug = cljs.core.get.call(null,map__19768__$1,new cljs.core.Keyword(null,"debug","debug",1109363141));if(cljs.core.truth_(debug))
{return console.log(cljs.core.to_array.call(null,args));
} else
{return null;
}
};
var log = function (p__19766,var_args){
var args = null;if (arguments.length > 1) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return log__delegate.call(this,p__19766,args);};
log.cljs$lang$maxFixedArity = 1;
log.cljs$lang$applyTo = (function (arglist__19769){
var p__19766 = cljs.core.first(arglist__19769);
var args = cljs.core.rest(arglist__19769);
return log__delegate(p__19766,args);
});
log.cljs$core$IFn$_invoke$arity$variadic = log__delegate;
return log;
})()
;
figwheel.client.reload_host = (function reload_host(p__19770){var map__19772 = p__19770;var map__19772__$1 = ((cljs.core.seq_QMARK_.call(null,map__19772))?cljs.core.apply.call(null,cljs.core.hash_map,map__19772):map__19772);var websocket_url = cljs.core.get.call(null,map__19772__$1,new cljs.core.Keyword(null,"websocket-url","websocket-url",633671131));return cljs.core.first.call(null,clojure.string.split.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,websocket_url,/^ws:/,""),/^\/\//,""),/\//));
});
figwheel.client.add_cache_buster = (function add_cache_buster(url){return (''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)+"?rel="+cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).getTime()));
});
figwheel.client.js_reload = (function js_reload(p__19773,callback){var map__19775 = p__19773;var map__19775__$1 = ((cljs.core.seq_QMARK_.call(null,map__19775))?cljs.core.apply.call(null,cljs.core.hash_map,map__19775):map__19775);var msg = map__19775__$1;var dependency_file = cljs.core.get.call(null,map__19775__$1,new cljs.core.Keyword(null,"dependency-file","dependency-file",2750516784));var namespace = cljs.core.get.call(null,map__19775__$1,new cljs.core.Keyword(null,"namespace","namespace",2266122445));var request_url = cljs.core.get.call(null,map__19775__$1,new cljs.core.Keyword(null,"request-url","request-url",2162835619));if(cljs.core.truth_((function (){var or__9285__auto__ = dependency_file;if(cljs.core.truth_(or__9285__auto__))
{return or__9285__auto__;
} else
{return goog.isProvided_(namespace);
}
})()))
{return goog.net.jsloader.load(figwheel.client.add_cache_buster.call(null,request_url)).addCallback(((function (map__19775,map__19775__$1,msg,dependency_file,namespace,request_url){
return (function (){return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg], null));
});})(map__19775,map__19775__$1,msg,dependency_file,namespace,request_url))
);
} else
{return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg], null));
}
});
figwheel.client.reload_js_file = (function reload_js_file(file_msg){var out = cljs.core.async.chan.call(null);figwheel.client.js_reload.call(null,file_msg,((function (out){
return (function (url){cljs.core.async.put_BANG_.call(null,out,url);
return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);
return out;
});
figwheel.client.load_all_js_files = (function load_all_js_files(files){return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.async.filter_LT_.call(null,cljs.core.identity,cljs.core.async.merge.call(null,cljs.core.mapv.call(null,figwheel.client.reload_js_file,files))));
});
figwheel.client.add_request_url = (function add_request_url(p__19776,p__19777){var map__19780 = p__19776;var map__19780__$1 = ((cljs.core.seq_QMARK_.call(null,map__19780))?cljs.core.apply.call(null,cljs.core.hash_map,map__19780):map__19780);var opts = map__19780__$1;var url_rewriter = cljs.core.get.call(null,map__19780__$1,new cljs.core.Keyword(null,"url-rewriter","url-rewriter",538861174));var map__19781 = p__19777;var map__19781__$1 = ((cljs.core.seq_QMARK_.call(null,map__19781))?cljs.core.apply.call(null,cljs.core.hash_map,map__19781):map__19781);var d = map__19781__$1;var file = cljs.core.get.call(null,map__19781__$1,new cljs.core.Keyword(null,"file","file",1017047278));return cljs.core.assoc.call(null,d,new cljs.core.Keyword(null,"request-url","request-url",2162835619),url_rewriter.call(null,("//"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.reload_host.call(null,opts))+cljs.core.str.cljs$core$IFn$_invoke$arity$1(file))));
});
figwheel.client.add_request_urls = (function add_request_urls(opts,files){return cljs.core.map.call(null,cljs.core.partial.call(null,figwheel.client.add_request_url,opts),files);
});
figwheel.client.reload_js_files = (function reload_js_files(p__19782,p__19783){var map__19824 = p__19782;var map__19824__$1 = ((cljs.core.seq_QMARK_.call(null,map__19824))?cljs.core.apply.call(null,cljs.core.hash_map,map__19824):map__19824);var opts = map__19824__$1;var on_jsload = cljs.core.get.call(null,map__19824__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",817745103));var before_jsload = cljs.core.get.call(null,map__19824__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",3705046831));var map__19825 = p__19783;var map__19825__$1 = ((cljs.core.seq_QMARK_.call(null,map__19825))?cljs.core.apply.call(null,cljs.core.hash_map,map__19825):map__19825);var files = cljs.core.get.call(null,map__19825__$1,new cljs.core.Keyword(null,"files","files",1111338473));var c__11722__auto__ = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,((function (c__11722__auto__,map__19824,map__19824__$1,opts,on_jsload,before_jsload,map__19825,map__19825__$1,files){
return (function (){var f__11723__auto__ = (function (){var switch__11651__auto__ = ((function (c__11722__auto__,map__19824,map__19824__$1,opts,on_jsload,before_jsload,map__19825,map__19825__$1,files){
return (function (state_19847){var state_val_19848 = (state_19847[1]);if((state_val_19848 === 6))
{var inst_19830 = (state_19847[7]);var inst_19839 = (state_19847[2]);var inst_19840 = [inst_19830];var inst_19841 = (new cljs.core.PersistentVector(null,1,5,cljs.core.PersistentVector.EMPTY_NODE,inst_19840,null));var inst_19842 = cljs.core.apply.call(null,on_jsload,inst_19841);var state_19847__$1 = (function (){var statearr_19849 = state_19847;(statearr_19849[8] = inst_19839);
return statearr_19849;
})();var statearr_19850_19864 = state_19847__$1;(statearr_19850_19864[2] = inst_19842);
(statearr_19850_19864[1] = 5);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_19848 === 5))
{var inst_19845 = (state_19847[2]);var state_19847__$1 = state_19847;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19847__$1,inst_19845);
} else
{if((state_val_19848 === 4))
{var state_19847__$1 = state_19847;var statearr_19851_19865 = state_19847__$1;(statearr_19851_19865[2] = null);
(statearr_19851_19865[1] = 5);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_19848 === 3))
{var inst_19830 = (state_19847[7]);var inst_19833 = console.log("%cFigwheel: loaded these files",figwheel.client.log_style);var inst_19834 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",1017047278),inst_19830);var inst_19835 = cljs.core.prn_str.call(null,inst_19834);var inst_19836 = console.log(inst_19835);var inst_19837 = cljs.core.async.timeout.call(null,10);var state_19847__$1 = (function (){var statearr_19852 = state_19847;(statearr_19852[9] = inst_19833);
(statearr_19852[10] = inst_19836);
return statearr_19852;
})();return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19847__$1,6,inst_19837);
} else
{if((state_val_19848 === 2))
{var inst_19830 = (state_19847[7]);var inst_19830__$1 = (state_19847[2]);var inst_19831 = cljs.core.not_empty.call(null,inst_19830__$1);var state_19847__$1 = (function (){var statearr_19853 = state_19847;(statearr_19853[7] = inst_19830__$1);
return statearr_19853;
})();if(cljs.core.truth_(inst_19831))
{var statearr_19854_19866 = state_19847__$1;(statearr_19854_19866[1] = 3);
} else
{var statearr_19855_19867 = state_19847__$1;(statearr_19855_19867[1] = 4);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_19848 === 1))
{var inst_19826 = before_jsload.call(null,files);var inst_19827 = figwheel.client.add_request_urls.call(null,opts,files);var inst_19828 = figwheel.client.load_all_js_files.call(null,inst_19827);var state_19847__$1 = (function (){var statearr_19856 = state_19847;(statearr_19856[11] = inst_19826);
return statearr_19856;
})();return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19847__$1,2,inst_19828);
} else
{return null;
}
}
}
}
}
}
});})(c__11722__auto__,map__19824,map__19824__$1,opts,on_jsload,before_jsload,map__19825,map__19825__$1,files))
;return ((function (switch__11651__auto__,c__11722__auto__,map__19824,map__19824__$1,opts,on_jsload,before_jsload,map__19825,map__19825__$1,files){
return (function() {
var state_machine__11652__auto__ = null;
var state_machine__11652__auto____0 = (function (){var statearr_19860 = [null,null,null,null,null,null,null,null,null,null,null,null];(statearr_19860[0] = state_machine__11652__auto__);
(statearr_19860[1] = 1);
return statearr_19860;
});
var state_machine__11652__auto____1 = (function (state_19847){while(true){
var ret_value__11653__auto__ = (function (){try{while(true){
var result__11654__auto__ = switch__11651__auto__.call(null,state_19847);if(cljs.core.keyword_identical_QMARK_.call(null,result__11654__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__11654__auto__;
}
break;
}
}catch (e19861){if((e19861 instanceof Object))
{var ex__11655__auto__ = e19861;var statearr_19862_19868 = state_19847;(statearr_19862_19868[5] = ex__11655__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19847);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e19861;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11653__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__19869 = state_19847;
state_19847 = G__19869;
continue;
}
} else
{return ret_value__11653__auto__;
}
break;
}
});
state_machine__11652__auto__ = function(state_19847){
switch(arguments.length){
case 0:
return state_machine__11652__auto____0.call(this);
case 1:
return state_machine__11652__auto____1.call(this,state_19847);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11652__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11652__auto____0;
state_machine__11652__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11652__auto____1;
return state_machine__11652__auto__;
})()
;})(switch__11651__auto__,c__11722__auto__,map__19824,map__19824__$1,opts,on_jsload,before_jsload,map__19825,map__19825__$1,files))
})();var state__11724__auto__ = (function (){var statearr_19863 = f__11723__auto__.call(null);(statearr_19863[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11722__auto__);
return statearr_19863;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11724__auto__);
});})(c__11722__auto__,map__19824,map__19824__$1,opts,on_jsload,before_jsload,map__19825,map__19825__$1,files))
);
return c__11722__auto__;
});
figwheel.client.current_links = (function current_links(){return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.truncate_url = (function truncate_url(url){return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.protocol)+"//"),""),"http://",""),"https://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.matches_file_QMARK_ = (function matches_file_QMARK_(p__19870,link_href){var map__19872 = p__19870;var map__19872__$1 = ((cljs.core.seq_QMARK_.call(null,map__19872))?cljs.core.apply.call(null,cljs.core.hash_map,map__19872):map__19872);var request_url = cljs.core.get.call(null,map__19872__$1,new cljs.core.Keyword(null,"request-url","request-url",2162835619));var file = cljs.core.get.call(null,map__19872__$1,new cljs.core.Keyword(null,"file","file",1017047278));var trunc_href = figwheel.client.truncate_url.call(null,link_href);return (cljs.core._EQ_.call(null,file,trunc_href)) || (cljs.core._EQ_.call(null,figwheel.client.truncate_url.call(null,request_url),trunc_href));
});
figwheel.client.get_correct_link = (function get_correct_link(f_data){return cljs.core.some.call(null,(function (l){if(figwheel.client.matches_file_QMARK_.call(null,f_data,l.href))
{return l;
} else
{return null;
}
}),figwheel.client.current_links.call(null));
});
figwheel.client.clone_link = (function clone_link(link,url){var clone = document.createElement("link");clone.rel = "stylesheet";
clone.media = link.media;
clone.disabled = link.disabled;
clone.href = figwheel.client.add_cache_buster.call(null,url);
return clone;
});
figwheel.client.create_link = (function create_link(url){var link = document.createElement("link");link.rel = "stylesheet";
link.href = figwheel.client.add_cache_buster.call(null,url);
return link;
});
figwheel.client.add_link_to_doc = (function() {
var add_link_to_doc = null;
var add_link_to_doc__1 = (function (new_link){return (document.getElementsByTagName("head")[0]).appendChild(new_link);
});
var add_link_to_doc__2 = (function (orig_link,klone){var parent = orig_link.parentNode;if(cljs.core._EQ_.call(null,orig_link,parent.lastChild))
{parent.appendChild(klone);
} else
{parent.insertBefore(klone,orig_link.nextSibling);
}
var c__11722__auto__ = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,((function (c__11722__auto__,parent){
return (function (){var f__11723__auto__ = (function (){var switch__11651__auto__ = ((function (c__11722__auto__,parent){
return (function (state_19893){var state_val_19894 = (state_19893[1]);if((state_val_19894 === 2))
{var inst_19890 = (state_19893[2]);var inst_19891 = parent.removeChild(orig_link);var state_19893__$1 = (function (){var statearr_19895 = state_19893;(statearr_19895[7] = inst_19890);
return statearr_19895;
})();return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19893__$1,inst_19891);
} else
{if((state_val_19894 === 1))
{var inst_19888 = cljs.core.async.timeout.call(null,200);var state_19893__$1 = state_19893;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19893__$1,2,inst_19888);
} else
{return null;
}
}
});})(c__11722__auto__,parent))
;return ((function (switch__11651__auto__,c__11722__auto__,parent){
return (function() {
var state_machine__11652__auto__ = null;
var state_machine__11652__auto____0 = (function (){var statearr_19899 = [null,null,null,null,null,null,null,null];(statearr_19899[0] = state_machine__11652__auto__);
(statearr_19899[1] = 1);
return statearr_19899;
});
var state_machine__11652__auto____1 = (function (state_19893){while(true){
var ret_value__11653__auto__ = (function (){try{while(true){
var result__11654__auto__ = switch__11651__auto__.call(null,state_19893);if(cljs.core.keyword_identical_QMARK_.call(null,result__11654__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__11654__auto__;
}
break;
}
}catch (e19900){if((e19900 instanceof Object))
{var ex__11655__auto__ = e19900;var statearr_19901_19903 = state_19893;(statearr_19901_19903[5] = ex__11655__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19893);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e19900;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11653__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__19904 = state_19893;
state_19893 = G__19904;
continue;
}
} else
{return ret_value__11653__auto__;
}
break;
}
});
state_machine__11652__auto__ = function(state_19893){
switch(arguments.length){
case 0:
return state_machine__11652__auto____0.call(this);
case 1:
return state_machine__11652__auto____1.call(this,state_19893);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11652__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11652__auto____0;
state_machine__11652__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11652__auto____1;
return state_machine__11652__auto__;
})()
;})(switch__11651__auto__,c__11722__auto__,parent))
})();var state__11724__auto__ = (function (){var statearr_19902 = f__11723__auto__.call(null);(statearr_19902[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11722__auto__);
return statearr_19902;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11724__auto__);
});})(c__11722__auto__,parent))
);
return c__11722__auto__;
});
add_link_to_doc = function(orig_link,klone){
switch(arguments.length){
case 1:
return add_link_to_doc__1.call(this,orig_link);
case 2:
return add_link_to_doc__2.call(this,orig_link,klone);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
add_link_to_doc.cljs$core$IFn$_invoke$arity$1 = add_link_to_doc__1;
add_link_to_doc.cljs$core$IFn$_invoke$arity$2 = add_link_to_doc__2;
return add_link_to_doc;
})()
;
figwheel.client.reload_css_file = (function reload_css_file(p__19905){var map__19907 = p__19905;var map__19907__$1 = ((cljs.core.seq_QMARK_.call(null,map__19907))?cljs.core.apply.call(null,cljs.core.hash_map,map__19907):map__19907);var f_data = map__19907__$1;var request_url = cljs.core.get.call(null,map__19907__$1,new cljs.core.Keyword(null,"request-url","request-url",2162835619));var file = cljs.core.get.call(null,map__19907__$1,new cljs.core.Keyword(null,"file","file",1017047278));var temp__4090__auto__ = figwheel.client.get_correct_link.call(null,f_data);if(cljs.core.truth_(temp__4090__auto__))
{var link = temp__4090__auto__;return figwheel.client.add_link_to_doc.call(null,link,figwheel.client.clone_link.call(null,link,request_url));
} else
{return figwheel.client.add_link_to_doc.call(null,figwheel.client.create_link.call(null,request_url));
}
});
figwheel.client.reload_css_files = (function reload_css_files(p__19908,files_msg){var map__19930 = p__19908;var map__19930__$1 = ((cljs.core.seq_QMARK_.call(null,map__19930))?cljs.core.apply.call(null,cljs.core.hash_map,map__19930):map__19930);var opts = map__19930__$1;var on_cssload = cljs.core.get.call(null,map__19930__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1611735789));var seq__19931_19951 = cljs.core.seq.call(null,figwheel.client.add_request_urls.call(null,opts,new cljs.core.Keyword(null,"files","files",1111338473).cljs$core$IFn$_invoke$arity$1(files_msg)));var chunk__19932_19952 = null;var count__19933_19953 = 0;var i__19934_19954 = 0;while(true){
if((i__19934_19954 < count__19933_19953))
{var f_19955 = cljs.core._nth.call(null,chunk__19932_19952,i__19934_19954);figwheel.client.reload_css_file.call(null,f_19955);
{
var G__19956 = seq__19931_19951;
var G__19957 = chunk__19932_19952;
var G__19958 = count__19933_19953;
var G__19959 = (i__19934_19954 + 1);
seq__19931_19951 = G__19956;
chunk__19932_19952 = G__19957;
count__19933_19953 = G__19958;
i__19934_19954 = G__19959;
continue;
}
} else
{var temp__4092__auto___19960 = cljs.core.seq.call(null,seq__19931_19951);if(temp__4092__auto___19960)
{var seq__19931_19961__$1 = temp__4092__auto___19960;if(cljs.core.chunked_seq_QMARK_.call(null,seq__19931_19961__$1))
{var c__10041__auto___19962 = cljs.core.chunk_first.call(null,seq__19931_19961__$1);{
var G__19963 = cljs.core.chunk_rest.call(null,seq__19931_19961__$1);
var G__19964 = c__10041__auto___19962;
var G__19965 = cljs.core.count.call(null,c__10041__auto___19962);
var G__19966 = 0;
seq__19931_19951 = G__19963;
chunk__19932_19952 = G__19964;
count__19933_19953 = G__19965;
i__19934_19954 = G__19966;
continue;
}
} else
{var f_19967 = cljs.core.first.call(null,seq__19931_19961__$1);figwheel.client.reload_css_file.call(null,f_19967);
{
var G__19968 = cljs.core.next.call(null,seq__19931_19961__$1);
var G__19969 = null;
var G__19970 = 0;
var G__19971 = 0;
seq__19931_19951 = G__19968;
chunk__19932_19952 = G__19969;
count__19933_19953 = G__19970;
i__19934_19954 = G__19971;
continue;
}
}
} else
{}
}
break;
}
var c__11722__auto__ = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,((function (c__11722__auto__,map__19930,map__19930__$1,opts,on_cssload){
return (function (){var f__11723__auto__ = (function (){var switch__11651__auto__ = ((function (c__11722__auto__,map__19930,map__19930__$1,opts,on_cssload){
return (function (state_19941){var state_val_19942 = (state_19941[1]);if((state_val_19942 === 2))
{var inst_19937 = (state_19941[2]);var inst_19938 = new cljs.core.Keyword(null,"files","files",1111338473).cljs$core$IFn$_invoke$arity$1(files_msg);var inst_19939 = on_cssload.call(null,inst_19938);var state_19941__$1 = (function (){var statearr_19943 = state_19941;(statearr_19943[7] = inst_19937);
return statearr_19943;
})();return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19941__$1,inst_19939);
} else
{if((state_val_19942 === 1))
{var inst_19935 = cljs.core.async.timeout.call(null,100);var state_19941__$1 = state_19941;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19941__$1,2,inst_19935);
} else
{return null;
}
}
});})(c__11722__auto__,map__19930,map__19930__$1,opts,on_cssload))
;return ((function (switch__11651__auto__,c__11722__auto__,map__19930,map__19930__$1,opts,on_cssload){
return (function() {
var state_machine__11652__auto__ = null;
var state_machine__11652__auto____0 = (function (){var statearr_19947 = [null,null,null,null,null,null,null,null];(statearr_19947[0] = state_machine__11652__auto__);
(statearr_19947[1] = 1);
return statearr_19947;
});
var state_machine__11652__auto____1 = (function (state_19941){while(true){
var ret_value__11653__auto__ = (function (){try{while(true){
var result__11654__auto__ = switch__11651__auto__.call(null,state_19941);if(cljs.core.keyword_identical_QMARK_.call(null,result__11654__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__11654__auto__;
}
break;
}
}catch (e19948){if((e19948 instanceof Object))
{var ex__11655__auto__ = e19948;var statearr_19949_19972 = state_19941;(statearr_19949_19972[5] = ex__11655__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19941);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e19948;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11653__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__19973 = state_19941;
state_19941 = G__19973;
continue;
}
} else
{return ret_value__11653__auto__;
}
break;
}
});
state_machine__11652__auto__ = function(state_19941){
switch(arguments.length){
case 0:
return state_machine__11652__auto____0.call(this);
case 1:
return state_machine__11652__auto____1.call(this,state_19941);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11652__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11652__auto____0;
state_machine__11652__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11652__auto____1;
return state_machine__11652__auto__;
})()
;})(switch__11651__auto__,c__11722__auto__,map__19930,map__19930__$1,opts,on_cssload))
})();var state__11724__auto__ = (function (){var statearr_19950 = f__11723__auto__.call(null);(statearr_19950[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11722__auto__);
return statearr_19950;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11724__auto__);
});})(c__11722__auto__,map__19930,map__19930__$1,opts,on_cssload))
);
return c__11722__auto__;
});
figwheel.client.compile_failed = (function compile_failed(fail_msg,compile_fail_callback){return compile_fail_callback.call(null,cljs.core.dissoc.call(null,fail_msg,new cljs.core.Keyword(null,"msg-name","msg-name",3979112649)));
});
figwheel.client.figwheel_closure_import_script = (function figwheel_closure_import_script(src){if(cljs.core.truth_(goog.inHtmlDocument_()))
{goog.net.jsloader.load(figwheel.client.add_cache_buster.call(null,src));
return true;
} else
{return false;
}
});
figwheel.client.patch_goog_base = (function patch_goog_base(){goog.provide = goog.exportPath_;
return goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.figwheel_closure_import_script;
});
figwheel.client.watch_and_reload_STAR_ = (function watch_and_reload_STAR_(p__19974){var map__19979 = p__19974;var map__19979__$1 = ((cljs.core.seq_QMARK_.call(null,map__19979))?cljs.core.apply.call(null,cljs.core.hash_map,map__19979):map__19979);var opts = map__19979__$1;var on_compile_fail = cljs.core.get.call(null,map__19979__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",846779160));var jsload_callback = cljs.core.get.call(null,map__19979__$1,new cljs.core.Keyword(null,"jsload-callback","jsload-callback",3126035989));var websocket_url = cljs.core.get.call(null,map__19979__$1,new cljs.core.Keyword(null,"websocket-url","websocket-url",633671131));var retry_count = cljs.core.get.call(null,map__19979__$1,new cljs.core.Keyword(null,"retry-count","retry-count",2949373212));console.log("%cFigwheel: trying to open cljs reload socket",figwheel.client.log_style);
var socket = (new WebSocket(websocket_url));socket.onmessage = ((function (socket,map__19979,map__19979__$1,opts,on_compile_fail,jsload_callback,websocket_url,retry_count){
return (function (msg_str){var msg = cljs.reader.read_string.call(null,msg_str.data);var pred__19980 = cljs.core._EQ_;var expr__19981 = new cljs.core.Keyword(null,"msg-name","msg-name",3979112649).cljs$core$IFn$_invoke$arity$1(msg);if(cljs.core.truth_(pred__19980.call(null,new cljs.core.Keyword(null,"files-changed","files-changed",2807270608),expr__19981)))
{return figwheel.client.reload_js_files.call(null,opts,msg);
} else
{if(cljs.core.truth_(pred__19980.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",1058553478),expr__19981)))
{return figwheel.client.reload_css_files.call(null,opts,msg);
} else
{if(cljs.core.truth_(pred__19980.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",630802569),expr__19981)))
{return figwheel.client.compile_failed.call(null,msg,on_compile_fail);
} else
{return null;
}
}
}
});})(socket,map__19979,map__19979__$1,opts,on_compile_fail,jsload_callback,websocket_url,retry_count))
;
socket.onopen = ((function (socket,map__19979,map__19979__$1,opts,on_compile_fail,jsload_callback,websocket_url,retry_count){
return (function (x){figwheel.client.patch_goog_base.call(null);
return console.log("%cFigwheel: socket connection established",figwheel.client.log_style);
});})(socket,map__19979,map__19979__$1,opts,on_compile_fail,jsload_callback,websocket_url,retry_count))
;
socket.onclose = ((function (socket,map__19979,map__19979__$1,opts,on_compile_fail,jsload_callback,websocket_url,retry_count){
return (function (x){figwheel.client.log.call(null,opts,"Figwheel: socket closed or failed to open");
if((retry_count > 0))
{return window.setTimeout(((function (socket,map__19979,map__19979__$1,opts,on_compile_fail,jsload_callback,websocket_url,retry_count){
return (function (){return watch_and_reload_STAR_.call(null,cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"retry-count","retry-count",2949373212),(retry_count - 1)));
});})(socket,map__19979,map__19979__$1,opts,on_compile_fail,jsload_callback,websocket_url,retry_count))
,2000);
} else
{return null;
}
});})(socket,map__19979,map__19979__$1,opts,on_compile_fail,jsload_callback,websocket_url,retry_count))
;
return socket.onerror = ((function (socket,map__19979,map__19979__$1,opts,on_compile_fail,jsload_callback,websocket_url,retry_count){
return (function (x){return figwheel.client.log.call(null,opts,"Figwheel: socket error ");
});})(socket,map__19979,map__19979__$1,opts,on_compile_fail,jsload_callback,websocket_url,retry_count))
;
});
figwheel.client.default_on_jsload = (function default_on_jsload(url){return document.querySelector("body").dispatchEvent((new CustomEvent("figwheel.js-reload",(function (){var obj19986 = {"detail":url};return obj19986;
})())));
});
figwheel.client.get_essential_messages = (function get_essential_messages(ed){if(cljs.core.truth_(ed))
{return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",1968829305),new cljs.core.Keyword(null,"class","class",1108647146)], null)),get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",1108338651).cljs$core$IFn$_invoke$arity$1(ed)));
} else
{return null;
}
});
figwheel.client.error_msg_format = (function error_msg_format(p__19987){var map__19989 = p__19987;var map__19989__$1 = ((cljs.core.seq_QMARK_.call(null,map__19989))?cljs.core.apply.call(null,cljs.core.hash_map,map__19989):map__19989);var class$ = cljs.core.get.call(null,map__19989__$1,new cljs.core.Keyword(null,"class","class",1108647146));var message = cljs.core.get.call(null,map__19989__$1,new cljs.core.Keyword(null,"message","message",1968829305));return (''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$)+" : "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(message));
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.default_on_compile_fail = (function default_on_compile_fail(p__19990){var map__19996 = p__19990;var map__19996__$1 = ((cljs.core.seq_QMARK_.call(null,map__19996))?cljs.core.apply.call(null,cljs.core.hash_map,map__19996):map__19996);var ed = map__19996__$1;var exception_data = cljs.core.get.call(null,map__19996__$1,new cljs.core.Keyword(null,"exception-data","exception-data",922291674));var formatted_exception = cljs.core.get.call(null,map__19996__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",1408867312));console.log("%cFigwheel: Compile Exception",figwheel.client.log_style);
var seq__19997_20001 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));var chunk__19998_20002 = null;var count__19999_20003 = 0;var i__20000_20004 = 0;while(true){
if((i__20000_20004 < count__19999_20003))
{var msg_20005 = cljs.core._nth.call(null,chunk__19998_20002,i__20000_20004);console.log(msg_20005);
{
var G__20006 = seq__19997_20001;
var G__20007 = chunk__19998_20002;
var G__20008 = count__19999_20003;
var G__20009 = (i__20000_20004 + 1);
seq__19997_20001 = G__20006;
chunk__19998_20002 = G__20007;
count__19999_20003 = G__20008;
i__20000_20004 = G__20009;
continue;
}
} else
{var temp__4092__auto___20010 = cljs.core.seq.call(null,seq__19997_20001);if(temp__4092__auto___20010)
{var seq__19997_20011__$1 = temp__4092__auto___20010;if(cljs.core.chunked_seq_QMARK_.call(null,seq__19997_20011__$1))
{var c__10041__auto___20012 = cljs.core.chunk_first.call(null,seq__19997_20011__$1);{
var G__20013 = cljs.core.chunk_rest.call(null,seq__19997_20011__$1);
var G__20014 = c__10041__auto___20012;
var G__20015 = cljs.core.count.call(null,c__10041__auto___20012);
var G__20016 = 0;
seq__19997_20001 = G__20013;
chunk__19998_20002 = G__20014;
count__19999_20003 = G__20015;
i__20000_20004 = G__20016;
continue;
}
} else
{var msg_20017 = cljs.core.first.call(null,seq__19997_20011__$1);console.log(msg_20017);
{
var G__20018 = cljs.core.next.call(null,seq__19997_20011__$1);
var G__20019 = null;
var G__20020 = 0;
var G__20021 = 0;
seq__19997_20001 = G__20018;
chunk__19998_20002 = G__20019;
count__19999_20003 = G__20020;
i__20000_20004 = G__20021;
continue;
}
}
} else
{}
}
break;
}
return ed;
});
figwheel.client.default_before_load = (function default_before_load(files){console.log("%cFigwheel: loading files",figwheel.client.log_style);
return files;
});
figwheel.client.default_on_cssload = (function default_on_cssload(files){console.log("%cFigwheel: loaded CSS files",figwheel.client.log_style);
console.log(cljs.core.prn_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",1017047278),files)));
return files;
});
figwheel.client.watch_and_reload_with_opts = (function watch_and_reload_with_opts(opts){if(cljs.core.truth_(figwheel.client.hasOwnProperty("watch_and_reload_singleton")))
{return null;
} else
{figwheel.client.watch_and_reload_singleton = figwheel.client.watch_and_reload_STAR_.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"retry-count","retry-count",2949373212),100,new cljs.core.Keyword(null,"jsload-callback","jsload-callback",3126035989),figwheel.client.default_on_jsload,new cljs.core.Keyword(null,"on-jsload","on-jsload",817745103),(function (){var or__9285__auto__ = new cljs.core.Keyword(null,"jsload-callback","jsload-callback",3126035989).cljs$core$IFn$_invoke$arity$1(opts);if(cljs.core.truth_(or__9285__auto__))
{return or__9285__auto__;
} else
{return figwheel.client.default_on_jsload;
}
})(),new cljs.core.Keyword(null,"on-cssload","on-cssload",1611735789),figwheel.client.default_on_cssload,new cljs.core.Keyword(null,"before-jsload","before-jsload",3705046831),figwheel.client.default_before_load,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",846779160),figwheel.client.default_on_compile_fail,new cljs.core.Keyword(null,"url-rewriter","url-rewriter",538861174),cljs.core.identity,new cljs.core.Keyword(null,"websocket-url","websocket-url",633671131),("ws://"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.host)+"/figwheel-ws")], null),opts));
}
});
/**
* @param {...*} var_args
*/
figwheel.client.watch_and_reload = (function() { 
var watch_and_reload__delegate = function (p__20022){var map__20024 = p__20022;var map__20024__$1 = ((cljs.core.seq_QMARK_.call(null,map__20024))?cljs.core.apply.call(null,cljs.core.hash_map,map__20024):map__20024);var opts = map__20024__$1;return figwheel.client.watch_and_reload_with_opts.call(null,opts);
};
var watch_and_reload = function (var_args){
var p__20022 = null;if (arguments.length > 0) {
  p__20022 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);} 
return watch_and_reload__delegate.call(this,p__20022);};
watch_and_reload.cljs$lang$maxFixedArity = 0;
watch_and_reload.cljs$lang$applyTo = (function (arglist__20025){
var p__20022 = cljs.core.seq(arglist__20025);
return watch_and_reload__delegate(p__20022);
});
watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = watch_and_reload__delegate;
return watch_and_reload;
})()
;

//# sourceMappingURL=client.js.map