(ns user
  (:require
   [weasel.repl :as ws-repl]
   [clairvoyant.core :as trace :include-macros true]))

(ws-repl/connect "ws://localhost:9091" :verbose true)

(trace/trace-forms
  {:tracer trace/default-tracer}
  (defn x [m n]
    (let [f (fn [x y]
              (let [z (* x y n)
                    w (+ x y n)]
                (+ z w n)))]
      (f (inc n) (dec n))
      (reify
        ILookup
        (-lookup [this k]
          (get m k))
        (-lookup [this k not-found]
          (get m k not-found))))))

(:foo (x {:foo "foo"} 200))
(:bar (x {:foo "bar"} 300) "bar")

(trace/trace-forms
 {:tracer trace/default-tracer}
 (defn add
   ([a] a)
   ([a b] (+ a b))
   ([a b & more]
      (reduce + (+ a b) more))))

(add 1 2)
(add 1 2 3)

(trace/trace-forms
 {:tracer trace/default-tracer}
 (extend-type object
   ILookup
   (-lookup [o k]
     (aget o (name k)))
   (-lookup [o k not-found]
     (or (aget o (name k)) not-found)))

 (extend-protocol ISeqable
   object
   (-seq [o]
     (for [k (js/Object.keys o)]
       [k (get o k)]))))



(:foo #js{:foo "bar"})
(:bar #js{:foo "bar"} "baz")
(seq #js{:foo "bar"})
