(ns user
  (:require
   [weasel.repl :as ws-repl]
   [clairvoyant.core :as trace :include-macros true]))

(ws-repl/connect "ws://localhost:9091" :verbose true)

(def example-el
  (doto (. js/document (createElement "div"))
    (.setAttribute "id" "example")))

(.. js/document -body (appendChild example-el))

(let [container-stack (atom [])
      gen-id (fn [] (gensym "id-"))
      make-container
      (fn []
        (let [id (gen-id)]
          (swap! container-stack conj id)
          (doto (. js/document (createElement "div"))
            (.setAttribute "style" "background:black;color:white;padding:10px;border-radius:3px;margin-bottom:10px")
            (.setAttribute "id" id))))

      text-node (fn [s]
                  (. js/document (createTextNode s)))
      add-line
      (fn [container s]
        (doto container
          (.appendChild
            (doto (. js/document (createElement "pre"))
              (.appendChild (text-node s))))))]

  (def dom-writing-tracer
    (reify
      trace/ITraceEnter
      (-trace-enter [_ {:keys [form ns name args arglist protocol dispatch-val anonymous?]}]
        (let [container (make-container)
              _ (. example-el (appendChild container))]
          (if protocol
            (add-line container (str protocol " " name " " arglist))
            (add-line container
              (str ns "/" name
                " "
                (when dispatch-val (str (pr-str dispatch-val) " "))
                arglist
                (when anonymous? " (anonymous)"))))
          (let [arglist (remove '#{&} arglist)]
            (doseq [[sym val] (map vector arglist args)]
              (add-line container (str sym " = " val))))
          (add-line container (str "Form: " form))))

      trace/ITraceError
      (-trace-error [_ {:keys [error]}]
        (let [id (peek @container-stack)
              container (. js/document (querySelector (str "#" id)))]
          (.setProperty (.-style container)
            "background" "darkred")
          (add-line container (.-stack error))
          (swap! container-stack pop)))

      trace/ITraceExit
      (-trace-exit [_ {:keys [exit]}]
        (let [id (peek @container-stack)
              container (. js/document (querySelector (str "#" id)))]
          (add-line container (str "Exit: " (pr-str exit)))
          (swap! container-stack pop))))))


(trace/trace-forms
  {:tracer trace/default-tracer}
  (defn x [m y]
    (let [{:keys [foo]} m
          f (fn [x y]
              
              (let [z (* x y)
                    w (+ x y)]
                (+ z w)))]
      (f 11 20)
      (reify
        ILookup
        (-lookup [this k]
          (get m k))
        (-lookup [this k not-found]
          (get m k not-found))))))

(:foo (x {:foo "foo"} 1))
(:bar (x {:foo "foo"} 2))
(:bar (x {:foo "bar"} 3) "bar")

(trace/trace-forms
 {:tracer trace/default-tracer}
 (defn add
   ([a] a)
   ([a b] (+ a b))
   ([a b & more]
      (reduce + (+ a b) more))))

(add 1)
(add 1 2)
(add 1 2 3)
